/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MInfoProcess;
import org.adempiere.model.MInfoRelated;
import org.compiere.model.AccessSqlParser;
import org.compiere.model.I_AD_Table;
import org.compiere.model.MInfoColumn;
import org.compiere.model.MInfoWindowAccess;
import org.compiere.model.MMenu;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_InfoWindow;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MInfoWindow
extends X_AD_InfoWindow
implements ImmutablePOSupport {
    private static final long serialVersionUID = -6793583766286122866L;
    private static ImmutablePOCache<String, MInfoWindow> s_cache = new ImmutablePOCache("AD_InfoWindow", 20, 0, false, 0);
    private MInfoRelated[] m_infoRelated;
    private MInfoProcess[] m_infoProcess;
    private MInfoColumn[] m_infocolumns = null;
    private boolean m_validateEachColumn = true;

    public MInfoWindow(Properties ctx, String AD_InfoWindow_UU, String trxName) {
        super(ctx, AD_InfoWindow_UU, trxName);
    }

    public MInfoWindow(Properties ctx, int AD_InfoWindow_ID, String trxName) {
        super(ctx, AD_InfoWindow_ID, trxName);
    }

    public MInfoWindow(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInfoWindow(MInfoWindow copy) {
        this(copy, null);
    }

    public MInfoWindow(MInfoWindow copy, String trxName) {
        this(Env.getCtx(), 0, trxName);
        this.copyPO(copy);
        this.m_validateEachColumn = copy.m_validateEachColumn;
        this.m_infocolumns = copy.m_infocolumns != null ? (MInfoColumn[])Arrays.stream(copy.m_infocolumns).map(MInfoColumn::new).toArray(MInfoColumn[]::new) : null;
        this.m_infoProcess = copy.m_infoProcess != null ? (MInfoProcess[])Arrays.stream(copy.m_infoProcess).map(MInfoProcess::new).toArray(MInfoProcess[]::new) : null;
        this.m_infoRelated = copy.m_infoRelated != null ? (MInfoRelated[])Arrays.stream(copy.m_infoRelated).map(MInfoRelated::new).toArray(MInfoRelated[]::new) : null;
    }

    public static MInfoWindow get(String tableName, String trxName) {
        Query query = new Query(Env.getCtx(), MTable.get(Env.getCtx(), 895), "AD_Table_ID=? AND IsValid='Y' ", null);
        MTable table2 = MTable.get(Env.getCtx(), tableName);
        if (table2 != null) {
            List iws = query.setParameters(table2.getAD_Table_ID()).setOrderBy("AD_Client_ID Desc, AD_Org_ID Desc, IsDefault Desc, AD_InfoWindow_ID Desc").setOnlyActiveRecords(true).setApplyAccessFilter(true).list();
            for (MInfoWindow iw : iws) {
                Boolean access = MRole.getDefault().getInfoAccess(iw.getAD_InfoWindow_ID());
                if (access == null || !access.booleanValue()) continue;
                return iw;
            }
        }
        return null;
    }

    public static MInfoWindow getInfoWindow(int AD_InfoWindow_ID) {
        if (AD_InfoWindow_ID > 0) {
            String key = String.valueOf(AD_InfoWindow_ID) + "|" + Env.getAD_Role_ID(Env.getCtx());
            MInfoWindow infoWin = (MInfoWindow)s_cache.get(key);
            if (infoWin != null) {
                return infoWin;
            }
            infoWin = (MInfoWindow)new Query(Env.getCtx(), "AD_InfoWindow", "AD_InfoWindow_ID=?", null).setParameters(AD_InfoWindow_ID).first();
            if (infoWin != null) {
                s_cache.put(key, infoWin);
                return infoWin;
            }
        }
        return null;
    }

    public MInfoRelated[] getInfoRelated(boolean requery) {
        if (this.m_infoRelated != null && !requery) {
            MInfoWindow.set_TrxName(this.m_infoRelated, this.get_TrxName());
            return this.m_infoRelated;
        }
        List<MInfoRelated> list = new Query(this.getCtx(), "AD_InfoRelated", "AD_InfoWindow_ID=?", this.get_TrxName()).setParameters(this.getAD_InfoWindow_ID()).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        this.m_infoRelated = list.toArray(new MInfoRelated[list.size()]);
        return this.m_infoRelated;
    }

    public MInfoProcess[] getInfoProcess(boolean requery) {
        if (this.m_infoProcess != null && !requery) {
            MInfoWindow.set_TrxName(this.m_infoProcess, this.get_TrxName());
            return this.m_infoProcess;
        }
        List<MInfoProcess> list = new Query(this.getCtx(), "AD_InfoProcess", "AD_InfoWindow_ID=?", this.get_TrxName()).setParameters(this.getAD_InfoWindow_ID()).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        this.checkProcessRight(list);
        this.m_infoProcess = list.toArray(new MInfoProcess[list.size()]);
        return this.m_infoProcess;
    }

    protected void checkProcessRight(List<MInfoProcess> lsInfoProcess) {
        Iterator<MInfoProcess> iterator = lsInfoProcess.iterator();
        while (iterator.hasNext()) {
            MInfoProcess testInfoProcess = iterator.next();
            Boolean access = MRole.getDefault().getProcessAccess(testInfoProcess.getAD_Process_ID());
            if (access != null && access.booleanValue()) continue;
            iterator.remove();
        }
    }

    public static MInfoWindow get(int infoWindowID, String trxName) {
        Boolean access;
        MInfoWindow iw = MInfoWindow.getInfoWindow(infoWindowID);
        if (iw != null && (access = MRole.getDefault().getInfoAccess(iw.getAD_InfoWindow_ID())) != null && access.booleanValue()) {
            if (!Util.isEmpty(trxName, true)) {
                iw = new MInfoWindow(iw, trxName);
            }
            return iw;
        }
        return null;
    }

    public synchronized MInfoColumn[] getInfoColumns(AccessSqlParser.TableInfo[] tableInfos) {
        this.getInfoColumns();
        ArrayList<MInfoColumn> list = new ArrayList<MInfoColumn>();
        MInfoColumn[] mInfoColumnArray = this.m_infocolumns;
        int n = this.m_infocolumns.length;
        int n2 = 0;
        while (n2 < n) {
            MInfoColumn ic = mInfoColumnArray[n2];
            if (ic.isColumnAccess(tableInfos)) {
                list.add(ic);
            }
            ++n2;
        }
        return list.toArray(new MInfoColumn[0]);
    }

    public synchronized MInfoColumn[] getInfoColumns() {
        if (this.m_infocolumns == null) {
            Query query = new Query(this.getCtx(), MTable.get(this.getCtx(), 897), "AD_InfoWindow_ID=?", this.get_TrxName());
            List<MInfoColumn> list = query.setParameters(this.getAD_InfoWindow_ID()).setOnlyActiveRecords(true).setOrderBy("SeqNo, AD_InfoColumn_ID").list();
            this.m_infocolumns = list.toArray(new MInfoColumn[0]);
        }
        if (this.get_TrxName() != null) {
            MInfoWindow.set_TrxName(this.m_infocolumns, this.get_TrxName());
        }
        return this.m_infocolumns;
    }

    public synchronized MInfoColumn[] getInfoColumns(boolean requery, boolean checkDisplay) {
        if (this.m_infocolumns == null || requery) {
            this.m_infocolumns = null;
            this.getInfoColumns();
        }
        if (checkDisplay) {
            ArrayList<MInfoColumn> list = new ArrayList<MInfoColumn>();
            MInfoColumn[] mInfoColumnArray = this.m_infocolumns;
            int n = this.m_infocolumns.length;
            int n2 = 0;
            while (n2 < n) {
                MInfoColumn ic = mInfoColumnArray[n2];
                if (ic.isDisplayed()) {
                    list.add(ic);
                }
                ++n2;
            }
            return list.toArray(new MInfoColumn[list.size()]);
        }
        return this.m_infocolumns;
    }

    public String getSql() {
        String fromsql = this.getFromClause();
        String oclause = this.getOtherClause();
        if (oclause == null) {
            oclause = " ";
        }
        MInfoColumn[] mColumns = this.getInfoColumns(true, true);
        StringBuilder sql = new StringBuilder("SELECT ");
        int size = mColumns.length;
        int i2 = 0;
        while (i2 < size) {
            if (i2 != 0) {
                sql.append(",");
            }
            sql.append(mColumns[i2].getSelectClause());
            ++i2;
        }
        sql.append(" FROM ").append(fromsql).append(oclause);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Generated SQL -- getSql: " + sql.toString());
        }
        return sql.toString();
    }

    public boolean validateSql() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = this.getSql();
        try {
            try {
                String countSql = Msg.parseTranslation(Env.getCtx(), sql.toString());
                countSql = MRole.getDefault().addAccessSQL(countSql, MTable.getTableName(Env.getCtx(), this.getAD_Table_ID()), true, false);
                pstmt = DB.prepareStatement(countSql, null);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    // empty if block
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return false;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return true;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        boolean isNeedValid;
        AccessSqlParser parser = new AccessSqlParser("SELECT * FROM " + this.getFromClause());
        AccessSqlParser.TableInfo[] tableInfos = parser.getTableInfo(0);
        if (tableInfos == null || tableInfos.length == 0) {
            this.log.saveError("ParseFromClauseError", "Failed to parse from clause");
            return false;
        }
        if ((newRecord || this.is_ValueChanged("IsDefault")) && this.isDefault()) {
            if (newRecord) {
                query = new Query(this.getCtx(), MTable.get(this.getCtx(), 895), "AD_Table_ID=? AND IsDefault='Y' AND AD_Client_ID=?", this.get_TrxName());
                List list = query.setParameters(this.getAD_Table_ID(), this.getAD_Client_ID()).list();
                for (MInfoWindow iw : list) {
                    iw.setIsDefault(false);
                    iw.saveEx();
                }
            } else {
                query = new Query(this.getCtx(), MTable.get(this.getCtx(), 895), "AD_InfoWindow_ID<>? AND AD_Table_ID=? AND IsDefault='Y' AND AD_Client_ID=?", this.get_TrxName());
                List list = query.setParameters(this.getAD_InfoWindow_ID(), this.getAD_Table_ID(), this.getAD_Client_ID()).list();
                for (MInfoWindow iw : list) {
                    iw.setIsDefault(false);
                    iw.saveEx();
                }
            }
        }
        boolean bl = isNeedValid = this.is_new() || this.is_ValueChanged("AD_Table_ID") || this.is_ValueChanged("WhereClause") || this.is_ValueChanged("FromClause") || this.is_ValueChanged("OrderByClause") || this.is_ValueChanged("OtherClause") || this.is_ValueChanged("IsDistinct");
        if (isNeedValid) {
            this.validate();
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        block4: {
            block3: {
                if (!success) {
                    return success;
                }
                if (!newRecord) break block3;
                MRole[] roles = MRole.getOf(this.getCtx(), "IsManual='N'");
                int i2 = 0;
                while (i2 < roles.length) {
                    MInfoWindowAccess wa = new MInfoWindowAccess(this, roles[i2].getAD_Role_ID());
                    wa.saveEx();
                    ++i2;
                }
                break block4;
            }
            if (!this.is_ValueChanged("IsActive") && !this.is_ValueChanged("Name") && !this.is_ValueChanged("Description")) break block4;
            MMenu[] menues = MMenu.get(this.getCtx(), "AD_InfoWindow_ID=" + this.getAD_InfoWindow_ID(), this.get_TrxName());
            int i3 = 0;
            while (i3 < menues.length) {
                menues[i3].setName(this.getName());
                menues[i3].setDescription(this.getDescription());
                menues[i3].setIsActive(this.isActive());
                menues[i3].saveEx();
                ++i3;
            }
        }
        return super.afterSave(newRecord, success);
    }

    public void validate() {
        MInfoColumn[] infoColumns;
        this.setIsValid(false);
        StringBuilder builder = new StringBuilder("SELECT ");
        if (this.isDistinct()) {
            builder.append("DISTINCT ");
        }
        if ((infoColumns = this.getInfoColumns()).length == 0) {
            return;
        }
        int columnIndex = 0;
        while (columnIndex < infoColumns.length) {
            if (columnIndex > 0) {
                builder.append(", ");
            }
            builder.append(infoColumns[columnIndex].getSelectClause());
            ++columnIndex;
        }
        builder.append(" FROM ").append(this.getFromClause());
        if (this.getWhereClause() != null && this.getWhereClause().trim().length() > 0) {
            builder.append(" WHERE (1=2) AND (").append(this.getWhereClause()).append(")");
        } else {
            builder.append(" WHERE 1=2");
        }
        if (this.getOtherClause() != null && this.getOtherClause().trim().length() > 0) {
            builder.append(" ").append(this.getOtherClause());
        }
        if (this.getOrderByClause() != null && this.getOrderByClause().trim().length() > 0) {
            builder.append(" ORDER BY ").append(this.getOrderByClause());
        }
        while (builder.indexOf("@") >= 0) {
            int start = builder.indexOf("@");
            int end = builder.indexOf("@", start + 1);
            if (start < 0 || end <= start) break;
            String variable = builder.substring(start, end + 1);
            String replaced = Env.parseContext(this.getCtx(), 0, variable, false);
            if (Util.isEmpty(replaced)) {
                replaced = "0";
            }
            builder.replace(start, end + 1, replaced);
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(builder.toString(), this.get_TrxName());
                rs = pstmt.executeQuery();
            }
            catch (Exception ex) {
                this.log.log(Level.WARNING, ex.getMessage());
                throw new AdempiereException(ex);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        this.setIsValid(true);
    }

    public void setIsValidateEachColumn(boolean validateEachColumn) {
        this.m_validateEachColumn = validateEachColumn;
    }

    boolean isValidateEachColumn() {
        return this.m_validateEachColumn;
    }

    @Override
    public MInfoWindow markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_infocolumns != null && this.m_infocolumns.length > 0) {
            Arrays.stream(this.m_infocolumns).forEach(e -> {
                PO pO = e.markImmutable();
            });
        }
        if (this.m_infoProcess != null && this.m_infoProcess.length > 0) {
            Arrays.stream(this.m_infoProcess).forEach(e -> {
                MInfoProcess mInfoProcess = e.markImmutable();
            });
        }
        if (this.m_infoRelated != null && this.m_infoRelated.length > 0) {
            Arrays.stream(this.m_infoRelated).forEach(e -> {
                MInfoRelated mInfoRelated = e.markImmutable();
            });
        }
        return this;
    }

    @Override
    public I_AD_Table getAD_Table() throws RuntimeException {
        return MTable.get(Env.getCtx(), this.getAD_Table_ID(), this.get_TrxName());
    }

    public AccessSqlParser.TableInfo[] getTableInfos() {
        AccessSqlParser sqlParser = new AccessSqlParser("SELECT * FROM " + this.getFromClause());
        return sqlParser.getTableInfo(0);
    }
}

