/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.html.HTMLs;
import org.zkoss.io.Files;
import org.zkoss.io.WriterOutputStream;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.util.FastReadArray;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.DspExtendlet;
import org.zkoss.web.util.resource.Extendlet;
import org.zkoss.web.util.resource.ExtendletConfig;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.Filter;
import org.zkoss.web.util.resource.FilterChain;
import org.zkoss.web.util.resource.FilterConfig;
import org.zkoss.xml.XMLs;

public class ClassWebResource {
    private static final Logger log = LoggerFactory.getLogger(ClassWebResource.class);
    private final ServletContext _ctx;
    private String _mappingURI;
    private final CWC _cwc;
    private Set<String> _compressExts;
    private final Map<String, Extendlet> _extlets = new ConcurrentHashMap<String, Extendlet>();
    private final Map<String, FastReadArray<Filter>> _reqfilters = new ConcurrentHashMap<String, FastReadArray<Filter>>(2);
    private final Map<String, FastReadArray<Filter>> _incfilters = new ConcurrentHashMap<String, FastReadArray<Filter>>(2);
    private Locator _extraloc;
    private String _encURLPrefix;
    private boolean _debugJS;
    private boolean _sourceMapEnabled;
    public static final String PATH_PREFIX = "/web";
    private static final String ZVER = "/_zv";
    public static final int FILTER_REQUEST = 1;
    public static final int FILTER_INCLUDE = 2;
    private static final long _expires;
    private static final Object LOCK;

    public static URL getClassResource(String uri) {
        return Locators.getDefault().getResource(PATH_PREFIX + ClassWebResource.fixURI(uri));
    }

    public static InputStream getClassResourceAsStream(String uri) {
        return Locators.getDefault().getResourceAsStream(PATH_PREFIX + ClassWebResource.fixURI(uri));
    }

    public URL getResource(String uri) {
        URL url;
        uri = ClassWebResource.fixURI(uri);
        if (this._extraloc != null && (url = this._extraloc.getResource(uri)) != null) {
            return url;
        }
        Path normalized = Path.of(PATH_PREFIX, uri).normalize();
        if (!normalized.toString().startsWith(Path.of(PATH_PREFIX, new String[0]).normalize().toString())) {
            throw new IllegalArgumentException("User path escapes the base path [" + normalized + "]");
        }
        return Locators.getDefault().getResource(PATH_PREFIX + uri);
    }

    public InputStream getResourceAsStream(String uri) {
        InputStream is;
        uri = ClassWebResource.fixURI(uri);
        if (this._extraloc != null && (is = this._extraloc.getResourceAsStream(uri)) != null) {
            return is;
        }
        Path normalized = Path.of(PATH_PREFIX, uri).normalize();
        if (!normalized.toString().startsWith(Path.of(PATH_PREFIX, new String[0]).normalize().toString())) {
            throw new IllegalArgumentException("User path escapes the base path [" + normalized + "]");
        }
        return Locators.getDefault().getResourceAsStream(PATH_PREFIX + uri);
    }

    private static String fixURI(String uri) {
        int j = uri.lastIndexOf(63);
        if (j >= 0) {
            uri = uri.substring(0, j);
        }
        if ((j = uri.lastIndexOf(";jsession")) >= 0) {
            uri = uri.substring(0, j);
        }
        return uri;
    }

    private static void setClientCacheForever(HttpServletResponse response) {
        if (!"false".equals(Library.getProperty((String)"org.zkoss.web.classWebResource.cache"))) {
            response.setHeader("Cache-Control", "public, max-age=31536000");
            response.setDateHeader("Expires", _expires);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ClassWebResource getInstance(ServletContext ctx, String mappingURI) {
        Object object = LOCK;
        synchronized (object) {
            CWC cwc = (CWC)Servlets.getExtendletContext(ctx, ".");
            if (cwc != null) {
                return cwc.getClassWebResource();
            }
            ClassWebResource cwr = new ClassWebResource(ctx, mappingURI);
            Servlets.addExtendletContext(ctx, ".", cwr._cwc);
            return cwr;
        }
    }

    private ClassWebResource(ServletContext ctx, String mappingURI) {
        if (!mappingURI.startsWith("/") || mappingURI.endsWith("/")) {
            throw new IllegalArgumentException("mappingURI must start with /, but not ends with /");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("null ctx");
        }
        this._ctx = ctx;
        this._mappingURI = mappingURI + PATH_PREFIX;
        this._cwc = new CWC();
        this.addExtendlet("dsp", new DspExtendlet());
    }

    public Locator getExtraLocator() {
        return this._extraloc;
    }

    public void setExtraLocator(Locator loc) {
        this._extraloc = loc;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pi = Https.getThisPathInfo((ServletRequest)request);
        if (pi != null) {
            Path normalized = Path.of(pi, new String[0]).normalize();
            if (!normalized.toString().startsWith(Path.of(PATH_PREFIX, new String[0]).normalize().toString())) {
                throw new IllegalArgumentException("User path escapes the base path [" + normalized + "]");
            }
            this.service(request, response, pi.substring(PATH_PREFIX.length()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        Servlets.getBrowser((ServletRequest)request);
        Object old = Charsets.setup((ServletRequest)request, (ServletResponse)response, "UTF-8");
        try {
            this.web(request, response, path);
        }
        finally {
            Charsets.cleanup((ServletRequest)request, old);
        }
    }

    public Extendlet getExtendlet(String ext, boolean lookup) {
        if (ext == null) {
            return null;
        }
        ext = ext.toLowerCase(Locale.ENGLISH);
        while (true) {
            Extendlet exlet = this._extlets.get(ext);
            if (!lookup || exlet != null) {
                return exlet;
            }
            int j = ext.indexOf(46);
            if (j < 0) {
                return null;
            }
            ext = ext.substring(j + 1);
        }
    }

    public Extendlet getExtendlet(String ext) {
        return this.getExtendlet(ext, true);
    }

    public Extendlet addExtendlet(String ext, Extendlet extlet) {
        if (ext == null || extlet == null) {
            throw new IllegalArgumentException("null");
        }
        extlet.init(new ExtendletConfig(){

            @Override
            public ExtendletContext getExtendletContext() {
                return ClassWebResource.this._cwc;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCompressExtension(String ext) {
                ClassWebResource classWebResource = ClassWebResource.this;
                synchronized (classWebResource) {
                    if (ClassWebResource.this._compressExts == null) {
                        ClassWebResource.this._compressExts = new LinkedHashSet<String>();
                    }
                    ClassWebResource.this._compressExts.add(ext);
                }
            }
        });
        ext = ext.toLowerCase(Locale.ENGLISH);
        return this._extlets.put(ext, extlet);
    }

    public Extendlet removeExtendlet(String ext) {
        if (ext == null) {
            return null;
        }
        ext = ext.toLowerCase(Locale.ENGLISH);
        return this._extlets.remove(ext);
    }

    public Filter[] getFilters(String ext, int flag) {
        Map<String, FastReadArray<Filter>> filters;
        if (ext == null) {
            return null;
        }
        ext = ext.toLowerCase(Locale.ENGLISH);
        Map<String, FastReadArray<Filter>> map = filters = flag == 0 || (flag & 1) != 0 ? this._reqfilters : this._incfilters;
        if (filters.isEmpty()) {
            return null;
        }
        FastReadArray<Filter> ary;
        while ((ary = filters.get(ext)) == null) {
            int j = ext.indexOf(46);
            if (j < 0) {
                return null;
            }
            ext = ext.substring(j + 1);
        }
        return (Filter[])ary.toArray();
    }

    public void addFilter(String ext, Filter filter, int flags) {
        if (ext == null || filter == null) {
            throw new IllegalArgumentException("null");
        }
        filter.init(new FilterConfig(){

            @Override
            public ExtendletContext getExtendletContext() {
                return ClassWebResource.this._cwc;
            }
        });
        ext = ext.toLowerCase(Locale.ENGLISH);
        if (flags == 0 || (flags & 1) != 0) {
            ClassWebResource.addFilter(this._reqfilters, ext, filter);
        }
        if ((flags & 2) != 0) {
            ClassWebResource.addFilter(this._incfilters, ext, filter);
        }
    }

    private static void addFilter(Map<String, FastReadArray<Filter>> filters, String ext, Filter filter) {
        FastReadArray ary = filters.computeIfAbsent(ext, k -> new FastReadArray(Filter.class));
        ary.add((Object)filter);
    }

    public boolean removeFilter(String ext, Filter filter, int flags) {
        if (ext == null || filter == null) {
            return false;
        }
        ext = ext.toLowerCase(Locale.ENGLISH);
        boolean removed = false;
        if (flags == 0 || (flags & 1) != 0) {
            removed = ClassWebResource.rmFilter(this._reqfilters, ext, filter);
        }
        if ((flags & 2) != 0) {
            removed = ClassWebResource.rmFilter(this._incfilters, ext, filter) || removed;
        }
        return removed;
    }

    private static boolean rmFilter(Map<String, FastReadArray<Filter>> filters, String ext, Filter filter) {
        FastReadArray<Filter> ary = filters.get(ext);
        if (ary != null && ary.remove((Object)filter)) {
            if (ary.isEmpty()) {
                ary = filters.remove(ext);
            }
            if (ary != null && !ary.isEmpty()) {
                filters.put(ext, ary);
            }
            return true;
        }
        return false;
    }

    public void setCompress(String[] exts) {
        if (exts != null && exts.length > 0) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            int j = exts.length;
            while (--j >= 0) {
                set.add(exts[j]);
            }
            this._compressExts = set;
        } else {
            this._compressExts = null;
        }
    }

    public String[] getCompress() {
        return this._compressExts != null ? this._compressExts.toArray(new String[this._compressExts.size()]) : null;
    }

    public boolean isDebugJS() {
        return this._debugJS;
    }

    public void setDebugJS(boolean debug) {
        this._debugJS = debug;
    }

    public void setMappingURI(String mappingURI) {
        if (!mappingURI.startsWith("/") || mappingURI.endsWith("/")) {
            throw new IllegalArgumentException("mappingURI must start with /, but not ends with /");
        }
        this._mappingURI = mappingURI + PATH_PREFIX;
    }

    private void web(HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
        String ext = Servlets.getExtension(pi = this.modifyPath(pi), false);
        Filter[] filters = this.getFilters(ext, Servlets.isIncluded((ServletRequest)request) ? 2 : 1);
        if (filters == null) {
            this.web0(request, response, pi, ext);
        } else {
            new FilterChainImpl(filters, pi, ext).doFilter(request, response);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void web0(HttpServletRequest request, HttpServletResponse response, String pi, String ext) throws ServletException, IOException {
        ServletOutputStream out;
        byte[] data;
        boolean compressed;
        block25: {
            String orgpi;
            Extendlet extlet;
            if (ext != null && (extlet = this.getExtendlet(ext)) != null) {
                extlet.service(request, response, pi);
                return;
            }
            if (!Servlets.isIncluded((ServletRequest)request)) {
                Object ctype = ContentTypes.getContentType((String)ext);
                if (ctype == null) {
                    ctype = ";charset=UTF-8";
                } else {
                    int k = ((String)ctype).indexOf(59);
                    if (k >= 0) {
                        ctype = ((String)ctype).substring(0, k);
                    }
                    if (!ContentTypes.isBinary((String)ctype)) {
                        ctype = (String)ctype + ";charset=UTF-8";
                    }
                }
                response.setContentType((String)ctype);
                if (pi.indexOf(42) < 0) {
                    ClassWebResource.setClientCacheForever(response);
                }
            }
            InputStream is = null;
            compressed = false;
            if (this._debugJS && "js".equals(ext) && !this._sourceMapEnabled && (is = this.getResourceAsStream(orgpi = Servlets.locate(this._ctx, (ServletRequest)request, pi.substring(0, pi.length() - 3) + ".src.js", this._cwc.getLocator()))) != null) {
                pi = orgpi;
            }
            if (is == null) {
                String p = Servlets.locate(this._ctx, (ServletRequest)request, pi, this._cwc.getLocator());
                is = this.getResourceAsStream(p);
            }
            if (is == null) {
                if ("js".equals(ext)) {
                    data = ("(window.zk&&zk.error?zk.error:alert)('" + HTMLs.encodeJavaScript((String)XMLs.encodeText((String)pi)) + " not found');").getBytes("UTF-8");
                    break block25;
                } else {
                    if (Servlets.isIncluded((ServletRequest)request)) {
                        log.error("Resource not found: " + Encodes.encodeURI(pi));
                    }
                    response.sendError(404, HTMLs.encodeJavaScript((String)XMLs.escapeXML((String)pi)));
                    return;
                }
            }
            data = this.shallCompress((ServletRequest)request, ext) ? Https.gzip(request, response, is, null) : null;
            compressed = data != null;
            if (!compressed) {
                data = Files.readAll((InputStream)is);
            }
            Files.close((InputStream)is);
        }
        int len = data.length;
        response.setContentLength(len);
        if (Servlets.isIncluded((ServletRequest)request)) {
            try {
                out = new WriterOutputStream((Writer)response.getWriter(), "UTF-8");
            }
            catch (IllegalStateException ex) {
                try {
                    out = response.getOutputStream();
                }
                catch (Throwable t) {
                    log.warn("getOutputStream: failed" + Exceptions.getMessage((Throwable)t));
                    throw ex;
                }
            }
        } else {
            try {
                out = response.getOutputStream();
            }
            catch (IllegalStateException ex) {
                if (compressed) {
                    throw ex;
                }
                try {
                    out = new WriterOutputStream((Writer)response.getWriter(), "UTF-8");
                }
                catch (Throwable t) {
                    log.warn("getWriter: failed" + Exceptions.getMessage((Throwable)t));
                    throw ex;
                }
            }
        }
        out.write(data);
        out.flush();
    }

    private boolean shallCompress(ServletRequest request, String ext) {
        return this._compressExts != null && this._compressExts.contains(ext) && !Servlets.isIncluded(request);
    }

    public void setEncodeURLPrefix(String prefix) {
        if (prefix == null || ((String)prefix).length() == 0) {
            prefix = null;
        } else if (((String)prefix).charAt(0) != '/') {
            prefix = "/" + (String)prefix;
        }
        this._encURLPrefix = prefix;
    }

    public String getEncodeURLPrefix() {
        return this._encURLPrefix;
    }

    public String modifyPath(String path) throws UnsupportedEncodingException {
        int len2;
        int len1;
        if (path.startsWith(ZVER)) {
            int j = path.indexOf(47, ZVER.length());
            if (j >= 0) {
                path = path.substring(j);
            } else {
                log.warn("Unknown path info: " + Encodes.encodeURI(path));
            }
        } else if (this._encURLPrefix != null && path.startsWith(this._encURLPrefix) && (len1 = path.length()) > (len2 = this._encURLPrefix.length()) && path.charAt(len2) == '/') {
            path = path.substring(len2);
        }
        return path;
    }

    public boolean isSourceMapEnabled() {
        return this._sourceMapEnabled;
    }

    public void setSourceMapEnabled(boolean sourceMapEnabled) {
        this._sourceMapEnabled = sourceMapEnabled;
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.add(6, 365);
        _expires = cal.getTime().getTime();
        LOCK = new Object();
    }

    private class FilterChainImpl
    implements FilterChain {
        private final Filter[] _filters;
        private final String _pi;
        private final String _ext;
        private int _j;

        private FilterChainImpl(Filter[] filters, String pi, String ext) throws ServletException, IOException {
            this._pi = pi;
            this._filters = filters;
            this._ext = ext;
        }

        @Override
        public void doFilter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            int j;
            if (this._j > this._filters.length) {
                throw new IllegalStateException("Out of bound: " + this._j + ", filter=" + Objects.toString((Object)this._filters));
            }
            if ((j = this._j++) == this._filters.length) {
                ClassWebResource.this.web0(request, response, this._pi, this._ext);
            } else {
                this._filters[j].doFilter(request, response, this._pi, this);
            }
        }
    }

    private class CWC
    implements ExtendletContext {
        private final Locator _locator = new Locator(){

            public String getDirectory() {
                return null;
            }

            public URL getResource(String name) {
                return ClassWebResource.this.getResource(name);
            }

            public InputStream getResourceAsStream(String name) {
                return ClassWebResource.this.getResourceAsStream(name);
            }
        };

        private CWC() {
        }

        public ClassWebResource getClassWebResource() {
            return ClassWebResource.this;
        }

        @Override
        public ServletContext getServletContext() {
            return ClassWebResource.this._ctx;
        }

        @Override
        public Locator getLocator() {
            return this._locator;
        }

        @Override
        public boolean shallCompress(ServletRequest request, String ext) {
            return ClassWebResource.this.shallCompress(request, ext);
        }

        @Override
        public String encodeURL(ServletRequest request, ServletResponse response, String uri) throws ServletException, UnsupportedEncodingException {
            int j;
            uri = Servlets.locate(ClassWebResource.this._ctx, request, (String)uri, this.getLocator());
            uri = (String)(ClassWebResource.this._encURLPrefix != null ? ClassWebResource.this._mappingURI + ClassWebResource.this._encURLPrefix : ClassWebResource.this._mappingURI) + (String)uri;
            if (request instanceof HttpServletRequest) {
                Object ctxpath = Https.getThisContextPath(request);
                if (ctxpath == null) {
                    throw new NullPointerException("HttpServletRequest#getContentPath() returns a null value from [ " + request + " ]");
                }
                int ctxlen = ((String)ctxpath).length();
                if (ctxlen > 0) {
                    char cc = ((String)ctxpath).charAt(0);
                    if (cc != '/') {
                        ctxpath = "/" + (String)ctxpath;
                    } else if (ctxlen == 1) {
                        ctxpath = "";
                    }
                }
                uri = (String)ctxpath + (String)uri;
            }
            uri = (j = ((String)uri).indexOf(63)) < 0 ? Encodes.encodeURI((String)uri) : Encodes.encodeURI(((String)uri).substring(0, j)) + ((String)uri).substring(j);
            if (response instanceof HttpServletResponse) {
                uri = ((HttpServletResponse)response).encodeURL((String)uri);
            }
            return uri;
        }

        @Override
        public String encodeRedirectURL(HttpServletRequest request, HttpServletResponse response, String uri, Map params, int mode) {
            return Https.encodeRedirectURL(ClassWebResource.this._ctx, request, response, ClassWebResource.this._mappingURI + uri, params, mode);
        }

        @Override
        public RequestDispatcher getRequestDispatcher(String uri) {
            return ClassWebResource.this._ctx.getRequestDispatcher(ClassWebResource.this._mappingURI + uri);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void include(HttpServletRequest request, HttpServletResponse response, String uri, Map params) throws ServletException, IOException {
            if (uri.startsWith("~./") && uri.indexOf(63) < 0 && this.isDirectInclude(uri)) {
                Object old = request.getAttribute("arg");
                if (params != null) {
                    request.setAttribute("arg", (Object)params);
                }
                String attrnm = "org.zkoss.web.servlet.include";
                request.setAttribute("org.zkoss.web.servlet.include", (Object)Boolean.TRUE);
                try {
                    ClassWebResource.this.service(request, response, Servlets.locate(ClassWebResource.this._ctx, (ServletRequest)request, uri.substring(2), ClassWebResource.this._cwc.getLocator()));
                }
                finally {
                    request.removeAttribute("org.zkoss.web.servlet.include");
                    request.setAttribute("arg", old);
                }
            } else {
                Servlets.include(ClassWebResource.this._ctx, (ServletRequest)request, (ServletResponse)response, uri, params, 3);
            }
        }

        private boolean isDirectInclude(String path) {
            Extendlet extlet;
            String ext = Servlets.getExtension(path, false);
            Extendlet extendlet = extlet = ext != null ? ClassWebResource.this.getExtendlet(ext) : null;
            if (extlet != null) {
                try {
                    return extlet.getFeature(1);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }

        @Override
        public URL getResource(String uri) {
            return ClassWebResource.this.getResource(uri);
        }

        @Override
        public InputStream getResourceAsStream(String uri) {
            return ClassWebResource.this.getResourceAsStream(uri);
        }
    }
}

