/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.eventusermodel;

import java.io.IOException;
import java.io.InputStream;
import org.zkoss.poi.hssf.eventusermodel.HSSFRequest;
import org.zkoss.poi.hssf.eventusermodel.HSSFUserException;
import org.zkoss.poi.hssf.record.Record;
import org.zkoss.poi.hssf.record.RecordFactoryInputStream;
import org.zkoss.poi.poifs.filesystem.DirectoryNode;
import org.zkoss.poi.poifs.filesystem.DocumentInputStream;
import org.zkoss.poi.poifs.filesystem.POIFSFileSystem;

public class HSSFEventFactory {
    public void processWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException {
        this.processWorkbookEvents(req, fs.getRoot());
    }

    public void processWorkbookEvents(HSSFRequest req, DirectoryNode dir) throws IOException {
        DocumentInputStream in = dir.createDocumentInputStream("Workbook");
        this.processEvents(req, in);
    }

    public short abortableProcessWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException, HSSFUserException {
        return this.abortableProcessWorkbookEvents(req, fs.getRoot());
    }

    public short abortableProcessWorkbookEvents(HSSFRequest req, DirectoryNode dir) throws IOException, HSSFUserException {
        DocumentInputStream in = dir.createDocumentInputStream("Workbook");
        return this.abortableProcessEvents(req, in);
    }

    public void processEvents(HSSFRequest req, InputStream in) {
        try {
            this.genericProcessEvents(req, in);
        }
        catch (HSSFUserException hSSFUserException) {
            // empty catch block
        }
    }

    public short abortableProcessEvents(HSSFRequest req, InputStream in) throws HSSFUserException {
        return this.genericProcessEvents(req, in);
    }

    private short genericProcessEvents(HSSFRequest req, InputStream in) throws HSSFUserException {
        Record r;
        short userCode = 0;
        RecordFactoryInputStream recordStream = new RecordFactoryInputStream(in, false);
        while ((r = recordStream.nextRecord()) != null && (userCode = req.processRecord(r)) == 0) {
        }
        return userCode;
    }
}

