/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.ModelEvent;
import io.keikai.model.ModelEventListener;
import io.keikai.model.impl.EventListenerAdaptor;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class EventQueueListenerAdaptor
implements EventListenerAdaptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private String queueName;
    private String queueScope;
    private final List<WrappedListener> listeners = new LinkedList<WrappedListener>();

    public EventQueueListenerAdaptor(String scope, String bookId) {
        this.queueScope = scope;
        this.queueName = "kkModel_" + bookId;
    }

    @Override
    public void addEventListener(ModelEventListener listener) {
        WrappedListener l = new WrappedListener(listener);
        if (!this.listeners.contains(l)) {
            EventQueue queue = EventQueues.lookup((String)this.queueName, (String)this.queueScope, (boolean)true);
            queue.subscribe((EventListener)l);
            this.listeners.add(l);
        }
    }

    @Override
    public void removeEventListener(ModelEventListener listener) {
        WrappedListener l = new WrappedListener(listener);
        if (this.listeners.contains(l)) {
            EventQueue queue = EventQueues.lookup((String)this.queueName, (String)this.queueScope, (boolean)false);
            if (queue != null) {
                queue.unsubscribe((EventListener)l);
            }
            this.listeners.remove(l);
        }
    }

    @Override
    public void sendModelEvent(ModelEvent event) {
        EventQueue queue = EventQueues.lookup((String)this.queueName, (String)this.queueScope, (boolean)false);
        if (queue == null) {
            return;
        }
        queue.publish(new Event("onModelEvent", null, (Object)event));
    }

    @Override
    public void clear() {
        EventQueue queue = EventQueues.lookup((String)this.queueName, (String)this.queueScope, (boolean)false);
        if (queue != null) {
            for (WrappedListener l : this.listeners) {
                queue.unsubscribe((EventListener)l);
            }
        }
        this.listeners.clear();
    }

    @Override
    public int size() {
        return this.listeners.size();
    }

    static class WrappedListener
    implements SerializableEventListener<Event> {
        private static final long serialVersionUID = 1874923168106607228L;
        ModelEventListener listener;

        public WrappedListener(ModelEventListener l) {
            this.listener = l;
        }

        public void onEvent(Event event) throws Exception {
            ModelEvent me = (ModelEvent)event.getData();
            this.listener.onEvent(me);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WrappedListener other = (WrappedListener)obj;
            return !(this.listener == null ? other.listener != null : !this.listener.equals(other.listener));
        }
    }
}

