/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SCFValueObject;
import io.keikai.model.SColor;
import io.keikai.model.SDataBar;
import io.keikai.model.impl.CFValueObjectImpl;
import io.keikai.model.impl.ColorImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DataBarImpl
implements SDataBar,
Serializable {
    private static final long serialVersionUID = -4969929958321921242L;
    private List<SCFValueObject> valueObjects;
    private SColor color;
    private int minLength = 10;
    private int maxLength = 90;
    private boolean showValue = true;

    @Override
    public List<SCFValueObject> getCFValueObjects() {
        return this.valueObjects;
    }

    public void addValueObject(SCFValueObject vobject) {
        if (this.valueObjects == null) {
            this.valueObjects = new ArrayList<SCFValueObject>();
        }
        this.valueObjects.add(vobject);
    }

    @Override
    public SColor getColor() {
        return this.color;
    }

    public void setColor(SColor color) {
        this.color = color;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public boolean isShowValue() {
        return this.showValue;
    }

    public void setShowValue(boolean b) {
        this.showValue = b;
    }

    public DataBarImpl cloneDataBar(SBook book) {
        DataBarImpl bar = new DataBarImpl();
        for (SCFValueObject vo : this.valueObjects) {
            CFValueObjectImpl vo0 = (CFValueObjectImpl)vo;
            bar.addValueObject(vo0.cloneCFValueObject());
        }
        ColorImpl color0 = (ColorImpl)this.color;
        bar.color = color0.cloneColor(book);
        bar.minLength = this.minLength;
        bar.maxLength = this.maxLength;
        bar.showValue = this.showValue;
        return bar;
    }
}

