/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiFunction;

public class MergeEntryProcessor<K, V>
implements EntryProcessor<K, V, V>,
IdentifiedDataSerializable {
    BiFunction<? super V, ? super V, ? extends V> biFunction;
    V value;

    public MergeEntryProcessor() {
    }

    public MergeEntryProcessor(BiFunction<? super V, ? super V, ? extends V> biFunction, V value) {
        this.biFunction = biFunction;
        this.value = value;
    }

    @Override
    public V process(Map.Entry<K, V> entry) {
        V oldValue = entry.getValue();
        if (oldValue != null) {
            V newValue = this.biFunction.apply(oldValue, this.value);
            if (newValue != null) {
                entry.setValue(newValue);
                return newValue;
            }
            ((LazyMapEntry)entry).remove();
            return null;
        }
        entry.setValue(this.value);
        return this.value;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 152;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.biFunction);
        out.writeObject(this.value);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.biFunction = (BiFunction)in.readObject();
        this.value = in.readObject();
    }
}

