/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.strategy;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.internal.serialization.impl.GenericRecordQueryReader;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.query.impl.getters.JsonGetter;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nonnull;

@SerializableByConvention
public class AttributePartitioningStrategy
implements PartitioningStrategy<Object> {
    private final String[] attributes;

    public AttributePartitioningStrategy(String ... attributes) {
        AttributePartitioningStrategy.checkAttributesAreValid(attributes);
        this.attributes = attributes;
    }

    @Override
    public Object getPartitionKey(Object key) {
        Object[] result;
        if (key instanceof InternalGenericRecord) {
            result = this.extractFromGenericRecord((InternalGenericRecord)key);
        } else if (key instanceof HazelcastJsonValue) {
            result = this.extractFromJson(key);
        } else if (key instanceof DataSerializable || key instanceof Serializable) {
            result = this.extractFromPojo(key);
        } else {
            throw new HazelcastException("Cannot extract attributes from the key");
        }
        return this.attributes.length == 1 ? result[0] : result;
    }

    @Nonnull
    private Object[] extractFromPojo(Object key) {
        Object[] values = new Object[this.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            String attribute = this.attributes[i];
            Object value = ReflectionUtils.getFieldValue(attribute, key);
            AttributePartitioningStrategy.checkNull(value, attribute);
            values[i] = value;
        }
        return values;
    }

    @Nonnull
    private Object[] extractFromJson(Object key) {
        Object[] values = new Object[this.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            Object value = JsonGetter.INSTANCE.getValue(key, this.attributes[i]);
            AttributePartitioningStrategy.checkNull(value, this.attributes[i]);
            values[i] = value;
        }
        return values;
    }

    @Nonnull
    private Object[] extractFromGenericRecord(InternalGenericRecord key) {
        Object[] values = new Object[this.attributes.length];
        GenericRecordQueryReader reader = new GenericRecordQueryReader(key);
        for (int i = 0; i < this.attributes.length; ++i) {
            String attribute = this.attributes[i];
            try {
                Object value = reader.read(attribute);
                AttributePartitioningStrategy.checkNull(value, this.attributes[i]);
                values[i] = value;
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return values;
    }

    public String[] getPartitioningAttributes() {
        return this.attributes;
    }

    private static void checkNull(Object extracted, String attributeName) {
        if (extracted == null) {
            throw new HazelcastException("Cannot extract '" + attributeName + "' from the key");
        }
    }

    private static void checkAttributesAreValid(String[] attributes) {
        if (attributes == null) {
            throw new NullPointerException("Attributes names array must not be null.");
        }
        if (attributes.length == 0) {
            throw new IllegalArgumentException("Attributes names array must not be empty.");
        }
        for (String attribute : attributes) {
            if (attribute != null && !attribute.isEmpty()) continue;
            throw new IllegalArgumentException("Attribute name must not be empty.");
        }
    }
}

