/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.Env;

public class CalloutMovement
extends CalloutEngine {
    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        if (Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_Product_ID") == M_Product_ID && Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID"));
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)0);
        }
        MProduct product = MProduct.get((Properties)ctx, (int)M_Product_ID);
        mTab.setValue("C_UOM_ID", (Object)product.getC_UOM_ID());
        mTab.setValue("MovementQty", mTab.getValue("QtyEntered"));
        this.checkQtyAvailable(ctx, mTab, WindowNo, M_Product_ID, null);
        return "";
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null || mTab.getValue("M_Product_ID") == null) {
            return "";
        }
        BigDecimal movementQty = Env.ZERO;
        BigDecimal qtyEntered = Env.ZERO;
        int C_UOM_To_ID = 0;
        int M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (mField.getColumnName().equals("C_UOM_ID") || mField.getColumnName().equals("QtyEntered")) {
            boolean conversion;
            if (mField.getColumnName().equals("C_UOM_ID")) {
                C_UOM_To_ID = (Integer)value;
                qtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            } else if (mField.getColumnName().equals("QtyEntered")) {
                C_UOM_To_ID = (Integer)mTab.getValue("C_UOM_ID");
                qtyEntered = (BigDecimal)value;
            }
            BigDecimal qtyEntered1 = qtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), RoundingMode.HALF_UP);
            if (qtyEntered.compareTo(qtyEntered1) != 0) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + String.valueOf(qtyEntered) + "->" + String.valueOf(qtyEntered1));
                }
                qtyEntered = qtyEntered1;
                mTab.setValue("QtyEntered", (Object)qtyEntered);
            }
            if ((movementQty = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)qtyEntered)) == null) {
                movementQty = qtyEntered;
            }
            boolean bl = conversion = qtyEntered.compareTo(movementQty) != 0;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("UOM=" + C_UOM_To_ID + ", qtyEntered=" + String.valueOf(qtyEntered) + " -> " + conversion + " movementQty=" + String.valueOf(movementQty));
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("MovementQty", (Object)movementQty);
        } else if (mField.getColumnName().equals("MovementQty")) {
            boolean conversion;
            C_UOM_To_ID = (Integer)mTab.getValue("C_UOM_ID");
            movementQty = (BigDecimal)value;
            int precision = MProduct.get((Properties)ctx, (int)M_Product_ID).getUOMPrecision();
            BigDecimal movementQty1 = movementQty.setScale(precision, RoundingMode.HALF_UP);
            if (movementQty.compareTo(movementQty1) != 0) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Corrected MovementQty Scale " + String.valueOf(movementQty) + "->" + String.valueOf(movementQty1));
                }
                movementQty = movementQty1;
                mTab.setValue("MovementQty", (Object)movementQty);
            }
            if ((qtyEntered = MUOMConversion.convertProductTo((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)movementQty)) == null) {
                qtyEntered = movementQty;
            }
            boolean bl = conversion = movementQty.compareTo(qtyEntered) != 0;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("UOM=" + C_UOM_To_ID + ", MovementQty=" + String.valueOf(movementQty) + " -> " + conversion + " QtyEntered=" + String.valueOf(qtyEntered));
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyEntered", (Object)qtyEntered);
        } else {
            movementQty = (BigDecimal)mTab.getValue("MovementQty");
        }
        this.checkQtyAvailable(ctx, mTab, WindowNo, M_Product_ID, movementQty);
        return "";
    }

    public String locator(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Product_ID");
        this.checkQtyAvailable(ctx, mTab, WindowNo, M_Product_ID, null);
        return "";
    }

    private void checkQtyAvailable(Properties ctx, GridTab mTab, int WindowNo, int M_Product_ID, BigDecimal MovementQty) {
        MProduct product;
        if (M_Product_ID != 0 && (product = MProduct.get((Properties)ctx, (int)M_Product_ID)).isStocked()) {
            int M_Locator_ID;
            if (MovementQty == null) {
                MovementQty = (BigDecimal)mTab.getValue("MovementQty");
            }
            if ((M_Locator_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Locator_ID")) <= 0) {
                return;
            }
            int M_AttributeSetInstance_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_AttributeSetInstance_ID");
            BigDecimal available = MStorageOnHand.getQtyOnHandForLocator((int)M_Product_ID, (int)M_Locator_ID, (int)M_AttributeSetInstance_ID, null);
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() == 0) {
                mTab.fireDataStatusEEvent("NoQtyAvailable", "0", false);
            } else if (available.compareTo(MovementQty) < 0) {
                mTab.fireDataStatusEEvent("InsufficientQtyAvailable", available.toString(), false);
            }
        }
    }
}

