/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSystemColor;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;
import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.openxml4j.opc.PackagePart;
import org.zkoss.poi.openxml4j.opc.PackageRelationship;
import org.zkoss.poi.xssf.usermodel.XSSFColor;

public class ThemesTable
extends POIXMLDocumentPart {
    private ThemeDocument theme;

    public ThemesTable(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        try {
            this.theme = ThemeDocument.Factory.parse((InputStream)part.getInputStream());
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public ThemesTable(ThemeDocument theme) {
        this.theme = theme;
    }

    private XSSFColor getRGBColor(CTColor ctColor) {
        if (ctColor != null) {
            CTSystemColor sysClr = ctColor.getSysClr();
            if (sysClr != null) {
                return new XSSFColor(sysClr.getLastClr());
            }
            CTSRgbColor srgbClr = ctColor.getSrgbClr();
            if (srgbClr != null) {
                return new XSSFColor(srgbClr.getVal());
            }
        }
        return null;
    }

    public XSSFColor getThemeColor(int idx) {
        CTColorScheme colorScheme = this.theme.getTheme().getThemeElements().getClrScheme();
        switch (idx) {
            case 0: {
                return this.getRGBColor(colorScheme.getLt1());
            }
            case 1: {
                return this.getRGBColor(colorScheme.getDk1());
            }
            case 2: {
                return this.getRGBColor(colorScheme.getLt2());
            }
            case 3: {
                return this.getRGBColor(colorScheme.getDk2());
            }
        }
        CTColor ctColor = null;
        int cnt = 0;
        for (XmlObject obj : colorScheme.selectPath("./*")) {
            if (!(obj instanceof CTColor)) continue;
            if (cnt == idx) {
                ctColor = (CTColor)obj;
                return this.getRGBColor(ctColor);
            }
            ++cnt;
        }
        return null;
    }

    public void inheritFromThemeAsRequired(XSSFColor color) {
        if (color == null) {
            return;
        }
        if (!color.getCTColor().isSetTheme()) {
            return;
        }
        XSSFColor themeColor = this.getThemeColor(color.getTheme());
        color.getCTColor().setRgb(themeColor.getCTColor().getRgb());
    }
}

