/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api;

import io.keikai.api.model.Book;
import io.keikai.api.model.impl.BookImpl;
import io.keikai.model.SBook;
import io.keikai.model.SBookSeriesBuilder;
import java.util.Set;

public abstract class BookSeriesBuilder {
    private static BookSeriesBuilder _instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BookSeriesBuilder getInstance() {
        if (_instance != null) return _instance;
        Class<BookSeriesBuilder> clazz = BookSeriesBuilder.class;
        synchronized (BookSeriesBuilder.class) {
            if (_instance != null) return _instance;
            _instance = new BookSeriesBuilderWrap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public abstract void buildBookSeries(Set<Book> var1);

    public abstract void buildBookSeries(Book ... var1);

    static class BookSeriesBuilderWrap
    extends BookSeriesBuilder {
        BookSeriesBuilderWrap() {
        }

        @Override
        public void buildBookSeries(Set<Book> books) {
            this.buildBookSeries(books.toArray(new Book[books.size()]));
        }

        @Override
        public void buildBookSeries(Book ... books) {
            if (books == null) {
                throw new IllegalArgumentException("books is null");
            }
            SBook[] xbooks = new SBook[books.length];
            for (int i = 0; i < xbooks.length; ++i) {
                xbooks[i] = ((BookImpl)books[i]).getNative();
            }
            SBookSeriesBuilder.getInstance().buildBookSeries(xbooks);
        }
    }
}

