/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api.impl;

import io.keikai.api.CellVisitor;
import io.keikai.api.IllegalFormulaException;
import io.keikai.api.Range;
import io.keikai.api.RangeRunner;
import io.keikai.api.Ranges;
import io.keikai.api.SheetAnchor;
import io.keikai.api.impl.CellStyleHelperImpl;
import io.keikai.api.model.Book;
import io.keikai.api.model.CellData;
import io.keikai.api.model.CellStyle;
import io.keikai.api.model.Chart;
import io.keikai.api.model.Color;
import io.keikai.api.model.Font;
import io.keikai.api.model.Hyperlink;
import io.keikai.api.model.Picture;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.SheetProtection;
import io.keikai.api.model.Validation;
import io.keikai.api.model.impl.BookImpl;
import io.keikai.api.model.impl.CellDataImpl;
import io.keikai.api.model.impl.CellStyleImpl;
import io.keikai.api.model.impl.ChartImpl;
import io.keikai.api.model.impl.EnumUtil;
import io.keikai.api.model.impl.FontImpl;
import io.keikai.api.model.impl.HyperlinkImpl;
import io.keikai.api.model.impl.ModelRef;
import io.keikai.api.model.impl.PictureImpl;
import io.keikai.api.model.impl.SheetImpl;
import io.keikai.api.model.impl.SheetProtectionImpl;
import io.keikai.api.model.impl.SimpleRef;
import io.keikai.api.model.impl.ValidationImpl;
import io.keikai.model.CellRegion;
import io.keikai.model.InvalidFormulaException;
import io.keikai.model.SBook;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SChart;
import io.keikai.model.SDataValidation;
import io.keikai.model.SFont;
import io.keikai.model.SHyperlink;
import io.keikai.model.SPicture;
import io.keikai.model.SSheet;
import io.keikai.model.SSheetProtection;
import io.keikai.model.STable;
import io.keikai.model.ViewAnchor;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.CellAttribute;
import io.keikai.range.SRange;
import io.keikai.range.SRanges;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;

public class RangeImpl
implements Range,
Serializable {
    private static final long serialVersionUID = 500576741914800746L;
    private SRange _range;
    private Range.CellStyleHelper _cellStyleHelper;
    private CellData _cellData;
    private static int DEFAULT_CHART_WIDTH = 600;
    private static int DEFAULT_CHART_HEIGHT = 480;
    private SharedContext _sharedCtx;

    @Override
    public void setSyncLevel(Range.SyncLevel syncLevel) {
    }

    public RangeImpl(SRange range, Sheet sheet) {
        this._range = range;
        this._sharedCtx = new SharedContext(sheet);
    }

    public RangeImpl(SRange range, Book book) {
        this._range = range;
        this._sharedCtx = new SharedContext(book);
    }

    private RangeImpl(SRange range, SharedContext ctx) {
        this._range = range;
        this._sharedCtx = ctx;
    }

    @Override
    public ReadWriteLock getLock() {
        return this._range.getLock();
    }

    @Override
    public Range.CellStyleHelper getCellStyleHelper() {
        if (this._cellStyleHelper == null) {
            this._cellStyleHelper = new CellStyleHelperImpl(this.getBook());
        }
        return this._cellStyleHelper;
    }

    @Override
    public CellData getCellData() {
        if (this._cellData == null) {
            this._cellData = new CellDataImpl(this);
        }
        return this._cellData;
    }

    public SRange getNative() {
        return this._range;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._range == null ? 0 : this._range.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeImpl other = (RangeImpl)obj;
        return !(this._range == null ? other._range != null : !this._range.equals(other._range));
    }

    @Override
    public boolean isProtected() {
        return this._range.isProtected();
    }

    @Override
    public boolean isSheetProtected() {
        return this._range.isSheetProtected();
    }

    public boolean isAnyCellProtected() {
        return this._range.isAnyCellProtected();
    }

    @Override
    public Range paste(Range dest, boolean cut) {
        SRange r = this._range.copy(((RangeImpl)dest).getNative(), cut);
        return new RangeImpl(r, dest.getSheet());
    }

    @Override
    public Range paste(Range dest) {
        SRange r = this._range.copy(((RangeImpl)dest).getNative());
        return new RangeImpl(r, dest.getSheet());
    }

    @Override
    public Range pasteSpecial(Range dest, Range.PasteType type, Range.PasteOperation op, boolean skipBlanks, boolean transpose) {
        SRange r = this._range.pasteSpecial(((RangeImpl)dest).getNative(), EnumUtil.toRangePasteTypeNative(type), EnumUtil.toRangePasteOpNative(op), skipBlanks, transpose);
        return new RangeImpl(r, dest.getSheet());
    }

    @Override
    public void clearContents() {
        this._range.clearContents();
    }

    @Override
    public void clearAll() {
        this._range.clearAll();
    }

    @Override
    public Sheet getSheet() {
        return this._sharedCtx.getSheet();
    }

    @Override
    public void clearStyles() {
        this._range.clearCellStyles();
    }

    @Override
    public void setCellStyle(CellStyle nstyle) {
        this._range.setCellStyle(nstyle == null ? null : ((CellStyleImpl)nstyle).getNative());
    }

    @Override
    public int getColumn() {
        return this._range.getColumn();
    }

    @Override
    public int getRow() {
        return this._range.getRow();
    }

    @Override
    public int getLastColumn() {
        return this._range.getLastColumn();
    }

    @Override
    public int getLastRow() {
        return this._range.getLastRow();
    }

    @Override
    public void sync(RangeRunner run) {
        ReadWriteLock lock = this._range.getLock();
        lock.writeLock().lock();
        try {
            run.run(this);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(final CellVisitor visitor) {
        final int r = this.getRow();
        final int lr = this.getLastRow();
        final int c = this.getColumn();
        final int lc = this.getLastColumn();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                for (int i = r; i <= lr; ++i) {
                    for (int j = c; j <= lc && RangeImpl.this.visitCell(visitor, i, j); ++j) {
                    }
                }
            }
        };
        ReadWriteLock lock = this._range.getLock();
        lock.writeLock().lock();
        try {
            run.run();
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private boolean visitCell(CellVisitor visitor, int r, int c) {
        boolean ignore = false;
        SSheet sheet = this._range.getSheet();
        SCell cell = sheet.getCell(r, c);
        if (cell.isNull()) {
            if (ignore) {
                return true;
            }
            visitor.createIfNotExist(r, c);
        }
        return visitor.visit(new RangeImpl(SRanges.range((SSheet)this._range.getSheet(), (int)r, (int)c), this._sharedCtx));
    }

    @Override
    public Book getBook() {
        return this._sharedCtx.getBook();
    }

    public void applyBordersAround(CellStyle.BorderType borderType, String htmlColor) {
        this.applyBorders(Range.ApplyBorderType.OUTLINE, borderType, htmlColor);
    }

    @Override
    public void applyBorders(Range.ApplyBorderType type, CellStyle.BorderType borderType, String htmlColor) {
        this._range.setBorders(EnumUtil.toRangeApplyBorderType(type), EnumUtil.toRangeBorderType(borderType), htmlColor);
    }

    @Override
    public boolean hasMergedCell() {
        CellRegion curr = new CellRegion(this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn());
        for (CellRegion ma : this._range.getSheet().getMergedRegions()) {
            if (!curr.overlaps(ma)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMergedCell() {
        for (CellRegion ma : this._range.getSheet().getMergedRegions()) {
            if (!ma.equals(this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn())) continue;
            return true;
        }
        return false;
    }

    @Override
    public CellRegion getMergedRegion() {
        return this._range.getMergedRegion();
    }

    @Override
    public CellRegion getDataRegion() {
        return this._range.getDataRegion();
    }

    @Override
    public void merge(boolean across) {
        this._range.merge(across);
    }

    @Override
    public void unmerge() {
        this._range.unmerge();
    }

    @Override
    public RangeImpl toShiftedRange(int rowOffset, int colOffset) {
        RangeImpl offsetRange = new RangeImpl(this._range.getOffset(rowOffset, colOffset), this._sharedCtx);
        return offsetRange;
    }

    @Override
    public RangeImpl toCellRange(int rowOffset, int colOffset) {
        RangeImpl cellRange = new RangeImpl(SRanges.range((SSheet)this._range.getSheet(), (int)(this.getRow() + rowOffset), (int)(this.getColumn() + colOffset)), this._sharedCtx);
        return cellRange;
    }

    public RangeImpl getLeftTop() {
        return this.toCellRange(0, 0);
    }

    @Override
    public RangeImpl toRowRange() {
        return new RangeImpl(this._range.getRows(), this._sharedCtx);
    }

    @Override
    public RangeImpl toColumnRange() {
        return new RangeImpl(this._range.getColumns(), this._sharedCtx);
    }

    @Override
    public boolean isWholeColumn() {
        return this._range.isWholeColumn();
    }

    @Override
    public boolean isWholeRow() {
        return this._range.isWholeRow();
    }

    @Override
    public boolean isWholeSheet() {
        return this._range.isWholeSheet();
    }

    @Override
    public void insert(Range.InsertShift shift, Range.InsertCopyOrigin copyOrigin) {
        this._range.insert(EnumUtil.toRangeInsertShift(shift), EnumUtil.toRangeInsertCopyOrigin(copyOrigin));
    }

    @Override
    public void delete(Range.DeleteShift shift) {
        this._range.delete(EnumUtil.toRangeDeleteShift(shift));
    }

    @Override
    public void sort(boolean desc) {
        this.sort(desc, false, false, false, null);
    }

    @Override
    public void sort(boolean desc, boolean hasHeader, boolean matchCase, boolean sortByRows, Range.SortDataOption dataOption) {
        Range index = null;
        int r = this.getRow();
        int c = this.getColumn();
        int lr = this.getLastRow();
        int lc = this.getLastColumn();
        index = Ranges.range(this.getSheet(), r, c, sortByRows ? r : lr, sortByRows ? lc : c);
        this.sort(index, desc, dataOption, null, false, null, null, false, null, hasHeader, matchCase, sortByRows);
    }

    @Override
    public void sort(Range key1, boolean desc1, Range.SortDataOption dataOption1, Range key2, boolean desc2, Range.SortDataOption dataOption2, Range key3, boolean desc3, Range.SortDataOption dataOption3, boolean header, boolean matchCase, boolean sortByRows) {
        this._range.sort(key1 == null ? null : ((RangeImpl)key1).getNative(), desc1, dataOption1 == null ? SRange.SortDataOption.NORMAL_DEFAULT : EnumUtil.toRangeSortDataOption(dataOption1), key2 == null ? null : ((RangeImpl)key2).getNative(), desc2, dataOption2 == null ? SRange.SortDataOption.NORMAL_DEFAULT : EnumUtil.toRangeSortDataOption(dataOption2), key3 == null ? null : ((RangeImpl)key3).getNative(), desc3, dataOption3 == null ? SRange.SortDataOption.NORMAL_DEFAULT : EnumUtil.toRangeSortDataOption(dataOption3), header ? 1 : 0, matchCase, sortByRows);
    }

    @Override
    public boolean isAutoFilterEnabled() {
        SSheet sheet = this._range.getSheet();
        STable table = ((AbstractSheetAdv)sheet).getTableByRowCol(this.getRow(), this.getColumn());
        return table != null ? table.getAutoFilter() != null : sheet.getAutoFilter() != null;
    }

    @Override
    public Range findAutoFilterRange() {
        SRange r = this._range.findAutoFilterRange();
        if (r != null) {
            return Ranges.range(this.getSheet(), r.getRow(), r.getColumn(), r.getLastRow(), r.getLastColumn());
        }
        return null;
    }

    @Override
    public void enableAutoFilter(boolean enable) {
        if (this.isAutoFilterEnabled() == enable) {
            return;
        }
        this._range.enableAutoFilter(enable);
    }

    @Override
    public void enableAutoFilter(int field, Range.AutoFilterOperation filterOp, Object criteria1, Object criteria2, Boolean showButton) {
        boolean isTop10;
        boolean bl = isTop10 = filterOp == Range.AutoFilterOperation.TOP10 || filterOp == Range.AutoFilterOperation.TOP10PERCENT || filterOp == Range.AutoFilterOperation.BOTTOM10 || filterOp == Range.AutoFilterOperation.BOTTOM10PERCENT;
        if (isTop10) {
            int count = 10;
            if (criteria1 instanceof Object[] && ((Object[])criteria1).length > 0) {
                count = (Integer)((Object[])criteria1)[0];
            }
            boolean isTop = filterOp == Range.AutoFilterOperation.TOP10 || filterOp == Range.AutoFilterOperation.TOP10PERCENT;
            boolean isPercent = filterOp == Range.AutoFilterOperation.TOP10PERCENT || filterOp == Range.AutoFilterOperation.BOTTOM10PERCENT;
            criteria1 = new Object[]{count, isTop ? Boolean.TRUE : Boolean.FALSE, isPercent ? Boolean.TRUE : Boolean.FALSE};
        }
        this._range.enableAutoFilter(field, EnumUtil.toRangeAutoFilterOperation(filterOp), (Object)criteria1, criteria2, showButton);
    }

    @Override
    public void resetAutoFilter() {
        this._range.resetAutoFilter();
    }

    @Override
    public void applyAutoFilter() {
        this._range.applyAutoFilter();
    }

    @Override
    @Deprecated
    public void protectSheet(String password) {
        this._range.protectSheet(password);
    }

    @Override
    public void autoFill(Range dest, Range.AutoFillType fillType) {
        this._range.fill(((RangeImpl)dest).getNative(), EnumUtil.toRangeFillType(fillType));
    }

    @Override
    public void fillDown() {
        this._range.fillDown();
    }

    @Override
    public void fillLeft() {
        this._range.fillLeft();
    }

    @Override
    public void fillUp() {
        this._range.fillUp();
    }

    @Override
    public void fillRight() {
        this._range.fillRight();
    }

    @Override
    public void shift(int rowOffset, int colOffset) {
        this._range.move(rowOffset, colOffset);
    }

    @Override
    public String getCellEditText() {
        String txt = this._range.getEditText();
        return txt == null ? "" : txt;
    }

    @Override
    public void setCellEditText(String editText) {
        try {
            this._range.setEditText(editText);
        }
        catch (InvalidFormulaException x) {
            throw new IllegalFormulaException(x.getMessage(), x);
        }
    }

    @Override
    public String getCellFormatText() {
        return this._range.getCellFormatText();
    }

    @Override
    public String getCellDataFormat() {
        return this._range.getCellDataFormat();
    }

    @Override
    public Object getCellValue() {
        return this._range.getValue();
    }

    @Override
    public void setDisplaySheetGridlines(boolean enable) {
        this._range.setDisplayGridlines(enable);
    }

    @Override
    public boolean isDisplaySheetGridlines() {
        return this.getSheet().isDisplayGridlines();
    }

    @Override
    public void setHidden(boolean hidden) {
        this._range.setHidden(hidden);
    }

    @Override
    public void setCellHyperlink(Hyperlink.HyperlinkType type, String address, String display) {
        this._range.setHyperlink(EnumUtil.toHyperlinkType(type), address, display);
    }

    @Override
    public Hyperlink getCellHyperlink() {
        SHyperlink l = this._range.getHyperlink();
        return l == null ? null : new HyperlinkImpl(new SimpleRef<SHyperlink>(l), this.getCellEditText());
    }

    @Override
    public void setSheetName(String name) {
        this._range.setSheetName(name);
    }

    @Override
    public String getSheetName() {
        return this.getSheet().getSheetName();
    }

    @Override
    public void setSheetOrder(int pos) {
        this._range.setSheetOrder(pos);
    }

    @Override
    public int getSheetOrder() {
        return this.getBook().getSheetIndex(this.getSheet());
    }

    @Override
    public void setCellValue(Object value) {
        this._range.setValue(value);
    }

    private ModelRef<SBook> getBookRef() {
        return ((BookImpl)this.getBook()).getRef();
    }

    private ModelRef<SSheet> getSheetRef() {
        return ((SheetImpl)this.getSheet()).getRef();
    }

    @Override
    public CellStyle getCellStyle() {
        SCellStyle style = this._range.getCellStyle();
        return new CellStyleImpl(this.getBookRef(), new SimpleRef<SCellStyle>(style));
    }

    @Override
    public Picture addPicture(SheetAnchor anchor, byte[] image, Picture.Format format) {
        SPicture picture = this._range.addPicture(SheetImpl.toViewAnchor(this._range.getSheet(), anchor), image, EnumUtil.toPictureFormat(format));
        return new PictureImpl(new SimpleRef<SSheet>(this._range.getSheet()), new SimpleRef<SPicture>(picture));
    }

    @Override
    public void deletePicture(Picture picture) {
        this._range.deletePicture(((PictureImpl)picture).getNative());
    }

    @Override
    public void movePicture(SheetAnchor anchor, Picture picture) {
        this._range.movePicture(((PictureImpl)picture).getNative(), SheetImpl.toViewAnchor(this._range.getSheet(), anchor));
    }

    @Override
    public Chart addChart(SheetAnchor anchor, Chart.Type type, Chart.Grouping grouping, Chart.LegendPosition pos) {
        SChart chart = this._range.addChart(new ViewAnchor(anchor.getRow(), anchor.getColumn(), DEFAULT_CHART_WIDTH, DEFAULT_CHART_HEIGHT), EnumUtil.toChartType(type), EnumUtil.toChartGrouping(grouping), EnumUtil.toLegendPosition(pos), EnumUtil.isThreeDimentionalChart(type));
        return new ChartImpl(new SimpleRef<SSheet>(this._range.getSheet()), new SimpleRef<SChart>(chart));
    }

    @Override
    public void deleteChart(Chart chart) {
        this._range.deleteChart(((ChartImpl)chart).getNative());
    }

    @Override
    public void moveChart(SheetAnchor anchor, Chart chart) {
        this._range.moveChart(((ChartImpl)chart).getNative(), SheetImpl.toViewAnchor(this._range.getSheet(), anchor));
    }

    @Override
    public void updateChart(Chart chart) {
        this._range.updateChart(((ChartImpl)chart).getNative());
    }

    @Override
    public Sheet createSheet(String name) {
        SSheet sheet = this._range.createSheet(name);
        return new SheetImpl(this.getBookRef(), new SimpleRef<SSheet>(sheet));
    }

    @Override
    public Sheet cloneSheet(String name) {
        SSheet sheet = this._range.cloneSheet(name);
        return new SheetImpl(this.getBookRef(), new SimpleRef<SSheet>(sheet));
    }

    @Override
    public void deleteSheet() {
        this._range.deleteSheet();
    }

    @Override
    public void setColumnWidth(int widthPx) {
        SRange r = this._range.isWholeColumn() ? this._range : this._range.getColumns();
        r.setColumnWidth(widthPx);
    }

    @Override
    public void setRowHeight(int heightPx) {
        SRange r = this._range.isWholeRow() ? this._range : this._range.getRows();
        r.setRowHeight(heightPx);
    }

    @Override
    public void setRowHeight(int heightPx, boolean isCustom) {
        SRange r = this._range.isWholeRow() ? this._range : this._range.getRows();
        r.setRowHeight(heightPx, isCustom);
    }

    public String toString() {
        return Ranges.getAreaRefString(this.getSheet(), this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn());
    }

    @Override
    public void notifyChange() {
        this._range.notifyChange();
    }

    @Override
    public void notifyChange(String[] variables) {
        this._range.notifyChange(variables);
    }

    @Override
    public void setFreezePanel(int rowfreeze, int columnfreeze) {
        this._range.setFreezePanel(rowfreeze, columnfreeze);
    }

    @Override
    public int getRowCount() {
        return this._range.getLastRow() - this._range.getRow() + 1;
    }

    @Override
    public int getColumnCount() {
        return this._range.getLastColumn() - this._range.getColumn() + 1;
    }

    @Override
    public String asString() {
        return Ranges.getAreaRefString(this.getSheet(), this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn());
    }

    @Override
    public SRange getInternalRange() {
        return this._range;
    }

    @Override
    public void createName(String nameName) {
        this._range.createName(nameName);
    }

    @Override
    public void protectSheet(String password, boolean allowSelectingLockedCells, boolean allowSelectingUnlockedCells, boolean allowFormattingCells, boolean allowFormattingColumns, boolean allowFormattingRows, boolean allowInsertColumns, boolean allowInsertRows, boolean allowInsertingHyperlinks, boolean allowDeletingColumns, boolean allowDeletingRows, boolean allowSorting, boolean allowFiltering, boolean allowUsingPivotTables, boolean drawingObjects, boolean scenarios) {
        this._range.protectSheet(password, allowSelectingLockedCells, allowSelectingUnlockedCells, allowFormattingCells, allowFormattingColumns, allowFormattingRows, allowInsertColumns, allowInsertRows, allowInsertingHyperlinks, allowDeletingColumns, allowDeletingRows, allowSorting, allowFiltering, allowUsingPivotTables, drawingObjects, scenarios);
    }

    @Override
    public boolean unprotectSheet(String password) {
        return this._range.unprotectSheet(password);
    }

    @Override
    public SheetProtection getSheetProtection() {
        SSheetProtection ssp = this._range.getSheetProtection();
        return ssp == null ? null : new SheetProtectionImpl(new SimpleRef<SSheet>(this._range.getSheet()), new SimpleRef<SSheetProtection>(ssp));
    }

    @Override
    public Validation validate(String editText) {
        SDataValidation dv = this._range.validate(editText);
        return dv == null ? null : new ValidationImpl(new SimpleRef<SDataValidation>(dv));
    }

    @Override
    public void setValidation(Validation.ValidationType validationType, boolean ignoreBlank, Validation.OperatorType operatorType, boolean inCellDropDown, String formula1, String formula2, boolean showInput, String inputTitle, String inputMessage, boolean showError, Validation.AlertStyle alertStyle, String errorTitle, String errorMessage) {
        this._range.setValidation(validationType.getNative(), ignoreBlank, operatorType.getNative(), inCellDropDown, formula1, formula2, showInput, inputTitle, inputMessage, showError, alertStyle.getNative(), errorTitle, errorMessage);
    }

    @Override
    public List<Validation> getValidations() {
        List dvs = this._range.getValidations();
        ArrayList<Validation> vs = new ArrayList<Validation>(dvs.size());
        for (SDataValidation dv : dvs) {
            vs.add(new ValidationImpl(new SimpleRef<SDataValidation>(dv)));
        }
        return vs;
    }

    @Override
    public void deleteValidation() {
        this._range.deleteValidation();
    }

    @Override
    public void setCellRichText(String html) {
        this._range.setRichText(html);
    }

    @Override
    public String getCellRichText() {
        return this._range.getRichText();
    }

    @Override
    public Font getOrCreateFont(Font.Boldweight boldweight, Color color, int fontHeight, String fontName, boolean italic, boolean strikeout, Font.TypeOffset typeOffset, Font.Underline underline) {
        SFont font = this._range.getOrCreateFont(EnumUtil.toFontBoldweight(boldweight), color.getHtmlColor(), fontHeight, fontName, italic, strikeout, EnumUtil.toFontTypeOffset(typeOffset), EnumUtil.toFontUnderline(underline));
        return new FontImpl(((BookImpl)this.getBook()).getRef(), new SimpleRef<SFont>(font));
    }

    @Override
    public void refresh(boolean includeDependants) {
        this._range.refresh(includeDependants);
    }

    @Override
    public boolean setAutoRefresh(boolean auto) {
        return this._range.setAutoRefresh(auto);
    }

    @Override
    public void refresh(boolean includeDependants, boolean clearCache, boolean enforceEval) {
        this._range.refresh(includeDependants, clearCache, enforceEval);
    }

    @Override
    public void setSheetVisible(Range.SheetVisible visible) {
        SRange.SheetVisible option = null;
        switch (visible) {
            case HIDDEN: {
                option = SRange.SheetVisible.HIDDEN;
                break;
            }
            case VISIBLE: {
                option = SRange.SheetVisible.VISIBLE;
                break;
            }
            case VERY_HIDDEN: {
                option = SRange.SheetVisible.VERY_HIDDEN;
            }
        }
        this._range.setSheetVisible(option);
    }

    @Override
    public String getCommentRichText() {
        return this._range.getCommentRichText();
    }

    @Override
    public void setCommentRichText(String html) {
        this._range.setCommentRichText(html);
    }

    @Override
    public void setCommentVisible(boolean visible) {
        this._range.setCommentVisible(visible);
    }

    @Override
    public boolean isCommentVisible() {
        return this._range.isCommentVisible();
    }

    @Override
    public void notifyChange(Range.CellAttribute cellAttr) {
        this._range.notifyChange(CellAttribute.values()[cellAttr.ordinal()]);
    }

    @Override
    public void setNameName(String namename, String newname) {
        this._range.setNameName(namename, newname);
    }

    @Override
    public void setStringValue(String text) {
        this._range.setStringValue(text);
    }

    @Override
    public Sheet cloneSheetFrom(String name, Sheet sheet) {
        SSheet sheet0 = this._range.cloneSheetFrom(name, sheet.getInternalSheet());
        return new SheetImpl(this.getBookRef(), new SimpleRef<SSheet>(sheet0));
    }

    private static class Result<T> {
        T r;

        Result() {
        }

        Result(T r) {
            this.r = r;
        }

        public T get() {
            return this.r;
        }

        public void set(T r) {
            this.r = r;
        }
    }

    private static class SharedContext {
        Sheet _sheet;
        Book _book;

        private SharedContext(Sheet sheet) {
            this._sheet = sheet;
        }

        private SharedContext(Book book) {
            this._sheet = null;
            this._book = book;
        }

        public Sheet getSheet() {
            return this._sheet;
        }

        public Book getBook() {
            return this._book == null ? this._sheet.getBook() : this._book;
        }
    }
}

