/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColumn;
import io.keikai.model.SColumnArray;
import io.keikai.model.SRow;
import io.keikai.model.STable;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.range.SRange;
import io.keikai.range.impl.InsertDeleteHelper;
import io.keikai.range.impl.RangeHelperBase;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClearCellHelper
extends RangeHelperBase
implements Serializable {
    private static final long serialVersionUID = 1502958207878149903L;
    SCellStyle _defaultStyle;

    public ClearCellHelper(SRange range) {
        super(range);
        this._defaultStyle = range.getSheet().getBook().getDefaultCellStyle();
    }

    public void clearCellStyle() {
        if (this.isWholeSheet()) {
            this.clearWholeSheetStyle();
        } else if (this.isWholeRow()) {
            this.clearWholeRowCellStyle();
        } else if (this.isWholeColumn()) {
            this.clearWholeColumnCellStyle();
        } else {
            for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
                SRow row = this.sheet.getRow(r);
                for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                    SColumn column = this.sheet.getColumn(c);
                    SCell cell = this.sheet.getCell(r, c);
                    if (row.getCellStyle(true) != null || column.getCellStyle(true) != null) {
                        cell.setCellStyle(this._defaultStyle);
                        continue;
                    }
                    if (cell.getCellStyle(true) == null) continue;
                    cell.setCellStyle(null);
                }
            }
        }
    }

    private void clearWholeSheetStyle() {
        Iterator<SColumnArray> columns = this.sheet.getColumnArrayIterator();
        while (columns.hasNext()) {
            SColumnArray column = columns.next();
            if (column.getCellStyle(true) == null) continue;
            column.setCellStyle(null);
        }
        Iterator<SRow> rows = this.sheet.getRowIterator();
        while (rows.hasNext()) {
            SRow row = rows.next();
            if (row.getCellStyle(true) != null) {
                row.setCellStyle(null);
            }
            Iterator<SCell> cells = this.sheet.getCellIterator(row.getIndex());
            while (cells.hasNext()) {
                SCell cell = cells.next();
                if (cell.getCellStyle(true) == null) continue;
                cell.setCellStyle(null);
            }
        }
    }

    private void clearWholeColumnCellStyle() {
        for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
            SColumn column = this.sheet.getColumn(c);
            if (column.isNull()) continue;
            column.setCellStyle(null);
        }
        Iterator<SRow> rows = this.sheet.getRowIterator();
        while (rows.hasNext()) {
            SRow row = rows.next();
            boolean rowHasStyle = row.getCellStyle(true) != null;
            for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                SCell cell = this.sheet.getCell(row.getIndex(), c);
                if (rowHasStyle) {
                    cell.setCellStyle(this._defaultStyle);
                    continue;
                }
                if (cell.getCellStyle(true) == null) continue;
                cell.setCellStyle(null);
            }
        }
    }

    private void clearWholeRowCellStyle() {
        HashSet<Integer> columnHasStyle = new HashSet<Integer>();
        Iterator<SColumn> columns = this.sheet.getColumnIterator();
        while (columns.hasNext()) {
            SColumn column = columns.next();
            if (column.getCellStyle(true) == null) continue;
            columnHasStyle.add(column.getIndex());
        }
        for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
            HashSet rowColumnHasStyle = new HashSet(columnHasStyle);
            SRow row = this.sheet.getRow(r);
            if (!row.isNull()) {
                row.setCellStyle(null);
            }
            Iterator<SCell> cells = this.sheet.getCellIterator(r);
            while (cells.hasNext()) {
                SCell cell = cells.next();
                if (columnHasStyle.contains(cell.getColumnIndex())) {
                    cell.setCellStyle(this._defaultStyle);
                    rowColumnHasStyle.remove(cell.getColumnIndex());
                    continue;
                }
                if (cell.getCellStyle(true) == null) continue;
                cell.setCellStyle(null);
            }
            for (Integer c : rowColumnHasStyle) {
                this.sheet.getCell(row.getIndex(), c).setCellStyle(this._defaultStyle);
            }
        }
    }

    public boolean clearCellContentAndTables() {
        boolean deleted = this.clearTables();
        this.clearCellContent();
        return deleted;
    }

    public void clearCellContent() {
        if (this.isWholeSheet()) {
            this.clearWholeSheetContent();
        } else if (this.isWholeRow()) {
            this.clearWholeRowContent();
        } else if (this.isWholeColumn()) {
            this.clearWholeColumnContent();
        } else {
            for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
                for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                    SCell cell = this.sheet.getCell(r, c);
                    this.clearCellContent(cell);
                }
            }
        }
    }

    private boolean clearTables() {
        int col2;
        if (this.isWholeSheet()) {
            List<STable> tables = this.sheet.getTables();
            boolean deleteTables = !tables.isEmpty();
            AbstractBookAdv book = (AbstractBookAdv)this.sheet.getBook();
            for (STable tb : tables) {
                book.removeTable(tb.getName());
            }
            ((AbstractSheetAdv)this.sheet).clearTables();
            return deleteTables;
        }
        int row1 = this.getRow();
        int row2 = this.getLastRow();
        int col1 = this.getColumn();
        Set<String> toDelete = InsertDeleteHelper.collectContainedTables(this.sheet, row1, col1, row2, col2 = this.getLastColumn());
        boolean deleteTables = !toDelete.isEmpty();
        InsertDeleteHelper.deleteTablesByNames(this.sheet, toDelete);
        return deleteTables;
    }

    private void clearWholeSheetContent() {
        Iterator<SRow> rows = this.sheet.getRowIterator();
        while (rows.hasNext()) {
            SRow row = rows.next();
            Iterator<SCell> cells = this.sheet.getCellIterator(row.getIndex());
            while (cells.hasNext()) {
                SCell cell = cells.next();
                this.clearCellContent(cell);
            }
        }
    }

    private void clearWholeColumnContent() {
        Iterator<SRow> rows = this.sheet.getRowIterator();
        while (rows.hasNext()) {
            SRow row = rows.next();
            for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                SCell cell = this.sheet.getCell(row.getIndex(), c);
                this.clearCellContent(cell);
            }
        }
    }

    private void clearWholeRowContent() {
        for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
            Iterator<SCell> cells = this.sheet.getCellIterator(r);
            while (cells.hasNext()) {
                SCell cell = cells.next();
                this.clearCellContent(cell);
            }
        }
    }

    private void clearCellContent(SCell cell) {
        if (!cell.isNull()) {
            cell.setHyperlink(null);
            cell.clearValue();
        }
    }
}

