/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.zkoss.poi.ddf.EscherChildAnchorRecord;
import org.zkoss.poi.ddf.EscherClientAnchorRecord;
import org.zkoss.poi.ddf.EscherClientDataRecord;
import org.zkoss.poi.ddf.EscherComplexProperty;
import org.zkoss.poi.ddf.EscherContainerRecord;
import org.zkoss.poi.ddf.EscherOptRecord;
import org.zkoss.poi.ddf.EscherProperty;
import org.zkoss.poi.ddf.EscherRecord;
import org.zkoss.poi.ddf.EscherSpRecord;
import org.zkoss.poi.hssf.record.LabelSSTRecord;
import org.zkoss.poi.hssf.record.Record;
import org.zkoss.poi.hssf.record.RecordBase;
import org.zkoss.poi.hssf.record.aggregates.BOFRecordAggregate;
import org.zkoss.poi.hssf.record.chart.Chart3DRecord;
import org.zkoss.poi.hssf.record.chart.ChartRecord;
import org.zkoss.poi.hssf.record.chart.ChartTitleFormatRecord;
import org.zkoss.poi.hssf.record.chart.LegendRecord;
import org.zkoss.poi.hssf.record.chart.LinkedDataRecord;
import org.zkoss.poi.hssf.record.chart.SeriesIndexRecord;
import org.zkoss.poi.hssf.record.chart.SeriesTextRecord;
import org.zkoss.poi.hssf.record.chart.TextRecord;
import org.zkoss.poi.hssf.record.chart.ValueRangeRecord;
import org.zkoss.poi.hssf.usermodel.HSSFAnchor;
import org.zkoss.poi.hssf.usermodel.HSSFChart;
import org.zkoss.poi.hssf.usermodel.HSSFChartShape;
import org.zkoss.poi.hssf.usermodel.HSSFChildAnchor;
import org.zkoss.poi.hssf.usermodel.HSSFClientAnchor;
import org.zkoss.poi.hssf.usermodel.HSSFPatriarch;
import org.zkoss.poi.hssf.usermodel.HSSFPatriarchHelper;
import org.zkoss.poi.hssf.usermodel.HSSFShape;

public class HSSFChartDecoder
implements Serializable {
    private static final long serialVersionUID = -5941459337127878146L;
    private HSSFChartShape _chart;
    HSSFPatriarchHelper _helper;

    public HSSFChartDecoder(HSSFPatriarchHelper helper, HSSFChartShape chart) {
        this._helper = helper;
        this._chart = chart;
    }

    public void decode() {
        if (this._chart.getChartInfo() != null) {
            return;
        }
        EscherContainerRecord container = this._helper.getContainer((HSSFShape)this._chart);
        this.decodeChartRecord(this._helper.getPatriarch(), container);
    }

    private void decodeChartRecord(HSSFPatriarch patriarch, EscherContainerRecord container) {
        List recordList = container.getChildRecords();
        Iterator recordIter = recordList.iterator();
        EscherChildAnchorRecord childAnchorRecord = null;
        EscherClientAnchorRecord clientAnchorRecord = null;
        EscherOptRecord optRecord = null;
        EscherSpRecord spRecord = null;
        EscherClientDataRecord dataRecord = null;
        while (recordIter.hasNext()) {
            EscherRecord childRecord = (EscherRecord)recordIter.next();
            switch (childRecord.getRecordId()) {
                case -4086: {
                    spRecord = (EscherSpRecord)childRecord;
                    break;
                }
                case -4085: {
                    optRecord = (EscherOptRecord)childRecord;
                    break;
                }
                case -4081: {
                    childAnchorRecord = (EscherChildAnchorRecord)childRecord;
                    break;
                }
                case -4080: {
                    clientAnchorRecord = (EscherClientAnchorRecord)childRecord;
                    break;
                }
                case -4079: {
                    dataRecord = (EscherClientDataRecord)childRecord;
                }
            }
        }
        if (spRecord != null) {
            HSSFChildAnchor anchor = null;
            if (childAnchorRecord != null) {
                int dx1 = Math.min(1023, childAnchorRecord.getDx1());
                int dy1 = Math.min(255, childAnchorRecord.getDy1());
                int dx2 = Math.min(1023, childAnchorRecord.getDx2());
                int dy2 = Math.min(255, childAnchorRecord.getDy2());
                anchor = new HSSFChildAnchor(dx1, dy1, dx2, dy2);
            } else if (clientAnchorRecord != null) {
                int dx1 = Math.min(1023, clientAnchorRecord.getDx1());
                int dy1 = Math.min(255, clientAnchorRecord.getDy1());
                int dx2 = Math.min(1023, clientAnchorRecord.getDx2());
                int dy2 = Math.min(255, clientAnchorRecord.getDy2());
                short col1 = clientAnchorRecord.getCol1();
                short row1 = clientAnchorRecord.getRow1();
                short col2 = clientAnchorRecord.getCol2();
                short row2 = clientAnchorRecord.getRow2();
                anchor = new HSSFClientAnchor(dx1, dy1, dx2, dy2, col1, (int)row1, col2, (int)row2);
            }
            if (spRecord.isHaveAnchor() && anchor != null) {
                this.decodeChartRecord(patriarch, optRecord, (HSSFAnchor)anchor);
            }
        }
    }

    private void decodeChartRecord(HSSFPatriarch patriarch, EscherOptRecord optRecord, HSSFAnchor anchor) {
        String chartName = null;
        try {
            for (EscherProperty pro : optRecord.getEscherProperties()) {
                switch (pro.getPropertyNumber()) {
                    case 896: {
                        chartName = new String(((EscherComplexProperty)pro).getComplexData(), "UTF-16LE").trim();
                    }
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        HSSFChart chart = this.decodeChartRecord(this._helper.getChartBOF(this._chart));
        this._chart.setName(chartName);
        this._chart.setAnchor(anchor);
        this._chart.setChart(chart);
    }

    private HSSFChart decodeChartRecord(BOFRecordAggregate bofagg) {
        List bofRecords;
        List list = bofRecords = bofagg == null ? null : bofagg.getInnerRecords();
        if (bofRecords == null) {
            return null;
        }
        Chart3DRecord chart3d = null;
        ChartRecord chart = null;
        TextRecord titleTextRecord = null;
        ArrayList<Object[]> seriesList = new ArrayList<Object[]>();
        Object[] lastSeries = null;
        LegendRecord legend = null;
        ChartTitleFormatRecord chartTitleFormat = null;
        SeriesTextRecord chartTitleText = null;
        ArrayList<ValueRangeRecord> valueRanges = new ArrayList<ValueRangeRecord>();
        Stack<Record> stack = new Stack<Record>();
        Record chartType = null;
        Record preR = null;
        SeriesIndexRecord siIndex = null;
        for (RecordBase rb : bofRecords) {
            if (!(rb instanceof Record)) continue;
            Record r = (Record)rb;
            switch (r.getSid()) {
                case 4147: {
                    stack.push(preR);
                    break;
                }
                case 4148: {
                    Record popR = (Record)stack.pop();
                    if (popR.getSid() != 4099) break;
                    lastSeries = null;
                    break;
                }
                case 4098: {
                    chart = (ChartRecord)r;
                    break;
                }
                case 4154: {
                    chart3d = (Chart3DRecord)r;
                    break;
                }
                case 4117: {
                    legend = (LegendRecord)r;
                    break;
                }
                case 4099: {
                    lastSeries = new Object[]{r, new ArrayList(), null, null};
                    seriesList.add(lastSeries);
                    break;
                }
                case 4176: {
                    chartTitleFormat = (ChartTitleFormatRecord)r;
                    break;
                }
                case 4109: {
                    SeriesTextRecord str = (SeriesTextRecord)r;
                    if (legend == null && lastSeries != null) {
                        lastSeries[2] = str;
                        break;
                    }
                    chartTitleText = str;
                    break;
                }
                case 4133: {
                    Record peekR = (Record)stack.peek();
                    if (!(peekR instanceof ChartRecord) || preR.getSid() != 2215) break;
                    titleTextRecord = (TextRecord)r;
                    break;
                }
                case 4177: {
                    LinkedDataRecord linkedDataRecord = (LinkedDataRecord)r;
                    Record peekR = (Record)stack.peek();
                    switch (peekR.getSid()) {
                        case 4099: {
                            if (lastSeries == null) break;
                            ((List)lastSeries[1]).add(linkedDataRecord);
                        }
                    }
                    break;
                }
                case 4127: {
                    valueRanges.add((ValueRangeRecord)r);
                    break;
                }
                case 4119: 
                case 4120: 
                case 4121: 
                case 4122: 
                case 4123: {
                    chartType = r;
                    break;
                }
                case 4197: {
                    siIndex = (SeriesIndexRecord)r;
                    break;
                }
                case 253: {
                    Object[] ser;
                    if (siIndex == null || siIndex.getIndex() != 2) break;
                    Object[] objectArray = ser = lastSeries == null && seriesList.size() > 0 ? (Object[])seriesList.get(seriesList.size() - 1) : lastSeries;
                    if (ser == null) break;
                    ArrayList<LabelSSTRecord> cats = (ArrayList<LabelSSTRecord>)ser[3];
                    if (cats == null) {
                        ser[3] = cats = new ArrayList<LabelSSTRecord>();
                    }
                    cats.add((LabelSSTRecord)r);
                }
            }
            preR = r;
        }
        return new HSSFChart(this._helper.getSheet(), chart, legend, chartTitleFormat, chartTitleText, seriesList, valueRanges, chartType, chart3d, titleTextRecord);
    }
}

