/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.SBook;
import io.keikai.range.impl.imexp.AbstractExcelImporter;
import io.keikai.range.impl.imexp.AbstractImporter;
import io.keikai.range.impl.imexp.ExcelXlsImporter;
import io.keikai.range.impl.imexp.ExcelXlsxImporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.zkoss.lang.Library;
import org.zkoss.poi.POIXMLDocument;
import org.zkoss.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelImportAdapter
extends AbstractImporter {
    @Override
    public SBook imports(InputStream is, String bookName) throws IOException {
        if (!is.markSupported()) {
            is = new PushbackInputStream(is, 8);
        }
        AbstractExcelImporter importer = null;
        if (POIFSFileSystem.hasPOIFSHeader((InputStream)is)) {
            importer = new ExcelXlsImporter();
        } else if (POIXMLDocument.hasOOXMLHeader((InputStream)is)) {
            importer = new ExcelXlsxImporter();
        }
        if (importer != null) {
            importer.setImportCache(this.isImportCache());
            return importer.imports(is, bookName);
        }
        throw new IllegalArgumentException("The input stream to be imported is neither an OLE2 stream, nor an OOXML stream");
    }

    protected boolean isImportCache() {
        String importCache = Library.getProperty((String)"io.keikai.import.cache", (String)"false");
        return "true".equalsIgnoreCase(importCache.trim());
    }
}

