


zss.Info = zk.$extends(zk.Object, {
	$init: function (sheet, cmp) {
		this.$supers('$init', arguments);
		this.sheet = sheet;
		this.comp = cmp;
		this.txtcomp = jq(cmp).children("SPAN:first")[0];
		this.visible = false;
		this.displaytime = 2000;
		this.showcount = 0;
		this.enabled = true;
		cmp.ctrl = this;
		this.lastautohide;
	},
	cleanup: function () {
		this.invalid = true;
		this.visible = this.enabled = false;
		
		if(this.comp) this.comp.ctrl = null;
		this.sheet = this.comp = this.txtcmop = null;
	},
	
	setEnabled: function (enabled) {
		if(this.enabled == enabled) return;
		this.enabled = enabled;
		if(!enabled)
			this.hideInfo();
	},
	
	showInfo: function (autohide) {
		if (!this.enabled) return ;
		this.lastautohide = autohide;
		this.visible = true;
		jq(this.comp).css('display', 'inline');
		
		if (autohide) {
			var local = this;
			this.showcount++;
			setTimeout(function () {
				local.showcount -- ;
				if (local.showcount <= 0) {
					setTimeout(function () {
						if (local.showcount > 0) return;
						if (!local.lastautohide) return;
						local.hideInfo();
					}, local.displaytime);	
				}
			},300);
		}
	},
	
	setInfoText: function (txt) {
		var txtcmp = this.txtcomp;
		txt = txt.trim();
		jq(txtcmp).text(txt);
	},
	
	hideInfo: function(){
		if (!this.visible) return;
		this.visible = false;
		jq(this.comp).css('display', 'none');
	}
});