/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api;

import io.keikai.api.CellVisitor;
import io.keikai.api.Range;
import io.keikai.api.RangeRunner;
import io.keikai.api.Ranges;
import io.keikai.api.UnitUtil;
import io.keikai.api.model.CellStyle;
import io.keikai.api.model.Color;
import io.keikai.api.model.Font;
import io.keikai.api.model.Hyperlink;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.impl.EnumUtil;
import io.keikai.model.CellStyleHolder;
import io.keikai.model.SBook;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SFont;
import io.keikai.model.SRichText;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.util.RichTextHelper;
import io.keikai.range.SRange;
import io.keikai.range.impl.StyleUtil;
import io.keikai.range.impl.WholeStyleUtil;

public class CellOperationUtil {
    public static Range cut(Range src, Range dest) {
        if (src.isProtected()) {
            return null;
        }
        if (dest.isProtected()) {
            return null;
        }
        return src.paste(dest, true);
    }

    public static Range paste(Range src, Range dest) {
        if (dest.isProtected()) {
            return null;
        }
        return src.paste(dest);
    }

    public static Range pasteFormula(Range src, Range dest) {
        return CellOperationUtil.pasteSpecial(src, dest, Range.PasteType.FORMULAS, Range.PasteOperation.NONE, false, false);
    }

    public static Range pasteValue(Range src, Range dest) {
        return CellOperationUtil.pasteSpecial(src, dest, Range.PasteType.VALUES, Range.PasteOperation.NONE, false, false);
    }

    public static Range pasteAllExceptBorder(Range src, Range dest) {
        return CellOperationUtil.pasteSpecial(src, dest, Range.PasteType.ALL_EXCEPT_BORDERS, Range.PasteOperation.NONE, false, false);
    }

    public static Range pasteTranspose(Range src, Range dest) {
        return CellOperationUtil.pasteSpecial(src, dest, Range.PasteType.ALL, Range.PasteOperation.NONE, false, true);
    }

    public static Range pasteSpecial(Range src, Range dest, Range.PasteType pasteType, Range.PasteOperation pasteOperation, boolean skipBlank, boolean transpose) {
        if (dest.isProtected()) {
            return null;
        }
        return src.pasteSpecial(dest, pasteType, pasteOperation, skipBlank, transpose);
    }

    public static CellStyleApplier getFontNameApplier(final String fontName) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setFontName((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (String)fontName);
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setFontName((SRange)wholeRange.getInternalRange(), (String)fontName);
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static void applyFontName(Range range, String fontName) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getFontNameApplier(fontName));
    }

    public static CellStyleApplier getRichTextFontNameApplier(final String fontName) {
        return new CellStyleApplier(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setRichTextFontName((SBook)sheet.getBook(), (SCell)sheet.getCell(range.getRow(), range.getColumn()), (String)fontName);
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static CellStyleApplier getFontHeightApplier(int fontHeight) {
        return CellOperationUtil.getFontHeightPointsApplier(UnitUtil.twipToPoint(fontHeight));
    }

    public static void applyFontHeight(Range range, int fontHeight) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getFontHeightApplier(fontHeight));
    }

    public static void applyFontSize(Range range, int point) {
        CellOperationUtil.applyFontHeightPoints(range, point);
    }

    public static void applyFontHeightPoints(Range range, int fontHeightPoints) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getFontHeightPointsApplier(fontHeightPoints));
    }

    public static void fitFontHeightPoints(Range range) {
        int endRow = range.getLastRow();
        Sheet sheet = range.getSheet();
        for (int row = range.getRow(); row <= endRow; ++row) {
            int px;
            SRow srow = sheet.getInternalSheet().getRow(row);
            if (srow.isCustomHeight()) continue;
            int highest = 0;
            int endCol = range.getLastColumn();
            for (int col = range.getColumn(); col <= endCol; ++col) {
                int fpx;
                SCell c = range.getSheet().getInternalSheet().getCell(row, col);
                int n = fpx = c.isRichTextValue() ? RichTextHelper.getRichTextHeightPoints((SCell)c, (SRichText)c.getRichTextValue()) : c.getCellStyle().getFont().getHeightPoints();
                if (fpx <= highest) continue;
                highest = fpx;
            }
            int fpx = UnitUtil.pointToPx(highest) + 4;
            if (fpx <= (px = sheet.getRowHeight(row))) continue;
            Ranges.range(range.getSheet(), row, endCol).setRowHeight(fpx, false);
        }
    }

    public static CellStyleApplier getFontHeightPointsApplier(final int fontHeightPoints) {
        final int fpx = UnitUtil.pointToPx(fontHeightPoints);
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setFontHeightPoints((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (int)fontHeightPoints);
                int px = range.getSheet().getRowHeight(range.getRow());
                if (fpx > px) {
                    range.setRowHeight(fpx + 4, false);
                }
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setFontHeightPoints((SRange)wholeRange.getInternalRange(), (int)fontHeightPoints);
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static CellStyleApplier getRichTextFontHeightPointsApplier(final int heightPoints) {
        return new CellStyleApplier(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setRichTextFontHeightPoints((SBook)sheet.getBook(), (SCell)sheet.getCell(range.getRow(), range.getColumn()), (int)heightPoints);
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static CellStyleApplier getFontBoldweightApplier(final Font.Boldweight boldweight) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setFontBoldWeight((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (SFont.Boldweight)EnumUtil.toFontBoldweight(boldweight));
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setFontBoldWeight((SRange)wholeRange.getInternalRange(), (SFont.Boldweight)EnumUtil.toFontBoldweight(boldweight));
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static void applyFontBoldweight(Range range, Font.Boldweight boldweight) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getFontBoldweightApplier(boldweight));
    }

    public static CellStyleApplier getRichTextFontBoldweightApplier(final Font.Boldweight boldweight) {
        return new CellStyleApplier(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setRichTextFontBoldweight((SBook)sheet.getBook(), (SCell)sheet.getCell(range.getRow(), range.getColumn()), (SFont.Boldweight)EnumUtil.toFontBoldweight(boldweight));
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static CellStyleApplier getFontItalicApplier(final boolean italic) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setFontItalic((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (boolean)italic);
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setFontItalic((SRange)wholeRange.getInternalRange(), (boolean)italic);
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static void applyFontItalic(Range range, boolean italic) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getFontItalicApplier(italic));
    }

    public static CellStyleApplier getRichTextFontItalicApplier(final boolean italic) {
        return new CellStyleApplier(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setRichTextFontItalic((SBook)sheet.getBook(), (SCell)sheet.getCell(range.getRow(), range.getColumn()), (boolean)italic);
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static CellStyleApplier getFontStrikeoutApplier(final boolean strikeout) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setFontStrikethrough((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (boolean)strikeout);
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setFontStrikethrough((SRange)wholeRange.getInternalRange(), (boolean)strikeout);
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static void applyFontStrikeout(Range range, boolean strikeout) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getFontStrikeoutApplier(strikeout));
    }

    public static CellStyleApplier getRichTextFontStrikeoutApplier(final boolean strikeout) {
        return new CellStyleApplier(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setRichTextFontStrikeout((SBook)sheet.getBook(), (SCell)sheet.getCell(range.getRow(), range.getColumn()), (boolean)strikeout);
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static CellStyleApplier getFontUnderlineApplier(final Font.Underline underline) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setFontUnderline((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (SFont.Underline)EnumUtil.toFontUnderline(underline));
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setFontUnderline((SRange)wholeRange.getInternalRange(), (SFont.Underline)EnumUtil.toFontUnderline(underline));
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static void applyFontUnderline(Range range, Font.Underline underline) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getFontUnderlineApplier(underline));
    }

    public static CellStyleApplier getRichTextFontUnderlineApplier(final Font.Underline underline) {
        return new CellStyleApplier(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setRichTextFontUnderline((SBook)sheet.getBook(), (SCell)sheet.getCell(range.getRow(), range.getColumn()), (SFont.Underline)EnumUtil.toFontUnderline(underline));
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static CellStyleApplier getFontColorApplier(final Color color) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setFontColor((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (String)color.getHtmlColor());
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setFontColor((SRange)wholeRange.getInternalRange(), (String)color.getHtmlColor());
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static void applyFontColor(Range range, String htmlColor) {
        Color color = range.getCellStyleHelper().createColorFromHtmlColor(htmlColor);
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getFontColorApplier(color));
    }

    public static CellStyleApplier getRichTextFontColorApplier(final Color color) {
        return new CellStyleApplier(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setRichTextFontColor((SBook)sheet.getBook(), (SCell)sheet.getCell(range.getRow(), range.getColumn()), (String)color.getHtmlColor());
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static CellStyleApplier getBackColorApplier(final Color color) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setBackColor((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (String)color.getHtmlColor());
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setBackColor((SRange)wholeRange.getInternalRange(), (String)color.getHtmlColor());
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    @Deprecated
    public static CellStyleApplier getBackgroundColorApplier(Color color) {
        return CellOperationUtil.getBackColorApplier(color);
    }

    public static CellStyleApplier getFillColorApplier(final Color color) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setFillColor((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (String)color.getHtmlColor());
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setFillColor((SRange)wholeRange.getInternalRange(), (String)color.getHtmlColor());
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    @Deprecated
    public static void applyBackgroundColor(Range range, String htmlColor) {
        CellOperationUtil.applyBackColor(range, htmlColor);
    }

    public static void applyBackColor(Range range, String htmlColor) {
        Color color = range.getCellStyleHelper().createColorFromHtmlColor(htmlColor);
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getBackColorApplier(color));
    }

    public static void applyFillColor(Range range, String htmlColor) {
        Color color = range.getCellStyleHelper().createColorFromHtmlColor(htmlColor);
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getFillColorApplier(color));
    }

    public static CellStyleApplier getDataFormatApplier(final String format) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setDataFormat((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (String)format);
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setDataFormat((SRange)wholeRange.getInternalRange(), (String)format);
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static void applyDataFormat(Range range, String format) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getDataFormatApplier(format));
    }

    public static CellStyleApplier getAligmentApplier(final CellStyle.Alignment alignment) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setTextIndention((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (int)0);
                StyleUtil.setTextHAlign((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (SCellStyle.Alignment)EnumUtil.toStyleAlignemnt(alignment));
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setTextIndention((SRange)wholeRange.getInternalRange(), (int)0);
                WholeStyleUtil.setTextHAlign((SRange)wholeRange.getInternalRange(), (SCellStyle.Alignment)EnumUtil.toStyleAlignemnt(alignment));
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static void applyAlignment(Range range, CellStyle.Alignment alignment) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getAligmentApplier(alignment));
    }

    public static CellStyleApplier getVerticalAligmentApplier(final CellStyle.VerticalAlignment alignment) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setTextVAlign((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (SCellStyle.VerticalAlignment)EnumUtil.toStyleVerticalAlignemnt(alignment));
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setTextVAlign((SRange)wholeRange.getInternalRange(), (SCellStyle.VerticalAlignment)EnumUtil.toStyleVerticalAlignemnt(alignment));
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static void applyVerticalAlignment(Range range, CellStyle.VerticalAlignment alignment) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getVerticalAligmentApplier(alignment));
    }

    public static void applyCellStyle(Range range, final CellStyleApplier applyer) {
        if (range.isProtected() && !range.getSheetProtection().isFormatCellsAllowed()) {
            return;
        }
        if (applyer instanceof CellStyleApplierEx && (range.isWholeRow() || range.isWholeColumn())) {
            ((CellStyleApplierEx)applyer).applyWhole(range);
        } else {
            range.visit(new CellVisitor(){

                @Override
                public boolean visit(Range cellRange) {
                    applyer.apply(cellRange);
                    return true;
                }

                @Override
                public boolean ignoreIfNotExist(int row, int column) {
                    return false;
                }

                @Override
                public boolean createIfNotExist(int row, int column) {
                    return true;
                }
            });
        }
        applyer.notifyChange(range);
    }

    public static void applyBorder(Range range, Range.ApplyBorderType applyType, CellStyle.BorderType borderType, String htmlColor) {
        if (range.isProtected() && !range.getSheetProtection().isFormatCellsAllowed()) {
            return;
        }
        range.applyBorders(applyType, borderType, htmlColor);
    }

    public static void toggleMergeCenter(Range range) {
        if (range.isProtected()) {
            return;
        }
        range.sync(new RangeRunner(){

            @Override
            public void run(Range range) {
                if (range.hasMergedCell()) {
                    range.unmerge();
                } else {
                    range.merge(false);
                    CellOperationUtil.applyAlignment(range.toCellRange(0, 0), CellStyle.Alignment.CENTER);
                }
            }
        });
    }

    public static void merge(Range range, boolean across) {
        if (range.isProtected()) {
            return;
        }
        range.merge(across);
    }

    public static void unmerge(Range range) {
        if (range.isProtected()) {
            return;
        }
        range.unmerge();
    }

    public static CellStyleApplier getWrapTextApplier(final boolean wraptext) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range cellRange) {
                SSheet sheet = cellRange.getSheet().getInternalSheet();
                SCell cell = sheet.getCell(cellRange.getRow(), cellRange.getColumn());
                StyleUtil.setTextWrap((SBook)sheet.getBook(), (CellStyleHolder)cell, (boolean)wraptext);
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setTextWrap((SRange)wholeRange.getInternalRange(), (boolean)wraptext);
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.ALL);
            }
        };
    }

    public static void applyWrapText(Range range, boolean wraptext) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getWrapTextApplier(wraptext));
    }

    public static void applyHyperlink(Range range, Hyperlink.HyperlinkType type, String address, String label) {
        if (range.isProtected() && !range.getSheetProtection().isInsertHyperlinksAllowed()) {
            return;
        }
        range.setCellHyperlink(type, address, label);
        CellOperationUtil.applyFontUnderline(range, Font.Underline.SINGLE);
        CellOperationUtil.applyFontColor(range, "#0000FF");
    }

    public static void clearContents(Range range) {
        if (range.isProtected()) {
            return;
        }
        range.clearContents();
    }

    public static void clearStyles(Range range) {
        if (range.isProtected() && !range.getSheetProtection().isFormatCellsAllowed()) {
            return;
        }
        range.clearStyles();
        range.unmerge();
    }

    public static void clearAll(Range range) {
        if (range.isProtected()) {
            return;
        }
        range.clearAll();
    }

    public static void insert(Range range, Range.InsertShift shift, Range.InsertCopyOrigin copyOrigin) {
        if (range.isProtected() && (Range.InsertShift.RIGHT.equals((Object)shift) ? !range.getSheetProtection().isInsertColumnsAllowed() : !range.getSheetProtection().isInsertRowsAllowed())) {
            return;
        }
        range.insert(shift, copyOrigin);
    }

    public static void insertRow(Range range) {
        CellOperationUtil.insert(range.toRowRange(), Range.InsertShift.DOWN, Range.InsertCopyOrigin.FORMAT_LEFT_ABOVE);
    }

    public static void insertColumn(Range range) {
        CellOperationUtil.insert(range.toColumnRange(), Range.InsertShift.RIGHT, Range.InsertCopyOrigin.FORMAT_LEFT_ABOVE);
    }

    public static void delete(Range range, Range.DeleteShift shift) {
        if (range.isProtected() && (Range.DeleteShift.LEFT.equals((Object)shift) ? !range.getSheetProtection().isDeleteColumnsAllowed() : !range.getSheetProtection().isDeleteRowsAllowed())) {
            return;
        }
        range.delete(shift);
    }

    public static void deleteRow(Range range) {
        CellOperationUtil.delete(range.toRowRange(), Range.DeleteShift.UP);
    }

    public static void deleteColumn(Range range) {
        CellOperationUtil.delete(range.toColumnRange(), Range.DeleteShift.LEFT);
    }

    public static void sort(Range range, boolean desc) {
        if (range.isProtected() && !range.getSheetProtection().isSortAllowed()) {
            return;
        }
        range.sort(desc);
    }

    public static void sort(Range range, Range index1, boolean desc1, Range.SortDataOption dataOption1, Range index2, boolean desc2, Range.SortDataOption dataOption2, Range index3, boolean desc3, Range.SortDataOption dataOption3, boolean header, boolean matchCase, boolean sortByRows) {
        if (range.isProtected() && !range.getSheetProtection().isSortAllowed()) {
            return;
        }
        range.sort(index1, desc1, dataOption1, index2, desc2, dataOption2, index3, desc3, dataOption3, header, matchCase, sortByRows);
    }

    public static void hide(Range range) {
        if (range.isProtected()) {
            if (range.isWholeColumn() && !range.getSheetProtection().isFormatColumnsAllowed()) {
                return;
            }
            if (range.isWholeRow() && !range.getSheetProtection().isFormatRowsAllowed()) {
                return;
            }
        }
        range.setHidden(true);
    }

    public static void unhide(Range range) {
        if (range.isProtected()) {
            if (range.isWholeColumn() && !range.getSheetProtection().isFormatColumnsAllowed()) {
                return;
            }
            if (range.isWholeRow() && !range.getSheetProtection().isFormatRowsAllowed()) {
                return;
            }
        }
        range.setHidden(false);
    }

    public static void shift(Range range, int rowOffset, int colOffset) {
        if (range.isProtected()) {
            return;
        }
        Range dstrange = range.toCellRange(rowOffset, colOffset);
        if (dstrange.isProtected()) {
            return;
        }
        range.shift(rowOffset, colOffset);
    }

    public static void autoFill(Range src, Range dest, Range.AutoFillType type) {
        if (dest.isProtected()) {
            return;
        }
        src.autoFill(dest, type);
    }

    public static void setRowHeight(Range range, int heightPx) {
        range.setRowHeight(heightPx);
    }

    public static void setRowHeight(Range range, int heightPx, boolean isCustom) {
        range.setRowHeight(heightPx, isCustom);
    }

    public static void setColumnWidth(Range range, int widthPx) {
        range.setColumnWidth(widthPx);
    }

    public static CellStyleApplier getFontTypeOffsetApplier(final Font.TypeOffset offset) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setFontTypeOffset((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (SFont.TypeOffset)EnumUtil.toFontTypeOffset(offset));
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setFontTypeOffset((SRange)wholeRange.getInternalRange(), (SFont.TypeOffset)EnumUtil.toFontTypeOffset(offset));
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static void applyFontTypeOffset(Range range, Font.TypeOffset offset) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getFontTypeOffsetApplier(offset));
    }

    public static CellStyleApplier getRichTextFontTypeOffsetApplier(final Font.TypeOffset offset) {
        return new CellStyleApplier(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setRichTextFontTypeOffset((SBook)sheet.getBook(), (SCell)sheet.getCell(range.getRow(), range.getColumn()), (SFont.TypeOffset)EnumUtil.toFontTypeOffset(offset));
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static CellStyleApplier getRotationApplier(final short rotation) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setTextRotation((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (int)rotation);
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setTextRotation((SRange)wholeRange.getInternalRange(), (int)rotation);
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.ALL);
            }
        };
    }

    public static void applyRotation(Range range, int rotation) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getRotationApplier((short)rotation));
    }

    public static CellStyleApplier getIndentionApplier(final int offset) {
        return new CellStyleApplierEx(){

            @Override
            public void apply(Range range) {
                SSheet sheet = range.getSheet().getInternalSheet();
                StyleUtil.setTextHAlign((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (SCellStyle.Alignment)SCellStyle.Alignment.LEFT);
                StyleUtil.setTextIndentionOffset((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (int)offset);
            }

            @Override
            public void applyWhole(Range wholeRange) {
                WholeStyleUtil.setTextHAlign((SRange)wholeRange.getInternalRange(), (SCellStyle.Alignment)EnumUtil.toStyleAlignemnt(CellStyle.Alignment.LEFT));
                WholeStyleUtil.setTextIndentionOffset((SRange)wholeRange.getInternalRange(), (int)offset);
            }

            @Override
            public void notifyChange(Range range) {
                range.notifyChange(Range.CellAttribute.STYLE);
            }
        };
    }

    public static void applyIndentionOffset(Range range, int offset) {
        CellOperationUtil.applyCellStyle(range, CellOperationUtil.getIndentionApplier(offset));
    }

    public static interface CellStyleApplierEx
    extends CellStyleApplier {
        public void applyWhole(Range var1);
    }

    public static interface CellStyleApplier {
        public void apply(Range var1);

        public void notifyChange(Range var1);
    }
}

