/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import java.io.Serializable;
import java.util.Map;

@SerializableByConvention
public final class JoinClause<K, T0, T1, T1_OUT>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final FunctionEx<? super T0, ? extends K> leftKeyFn;
    private final FunctionEx<? super T1, ? extends K> rightKeyFn;
    private final FunctionEx<? super T1, ? extends T1_OUT> rightProjectFn;

    private JoinClause(FunctionEx<? super T0, ? extends K> leftKeyFn, FunctionEx<? super T1, ? extends K> rightKeyFn, FunctionEx<? super T1, ? extends T1_OUT> rightProjectFn) {
        SerializationUtil.checkSerializable(leftKeyFn, "leftKeyFn");
        SerializationUtil.checkSerializable(rightKeyFn, "rightKeyFn");
        SerializationUtil.checkSerializable(rightProjectFn, "rightProjectFn");
        this.leftKeyFn = leftKeyFn;
        this.rightKeyFn = rightKeyFn;
        this.rightProjectFn = rightProjectFn;
    }

    public static <K, T0, T1> JoinClause<K, T0, T1, T1> onKeys(FunctionEx<? super T0, ? extends K> leftKeyFn, FunctionEx<? super T1, ? extends K> rightKeyFn) {
        return new JoinClause(leftKeyFn, rightKeyFn, FunctionEx.identity());
    }

    public static <K, T0, T1_OUT> JoinClause<K, T0, Map.Entry<K, T1_OUT>, T1_OUT> joinMapEntries(FunctionEx<? super T0, ? extends K> leftKeyFn) {
        return new JoinClause<Object, T0, Map.Entry, Object>(leftKeyFn, Map.Entry::getKey, Map.Entry::getValue);
    }

    public <T1_NEW_OUT> JoinClause<K, T0, T1, T1_NEW_OUT> projecting(FunctionEx<? super T1, ? extends T1_NEW_OUT> rightProjectFn) {
        return new JoinClause<K, T0, T1, T1_NEW_OUT>(this.leftKeyFn, this.rightKeyFn, rightProjectFn);
    }

    public FunctionEx<? super T0, ? extends K> leftKeyFn() {
        return this.leftKeyFn;
    }

    public FunctionEx<? super T1, ? extends K> rightKeyFn() {
        return this.rightKeyFn;
    }

    public FunctionEx<? super T1, ? extends T1_OUT> rightProjectFn() {
        return this.rightProjectFn;
    }
}

