/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.statistics;

import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ProxyManager;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.monitor.impl.NearCacheStatsImpl;

class NearCacheMetricsProvider
implements DynamicMetricsProvider {
    private final ProxyManager proxyManager;

    NearCacheMetricsProvider(ProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        descriptor.withPrefix("nearcache");
        ClientContext clientContext = this.proxyManager.getContext();
        if (clientContext == null) {
            return;
        }
        clientContext.getNearCacheManagers().values().stream().flatMap(nearCacheManager -> nearCacheManager.listAllNearCaches().stream()).forEach(nearCache -> {
            String nearCacheName = nearCache.getName();
            NearCacheStatsImpl nearCacheStats = (NearCacheStatsImpl)nearCache.getNearCacheStats();
            context.collect(descriptor.copy().withDiscriminator("name", nearCacheName), nearCacheStats);
        });
    }
}

