/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.impl.ClientFailoverConfigSections;
import com.hazelcast.client.config.impl.YamlClientFailoverConfigLocator;
import com.hazelcast.client.config.impl.YamlClientFailoverDomConfigProcessor;
import com.hazelcast.config.AbstractYamlConfigBuilder;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.config.ConfigLoader;
import com.hazelcast.internal.config.YamlConfigSchemaValidator;
import com.hazelcast.internal.config.yaml.W3cDomUtil;
import com.hazelcast.internal.config.yaml.YamlDomChecker;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.yaml.YamlLoader;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Properties;
import org.w3c.dom.Node;

public class YamlClientFailoverConfigBuilder
extends AbstractYamlConfigBuilder {
    private final InputStream in;

    public YamlClientFailoverConfigBuilder(String resource) throws IOException {
        URL url = ConfigLoader.locateConfig(resource);
        Preconditions.checkTrue(url != null, "Could not load " + resource);
        this.in = url.openStream();
    }

    public YamlClientFailoverConfigBuilder(File file) throws IOException {
        Preconditions.checkNotNull(file, "File is null!");
        this.in = new FileInputStream(file);
    }

    public YamlClientFailoverConfigBuilder(URL url) throws IOException {
        Preconditions.checkNotNull(url, "URL is null!");
        this.in = url.openStream();
    }

    public YamlClientFailoverConfigBuilder(InputStream in) {
        this.in = in;
    }

    public YamlClientFailoverConfigBuilder() {
        this((YamlClientFailoverConfigLocator)null);
    }

    @PrivateApi
    public YamlClientFailoverConfigBuilder(YamlClientFailoverConfigLocator locator) {
        if (locator == null) {
            locator = new YamlClientFailoverConfigLocator();
            locator.locateEverywhere();
        }
        if (!locator.isConfigPresent()) {
            throw new HazelcastException("Failed to load ClientFailoverConfig");
        }
        this.in = locator.getIn();
    }

    public ClientFailoverConfig build() {
        ClientFailoverConfig clientFailoverConfig = new ClientFailoverConfig();
        this.build(clientFailoverConfig);
        return clientFailoverConfig;
    }

    public YamlClientFailoverConfigBuilder setProperties(Properties properties) {
        this.setPropertiesInternal(properties);
        return this;
    }

    void build(ClientFailoverConfig clientFailoverConfig) {
        try {
            this.parseAndBuildConfig(clientFailoverConfig);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            IOUtil.closeResource(this.in);
        }
    }

    private void parseAndBuildConfig(ClientFailoverConfig config) throws Exception {
        YamlMapping yamlRootNode;
        try {
            yamlRootNode = (YamlMapping)YamlLoader.load(this.in);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Invalid YAML configuration", ex);
        }
        String configRoot = this.getConfigRoot();
        YamlMapping clientFailoverRoot = yamlRootNode.childAsMapping(configRoot);
        if (clientFailoverRoot == null) {
            clientFailoverRoot = yamlRootNode;
        }
        YamlDomChecker.check(clientFailoverRoot, Collections.singleton(ClientFailoverConfigSections.CLIENT_FAILOVER.getName()));
        Node w3cRootNode = W3cDomUtil.asW3cNode(clientFailoverRoot);
        this.replaceVariables(w3cRootNode);
        this.importDocuments(clientFailoverRoot);
        if (this.shouldValidateTheSchema()) {
            new YamlConfigSchemaValidator().validate(yamlRootNode);
        }
        new YamlClientFailoverDomConfigProcessor(true, config).buildConfig(w3cRootNode);
    }

    @Override
    protected String getConfigRoot() {
        return ClientFailoverConfigSections.CLIENT_FAILOVER.getName();
    }
}

