/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.adempiere.webui.AdempiereIdGenerator;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADTreePanel;
import org.adempiere.webui.adwindow.ADWindowToolbar;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.adwindow.DetailPane;
import org.adempiere.webui.adwindow.GridView;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.GridTab;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.SystemProperties;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Toolbar;

public class ADSortTab
extends Panel
implements IADTabpanel {
    private static final long serialVersionUID = 4302282658814599752L;
    protected static final CLogger log = CLogger.getCLogger(ADSortTab.class);
    private int m_WindowNo;
    private int m_AD_Table_ID;
    private String m_TableName = null;
    private String m_ColumnSortName = null;
    private String m_ColumnYesNoName = null;
    private String m_KeyColumnName = null;
    private String m_IdentifierSql = null;
    private boolean m_IdentifierTranslated = false;
    private String m_ParentColumnName = null;
    private AbstractADWindowContent adWindowPanel = null;
    private Label noLabel = new Label();
    private Label yesLabel = new Label();
    private Button bAdd = ButtonFactory.createButton(null, ThemeManager.getThemeResource("images/MoveRight16.png"), null);
    private Button bRemove = ButtonFactory.createButton(null, ThemeManager.getThemeResource("images/MoveLeft16.png"), null);
    private Button bUp = ButtonFactory.createButton(null, ThemeManager.getThemeResource("images/MoveUp16.png"), null);
    private Button bDown = ButtonFactory.createButton(null, ThemeManager.getThemeResource("images/MoveDown16.png"), null);
    protected SimpleListModel noModel = new SimpleListModel(){
        private static final long serialVersionUID = 3488081120336708285L;

        @Override
        public void addElement(Object obj) {
            Object[] elements = this.list.toArray();
            Arrays.sort(elements);
            int index = Arrays.binarySearch(elements, obj);
            if (index < 0) {
                index = -1 * index - 1;
            }
            if (index >= elements.length) {
                this.list.add(obj);
            } else {
                this.list.add(index, obj);
            }
            this.fireEvent(1, index, index);
        }
    };
    protected SimpleListModel yesModel = new SimpleListModel();
    protected Listbox noList = new Listbox();
    protected Listbox yesList = new Listbox();
    private GridTab gridTab;
    private boolean uiCreated;
    private boolean active = false;
    private boolean isChanged;
    private boolean detailPaneMode;
    private int tabNo;

    @Override
    public void init(AbstractADWindowContent winPanel, GridTab gridTab) {
        this.adWindowPanel = winPanel;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("SortOrder=" + gridTab.getAD_ColumnSortOrder_ID() + ", SortYesNo=" + gridTab.getAD_ColumnSortYesNo_ID());
        }
        this.m_WindowNo = winPanel.getWindowNo();
        this.gridTab = gridTab;
        this.m_AD_Table_ID = gridTab.getAD_Table_ID();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this, "true");
        this.addEventListener("onActivate", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                ADSortTab.this.removeAttribute("org.adempiere.webui.adwindow.IADTabpanel.onActivatePosted");
            }
        });
    }

    private void dynInit(int AD_Table_ID, int AD_ColumnSortOrder_ID, int AD_ColumnSortYesNo_ID) {
        StringBuilder identifierSql;
        int identifiersCount;
        block24: {
            boolean trl;
            this.m_AD_Table_ID = AD_Table_ID;
            identifiersCount = 0;
            identifierSql = new StringBuilder();
            Object sql = "SELECT t.TableName, c.AD_Column_ID, c.ColumnName, e.Name,c.IsParent, c.IsKey, c.IsIdentifier, c.IsTranslated, c.ColumnSQL, c.AD_Reference_ID FROM AD_Table t, AD_Column c, AD_Element e WHERE t.AD_Table_ID=? AND t.AD_Table_ID=c.AD_Table_ID AND (c.AD_Column_ID=? OR AD_Column_ID=? OR c.IsParent='Y' OR c.IsKey='Y' OR c.IsIdentifier='Y') AND c.AD_Element_ID=e.AD_Element_ID";
            boolean bl = trl = !Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Element");
            if (trl) {
                sql = "SELECT t.TableName, c.AD_Column_ID, c.ColumnName, et.Name,c.IsParent, c.IsKey, c.IsIdentifier, c.IsTranslated, c.ColumnSQL, c.AD_Reference_ID FROM AD_Table t, AD_Column c, AD_Element_Trl et WHERE t.AD_Table_ID=? AND t.AD_Table_ID=c.AD_Table_ID AND (c.AD_Column_ID=? OR AD_Column_ID=?\tOR c.IsParent='Y' OR c.IsKey='Y' OR c.IsIdentifier='Y') AND c.AD_Element_ID=et.AD_Element_ID AND et.AD_Language=?";
            }
            sql = (String)sql + " ORDER BY c.SeqNo";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, AD_Table_ID);
                    pstmt.setInt(2, AD_ColumnSortOrder_ID);
                    pstmt.setInt(3, AD_ColumnSortYesNo_ID);
                    if (trl) {
                        pstmt.setString(4, Env.getAD_Language((Properties)Env.getCtx()));
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.m_TableName = rs.getString(1);
                        if (AD_ColumnSortOrder_ID == rs.getInt(2)) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Sort=" + rs.getString(1) + "." + rs.getString(3));
                            }
                            this.m_ColumnSortName = rs.getString(3);
                            this.yesLabel.setValue(rs.getString(4));
                        } else if (AD_ColumnSortYesNo_ID == rs.getInt(2)) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("YesNo=" + rs.getString(1) + "." + rs.getString(3));
                            }
                            this.m_ColumnYesNoName = rs.getString(3);
                        } else if (rs.getString(5).equals("Y")) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Parent=" + rs.getString(1) + "." + rs.getString(3));
                            }
                            this.m_ParentColumnName = rs.getString(3);
                        } else if (rs.getString(6).equals("Y")) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Key=" + rs.getString(1) + "." + rs.getString(3));
                            }
                            this.m_KeyColumnName = rs.getString(3);
                        }
                        if (!rs.getString(7).equals("Y")) continue;
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Identifier=" + rs.getString(1) + "." + rs.getString(3));
                        }
                        boolean isTranslated = trl && "Y".equals(rs.getString(8));
                        int AD_Reference_ID = rs.getInt(10);
                        if (identifierSql.length() > 0) {
                            identifierSql.append(" || '").append(MSysConfig.getValue((String)"IDENTIFIER_SEPARATOR", (String)"_", (int)Env.getAD_Client_ID((Properties)Env.getCtx()))).append("' || ");
                        }
                        identifierSql.append("NVL(");
                        if (!Util.isEmpty((String)rs.getString(9))) {
                            String value = rs.getString(9).replace(this.m_TableName + ".", isTranslated ? "tt." : "t.");
                            identifierSql.append(DB.TO_CHAR((String)("(" + value + ")"), (int)AD_Reference_ID, (String)Env.getAD_Language((Properties)Env.getCtx())));
                        } else {
                            identifierSql.append(DB.TO_CHAR((String)((isTranslated ? "tt." : "t.") + rs.getString(3)), (int)AD_Reference_ID, (String)Env.getAD_Language((Properties)Env.getCtx())));
                        }
                        identifierSql.append(",'')");
                        ++identifiersCount;
                        if (!isTranslated) continue;
                        this.m_IdentifierTranslated = true;
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, ((String)sql).toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block24;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_IdentifierSql = identifiersCount == 0 ? "NULL" : identifierSql.toString();
        this.noLabel.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Available"));
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.m_ColumnSortName);
        }
    }

    private void init() throws Exception {
        this.noLabel.setValue("No");
        this.yesLabel.setValue("Yes");
        ZKUpdateUtil.setVflex(this.yesList, true);
        ZKUpdateUtil.setVflex(this.noList, true);
        if (SystemProperties.isZkUnitTest()) {
            this.setId(AdempiereIdGenerator.escapeId(this.gridTab.getName()));
        }
        EventListener<Event> mouseListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if ("onDoubleClick".equals(event.getName())) {
                    ADSortTab.this.migrateValueAcrossLists(event);
                }
            }
        };
        this.yesList.addDoubleClickListener(mouseListener);
        this.noList.addDoubleClickListener(mouseListener);
        EventListener<Event> actionListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                ADSortTab.this.migrateValueAcrossLists(event);
            }
        };
        this.yesModel.setMultiple(true);
        this.noModel.setMultiple(true);
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bAdd);
        LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)this.bAdd);
        this.bAdd.addEventListener("onClick", (EventListener)actionListener);
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bRemove);
        LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)this.bRemove);
        this.bRemove.addEventListener("onClick", (EventListener)actionListener);
        DragListener crossListMouseListener = new DragListener();
        this.yesList.addOnDropListener(crossListMouseListener);
        this.noList.addOnDropListener(crossListMouseListener);
        this.yesList.setItemDraggable(true);
        this.noList.setItemDraggable(true);
        EventListener<Event> actionListener2 = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                ADSortTab.this.migrateValueWithinYesList(event);
            }
        };
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bUp);
        LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)this.bUp);
        this.bUp.addEventListener("onClick", (EventListener)actionListener2);
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bDown);
        LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)this.bDown);
        this.bDown.addEventListener("onClick", (EventListener)actionListener2);
        ListHead listHead = new ListHead();
        listHead.setParent((Component)this.yesList);
        ListHeader listHeader = new ListHeader();
        listHeader.appendChild((Component)this.yesLabel);
        Hlayout yesButtonLayout = new Hlayout();
        yesButtonLayout.appendChild((Component)this.bUp);
        yesButtonLayout.appendChild((Component)this.bDown);
        listHeader.appendChild((Component)yesButtonLayout);
        yesButtonLayout.setStyle("display: inline-block; float: right;");
        listHeader.setParent((Component)listHead);
        listHead = new ListHead();
        listHead.setParent((Component)this.noList);
        listHeader = new ListHeader();
        listHeader.appendChild((Component)this.noLabel);
        Hlayout noButtonLayout = new Hlayout();
        noButtonLayout.appendChild((Component)this.bRemove);
        noButtonLayout.appendChild((Component)this.bAdd);
        listHeader.appendChild((Component)noButtonLayout);
        noButtonLayout.setStyle("display: inline-block; float: right;");
        listHeader.setParent((Component)listHead);
        Hlayout hlayout = new Hlayout();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)hlayout, "true");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hlayout, "true");
        hlayout.setStyle("margin: auto;");
        this.appendChild((Component)hlayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.noList, "1");
        ZKUpdateUtil.setVflex(this.noList, true);
        hlayout.appendChild((Component)this.noList);
        ZKUpdateUtil.setVflex(this.yesList, true);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.yesList, "1");
        hlayout.appendChild((Component)this.yesList);
    }

    public void loadData() {
        boolean isReadWrite;
        block21: {
            this.yesModel.removeAllElements();
            this.noModel.removeAllElements();
            isReadWrite = true;
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT t.").append(this.m_KeyColumnName).append(",").append(this.m_IdentifierSql).append(",t.").append(this.m_ColumnSortName).append(", t.AD_Client_ID, t.AD_Org_ID");
            if (this.m_ColumnYesNoName != null) {
                sql.append(",t.").append(this.m_ColumnYesNoName);
            }
            sql.append(" FROM ").append(this.m_TableName).append(" t");
            if (this.m_IdentifierTranslated) {
                sql.append(", ").append(this.m_TableName).append("_Trl tt");
            }
            if (this.m_ParentColumnName != null) {
                sql.append(" WHERE t.").append(this.m_ParentColumnName).append("=?");
            } else {
                sql.append(" WHERE 1=?");
            }
            int reportView_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"AD_ReportView_ID");
            if ("AD_PrintFormatItem".equals(this.m_TableName) && reportView_ID > 0) {
                sql.append(" AND (t.AD_Column_ID IN (SELECT AD_Column_ID FROM AD_ReportView_Column WHERE AD_ReportView_ID=").append(reportView_ID).append(" AND IsActive='Y')").append(" OR ((SELECT COUNT(*) FROM AD_ReportView_Column WHERE AD_ReportView_ID=").append(reportView_ID).append(" AND IsActive='Y') = 0))");
            }
            if (this.m_IdentifierTranslated) {
                sql.append(" AND t.").append(this.m_KeyColumnName).append("=tt.").append(this.m_KeyColumnName).append(" AND tt.AD_Language=?");
            }
            sql.append(" AND t.AD_Client_ID IN (0,?)");
            sql.append(" ORDER BY ");
            if (this.m_ColumnYesNoName != null) {
                sql.append("6 DESC,");
            }
            sql.append("3,2");
            int ID = 0;
            if (this.m_ParentColumnName != null) {
                ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)this.m_ParentColumnName);
                if (log.isLoggable(Level.FINE)) {
                    log.fine(sql.toString() + " - ID=" + ID);
                }
            } else {
                ID = 1;
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    int idx = 1;
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(idx++, ID);
                    if (this.m_IdentifierTranslated) {
                        pstmt.setString(idx++, Env.getAD_Language((Properties)Env.getCtx()));
                    }
                    pstmt.setInt(idx++, Env.getAD_Client_ID((Properties)Env.getCtx()));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int key = rs.getInt(1);
                        String name = rs.getString(2);
                        int seq = rs.getInt(3);
                        boolean isYes = seq != 0;
                        int AD_Client_ID = rs.getInt(4);
                        int AD_Org_ID = rs.getInt(5);
                        if (this.m_ColumnYesNoName != null) {
                            isYes = rs.getString(6).equals("Y");
                        }
                        ListElement pp = new ListElement(key, name, seq, isYes, AD_Client_ID, AD_Org_ID);
                        if (isYes) {
                            this.yesModel.addElement((Object)pp);
                        } else {
                            this.noModel.addElement((Object)pp);
                        }
                        if (!isYes || pp.isUpdateable()) continue;
                        isReadWrite = false;
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block21;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (!this.gridTab.getParentTab().needSave(true, true)) {
            this.setIsChanged(false);
        }
        this.bAdd.setEnabled(isReadWrite);
        this.bRemove.setEnabled(isReadWrite);
        this.bUp.setEnabled(isReadWrite);
        this.bDown.setEnabled(isReadWrite);
        this.yesList.setEnabled(isReadWrite);
        this.noList.setEnabled(isReadWrite);
        this.yesList.setItemRenderer(this.yesModel);
        this.yesList.setModel((ListModel)this.yesModel);
        this.noList.setItemRenderer(this.noModel);
        this.noList.setModel((ListModel)this.noModel);
    }

    public void setIsChanged(boolean value) {
        this.isChanged = value;
        if (this.adWindowPanel != null) {
            this.adWindowPanel.getToolbar().enableSave(value);
            this.adWindowPanel.getToolbar().enableIgnore(value);
        }
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    protected void migrateValueAcrossLists(Event event) {
        Component source = event.getTarget();
        if (source instanceof ListItem) {
            source = ((ListItem)source).getListbox();
        }
        Listbox listFrom = source == this.bAdd || source == this.noList ? this.noList : this.yesList;
        Listbox listTo = source == this.bAdd || source == this.noList ? this.yesList : this.noList;
        int endIndex = this.yesList.getIndexOfItem(listTo.getSelectedItem());
        if (endIndex < 0) {
            endIndex = 0;
        }
        this.migrateLists(listFrom, listTo, endIndex);
    }

    protected void migrateLists(Listbox listFrom, Listbox listTo, int endIndex) {
        int index = 0;
        SimpleListModel lmFrom = listFrom == this.yesList ? this.yesModel : this.noModel;
        SimpleListModel lmTo = lmFrom == this.yesModel ? this.noModel : this.yesModel;
        Set selectedItems = listFrom.getSelectedItems();
        ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
        for (Object obj : selectedItems) {
            ListItem listItem = (ListItem)((Object)obj);
            index = listFrom.getIndexOfItem(listItem);
            ListElement selObject = (ListElement)((Object)lmFrom.getElementAt(index));
            selObjects.add(selObject);
        }
        index = 0;
        Arrays.sort(selObjects.toArray());
        for (ListElement selObject : selObjects) {
            if (selObject == null || !selObject.isUpdateable()) continue;
            lmFrom.removeElement((Object)selObject);
            lmTo.add(endIndex, (Object)selObject);
        }
        this.setIsChanged(true);
        if (listTo.getSelectedItem() != null) {
            AuFocus focus = new AuFocus((Component)listTo.getSelectedItem());
            Clients.response((AuResponse)focus);
        }
    }

    protected void migrateValueWithinYesList(Event event) {
        Object[] selObjects = this.yesList.getSelectedItems().toArray();
        if (selObjects == null) {
            return;
        }
        int length = selObjects.length;
        if (length == 0) {
            return;
        }
        int[] indices = this.yesList.getSelectedIndices();
        boolean change = false;
        Component source = event.getTarget();
        if (source == this.bUp) {
            i = 0;
            while (i < length) {
                int index = indices[i];
                if (index == 0) break;
                ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(index));
                ListElement newObject = (ListElement)((Object)this.yesModel.getElementAt(index - 1));
                if (selObject.isUpdateable() && newObject.isUpdateable()) {
                    this.yesModel.setElementAt((Object)newObject, index);
                    this.yesModel.setElementAt((Object)selObject, index - 1);
                    indices[i] = index - 1;
                    change = true;
                    ++i;
                    continue;
                }
                break;
            }
        } else if (source == this.bDown) {
            i = length - 1;
            while (i >= 0) {
                int index = indices[i];
                if (index >= this.yesModel.getSize() - 1) break;
                ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(index));
                ListElement newObject = (ListElement)((Object)this.yesModel.getElementAt(index + 1));
                if (selObject.isUpdateable() && newObject.isUpdateable()) {
                    this.yesModel.setElementAt((Object)newObject, index);
                    this.yesModel.setElementAt((Object)selObject, index + 1);
                    this.yesList.setSelectedIndex(index + 1);
                    indices[i] = index + 1;
                    change = true;
                    --i;
                    continue;
                }
                break;
            }
        }
        if (change) {
            this.yesList.setSelectedIndices(indices);
            this.setIsChanged(true);
            if (this.yesList.getSelectedItem() != null) {
                AuFocus focus = new AuFocus((Component)this.yesList.getSelectedItem());
                Clients.response((AuResponse)focus);
            }
        }
    }

    protected void migrateValueWithinYesList(int endIndex, List<ListElement> selObjects) {
        int iniIndex = 0;
        Arrays.sort(selObjects.toArray());
        ListElement selObject = null;
        ListElement endObject = (ListElement)((Object)this.yesModel.getElementAt(endIndex));
        for (ListElement selected : selObjects) {
            iniIndex = this.yesModel.indexOf((Object)selected);
            selObject = (ListElement)((Object)this.yesModel.getElementAt(iniIndex));
            this.yesModel.removeElement((Object)selObject);
            endIndex = this.yesModel.indexOf((Object)endObject);
            this.yesModel.add(endIndex, (Object)selObject);
        }
        this.yesList.removeAllItems();
        int i = 0;
        while (i < this.yesModel.getSize()) {
            ListElement pp = (ListElement)((Object)this.yesModel.getElementAt(i));
            this.yesList.addItem(new KeyNamePair(pp.m_key, pp.getName()));
            ++i;
        }
        this.setIsChanged(true);
    }

    public void registerAPanel(AbstractADWindowContent panel) {
        this.adWindowPanel = panel;
    }

    public void saveData() {
        if (!this.adWindowPanel.getToolbar().isSaveEnable()) {
            return;
        }
        boolean ok = true;
        StringBuilder info = new StringBuilder();
        MTable table2 = MTable.get((Properties)Env.getCtx(), (String)this.m_TableName);
        HashMap<Integer, ListElement> noModelBackup = new HashMap<Integer, ListElement>();
        HashMap<Integer, ListElement> yesModelBackup = new HashMap<Integer, ListElement>();
        try (Trx trx = Trx.get((String)Trx.createTrxName((String)"ADSortTab_save"), (boolean)true);){
            trx.start();
            int i = 0;
            while (i < this.noModel.getSize()) {
                ListElement pp = (ListElement)((Object)this.noModel.getElementAt(i));
                if (pp.isUpdateable() && (pp.getSortNo() != 0 || this.m_ColumnYesNoName != null && pp.isYes())) {
                    PO po = table2.getPO(pp.getKey(), trx.getTrxName());
                    po.set_ValueOfColumn(this.m_ColumnSortName, (Object)0);
                    if (this.m_ColumnYesNoName != null) {
                        po.set_ValueOfColumn(this.m_ColumnYesNoName, (Object)"N");
                    }
                    try {
                        po.saveEx();
                        ListElement backup = new ListElement(pp.getKey(), pp.getName(), pp.getSortNo(), pp.isYes(), pp.getAD_Client_ID(), pp.getAD_Org_ID());
                        noModelBackup.put(i, backup);
                        pp.setSortNo(0);
                        pp.setIsYes(false);
                    }
                    catch (Exception e) {
                        ok = false;
                        trx.rollback();
                        if (info.length() > 0) {
                            info.append(", ");
                        }
                        info.append(pp.getName());
                        log.log(Level.SEVERE, "NoModel - Not updated: " + this.m_KeyColumnName + "=" + pp.getKey(), (Throwable)e);
                        break;
                    }
                }
                ++i;
            }
            if (ok) {
                int index = 0;
                int i2 = 0;
                while (i2 < this.yesModel.getSize()) {
                    ListElement pp = (ListElement)((Object)this.yesModel.getElementAt(i2));
                    if (pp.isUpdateable() && (pp.getSortNo() != (index += 10) || this.m_ColumnYesNoName != null && !pp.isYes())) {
                        PO po = table2.getPO(pp.getKey(), trx.getTrxName());
                        po.set_ValueOfColumn(this.m_ColumnSortName, (Object)index);
                        if (this.m_ColumnYesNoName != null) {
                            po.set_ValueOfColumn(this.m_ColumnYesNoName, (Object)"Y");
                        }
                        try {
                            po.saveEx();
                            ListElement backup = new ListElement(pp.getKey(), pp.getName(), pp.getSortNo(), pp.isYes(), pp.getAD_Client_ID(), pp.getAD_Org_ID());
                            yesModelBackup.put(i2, backup);
                            pp.setSortNo(index);
                            pp.setIsYes(true);
                        }
                        catch (Exception e) {
                            ok = false;
                            trx.rollback();
                            if (info.length() > 0) {
                                info.append(", ");
                            }
                            info.append(pp.getName());
                            log.log(Level.SEVERE, "YesModel - Not updated: " + this.m_KeyColumnName + "=" + pp.getKey(), (Throwable)e);
                            break;
                        }
                    }
                    ++i2;
                }
            }
            if (ok) {
                try {
                    trx.commit(true);
                }
                catch (Exception e) {
                    ok = false;
                    trx.rollback();
                    info.append("Failed to commit database transaction");
                    log.log(Level.SEVERE, "Failed to commit database transaction", (Throwable)e);
                }
            }
            if (!ok) {
                ListElement e;
                for (Integer index : noModelBackup.keySet()) {
                    e = (ListElement)((Object)noModelBackup.get(index));
                    this.noModel.setElementAt((Object)e, index);
                }
                for (Integer index : yesModelBackup.keySet()) {
                    e = (ListElement)((Object)yesModelBackup.get(index));
                    this.yesModel.setElementAt((Object)e, index);
                }
            }
        }
        if (ok) {
            this.setIsChanged(false);
        } else {
            Dialog.error(this.m_WindowNo, "SaveError", info.toString());
        }
    }

    @Override
    public void activate(boolean b) {
        if (b) {
            if (this.getAttribute("org.adempiere.webui.adwindow.IADTabpanel.onActivatePosted") != null) {
                return;
            }
            this.setAttribute("org.adempiere.webui.adwindow.IADTabpanel.onActivatePosted", Boolean.TRUE);
        }
        this.active = b;
        Event event = new Event("onActivate", (Component)this, (Object)b);
        Events.postEvent((Event)event);
    }

    @Override
    public void createUI() {
        if (this.uiCreated) {
            return;
        }
        try {
            this.init();
            this.dynInit(this.gridTab.getAD_Table_ID(), this.gridTab.getAD_ColumnSortOrder_ID(), this.gridTab.getAD_ColumnSortYesNo_ID());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        this.uiCreated = true;
    }

    @Override
    public void dynamicDisplay(int i) {
    }

    @Deprecated(forRemoval=true, since="11")
    public void editRecord(boolean b) {
    }

    @Override
    public String getDisplayLogic() {
        return this.gridTab.getDisplayLogic();
    }

    @Override
    public GridTab getGridTab() {
        return this.gridTab;
    }

    @Override
    public int getTabLevel() {
        return this.gridTab.getTabLevel();
    }

    @Override
    public String getTableName() {
        return this.gridTab.getTableName();
    }

    @Override
    public int getRecord_ID() {
        return this.gridTab.getRecord_ID();
    }

    @Override
    public String getTitle() {
        return this.gridTab.getName();
    }

    @Override
    public boolean isCurrent() {
        return this.gridTab != null ? this.gridTab.isCurrent() : false;
    }

    @Override
    public void query() {
        this.loadData();
    }

    @Override
    public void query(boolean currentRows, int currentDays, int i) {
        this.loadData();
    }

    @Override
    public void refresh() {
        this.createUI();
        this.loadData();
    }

    @Override
    public void switchRowPresentation() {
    }

    @Override
    public void onAfterFind() {
    }

    public String get_ValueAsString(String variableName) {
        return new DefaultEvaluatee(this.getGridTab(), this.m_WindowNo, this.tabNo).get_ValueAsString(Env.getCtx(), variableName);
    }

    @Override
    public void afterSave(boolean onSaveEvent) {
    }

    @Override
    public boolean onEnterKey() {
        return false;
    }

    @Override
    public boolean isGridView() {
        return false;
    }

    @Override
    public boolean isActivated() {
        return this.active;
    }

    @Override
    public void setDetailPaneMode(boolean detailMode) {
        this.detailPaneMode = detailMode;
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this, "true");
    }

    @Override
    public boolean isDetailPaneMode() {
        return this.detailPaneMode;
    }

    @Override
    public GridView getGridView() {
        return null;
    }

    @Override
    public boolean needSave(boolean rowChange, boolean onlyRealChange) {
        return this.isChanged();
    }

    @Override
    public boolean dataSave(boolean onSaveEvent) {
        if (this.isChanged()) {
            this.saveData();
            return !this.isChanged();
        }
        return true;
    }

    @Override
    public void setTabNo(int tabNo) {
        this.tabNo = tabNo;
    }

    @Override
    public int getTabNo() {
        return this.tabNo;
    }

    @Override
    public void setDetailPane(DetailPane detailPane) {
    }

    @Override
    public DetailPane getDetailPane() {
        return null;
    }

    @Override
    public void resetDetailForNewParentRecord() {
        this.yesModel.removeAllElements();
        this.noModel.removeAllElements();
        this.bAdd.setEnabled(false);
        this.bRemove.setEnabled(false);
        this.bUp.setEnabled(false);
        this.bDown.setEnabled(false);
        this.yesList.setEnabled(false);
        this.noList.setEnabled(false);
        this.yesList.setItemRenderer(this.yesModel);
        this.yesList.setModel((ListModel)this.yesModel);
        this.noList.setItemRenderer(this.noModel);
        this.noList.setModel((ListModel)this.noModel);
    }

    @Override
    public ADTreePanel getTreePanel() {
        return null;
    }

    @Override
    public boolean isEnableQuickFormButton() {
        return false;
    }

    @Override
    public List<org.zkoss.zul.Button> getToolbarButtons() {
        return new ArrayList<org.zkoss.zul.Button>();
    }

    @Override
    public boolean isEnableCustomizeButton() {
        return false;
    }

    @Override
    public boolean isEnableProcessButton() {
        return false;
    }

    @Override
    public void updateToolbar(ADWindowToolbar toolbar) {
    }

    @Override
    public void updateDetailToolbar(Toolbar toolbar) {
    }

    private class DragListener
    implements EventListener<Event> {
        public void onEvent(Event event) throws Exception {
            if (event instanceof DropEvent) {
                int endIndex = 0;
                DropEvent me = (DropEvent)event;
                ListItem endItem = (ListItem)me.getTarget();
                ListItem startItem = (ListItem)me.getDragged();
                if (!startItem.isSelected()) {
                    startItem.setSelected(true);
                }
                if (startItem.getListbox() != endItem.getListbox()) {
                    Listbox listFrom = (Listbox)startItem.getListbox();
                    Listbox listTo = (Listbox)endItem.getListbox();
                    endIndex = ADSortTab.this.yesList.getIndexOfItem(endItem);
                    ADSortTab.this.migrateLists(listFrom, listTo, endIndex);
                } else if (startItem.getListbox() == endItem.getListbox() && startItem.getListbox() == ADSortTab.this.yesList) {
                    ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
                    endIndex = ADSortTab.this.yesList.getIndexOfItem(endItem);
                    for (Object obj : ADSortTab.this.yesList.getSelectedItems()) {
                        ListItem listItem = (ListItem)((Object)obj);
                        int index = ADSortTab.this.yesList.getIndexOfItem(listItem);
                        ListElement selObject = (ListElement)((Object)ADSortTab.this.yesModel.getElementAt(index));
                        selObjects.add(selObject);
                    }
                    ADSortTab.this.migrateValueWithinYesList(endIndex, selObjects);
                }
            }
        }
    }

    private class ListElement
    extends NamePair {
        private static final long serialVersionUID = -6319536467438753815L;
        private int m_key;
        private int m_AD_Client_ID;
        private int m_AD_Org_ID;
        private int m_sortNo;
        private boolean m_isYes;
        private boolean m_updateable;

        public ListElement(int key, String name, int sortNo, boolean isYes, int AD_Client_ID, int AD_Org_ID) {
            super(name);
            this.m_key = key;
            this.m_AD_Client_ID = AD_Client_ID;
            this.m_AD_Org_ID = AD_Org_ID;
            this.m_sortNo = sortNo;
            this.m_isYes = isYes;
            this.m_updateable = MRole.getDefault().canUpdate(this.m_AD_Client_ID, this.m_AD_Org_ID, ADSortTab.this.m_AD_Table_ID, this.m_key, false);
        }

        public int getKey() {
            return this.m_key;
        }

        public void setSortNo(int sortNo) {
            this.m_sortNo = sortNo;
        }

        public int getSortNo() {
            return this.m_sortNo;
        }

        public void setIsYes(boolean value) {
            this.m_isYes = value;
        }

        public boolean isYes() {
            return this.m_isYes;
        }

        public int getAD_Client_ID() {
            return this.m_AD_Client_ID;
        }

        public int getAD_Org_ID() {
            return this.m_AD_Org_ID;
        }

        public boolean isUpdateable() {
            return this.m_updateable;
        }

        public String getID() {
            return this.m_key != -1 ? String.valueOf(this.m_key) : null;
        }

        public int hashCode() {
            return this.m_key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListElement) {
                ListElement li = (ListElement)((Object)obj);
                return li.getKey() == this.m_key && li.getName() != null && li.getName().equals(this.getName()) && li.getAD_Client_ID() == this.m_AD_Client_ID && li.getAD_Org_ID() == this.m_AD_Org_ID;
            }
            return false;
        }

        public String toString() {
            Object s = super.toString();
            if (s == null || ((String)s).trim().length() == 0) {
                s = "<" + this.getKey() + ">";
            }
            return s;
        }
    }
}

