/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.webui.component.Menupopup;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.WFieldSuggestion;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MToolBarButtonRestrict;
import org.compiere.model.MZoomCondition;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Menuitem;

public class WEditorPopupMenu
extends Menupopup
implements EventListener<Event> {
    private static final long serialVersionUID = 4574171758155591250L;
    public static final String EVENT_ATTRIBUTE = "EVENT";
    public static final String ZOOM_EVENT = "ZOOM";
    public static final String REQUERY_EVENT = "REQUERY";
    public static final String PREFERENCE_EVENT = "VALUE_PREFERENCE";
    public static final String NEW_EVENT = "NEW_RECORD";
    public static final String UPDATE_EVENT = "UPDATE_RECORD";
    public static final String SHOWLOCATION_EVENT = "SHOW_LOCATION";
    public static final String CHANGE_LOG_EVENT = "CHANGE_LOG";
    public static final String EDITOR_EVENT = "EDITOR";
    public static final String RESET_EVENT = "RESET";
    public static final String ASSISTANT_EVENT = "ASSISTANT";
    public static final String DRILL_EVENT = "DRILL";
    private boolean newEnabled = true;
    private boolean updateEnabled = true;
    private boolean zoomEnabled = true;
    private boolean requeryEnabled = true;
    private boolean preferencesEnabled = true;
    private boolean showLocation = true;
    private boolean drillEnabled = true;
    private Menuitem zoomItem;
    private Menuitem requeryItem;
    private Menuitem prefItem;
    private Menuitem newItem;
    private Menuitem updateItem;
    private Menuitem showLocationItem;
    private Menuitem drillItem;
    private ArrayList<ContextMenuListener> menuListeners = new ArrayList();

    public WEditorPopupMenu(boolean zoom, boolean requery, boolean preferences) {
        this(zoom, requery, preferences, false, false, false, false, null);
    }

    @Deprecated
    public WEditorPopupMenu(boolean zoom, boolean requery, boolean preferences, boolean newRecord) {
        this(zoom, requery, preferences, newRecord, false, false, null);
    }

    @Deprecated
    public WEditorPopupMenu(boolean zoom, boolean requery, boolean preferences, boolean newRecord, boolean updateRecord) {
        this(zoom, requery, preferences, newRecord, updateRecord, false, null);
    }

    @Deprecated
    public WEditorPopupMenu(boolean zoom, boolean requery, boolean preferences, boolean newRecord, boolean updateRecord, boolean showLocation) {
        this(zoom, requery, preferences, newRecord, updateRecord, false, null);
    }

    public WEditorPopupMenu(boolean zoom, boolean requery, boolean preferences, boolean newRecord, boolean updateRecord, boolean showLocation, Lookup lookup) {
        this(zoom, requery, preferences, newRecord, updateRecord, showLocation, false, lookup);
    }

    public WEditorPopupMenu(boolean zoom, boolean requery, boolean preferences, boolean newRecord, boolean updateRecord, boolean showLocation, boolean drillEnabled, Lookup lookup) {
        this.zoomEnabled = zoom;
        this.requeryEnabled = requery;
        this.preferencesEnabled = preferences;
        this.newEnabled = newRecord;
        this.updateEnabled = updateRecord;
        this.showLocation = showLocation;
        this.drillEnabled = drillEnabled;
        String tableName = null;
        if (lookup != null && lookup.getColumnName() != null) {
            tableName = lookup.getColumnName().substring(0, lookup.getColumnName().indexOf("."));
        }
        if (lookup != null) {
            int winID = lookup.getZoom();
            int winIDPO = lookup.getZoom(false);
            Boolean canAccess = MRole.getDefault().getWindowAccess(winID);
            Boolean canAccessPO = null;
            if (winIDPO > 0) {
                canAccessPO = MRole.getDefault().getWindowAccess(winIDPO);
            }
            if (!(winID > 0 && canAccess != null || canAccessPO != null && canAccessPO.booleanValue())) {
                this.zoomEnabled = false;
                this.newEnabled = false;
                this.updateEnabled = false;
                MTable table2 = MTable.get((Properties)Env.getCtx(), (String)tableName);
                MZoomCondition[] mZoomConditionArray = MZoomCondition.getConditions((int)table2.getAD_Table_ID());
                int n = mZoomConditionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MZoomCondition zoomCondition = mZoomConditionArray[n2];
                    Boolean canAccessZoom = MRole.getDefault().getWindowAccess(zoomCondition.getAD_Window_ID());
                    if (canAccessZoom != null && canAccessZoom.booleanValue()) {
                        this.zoomEnabled = true;
                        if (this.hasQuickEntryField(zoomCondition.getAD_Window_ID(), 0, tableName)) {
                            this.newEnabled = !MToolBarButtonRestrict.isNewButtonRestricted((int)zoomCondition.getAD_Window_ID());
                            this.updateEnabled = true;
                        }
                        break;
                    }
                    ++n2;
                }
            } else if (this.hasQuickEntryField(winID, winIDPO, tableName)) {
                this.newEnabled = !MToolBarButtonRestrict.isNewButtonRestricted((int)winID) || winIDPO > 0 && winIDPO != winID && !MToolBarButtonRestrict.isNewButtonRestricted((int)winIDPO);
                this.updateEnabled = true;
            } else {
                this.newEnabled = false;
                this.updateEnabled = false;
            }
        }
        this.init();
    }

    protected boolean hasQuickEntryField(int winID, int winIDPO, String tableName) {
        return DB.getSQLValueEx(null, (String)"SELECT COUNT(*) FROM   AD_Field f        JOIN AD_Tab t          ON ( t.AD_Tab_ID = f.AD_Tab_ID ) WHERE  t.AD_Window_ID IN (?,?)        AND f.IsActive = 'Y'        AND t.IsActive = 'Y'        AND f.IsQuickEntry = 'Y'        AND (t.TabLevel = 0           AND   t.AD_Table_ID IN (SELECT AD_Table_ID FROM AD_Table WHERE TableName = ? )) ", (Object[])new Object[]{winID, winIDPO, tableName}) > 0;
    }

    public boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    private void init() {
        if (this.zoomEnabled) {
            this.zoomItem = new Menuitem();
            this.zoomItem.setAttribute(EVENT_ATTRIBUTE, (Object)ZOOM_EVENT);
            this.zoomItem.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Zoom")).intern());
            if (ThemeManager.isUseFontIconForImage()) {
                this.zoomItem.setIconSclass("z-icon-Zoom");
            } else {
                this.zoomItem.setImage(ThemeManager.getThemeResource("images/Zoom16.png"));
            }
            this.zoomItem.addEventListener("onClick", (EventListener)this);
            this.appendChild((Component)this.zoomItem);
        }
        if (this.requeryEnabled) {
            this.requeryItem = new Menuitem();
            this.requeryItem.setAttribute(EVENT_ATTRIBUTE, (Object)REQUERY_EVENT);
            this.requeryItem.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh")).intern());
            if (ThemeManager.isUseFontIconForImage()) {
                this.requeryItem.setIconSclass("z-icon-Refresh");
            } else {
                this.requeryItem.setImage(ThemeManager.getThemeResource("images/Refresh16.png"));
            }
            this.requeryItem.addEventListener("onClick", (EventListener)this);
            this.appendChild((Component)this.requeryItem);
        }
        if (this.preferencesEnabled) {
            this.prefItem = new Menuitem();
            this.prefItem.setAttribute(EVENT_ATTRIBUTE, (Object)PREFERENCE_EVENT);
            this.prefItem.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"ValuePreference")).intern());
            if (ThemeManager.isUseFontIconForImage()) {
                this.prefItem.setIconSclass("z-icon-VPreference");
            } else {
                this.prefItem.setImage(ThemeManager.getThemeResource("images/VPreference16.png"));
            }
            this.prefItem.addEventListener("onClick", (EventListener)this);
            this.appendChild((Component)this.prefItem);
        }
        if (this.newEnabled) {
            this.newItem = new Menuitem();
            this.newItem.setAttribute(EVENT_ATTRIBUTE, (Object)NEW_EVENT);
            this.newItem.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"New")).intern());
            if (ThemeManager.isUseFontIconForImage()) {
                this.newItem.setIconSclass("z-icon-New");
            } else {
                this.newItem.setImage(ThemeManager.getThemeResource("images/New16.png"));
            }
            this.newItem.addEventListener("onClick", (EventListener)this);
            this.appendChild((Component)this.newItem);
        }
        if (this.updateEnabled) {
            this.updateItem = new Menuitem();
            this.updateItem.setAttribute(EVENT_ATTRIBUTE, (Object)UPDATE_EVENT);
            this.updateItem.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Update")).intern());
            if (ThemeManager.isUseFontIconForImage()) {
                this.updateItem.setIconSclass("z-icon-InfoBPartner");
            } else {
                this.updateItem.setImage(ThemeManager.getThemeResource("images/InfoBPartner16.png"));
            }
            this.updateItem.addEventListener("onClick", (EventListener)this);
            this.appendChild((Component)this.updateItem);
        }
        if (this.showLocation) {
            this.showLocationItem = new Menuitem();
            this.showLocationItem.setAttribute(EVENT_ATTRIBUTE, (Object)SHOWLOCATION_EVENT);
            this.showLocationItem.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"ShowLocation")).intern());
            if (ThemeManager.isUseFontIconForImage()) {
                this.showLocationItem.setIconSclass("z-icon-InfoBPartner");
            } else {
                this.showLocationItem.setImage(ThemeManager.getThemeResource("images/InfoBPartner16.png"));
            }
            this.showLocationItem.addEventListener("onClick", (EventListener)this);
            this.appendChild((Component)this.showLocationItem);
        }
        if (this.drillEnabled) {
            this.drillItem = new Menuitem();
            this.drillItem.setAttribute(EVENT_ATTRIBUTE, (Object)DRILL_EVENT);
            this.drillItem.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"DrillAssistant")).intern());
            if (ThemeManager.isUseFontIconForImage()) {
                this.drillItem.setIconSclass("z-icon-Window");
            } else {
                this.drillItem.setImage(ThemeManager.getThemeResource("images/mWindow.png"));
            }
            this.drillItem.addEventListener("onClick", (EventListener)this);
            this.appendChild((Component)this.drillItem);
        }
    }

    public void addMenuListener(ContextMenuListener listener) {
        if (!this.menuListeners.contains(listener)) {
            this.menuListeners.add(listener);
        }
    }

    public void onEvent(Event event) {
        String evt = (String)event.getTarget().getAttribute(EVENT_ATTRIBUTE);
        if (evt != null) {
            ContextMenuEvent menuEvent = new ContextMenuEvent(evt);
            menuEvent.setTarget(event.getTarget());
            ContextMenuListener[] listeners = new ContextMenuListener[]{};
            ContextMenuListener[] contextMenuListenerArray = listeners = this.menuListeners.toArray(listeners);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ContextMenuListener listener = contextMenuListenerArray[n2];
                listener.onMenu(menuEvent);
                ++n2;
            }
        }
    }

    public void addSuggestion(final GridField field) {
        if (!MRole.getDefault().isTableAccessExcluded(200209)) {
            Menuitem editor = new Menuitem(Msg.getElement((Properties)Env.getCtx(), (String)"AD_FieldSuggestion_ID"));
            if (ThemeManager.isUseFontIconForImage()) {
                editor.setIconSclass("z-icon-FieldSuggestion");
            } else {
                editor.setImage(ThemeManager.getThemeResource("images/FieldSuggestion16.png"));
            }
            editor.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    WFieldSuggestion fieldSuggestion = new WFieldSuggestion(field.getAD_Field_ID());
                    fieldSuggestion.setPage(WEditorPopupMenu.this.getPage());
                    fieldSuggestion.doHighlighted();
                }
            });
            this.appendChild((Component)editor);
        }
    }

    public void showDrillAssistant(boolean show) {
        if (this.drillItem != null) {
            this.drillItem.setVisible(show);
        }
    }

    public void removeNewUpdateMenu() {
        if (this.newItem != null) {
            this.removeChild((Component)this.newItem);
        }
        if (this.updateItem != null) {
            this.removeChild((Component)this.updateItem);
        }
    }
}

