/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.awt.Color;
import org.compiere.util.Util;
import org.zkoss.zk.ui.HtmlBasedComponent;

public final class ZkCssHelper {
    public static final String STYLE_TEXT_ALIGN_LEFT = "text-align:left";
    public static final String STYLE_TEXT_ALIGN_RIGHT = "text-align:right";
    public static final String STYLE_TEXT_ALIGN_CENTER = "text-align:center";
    public static final String STYLE_COLOR = "color:#";
    public static final String STYLE_BACKGROUND_COLOR = "background-color:#";

    private ZkCssHelper() {
    }

    public static String createHexColorString(Color color) {
        String colorString = String.format("%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
        return colorString;
    }

    public static void appendStyle(HtmlBasedComponent component, String style) {
        if (component.getStyle() != null) {
            String oldStyle = component.getStyle().trim();
            if (!oldStyle.endsWith(";")) {
                component.setStyle(oldStyle + ";" + style);
            } else {
                component.setStyle(oldStyle + style);
            }
        } else {
            component.setStyle(style);
        }
    }

    public static void appendStyleColor(HtmlBasedComponent component, Color color) {
        String colorString = ZkCssHelper.createHexColorString(color);
        String colorStyleString = STYLE_COLOR + colorString;
        ZkCssHelper.appendStyle(component, colorStyleString);
    }

    public static void setStyleColor(HtmlBasedComponent component, Color color) {
        String colorString = ZkCssHelper.createHexColorString(color);
        String colorStyleString = STYLE_COLOR + colorString;
        component.setStyle(colorStyleString);
    }

    public static void appendStyleBackgroundColor(HtmlBasedComponent component, Color color) {
        String colorString = ZkCssHelper.createHexColorString(color);
        String colorStyleString = STYLE_BACKGROUND_COLOR + colorString;
        ZkCssHelper.appendStyle(component, colorStyleString);
    }

    public static void setStyleBackgroundColor(HtmlBasedComponent component, Color color) {
        String colorString = ZkCssHelper.createHexColorString(color);
        String colorStyleString = STYLE_BACKGROUND_COLOR + colorString;
        component.setStyle(colorStyleString);
    }

    public static void removeStyle(HtmlBasedComponent component, String styleName) {
        String style;
        int index;
        if (component.getStyle() != null && (index = (style = component.getStyle()).indexOf(styleName + ":")) >= 0) {
            int end = style.indexOf(";", index);
            if (Util.isEmpty((String)(style = end > index ? style.replace(style.substring(index, end + 1), "") : style.replace(style.substring(index, style.length()), "")), (boolean)true)) {
                component.setStyle(null);
            } else {
                component.setStyle(style);
            }
        }
    }
}

