/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.ArrayList;
import java.util.List;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Span;

public class ListitemGroup
extends Listgroup {
    private static final long serialVersionUID = -1790997329703776505L;
    public static final String GROUP_LISTITEM_VISIBLE_KEY = "groupListitemVisible";
    private List<Listitem> m_items = new ArrayList<Listitem>();

    public ListitemGroup() {
    }

    public ListitemGroup(String label) {
        super(label);
    }

    public <T> ListitemGroup(String label, T value) {
        super(label, value);
    }

    public String getLabel() {
        Component cell = this.getFirstChild();
        return cell != null && cell instanceof ListitemGroupHeader ? ((ListitemGroupHeader)cell).getTitle() : null;
    }

    public void setLabel(String label) {
        this.getOrCreateGroupHeader().setTitle(label);
    }

    public void setColspan(int colspan) {
        this.getOrCreateGroupHeader().setSpan(colspan);
    }

    private ListitemGroupHeader getOrCreateGroupHeader() {
        Object cell;
        Component component = cell = this.getChildren().size() == 0 || this.getChildren().size() == 1 ? this.getFirstChild() : this.getFirstChild().getNextSibling();
        if (cell == null || cell instanceof ListitemGroupHeader) {
            if (cell == null) {
                cell = new ListitemGroupHeader();
            }
            cell.applyProperties();
            cell.setParent((Component)this);
            return (ListitemGroupHeader)((Object)cell);
        }
        throw new UiException("Unsupported child for setLabel: " + String.valueOf(cell));
    }

    public void setOpen(boolean open) {
        super.setOpen(open);
        this.getOrCreateGroupHeader().setOpen(this.isOpen());
        if (this.getParent() != null) {
            for (Listitem item : this.m_items) {
                boolean visible = true;
                String value = (String)item.getAttribute(GROUP_LISTITEM_VISIBLE_KEY);
                if (value != null) {
                    visible = value.equals("true");
                }
                item.setVisible(this.isOpen() && visible);
            }
        }
    }

    public void add(Listitem item) {
        this.m_items.add(item);
    }

    public static class ListitemGroupHeader
    extends Listcell
    implements EventListener<Event> {
        private static final long serialVersionUID = -4070011056533999557L;
        private Span span;
        private Label lbl;
        private String title;
        private boolean open;

        public ListitemGroupHeader() {
            this.init();
            this.setTitle(null);
            this.setOpen(true);
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this, "1");
        }

        private void init() {
            this.setZclass("z-listgroup-header");
            this.span = new Span();
            this.span.setZclass("z-listgroup-icon");
            this.appendChild((Component)this.span);
            this.span.addEventListener("onClick", (EventListener)this);
            this.lbl = new Label();
            this.lbl.setStyle("cursor: pointer");
            this.appendChild((Component)this.lbl);
            this.lbl.addEventListener("onClick", (EventListener)this);
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
            this.lbl.setValue(this.title);
        }

        public boolean isOpen() {
            return this.open;
        }

        public void setOpen(boolean open) {
            this.open = open;
            this.span.setSclass(this.open ? "z-icon-listgroup-open" : "z-icon-listgroup-close");
        }

        public void onEvent(Event e) throws Exception {
            if (e.getName().equals("onClick")) {
                ((ListitemGroup)this.getParent()).setOpen(!this.isOpen());
            }
        }
    }
}

