/*
 * Decompiled with CFR 0.152.
 */
package com.sfcommerce.jpaymentcomponent.ssl;

import com.sfcommerce.jpaymentcomponent.exceptions.HostUnknownException;
import com.sfcommerce.jpaymentcomponent.exceptions.SocketCreationFailedException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;

public class SSLServerConnection {
    private static final int POLL_DELAY = 100;
    private SocketFactory myFactory = null;

    public SSLServerConnection(SocketFactory aFactory) {
        this.myFactory = aFactory;
    }

    public SSLSocket connect(InetAddress anAddr, int aPort, int aTimeout) throws SocketCreationFailedException, HostUnknownException, InterruptedIOException {
        SSLSocket sslSock;
        block10: {
            Connection con = new Connection(anAddr, aPort, this.myFactory);
            con.start();
            int timer = 0;
            sslSock = null;
            do {
                if (con.isConnected()) {
                    sslSock = con.getSocket();
                    break block10;
                }
                if (con.isError()) {
                    if (con.getException().getClass().getName().equals("java.net.UnknownHostException")) {
                        throw new HostUnknownException("  ERROR(73) Server name you specified is unknown.");
                    }
                    if (con.getException().getClass().getName().equals("java.net.ConnectException")) {
                        throw new HostUnknownException("  ERROR(115) Connection refused by server. Check your PaymentServerPort.");
                    }
                    if (con.getException().getClass().getName().equals("java.net.SocketException")) {
                        throw new SocketCreationFailedException("  ERROR(120) Connection refused by Server. Check the location of your TrustManager keystore");
                    }
                    throw new SocketCreationFailedException("  ERROR(74) Socket creation failed, please try later.");
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while ((timer += 100) < aTimeout);
            if (con.isConnected()) {
                sslSock = con.getSocket();
            } else {
                throw new InterruptedIOException();
            }
        }
        return sslSock;
    }

    public SSLSocket connect(String aHost, int aPort, int aTimeout) throws HostUnknownException, SocketCreationFailedException, InterruptedIOException {
        InetAddress inetAddr = null;
        try {
            inetAddr = InetAddress.getByName(aHost);
        }
        catch (UnknownHostException ee) {
            throw new HostUnknownException("  ERROR(73) Server name you specified is unknown.");
        }
        return this.connect(inetAddr, aPort, aTimeout);
    }

    private class Connection
    extends Thread {
        private SSLSocket myConnection = null;
        private String myHost = null;
        private InetAddress myInet = null;
        private int myPort = 0;
        private Exception myException = null;
        private SocketFactory myFactory = null;

        public Connection(String aHost, int aPort, SocketFactory aFactory) {
            this.myHost = aHost;
            this.myPort = aPort;
            this.myFactory = aFactory;
        }

        public Connection(InetAddress aInetAddr, int aPort, SocketFactory aFactory) {
            this.myInet = aInetAddr;
            this.myPort = aPort;
            this.myFactory = aFactory;
        }

        public void run() {
            SSLSocket sslSock = null;
            try {
                sslSock = this.myHost != null ? (SSLSocket)this.myFactory.createSocket(this.myHost, this.myPort) : (SSLSocket)this.myFactory.createSocket(this.myInet, this.myPort);
            }
            catch (UnknownHostException uknHost) {
                this.myException = uknHost;
                return;
            }
            catch (IOException ioe) {
                this.myException = ioe;
                return;
            }
            this.myConnection = sslSock;
        }

        public boolean isConnected() {
            return this.myConnection != null;
        }

        public boolean isError() {
            return this.myException != null;
        }

        public SSLSocket getSocket() {
            return this.myConnection;
        }

        public Exception getException() {
            return this.myException;
        }
    }
}

