/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.qr;

import org.krysalis.barcode4j.impl.qr.QRConstants;

public class QRHighLevelEncoder
implements QRConstants {
    private int encodingMode;

    public QRHighLevelEncoder(String msg) {
        this.encodingMode = this.analyzeMessage(msg);
    }

    public int getEncodingMode() {
        return this.encodingMode;
    }

    private int analyzeMessage(String msg) {
        int mode = 0;
        int i2 = 0;
        int c = msg.length();
        while (i2 < c) {
            char ch = msg.charAt(i2);
            if (!QRHighLevelEncoder.isDigit(ch)) {
                if (mode == 0 && QRHighLevelEncoder.isAlphanumeric(ch)) {
                    mode = 1;
                } else {
                    mode = 2;
                    break;
                }
            }
            ++i2;
        }
        return mode;
    }

    private static final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static final boolean isAlphanumeric(char ch) {
        return ALPHANUMERIC_TABLE[ch] >= 0;
    }
}

