/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.print.renderer;

import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import org.adempiere.base.Core;
import org.adempiere.exceptions.AdempiereException;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.MultiPartElement;
import org.apache.ecs.XhtmlDocument;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.style;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.tbody;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.thead;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.AttachmentData;
import org.compiere.model.MAttachment;
import org.compiere.model.MColumn;
import org.compiere.model.MImage;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MStyle;
import org.compiere.model.MStyleLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.MPrintColor;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.MPrintTableFormat;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.print.layout.InstanceAttributeColumn;
import org.compiere.print.layout.InstanceAttributeData;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.print.layout.PrintDataEvaluatee;
import org.compiere.util.CLogger;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluator;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.print.renderer.HTMLReportRendererConfiguration;
import org.idempiere.print.renderer.IReportRenderer;
import org.osgi.service.component.annotations.Component;

@Component(service={IReportRenderer.class}, immediate=true)
public class HTMLReportRenderer
implements IReportRenderer<HTMLReportRendererConfiguration> {
    private static final CLogger log = CLogger.getCLogger(HTMLReportRenderer.class);

    @Override
    public String getId() {
        return "HTML";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FileHTML");
    }

    @Override
    public String getContentType() {
        return MediaType.HTML_UTF_8.toString();
    }

    @Override
    public String getFileExtension() {
        return "html";
    }

    @Override
    public void renderReport(ReportEngine reportEngine, HTMLReportRendererConfiguration configuration) {
        try {
            Language lang = configuration.getLanguage();
            if (lang == null) {
                lang = Language.getLoginLanguage();
            }
            Writer fw = null;
            fw = configuration.getOutputFile() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.getOutputFile(), false), Ini.getCharset()) : configuration.getOutputWriter();
            this.createHTML(reportEngine, new BufferedWriter(fw), configuration.isOnlyTable(), lang, configuration.getExtension(), configuration.isExport(), configuration.getContextPath());
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
            throw new AdempiereException(e);
        }
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void createHTML(ReportEngine reportEngine, Writer writer, boolean onlyTable, Language language, IHTMLExtension extension, boolean isExport, String contextPath) {
        MPrintFormat printFormat = reportEngine.getPrintFormat();
        PrintData printData = reportEngine.getPrintData();
        MQuery reportEngineQuery = reportEngine.getQuery();
        LayoutEngine layout = reportEngine.getLayout();
        HashMap<CSSInfo, List<ColumnInfo>> mapCssInfo = new HashMap<CSSInfo, List<ColumnInfo>>();
        try {
            String cssPrefix;
            ArrayList<Object> columns = new ArrayList<Object>();
            ArrayList<Object> asiElements = new ArrayList<Object>();
            int columnCount = 0;
            int col = 0;
            while (col < printFormat.getItemCount()) {
                MPrintFormatItem mPrintFormatItem = printFormat.getItem(col);
                if (mPrintFormatItem.isPrinted()) {
                    if (mPrintFormatItem.isTypeField() && mPrintFormatItem.isPrintInstanceAttributes()) {
                        InstanceAttributeData asiElement = new InstanceAttributeData(mPrintFormatItem, columnCount);
                        asiElement.readAttributesData(printData);
                        asiElements.add(asiElement);
                    } else {
                        columns.add(mPrintFormatItem);
                        ++columnCount;
                    }
                }
                ++col;
            }
            if (asiElements.size() > 0) {
                int columnCreated = 0;
                for (InstanceAttributeData instanceAttributeData : asiElements) {
                    List<InstanceAttributeColumn> instanceColumns = instanceAttributeData.getColumns();
                    int index = instanceAttributeData.getColumnIndex() + columnCreated;
                    for (InstanceAttributeColumn c : instanceColumns) {
                        columns.add(index, c);
                        ++index;
                        ++columnCreated;
                    }
                }
            }
            String string = cssPrefix = extension != null ? extension.getClassPrefix() : null;
            if (cssPrefix != null && cssPrefix.trim().length() == 0) {
                cssPrefix = null;
            }
            Object var17_22 = null;
            if (!printFormat.isForm() && reportEngineQuery != null && reportEngineQuery.isActive()) {
                int rows;
                int n = rows = reportEngineQuery.getReportProcessQuery() != null ? reportEngineQuery.getReportProcessQuery().getRestrictionCount() : reportEngineQuery.getRestrictionCount();
                if (rows > 0) {
                    table table2 = new table();
                    if (cssPrefix != null) {
                        table2.setClass(cssPrefix + "-parameter-table");
                    } else {
                        table2.setClass("parameter-table");
                    }
                    table2.setNeedClosingTag(false);
                }
            }
            table table2 = new table();
            if (cssPrefix != null) {
                table2.setClass(cssPrefix + "-table");
            }
            table2.setNeedClosingTag(false);
            PrintWriter w = new PrintWriter(writer);
            XhtmlDocument doc = null;
            boolean minify = MSysConfig.getBooleanValue("HTML_REPORT_MINIFY", true, Env.getAD_Client_ID(Env.getCtx()));
            if (onlyTable) {
                w.print(HTMLReportRenderer.compress(table2.toString(), minify));
            } else {
                doc = new XhtmlDocument();
                doc.getHtml().setNeedClosingTag(false);
                doc.getBody().setNeedClosingTag(false);
                doc.appendHead("<meta charset=\"UTF-8\" />");
                if (extension != null && !Util.isEmpty(extension.getWebFontLinks(), true)) {
                    doc.appendHead(extension.getWebFontLinks());
                }
                if (extension != null && extension.getStyleURL() != null) {
                    String pathStyleFile = extension.getFullPathStyle();
                    Path path = Paths.get(pathStyleFile, new String[0]);
                    List<String> styleLines = Files.readAllLines(path, Ini.getCharset());
                    Files.delete(path);
                    StringBuilder styleBuild = new StringBuilder();
                    for (String styleLine : styleLines) {
                        styleBuild.append(styleLine);
                    }
                    HTMLReportRenderer.appendInlineCss(doc, styleBuild);
                }
                if (extension != null && extension.getScriptURL() != null && !isExport) {
                    script jslink = new script();
                    jslink.setLanguage("javascript");
                    jslink.setSrc(extension.getScriptURL());
                    doc.appendHead((Element)jslink);
                }
                if (extension != null && !isExport) {
                    extension.setWebAttribute(doc.getBody());
                }
            }
            if (doc != null) {
                void var17_24;
                MPrintFormatItem item = null;
                int printColIndex = -1;
                int col2 = 0;
                while (col2 < columns.size()) {
                    Object colobj = columns.get(col2);
                    if (colobj instanceof MPrintFormatItem) {
                        item = (MPrintFormatItem)colobj;
                    } else if (colobj instanceof InstanceAttributeColumn) {
                        item = ((InstanceAttributeColumn)colobj).getPrintFormatItem();
                    }
                    if (!(item == null || item.isNextLine() && item.getBelowColumn() >= 1)) {
                        HTMLReportRenderer.addCssInfo(printFormat, item, ++printColIndex, mapCssInfo);
                    }
                    ++col2;
                }
                HTMLReportRenderer.appendInlineCss(doc, mapCssInfo);
                StringBuilder styleBuild = new StringBuilder();
                MPrintTableFormat tf = printFormat.getTableFormat();
                CSSInfo cssInfo = new CSSInfo(tf.getPageHeader_Font(), tf.getPageHeaderFG_Color());
                if (cssPrefix != null) {
                    if (var17_24 != null) {
                        styleBuild.append("." + cssPrefix + "-parameter-table th").append(cssInfo.getCssRule());
                    }
                    styleBuild.append("." + cssPrefix + "-table th").append(cssInfo.getCssRule());
                } else {
                    if (var17_24 != null) {
                        styleBuild.append("parameter-table th").append(cssInfo.getCssRule());
                    }
                    styleBuild.append("table th").append(cssInfo.getCssRule());
                }
                cssInfo = new CSSInfo(tf.getParameter_Font(), tf.getParameter_Color());
                styleBuild.append(".tr-parameter td").append(cssInfo.getCssRule());
                cssInfo = new CSSInfo(tf.getFunct_Font(), tf.getFunctFG_Color());
                styleBuild.append(".tr-function td").append(cssInfo.getCssRule());
                MPrintFont printFont = MPrintFont.get(printFormat.getAD_PrintFont_ID());
                Font base = printFont.getFont();
                Font newFont = new Font(base.getName(), 0, base.getSize() - 1);
                cssInfo = new CSSInfo(newFont, null);
                styleBuild.append(".tr-level-1 td").append(cssInfo.getCssRule());
                newFont = new Font(base.getName(), 0, base.getSize() - 2);
                cssInfo = new CSSInfo(newFont, null);
                styleBuild.append(".tr-level-2 td").append(cssInfo.getCssRule());
                styleBuild = new StringBuilder(styleBuild.toString().replace(";", "!important;"));
                HTMLReportRenderer.appendInlineCss(doc, styleBuild);
                w.print(HTMLReportRenderer.compress(doc.toString(), minify));
                w.print("<div class='" + cssPrefix + "-flex-container'>");
                String paraWrapId = null;
                if (var17_24 != null) {
                    void var33_52;
                    paraWrapId = cssPrefix + "-para-table-wrap";
                    w.print("<details id='" + paraWrapId + "' open=true style='cursor:pointer'>");
                    w.print("<summary style='cursor:pointer'>" + Msg.getMsg(Env.getCtx(), "Parameter") + "</summary>");
                    w.print(HTMLReportRenderer.compress(var17_24.toString(), minify));
                    tr tr2 = new tr();
                    tr2.setClass("tr-parameter");
                    MQuery query = reportEngineQuery;
                    if (reportEngineQuery.getReportProcessQuery() != null) {
                        query = reportEngineQuery.getReportProcessQuery();
                    }
                    boolean bl = false;
                    while (var33_52 < query.getRestrictionCount()) {
                        if (var33_52 > 0) {
                            tr2 = new tr();
                            tr2.setClass("tr-parameter");
                        }
                        td td2 = new td();
                        tr2.addElement((Element)td2);
                        td2.addElement(query.getInfoName((int)var33_52));
                        td2 = new td();
                        tr2.addElement((Element)td2);
                        td2.addElement(query.getInfoOperator((int)var33_52));
                        td2 = new td();
                        tr2.addElement((Element)td2);
                        td2.addElement(query.getInfoDisplayAll((int)var33_52));
                        w.print(HTMLReportRenderer.compress(tr2.toString(), minify));
                        ++var33_52;
                    }
                    w.print("</table>");
                    w.print("</details>");
                }
                StringBuilder tableWrapDiv = new StringBuilder();
                tableWrapDiv.append("<div class='").append(cssPrefix).append("-table-wrap' ");
                if (paraWrapId != null) {
                    String paraWrapGet = "document.getElementById(\"" + paraWrapId + "\")";
                    tableWrapDiv.append("onscroll='setTimeout(() => {if (this.scrollTop > 0) ").append(" if(").append(paraWrapGet).append(".open) ").append(paraWrapGet).append(".open=false;}, 100)'");
                }
                tableWrapDiv.append(" >");
                w.print(HTMLReportRenderer.compress(tableWrapDiv.toString(), minify));
                w.print(HTMLReportRenderer.compress(table2.toString(), minify));
            }
            thead thead2 = new thead();
            tbody tbody2 = new tbody();
            tbody2.setNeedClosingTag(false);
            Boolean[] colSuppressRepeats = layout == null || layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats(printFormat) : layout.colSuppressRepeats;
            Object[] preValues = null;
            if (colSuppressRepeats != null) {
                preValues = new Object[colSuppressRepeats.length];
            }
            int printColIndex = -1;
            HashMap<Integer, th> suppressMap = new HashMap<Integer, th>();
            TreeSet<Integer> headerColumnSet = new TreeSet<Integer>();
            int col3 = 0;
            while (col3 < columns.size()) {
                Object colObj = columns.get(col3);
                MPrintFormatItem item = null;
                InstanceAttributeColumn instanceAttributeColumn = null;
                if (colObj instanceof MPrintFormatItem) {
                    item = (MPrintFormatItem)colObj;
                } else if (colObj instanceof InstanceAttributeColumn) {
                    instanceAttributeColumn = (InstanceAttributeColumn)colObj;
                    item = instanceAttributeColumn.getPrintFormatItem();
                }
                if (item != null) {
                    if (item.isNextLine() && item.getBelowColumn() >= 1) {
                        headerColumnSet.add(item.getBelowColumn() - 1);
                    } else {
                        headerColumnSet.add(col3);
                    }
                }
                ++col3;
            }
            ArrayList belowColumnMap = new ArrayList();
            int col4 = 0;
            while (col4 < columns.size()) {
                Object colObj = columns.get(col4);
                MPrintFormatItem item = null;
                Object var33_53 = null;
                if (colObj instanceof MPrintFormatItem) {
                    item = (MPrintFormatItem)colObj;
                } else if (colObj instanceof InstanceAttributeColumn) {
                    InstanceAttributeColumn instanceAttributeColumn = (InstanceAttributeColumn)colObj;
                    item = instanceAttributeColumn.getPrintFormatItem();
                }
                if (item != null && item.isNextLine() && item.getBelowColumn() >= 1) {
                    int belowColumn = item.getBelowColumn() - 1;
                    int i = 0;
                    for (Integer headerCol : headerColumnSet) {
                        if (headerCol == belowColumn) {
                            belowColumn = i;
                            break;
                        }
                        ++i;
                    }
                    if (belowColumnMap.isEmpty()) {
                        belowColumnMap.add(new HashMap());
                    }
                    boolean added = false;
                    for (Map map : belowColumnMap) {
                        if (map.containsKey(belowColumn)) continue;
                        map.put(belowColumn, col4);
                        added = true;
                        break;
                    }
                    if (!added) {
                        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
                        hashMap.put(belowColumn, col4);
                        belowColumnMap.add(hashMap);
                    }
                }
                ++col4;
            }
            int row = -1;
            while (row < printData.getRowCount()) {
                void var33_57;
                HashMap<Integer, td> tdMap = new HashMap<Integer, td>();
                tr tr3 = new tr();
                if (row != -1) {
                    printData.setRowIndex(row);
                    if (extension != null && !isExport) {
                        extension.extendRowElement((ConcreteElement)tr3, printData);
                    }
                    if (printData.isFunctionRow()) {
                        tr3.setClass(cssPrefix + "-functionrow");
                    } else if (row < printData.getRowCount() && printData.isFunctionRow(row + 1)) {
                        tr3.setClass(cssPrefix + "-lastgrouprow");
                    }
                } else {
                    thead2.addElement((Element)tr3);
                }
                printColIndex = -1;
                boolean bl = false;
                while (var33_57 < columns.size()) {
                    Object colObj = columns.get((int)var33_57);
                    MPrintFormatItem item = null;
                    InstanceAttributeColumn instanceAttributeColumn = null;
                    if (colObj instanceof MPrintFormatItem) {
                        item = (MPrintFormatItem)colObj;
                    } else if (colObj instanceof InstanceAttributeColumn) {
                        instanceAttributeColumn = (InstanceAttributeColumn)colObj;
                        item = instanceAttributeColumn.getPrintFormatItem();
                    }
                    if (item != null && (!item.isNextLine() || item.getBelowColumn() < 1 || headerColumnSet.contains((int)var33_57))) {
                        ++printColIndex;
                        if (row == -1) {
                            MColumn column;
                            th th2 = new th();
                            tr3.addElement((Element)th2);
                            String columnHeader = instanceAttributeColumn != null ? instanceAttributeColumn.getName() : item.getPrintName(language);
                            th2.addElement(Util.maskHTML(columnHeader));
                            if (cssPrefix != null && instanceAttributeColumn == null && (column = MColumn.get(Env.getCtx(), item.getAD_Column_ID())) != null && column.getAD_Column_ID() > 0 && DisplayType.isNumeric(column.getAD_Reference_ID())) {
                                th2.setClass(cssPrefix + "-number");
                            }
                            if (item.isSuppressNull()) {
                                suppressMap.put(printColIndex, th2);
                                th2.setID("report-th-" + printColIndex);
                            }
                        } else {
                            td td2 = new td();
                            tr3.addElement((Element)td2);
                            tdMap.put(printColIndex, td2);
                            if (!item.isNextLine() || item.getBelowColumn() < 1 || !headerColumnSet.contains((int)var33_57)) {
                                HTMLReportRenderer.printColumn(reportEngine, language, extension, isExport, (MultiPartElement)td2, item, instanceAttributeColumn, row, printData, colSuppressRepeats, printColIndex, preValues, suppressMap, cssPrefix, contextPath);
                            }
                        }
                    }
                    ++var33_57;
                }
                if (row == -1) {
                    w.print(HTMLReportRenderer.compress(thead2.toString(), minify));
                    w.print(HTMLReportRenderer.compress(tbody2.toString(), minify));
                }
                if (!belowColumnMap.isEmpty() && row != -1) {
                    for (Map map : belowColumnMap) {
                        printColIndex = -1;
                        int col6 = 0;
                        while (col6 < columns.size()) {
                            if (!map.containsValue(col6) && map.containsKey(++printColIndex)) {
                                int mapTo = (Integer)map.get(printColIndex);
                                Object e = columns.get(mapTo);
                                MPrintFormatItem item = null;
                                InstanceAttributeColumn instanceAttributeColumn = null;
                                if (e instanceof MPrintFormatItem) {
                                    item = (MPrintFormatItem)e;
                                } else if (e instanceof InstanceAttributeColumn) {
                                    instanceAttributeColumn = (InstanceAttributeColumn)e;
                                    item = instanceAttributeColumn.getPrintFormatItem();
                                }
                                if (item != null) {
                                    PrintDataElement pde;
                                    String value;
                                    Object obj;
                                    Object object = obj = instanceAttributeColumn != null ? instanceAttributeColumn.getPrintDataElement(row) : printData.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID());
                                    if (obj != null && ReportEngine.isDisplayPFItem(printData, item) && obj instanceof PrintDataElement && !Util.isEmpty(value = (pde = (PrintDataElement)obj).getValueDisplay(language), true)) {
                                        td td4 = (td)tdMap.get(printColIndex);
                                        div div2 = new div();
                                        td4.addElement((Element)div2);
                                        HTMLReportRenderer.printColumn(reportEngine, language, extension, isExport, (MultiPartElement)div2, item, instanceAttributeColumn, row, printData, colSuppressRepeats, printColIndex, preValues, suppressMap, cssPrefix, contextPath);
                                        div2.setClass("");
                                    }
                                }
                            }
                            ++col6;
                        }
                    }
                }
                if (row != -1) {
                    w.print(HTMLReportRenderer.compress(tr3.toString(), minify));
                }
                ++row;
            }
            w.print("</tbody>");
            w.print("</table>");
            if (suppressMap.size() > 0) {
                StringBuilder st = new StringBuilder();
                for (th t : suppressMap.values()) {
                    if (st.length() > 0) {
                        st.append(",");
                    }
                    st.append("#").append(t.getAttribute("id"));
                }
                st.append(" {\n\t\tdisplay:none;\n\t}");
                style styleTag = new style();
                styleTag.addElement(st.toString());
                w.print(HTMLReportRenderer.compress(styleTag.toString(), minify));
            }
            if (!onlyTable) {
                w.print("</div>");
                w.print("</div>");
                w.print("</body>");
                w.print("</html>");
            }
            w.flush();
            w.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
            throw new AdempiereException(e);
        }
    }

    private static void printColumn(ReportEngine reportEngine, Language language, IHTMLExtension extension, boolean isExport, MultiPartElement td2, MPrintFormatItem item, InstanceAttributeColumn instanceAttributeColumn, int row, PrintData printData, Boolean[] colSuppressRepeats, int printColIndex, Object[] preValues, HashMap<Integer, th> suppressMap, String cssPrefix, String contextPath) {
        Object obj;
        MStyle style2 = item.getAD_FieldStyle_ID() > 0 ? MStyle.get(Env.getCtx(), item.getAD_FieldStyle_ID()) : null;
        Object object = obj = instanceAttributeColumn != null ? instanceAttributeColumn.getPrintDataElement(row) : printData.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID());
        if (obj == null && ReportEngine.isDisplayPFItem(printData, item) && item.isTypeImage() && !item.isImageField() && !item.isImageIsAttached() && !Util.isEmpty(item.getImageURL(), true)) {
            HTMLReportRenderer.printImageColumn(td2, item, null, isExport, contextPath, printData);
        } else if (obj == null || !ReportEngine.isDisplayPFItem(printData, item)) {
            td2.addElementToRegistry("&nbsp;");
            if (colSuppressRepeats != null && colSuppressRepeats[printColIndex].booleanValue()) {
                preValues[printColIndex] = null;
            }
            if (item.isSuppressNull() && obj != null && suppressMap.containsKey(printColIndex)) {
                suppressMap.remove(printColIndex);
            }
        } else if (obj instanceof PrintDataElement) {
            PrintDataElement pde = (PrintDataElement)obj;
            String value = pde.getValueDisplay(language);
            if (colSuppressRepeats != null && colSuppressRepeats[printColIndex].booleanValue()) {
                if (value.equals(preValues[printColIndex])) {
                    td2.addElementToRegistry("&nbsp;");
                    return;
                }
                preValues[printColIndex] = value;
            }
            if (item.isSuppressNull() && obj != null && suppressMap.containsKey(printColIndex)) {
                suppressMap.remove(printColIndex);
            }
            if (item.isTypeImage()) {
                HTMLReportRenderer.printImageColumn(td2, item, pde, isExport, contextPath, printData);
            } else if (pde.getColumnName().endsWith("_ID") && extension != null && !isExport) {
                boolean isZoom = false;
                if (item.getColumnName().equals("Record_ID")) {
                    Object tablePDE = printData.getNode("AD_Table_ID");
                    if (tablePDE != null && tablePDE instanceof PrintDataElement) {
                        int tableID = -1;
                        try {
                            tableID = Integer.parseInt(((PrintDataElement)tablePDE).getValueAsString());
                        }
                        catch (Exception exception) {
                            tableID = -1;
                        }
                        if (tableID > 0) {
                            MTable mTable = MTable.get(Env.getCtx(), tableID);
                            String tableName = mTable.getTableName();
                            value = reportEngine.getIdentifier(mTable, tableName, Integer.parseInt(value));
                            String foreignColumnName = tableName + "_ID";
                            pde.setForeignColumnName(foreignColumnName);
                            isZoom = true;
                        }
                    }
                } else {
                    isZoom = true;
                }
                if (isZoom) {
                    MTable mTable = MTable.get(Env.getCtx(), pde.getForeignColumnName().substring(0, pde.getForeignColumnName().length() - 3));
                    int Record_ID = -1;
                    try {
                        Record_ID = Integer.parseInt(pde.getValueAsString());
                    }
                    catch (Exception exception) {
                        Record_ID = -1;
                    }
                    Boolean canAccess = null;
                    if (Record_ID >= 0 && mTable != null) {
                        int AD_Window_ID = Env.getZoomWindowID(mTable.get_ID(), Record_ID);
                        canAccess = MRole.getDefault().getWindowAccess(AD_Window_ID);
                    }
                    if (canAccess == null) {
                        isZoom = false;
                    }
                }
                if (isZoom) {
                    a href = new a("javascript:void(0)");
                    href.setID(pde.getColumnName() + "_" + row + "_a");
                    td2.addElementToRegistry((Element)href);
                    href.addElement(Util.maskHTML(value));
                    if (cssPrefix != null) {
                        href.setClass(cssPrefix + "-href");
                    }
                    if (style2 != null && style2.isWrapWithSpan()) {
                        HTMLReportRenderer.setStyle(printData, (MultiPartElement)href, style2);
                    } else {
                        HTMLReportRenderer.setStyle(printData, td2, style2);
                    }
                    extension.extendIDColumn(row, (ConcreteElement)td2, href, pde);
                } else if (style2 != null && style2.isWrapWithSpan()) {
                    span span2 = new span();
                    HTMLReportRenderer.setStyle(printData, (MultiPartElement)span2, style2);
                    span2.addElement(Util.maskHTML(value));
                    td2.addElementToRegistry((Element)span2);
                } else {
                    HTMLReportRenderer.setStyle(printData, td2, style2);
                    td2.addElementToRegistry(Util.maskHTML(value));
                }
            } else if (style2 != null && style2.isWrapWithSpan()) {
                span span3 = new span();
                HTMLReportRenderer.setStyle(printData, (MultiPartElement)span3, style2);
                span3.addElement(Util.maskHTML(value));
                td2.addElementToRegistry((Element)span3);
            } else {
                HTMLReportRenderer.setStyle(printData, td2, style2);
                td2.addElementToRegistry(Util.maskHTML(value));
            }
            if (cssPrefix != null) {
                if (item.isTypeImage()) {
                    td2.setClass(cssPrefix + "-image");
                } else if (DisplayType.isNumeric(pde.getDisplayType())) {
                    td2.setClass(cssPrefix + "-number");
                } else if (DisplayType.isDate(pde.getDisplayType())) {
                    td2.setClass(cssPrefix + "-date");
                } else {
                    td2.setClass(cssPrefix + "-text");
                }
            }
        } else if (!(obj instanceof PrintData)) {
            log.log(Level.SEVERE, "Element not PrintData(Element) " + String.valueOf(obj.getClass()));
        }
    }

    private static void printImageColumn(MultiPartElement td2, MPrintFormatItem item, PrintDataElement pde, boolean isExport, String contextPath, PrintData printData) {
        if (item.isImageField()) {
            Object data = pde.getValue();
            if (data != null) {
                if (pde.getDisplayType() == 32) {
                    if (data instanceof Number) {
                        Number number = (Number)data;
                        int id = number.intValue();
                        MImage image = MImage.get(id);
                        byte[] imageData = image.getBinaryData();
                        HTMLReportRenderer.createDataURLImageElement(td2, imageData, item);
                    }
                } else {
                    String url = data.toString();
                    if (MAttachment.isAttachmentURLPath(url)) {
                        HTMLReportRenderer.createImageElementFromAttachmentPath(td2, item, url, isExport, contextPath, printData);
                    } else if (url.indexOf("://") == -1) {
                        ClassLoader cl = HTMLReportRenderer.class.getClassLoader();
                        URL resource = cl.getResource(url);
                        if (resource != null) {
                            HTMLReportRenderer.createDataURLImageElement(td2, resource, item);
                        }
                        if ((resource = Core.getResourceFinder().getResource(url)) != null) {
                            HTMLReportRenderer.createDataURLImageElement(td2, resource, item);
                        }
                    } else {
                        img image = new img(url);
                        td2.addElementToRegistry((Element)image);
                        HTMLReportRenderer.applyHeightAndWidth(item, image);
                    }
                }
            }
        } else if (item.isImageIsAttached()) {
            MAttachment attachment = MAttachment.get(Env.getCtx(), 489, item.get_ID(), null, null);
            if (attachment != null) {
                if (attachment.getEntryCount() != 1) {
                    log.log(Level.WARNING, "Need just 1 Attachment Entry = " + attachment.getEntryCount());
                    return;
                }
                byte[] imageData = attachment.getEntryData(0);
                HTMLReportRenderer.createDataURLImageElement(td2, imageData, item);
            }
        } else if (!Util.isEmpty(item.getImageURL(), true)) {
            String url = item.getImageURL();
            if (MAttachment.isAttachmentURLPath(url)) {
                HTMLReportRenderer.createImageElementFromAttachmentPath(td2, item, url, isExport, contextPath, printData);
            } else {
                img image = new img(item.getImageURL());
                td2.addElementToRegistry((Element)image);
                HTMLReportRenderer.applyHeightAndWidth(item, image);
            }
        }
    }

    private static void createImageElementFromAttachmentPath(MultiPartElement td2, MPrintFormatItem item, String path, boolean isExport, String contextPath, PrintData printData) {
        AttachmentData imageData;
        if (path.indexOf("@") >= 0) {
            PrintDataEvaluatee.PrintDataDataProvider dp = new PrintDataEvaluatee.PrintDataDataProvider(null, printData);
            DefaultEvaluatee evaluatee = new DefaultEvaluatee(dp);
            path = Env.parseVariable(path, evaluatee, true, false);
        }
        if ((imageData = MAttachment.getDataFromAttachmentURLPath(path)) != null && imageData.data() != null && imageData.data().length > 0) {
            if (isExport) {
                HTMLReportRenderer.createDataURLImageElement(td2, imageData.data(), item);
            } else {
                String url = MAttachment.getImageAttachmentURLFromPath(contextPath, path);
                if (url != null) {
                    img image = new img(url);
                    td2.addElementToRegistry((Element)image);
                    HTMLReportRenderer.applyHeightAndWidth(item, image);
                }
            }
        } else {
            span sp = new span();
            sp.setClass("no-image");
            td2.addElementToRegistry((Element)sp);
            HTMLReportRenderer.applyHeightAndWidth(item, sp);
        }
    }

    private static void applyHeightAndWidth(MPrintFormatItem item, span sp) {
        StringBuilder style2 = new StringBuilder();
        if (item.getMaxHeight() > 0) {
            style2.append("height:").append(item.getMaxHeight()).append("px;");
        }
        if (item.getMaxWidth() > 0) {
            style2.append("width:").append(item.getMaxWidth()).append("px;");
        }
        if (style2.length() > 0) {
            style2.append("object-fit: scale-down;");
            sp.setStyle(style2.toString());
        }
    }

    private static void applyHeightAndWidth(MPrintFormatItem item, img image) {
        StringBuilder style2 = new StringBuilder();
        if (item.getMaxHeight() > 0) {
            style2.append("height:").append(item.getMaxHeight()).append("px;");
        }
        if (item.getMaxWidth() > 0) {
            style2.append("width:").append(item.getMaxWidth()).append("px;");
        }
        if (style2.length() > 0) {
            style2.append("object-fit: scale-down;");
            image.setStyle(style2.toString());
        }
    }

    private static void createDataURLImageElement(MultiPartElement td2, URL url, MPrintFormatItem item) {
        byte[] imageData = null;
        try {
            imageData = ByteStreams.toByteArray((InputStream)url.openStream());
            HTMLReportRenderer.createDataURLImageElement(td2, imageData, item);
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String createDataURLImage(byte[] imageData) {
        contentType = null;
        readers = null;
        try {
            readers = ImageIO.getImageReaders(ImageIO.createImageInputStream(new ByteArrayInputStream(imageData)));
            if (true) ** GOTO lbl16
        }
        catch (IOException e) {
            HTMLReportRenderer.log.log(Level.WARNING, e.getLocalizedMessage(), e);
            return null;
        }
        do {
            reader = readers.next();
            try {
                contentType = reader.getFormatName();
                if (Util.isEmpty(contentType)) continue;
                break;
            }
            catch (IOException v0) {}
lbl16:
            // 3 sources

        } while (readers.hasNext());
        if (contentType != null) {
            builder = new StringBuilder("data:").append(contentType).append(";base64,");
            builder.append(Base64.getEncoder().encodeToString(imageData));
            return builder.toString();
        }
        return null;
    }

    private static void createDataURLImageElement(MultiPartElement td2, byte[] imageData, MPrintFormatItem item) {
        String dataUrl = HTMLReportRenderer.createDataURLImage(imageData);
        if (dataUrl != null) {
            img image = new img(dataUrl);
            td2.addElementToRegistry((Element)image);
            HTMLReportRenderer.applyHeightAndWidth(item, image);
        }
    }

    public static String compress(String src, boolean minify) {
        if (minify) {
            HtmlCompressor compressor = new HtmlCompressor();
            compressor.setEnabled(true);
            compressor.setCompressCss(true);
            compressor.setCompressJavaScript(true);
            compressor.setRemoveComments(true);
            compressor.setRemoveMultiSpaces(true);
            compressor.setRemoveIntertagSpaces(true);
            return compressor.compress(src);
        }
        return src;
    }

    public static void appendInlineCss(XhtmlDocument doc, Map<CSSInfo, List<ColumnInfo>> mapCssInfo) {
        StringBuilder buildCssInline = new StringBuilder();
        for (Map.Entry<CSSInfo, List<ColumnInfo>> cssClassInfo : mapCssInfo.entrySet()) {
            int i = 0;
            while (i < cssClassInfo.getValue().size()) {
                if (i > 0) {
                    buildCssInline.append(",");
                }
                buildCssInline.append(cssClassInfo.getValue().get(i).getCssSelector());
                ++i;
            }
            buildCssInline.append(cssClassInfo.getKey().getCssRule());
            buildCssInline.append("\n");
        }
        HTMLReportRenderer.appendInlineCss(doc, buildCssInline);
    }

    public static void appendInlineCss(XhtmlDocument doc, StringBuilder buildCssInline) {
        if (buildCssInline.length() > 0) {
            buildCssInline.insert(0, "<style>");
            buildCssInline.append("</style>");
            doc.appendHead(buildCssInline.toString());
        }
    }

    public static void addCssInfo(MPrintFormat printFormat, MPrintFormatItem formatItem, int index, Map<CSSInfo, List<ColumnInfo>> mapCssInfo) {
        CSSInfo cadidateCss = new CSSInfo(printFormat, formatItem);
        if (mapCssInfo.containsKey(cadidateCss)) {
            mapCssInfo.get(cadidateCss).add(new ColumnInfo(index, formatItem));
        } else {
            ArrayList<ColumnInfo> newColumnList = new ArrayList<ColumnInfo>();
            newColumnList.add(new ColumnInfo(index, formatItem));
            mapCssInfo.put(cadidateCss, newColumnList);
        }
    }

    private static String getCSSFontFamily(String fontFamily) {
        if ("Dialog".equals(fontFamily) || "DialogInput".equals(fontFamily) || "Monospaced".equals(fontFamily)) {
            return "monospace";
        }
        if ("SansSerif".equals(fontFamily)) {
            return "sans-serif";
        }
        if ("Serif".equals(fontFamily)) {
            return "serif";
        }
        return null;
    }

    public static void setStyle(PrintData printData, MultiPartElement element, MStyle style2) {
        if (style2 == null || style2.getAD_Style_ID() == 0) {
            return;
        }
        MStyleLine[] lines = style2.getStyleLines();
        StringBuilder styleBuilder = new StringBuilder();
        MStyleLine[] mStyleLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MStyleLine line = mStyleLineArray[n2];
            String inlineStyle = line.getInlineStyle().trim();
            String displayLogic = line.getDisplayLogic();
            if (Util.isEmpty(displayLogic) || Evaluator.evaluateLogic(new PrintDataEvaluatee(null, printData), displayLogic)) {
                if (styleBuilder.length() > 0 && styleBuilder.charAt(styleBuilder.length() - 1) != ';') {
                    styleBuilder.append("; ");
                }
                styleBuilder.append(inlineStyle);
            }
            ++n2;
        }
        if (styleBuilder.length() > 0) {
            element.setStyle(styleBuilder.toString());
        }
    }

    @Override
    public Class<HTMLReportRendererConfiguration> getConfigurationType() {
        return HTMLReportRendererConfiguration.class;
    }

    public static class CSSInfo {
        private Font font;
        private Color color;
        private String cssStr;

        public CSSInfo(MPrintFormat printFormat, MPrintFormatItem item) {
            MPrintFont mPrintFont = null;
            if (item.getAD_PrintFont_ID() > 0) {
                mPrintFont = MPrintFont.get(item.getAD_PrintFont_ID());
            } else if (printFormat.getAD_PrintFont_ID() > 0) {
                mPrintFont = MPrintFont.get(printFormat.getAD_PrintFont_ID());
            }
            if (mPrintFont != null && mPrintFont.getAD_PrintFont_ID() > 0) {
                this.font = mPrintFont.getFont();
            }
            MPrintColor mPrintColor = null;
            if (item.getAD_PrintColor_ID() > 0) {
                mPrintColor = MPrintColor.get(Env.getCtx(), item.getAD_PrintColor_ID());
            } else if (printFormat.getAD_PrintColor_ID() > 0) {
                mPrintColor = MPrintColor.get(Env.getCtx(), printFormat.getAD_PrintColor_ID());
            }
            if (mPrintColor != null && mPrintColor.getAD_PrintColor_ID() > 0) {
                this.color = mPrintColor.getColor();
            }
        }

        public CSSInfo(Font font, Color color) {
            this.font = font;
            this.color = color;
        }

        public int hashCode() {
            return (this.color == null ? 0 : this.color.hashCode()) + (this.font == null ? 0 : this.font.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CSSInfo) || obj.hashCode() != this.hashCode()) {
                return false;
            }
            CSSInfo compareObj = (CSSInfo)obj;
            return this.compareObj(compareObj.color, this.color) && this.compareObj(compareObj.font, this.font);
        }

        protected boolean compareObj(Object obj1, Object obj2) {
            if (obj1 == null && obj2 != null) {
                return false;
            }
            if (obj1 == null && obj2 == null) {
                return true;
            }
            return obj1.equals(obj2);
        }

        protected void addCssRule(StringBuilder cssBuild, String ruleName, String ruleValue) {
            cssBuild.append(ruleName);
            cssBuild.append(":");
            cssBuild.append(ruleValue);
            cssBuild.append(";");
        }

        public String getCssRule() {
            if (this.cssStr != null) {
                return this.cssStr;
            }
            StringBuilder cssBuild = new StringBuilder();
            cssBuild.append("{");
            if (this.font != null) {
                String fontFamily = this.font.getFamily();
                if ((fontFamily = HTMLReportRenderer.getCSSFontFamily(fontFamily)) != null) {
                    this.addCssRule(cssBuild, "font-family", fontFamily);
                }
                if (this.font.isBold()) {
                    this.addCssRule(cssBuild, "font-weight", "bold");
                }
                if (this.font.isItalic()) {
                    this.addCssRule(cssBuild, "font-style", "italic");
                }
                int size = this.font.getSize();
                this.addCssRule(cssBuild, "font-size", size + "pt");
            }
            if (this.color != null) {
                cssBuild.append("color:rgb(");
                cssBuild.append(this.color.getRed());
                cssBuild.append(",");
                cssBuild.append(this.color.getGreen());
                cssBuild.append(",");
                cssBuild.append(this.color.getBlue());
                cssBuild.append(");");
            }
            cssBuild.append("}");
            this.cssStr = cssBuild.toString();
            return this.cssStr;
        }
    }

    public static class ColumnInfo {
        protected static String CSS_SELECTOR_TEMPLATE = "table > tbody > tr > td:nth-child(%1$s)";
        int index = -1;

        public ColumnInfo(int index, MPrintFormatItem formatItem) {
            this.index = index;
        }

        public String getCssSelector() {
            return String.format(CSS_SELECTOR_TEMPLATE, this.index + 1);
        }
    }
}

