/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.expression.logic;

import java.util.logging.Level;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.compiere.util.CLogger;
import org.compiere.util.Evaluatee;
import org.idempiere.expression.logic.EvaluationVisitor;
import org.idempiere.expression.logic.SimpleBooleanLexer;
import org.idempiere.expression.logic.SimpleBooleanParser;
import org.idempiere.expression.logic.ThrowingErrorListener;

public final class LogicEvaluator {
    private static final CLogger s_log = CLogger.getCLogger(LogicEvaluator.class);

    private LogicEvaluator() {
    }

    public static boolean evaluateLogic(Evaluatee source, String logic) {
        SimpleBooleanLexer lexer = new SimpleBooleanLexer((CharStream)CharStreams.fromString((String)logic));
        SimpleBooleanParser parser = new SimpleBooleanParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        try {
            Object result = new EvaluationVisitor(source).visit((ParseTree)parser.parse());
            if (result != null && result instanceof Boolean) {
                return (Boolean)result;
            }
            s_log.severe("Logic does not comply with format '<expression> [<logic> <expression>]' => " + logic);
            return false;
        }
        catch (ParseCancellationException e) {
            s_log.log(Level.SEVERE, "Logic=" + logic + " Error=" + e.getMessage(), e);
            return false;
        }
    }

    public static void validate(String logic) {
        SimpleBooleanLexer lexer = new SimpleBooleanLexer((CharStream)CharStreams.fromString((String)logic));
        SimpleBooleanParser parser = new SimpleBooleanParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        parser.parse();
    }
}

