/*
 * Decompiled with CFR 0.152.
 */
package org.globalqss.process;

import org.adempiere.base.annotation.Process;
import org.compiere.model.MCashPlan;
import org.compiere.model.MCashPlanLine;
import org.compiere.model.MProcessPara;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.DB;

@Process
public class CopyFromCashPlan
extends SvrProcess {
    private int p_C_CashPlanSource_ID = 0;
    private int p_C_CashPlanTarget_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (name.equals("C_CashPlan_ID")) {
                this.p_C_CashPlanSource_ID = para[i2].getParameterAsInt();
            } else {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
            }
            ++i2;
        }
        this.p_C_CashPlanTarget_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MCashPlan cptarget = new MCashPlan(this.getCtx(), this.p_C_CashPlanTarget_ID, this.get_TrxName());
        if (cptarget.get_ID() <= 0) {
            throw new IllegalArgumentException("Target Cash Plan does not exist");
        }
        MCashPlan cpsource = new MCashPlan(this.getCtx(), this.p_C_CashPlanSource_ID, this.get_TrxName());
        if (cptarget.get_ID() <= 0) {
            throw new IllegalArgumentException("Source Cash Plan does not exist");
        }
        int insertNo = 0;
        int lineNo = DB.getSQLValue(this.get_TrxName(), "SELECT NVL(MAX(Line),0)+10 FROM C_CashPlanLine WHERE C_CashPlan_ID=?", this.p_C_CashPlanTarget_ID);
        MCashPlanLine[] mCashPlanLineArray = cpsource.getLines();
        int n = mCashPlanLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MCashPlanLine cpls = mCashPlanLineArray[n2];
            MCashPlanLine cplt = new MCashPlanLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(cpls, cplt);
            cplt.setAD_Org_ID(cptarget.getAD_Org_ID());
            cplt.setLine(lineNo);
            cplt.setC_CashPlan_ID(cptarget.getC_CashPlan_ID());
            lineNo += 10;
            if (!cplt.save()) {
                throw new AdempiereSystemError("Error saving cash plan line");
            }
            ++insertNo;
            ++n2;
        }
        return "@Inserted@=" + insertNo;
    }
}

