/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.IMFAMechanism;
import org.compiere.model.MMFAMethod;
import org.compiere.model.MMFARegistration;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;
import org.compiere.util.Util;

@Process
public class MFACompleteRegistration
extends SvrProcess {
    private int p_MFA_Registration_ID = 0;
    private String p_MFAValidationCode = null;
    private String p_Name = null;
    private boolean p_IsUserMFAPreferred = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            ProcessInfoParameter para = processInfoParameterArray[n2];
            switch (name = para.getParameterName()) {
                case "MFA_Registration_ID": {
                    this.p_MFA_Registration_ID = para.getParameterAsInt();
                    break;
                }
                case "MFAValidationCode": {
                    this.p_MFAValidationCode = para.getParameterAsString();
                    break;
                }
                case "Name": {
                    this.p_Name = para.getParameterAsString();
                    break;
                }
                case "IsUserMFAPreferred": {
                    this.p_IsUserMFAPreferred = para.getParameterAsBoolean();
                    break;
                }
                default: {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
                }
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MMFARegistration reg;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("MFA_Registration_ID=" + this.p_MFA_Registration_ID + ", MFAValidationCode=" + this.p_MFAValidationCode + ", Name=" + this.p_Name + ", IsUserMFAPreferred=" + this.p_IsUserMFAPreferred);
        }
        if ((reg = new MMFARegistration(this.getCtx(), this.p_MFA_Registration_ID, this.get_TrxName())).isValid()) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "MFARegistrationAlreadyValid"));
        }
        if (Util.isEmpty(this.p_MFAValidationCode)) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "MFACodeRequired"));
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        if (reg.getExpiration() != null && now.after(reg.getExpiration())) {
            reg.setIsActive(false);
            reg.saveEx(null);
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "MFARegistrationExpired"));
        }
        MMFAMethod method = new MMFAMethod(this.getCtx(), reg.getMFA_Method_ID(), this.get_TrxName());
        IMFAMechanism mechanism = method.getMFAMechanism();
        String msg = mechanism.complete(this.getCtx(), reg, this.p_MFAValidationCode, this.p_Name, this.p_IsUserMFAPreferred, this.get_TrxName());
        return msg;
    }
}

