/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Graphics2D;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.compiere.model.MQuery;
import org.compiere.print.MPrintTableFormat;
import org.compiere.print.layout.GridElement;
import org.compiere.util.Msg;

public class ParameterElement
extends GridElement {
    private static final long serialVersionUID = 4702399095192668527L;
    private Map<Integer, List<TextLayout>> valueTextLayoutMap = new HashMap<Integer, List<TextLayout>>();

    public ParameterElement(MQuery query, Properties ctx, MPrintTableFormat tFormat) {
        super(query.getReportProcessQuery() != null ? query.getReportProcessQuery().getRestrictionCount() : query.getRestrictionCount(), 4);
        this.setData(0, 0, Msg.getMsg(ctx, "Parameter") + ":", tFormat.getPageHeader_Font(), tFormat.getPageHeaderFG_Color());
        if (query.getReportProcessQuery() != null) {
            query = query.getReportProcessQuery();
        }
        int r = 0;
        while (r < query.getRestrictionCount()) {
            this.setData(r, 1, query.getInfoName(r), tFormat.getParameter_Font(), tFormat.getParameter_Color());
            this.setData(r, 2, query.getInfoOperator(r), tFormat.getParameter_Font(), tFormat.getParameter_Color());
            this.setData(r, 3, query.getInfoDisplayAll(r), tFormat.getParameter_Font(), tFormat.getParameter_Color());
            ++r;
        }
    }

    public void fitToPage(int pageWidth) {
        int offsetWidth = this.m_colWidth[0] + this.m_colGap + this.m_colWidth[1] + this.m_colGap + this.m_colWidth[2];
        int maxWidth = pageWidth - offsetWidth;
        int row = 0;
        while (row < this.m_rows) {
            int height = 0;
            AttributedCharacterIterator iter = this.m_iterator[row][3];
            if (iter != null) {
                LineBreakMeasurer measurer = new LineBreakMeasurer(iter, this.m_frc);
                while (measurer.getPosition() < iter.getEndIndex()) {
                    TextLayout layout = measurer.nextLayout(maxWidth);
                    List<TextLayout> layouts = this.valueTextLayoutMap.get(row);
                    if (layouts == null) {
                        layouts = new ArrayList<TextLayout>();
                        this.valueTextLayoutMap.put(row, layouts);
                    }
                    height += (int)(layout.getAscent() + layout.getDescent() + layout.getLeading()) + 1;
                    layouts.add(layout);
                }
                if (this.m_rowHeight[row] < height) {
                    this.m_rowHeight[row] = height;
                }
            }
            ++row;
        }
        this.calculateSize();
    }

    @Override
    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Properties ctx, boolean isView) {
        if (this.valueTextLayoutMap.isEmpty()) {
            super.paint(g2D, pageNo, pageStart, ctx, isView);
            return;
        }
        Point2D.Double location = this.getAbsoluteLocation(pageStart);
        float y = (float)location.y;
        int row = 0;
        while (row < this.m_rows) {
            float x = (float)location.x;
            int col = 0;
            while (col < this.m_cols) {
                if (col == 3 && this.valueTextLayoutMap.get(row) != null) {
                    List<TextLayout> layouts = this.valueTextLayoutMap.get(row);
                    float curY = y;
                    for (TextLayout layout : layouts) {
                        layout.draw(g2D, x, curY += layout.getAscent());
                        curY += (float)this.m_rowGap;
                    }
                } else {
                    if (this.m_textLayout[row][col] != null) {
                        float yy = y + this.m_textLayout[row][col].getAscent();
                        this.m_textLayout[row][col].draw(g2D, x, yy);
                    }
                    x += (float)this.m_colWidth[col];
                    if (this.m_colWidth[col] > 0) {
                        x += (float)this.m_colGap;
                    }
                }
                ++col;
            }
            y += (float)this.m_rowHeight[row];
            if (this.m_rowHeight[row] > 0) {
                y += (float)this.m_rowGap;
            }
            ++row;
        }
    }
}

