/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.event.PrintServiceAttributeEvent;
import javax.print.event.PrintServiceAttributeListener;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MLanguage;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.print.ArchiveEngine;
import org.compiere.print.DataEngine;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.IReportEngineEventListener;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintUtil;
import org.compiere.print.ReportEngineEvent;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.print.layout.PrintDataEvaluatee;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ServerProcessCtl;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Evaluator;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.idempiere.print.renderer.CSVReportRenderer;
import org.idempiere.print.renderer.CSVReportRendererConfiguration;
import org.idempiere.print.renderer.HTMLReportRenderer;
import org.idempiere.print.renderer.HTMLReportRendererConfiguration;
import org.idempiere.print.renderer.PDFReportRenderer;
import org.idempiere.print.renderer.PDFReportRendererConfiguration;
import org.idempiere.print.renderer.PSReportRenderer;
import org.idempiere.print.renderer.PSReportRendererConfiguration;
import org.idempiere.print.renderer.SSVReportRenderer;
import org.idempiere.print.renderer.SSVReportRendererConfiguration;
import org.idempiere.print.renderer.TabDelimitedReportRenderer;
import org.idempiere.print.renderer.TabDelimitedReportRendererConfiguration;
import org.idempiere.print.renderer.XLSReportRenderer;
import org.idempiere.print.renderer.XLSReportRendererConfiguration;
import org.idempiere.print.renderer.XLSXReportRenderer;
import org.idempiere.print.renderer.XLSXReportRendererConfiguration;
import org.idempiere.print.renderer.XMLReportRenderer;
import org.idempiere.print.renderer.XMLReportRendererConfiguration;

public class ReportEngine
implements PrintServiceAttributeListener {
    private static CLogger log = CLogger.getCLogger(ReportEngine.class);
    private Properties m_ctx;
    private MPrintFormat m_printFormat;
    private PrintInfo m_info;
    private MQuery m_query;
    private PrintData m_printData;
    private LayoutEngine m_layout = null;
    private String m_printerName = Ini.getProperty("Printer");
    private String m_trxName = null;
    private String m_whereExtended = null;
    private int m_windowNo = 0;
    private int m_language_id = 0;
    private boolean m_summary = false;
    private String m_name = null;
    private boolean m_isReplaceTabContent = false;
    private List<IReportEngineEventListener> eventListeners = new ArrayList<IReportEngineEventListener>();
    public static final int ORDER = 0;
    public static final int SHIPMENT = 1;
    public static final int INVOICE = 2;
    public static final int PROJECT = 3;
    public static final int RFQ = 4;
    public static final int REMITTANCE = 5;
    public static final int CHECK = 6;
    public static final int DUNNING = 7;
    public static final int MANUFACTURING_ORDER = 8;
    public static final int DISTRIBUTION_ORDER = 9;
    public static final int INVENTORY = 10;
    public static final int MOVEMENT = 11;
    private static final String[] DOC_BASETABLES = new String[]{"C_Order", "M_InOut", "C_Invoice", "C_Project", "C_RfQResponse", "C_PaySelectionCheck", "C_PaySelectionCheck", "C_DunningRunEntry", "PP_Order", "DD_Order", "M_Inventory", "M_Movement"};
    private static final String[] DOC_IDS = new String[]{"C_Order_ID", "M_InOut_ID", "C_Invoice_ID", "C_Project_ID", "C_RfQResponse_ID", "C_PaySelectionCheck_ID", "C_PaySelectionCheck_ID", "C_DunningRunEntry_ID", "PP_Order_ID", "DD_Order_ID", "M_Inventory_ID", "M_Movement_ID"};
    private static final int[] DOC_TABLE_ID = new int[]{259, 319, 318, 203, 674, 525, 525, 527, 53027, 53037, 321, 323};
    private String reportType;
    private ProcessInfo m_pi = null;

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info) {
        this(ctx, pf, query, info, null);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, boolean isSummary) {
        this(ctx, pf, query, info, isSummary, null);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, String trxName) {
        this(ctx, pf, query, info, false, trxName);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, boolean isSummary, String trxName) {
        this(ctx, pf, query, info, false, trxName, 0);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, String trxName, int windowNo) {
        this(ctx, pf, query, info, false, trxName, windowNo);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, boolean isSummary, String trxName, int windowNo) {
        this.m_summary = isSummary;
        if (pf == null) {
            throw new IllegalArgumentException("ReportEngine - no PrintFormat");
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(pf) + " -- " + String.valueOf(query));
        }
        this.m_ctx = ctx;
        this.m_printFormat = pf;
        this.m_info = info;
        this.m_trxName = trxName;
        this.m_windowNo = windowNo;
        this.initName();
        this.setQuery(query);
    }

    public void addEventListener(IReportEngineEventListener listener) {
        this.eventListeners.add(listener);
    }

    public boolean removeEventListener(IReportEngineEventListener listener) {
        return this.eventListeners.remove(listener);
    }

    public void setPrintFormat(MPrintFormat pf) {
        IReportEngineEventListener[] listeners;
        this.m_printFormat = pf;
        pf.reloadItems();
        if (this.m_layout != null) {
            this.setPrintData();
            this.m_layout.setPrintFormat(pf, false);
            this.m_layout.setPrintData(this.m_printData, this.m_query, true);
        }
        IReportEngineEventListener[] iReportEngineEventListenerArray = listeners = this.eventListeners.toArray(new IReportEngineEventListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IReportEngineEventListener listener = iReportEngineEventListenerArray[n2];
            listener.onPrintFormatChanged(new ReportEngineEvent(this));
            ++n2;
        }
    }

    public void setQuery(MQuery query) {
        IReportEngineEventListener[] listeners;
        this.m_query = query;
        if (query == null) {
            return;
        }
        this.setPrintData();
        if (this.m_layout != null) {
            this.m_layout.setPrintData(this.m_printData, this.m_query, true);
        }
        IReportEngineEventListener[] iReportEngineEventListenerArray = listeners = this.eventListeners.toArray(new IReportEngineEventListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IReportEngineEventListener listener = iReportEngineEventListenerArray[n2];
            listener.onQueryChanged(new ReportEngineEvent(this));
            ++n2;
        }
    }

    public MQuery getQuery() {
        return this.m_query;
    }

    private void setPrintData() {
        if (this.m_query == null) {
            return;
        }
        DataEngine de = new DataEngine(this.m_printFormat.getLanguage(), this.m_trxName, this.m_windowNo);
        this.setPrintData(de.getPrintData(this.m_ctx, this.m_printFormat, this.m_query, this.m_summary));
    }

    public PrintData getPrintData() {
        return this.m_printData;
    }

    public void setPrintData(PrintData printData) {
        if (printData == null) {
            return;
        }
        this.m_printData = printData;
    }

    private void layout() {
        if (this.m_printFormat == null) {
            throw new IllegalStateException("No print format");
        }
        if (this.m_printFormat.getJasperProcess_ID() > 0) {
            return;
        }
        if (this.m_printData == null) {
            throw new IllegalStateException("No print data (Delete Print Format and restart)");
        }
        this.m_layout = new LayoutEngine(this.m_printFormat, this.m_printData, this.m_query, this.m_info, this.m_trxName, this.m_windowNo);
    }

    public LayoutEngine getLayout() {
        if (this.m_layout == null) {
            this.layout();
        }
        return this.m_layout;
    }

    public void initName() {
        MProcess process;
        Language language = this.m_printFormat.getLanguage();
        String processFileNamePattern = this.m_printFormat.get_Translation("FileNamePattern", language.getAD_Language());
        if (this.m_info.getAD_Process_ID() > 0 && (process = new MProcess(Env.getCtx(), this.m_info.getAD_Process_ID(), this.m_trxName)) != null && !Util.isEmpty(process.getFileNamePattern())) {
            processFileNamePattern = process.getFileNamePattern();
        }
        this.m_name = Util.isEmpty(processFileNamePattern) ? this.m_printFormat.get_Translation("Name") : FileUtil.parseTitle(this.m_ctx, processFileNamePattern, this.m_info.getAD_Table_ID(), this.m_info.getRecord_ID(), this.m_windowNo, this.m_trxName);
    }

    public String getName() {
        if (this.m_name == null) {
            this.initName();
        }
        return this.m_name;
    }

    public MPrintFormat getPrintFormat() {
        return this.m_printFormat;
    }

    public PrintInfo getPrintInfo() {
        return this.m_info;
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    public int getRowCount() {
        return this.m_printData != null ? this.m_printData.getRowCount() : 0;
    }

    public int getColumnCount() {
        if (this.m_layout != null) {
            return this.m_layout.getColumnCount();
        }
        return 0;
    }

    public void print() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.m_info.toString());
        }
        if (this.m_layout == null) {
            this.layout();
        }
        PrintRequestAttributeSet prats = this.m_layout.getPaper().getPrintRequestAttributeSet();
        if (this.m_info.isDocumentCopy() || this.m_info.getCopies() < 1) {
            prats.add(new Copies(1));
        } else {
            prats.add(new Copies(this.m_info.getCopies()));
        }
        Locale locale = Language.getLoginLanguage().getLocale();
        prats.add(new JobName(this.m_printFormat.getName(), locale));
        prats.add(PrintUtil.getJobPriority(this.m_layout.getNumberOfPages(), this.m_info.getCopies(), true));
        try {
            PrinterJob job = this.getPrinterJob(this.m_info.getPrinterName());
            job.setPageable(this.m_layout.getPageable(false));
            try {
                if (this.m_info.isWithDialog() && !job.printDialog(prats)) {
                    return;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Operating System Print Issue, check & try again", e);
                return;
            }
            boolean printCopy = this.m_info.isDocumentCopy() && this.m_info.getCopies() > 1;
            ArchiveEngine.get().archive(this.m_layout, this.m_info);
            PrintUtil.print(job, prats, false, printCopy);
            if (printCopy) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Copy " + (this.m_info.getCopies() - 1));
                }
                prats.add(new Copies(this.m_info.getCopies() - 1));
                job = this.getPrinterJob(this.m_info.getPrinterName());
                job.setPageable(this.m_layout.getPageable(true));
                PrintUtil.print(job, prats, false, false);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public void attributeUpdate(PrintServiceAttributeEvent psae) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("attributeUpdate - " + String.valueOf(psae));
        }
    }

    private PrinterJob getPrinterJob(String printerName) {
        if (printerName != null && printerName.length() > 0) {
            return PrintUtil.getPrinterJob(printerName);
        }
        return PrintUtil.getPrinterJob(this.m_printerName);
    }

    public void pageSetupDialog() {
        IReportEngineEventListener[] listeners;
        if (this.m_layout == null) {
            this.layout();
        }
        this.m_layout.pageSetupDialog(this.getPrinterJob(this.m_printerName));
        IReportEngineEventListener[] iReportEngineEventListenerArray = listeners = this.eventListeners.toArray(new IReportEngineEventListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IReportEngineEventListener listener = iReportEngineEventListenerArray[n2];
            listener.onPageSetupChanged(new ReportEngineEvent(this));
            ++n2;
        }
    }

    public void setPrinterName(String printerName) {
        this.m_printerName = printerName == null ? Ini.getProperty("Printer") : printerName;
    }

    public String getPrinterName() {
        return this.m_printerName;
    }

    public boolean createHTML(File file, boolean onlyTable, Language language) {
        return this.createHTML(file, onlyTable, language, null);
    }

    public boolean createHTML(File file, boolean onlyTable, Language language, IHTMLExtension extension) {
        try {
            Language lang = language;
            if (lang == null) {
                lang = Language.getLoginLanguage();
            }
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Ini.getCharset());
            return this.createHTML(new BufferedWriter(fw), onlyTable, lang, extension);
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
            throw new AdempiereException(e);
        }
        return false;
    }

    public boolean createHTML(Writer writer, boolean onlyTable, Language language) {
        return this.createHTML(writer, onlyTable, language, null);
    }

    public boolean createHTML(Writer writer, boolean onlyTable, Language language, IHTMLExtension extension) {
        return this.createHTML(writer, onlyTable, language, extension, false);
    }

    public boolean createHTML(Writer writer, boolean onlyTable, Language language, IHTMLExtension extension, boolean isExport) {
        HTMLReportRendererConfiguration config = new HTMLReportRendererConfiguration().setOutputWriter(writer).setOnlyTable(onlyTable).setExport(isExport).setExtension(extension).setLanguage(language);
        new HTMLReportRenderer().renderReport(this, config);
        return true;
    }

    public String getIdentifier(MTable mTable, String tableName, int recordID) {
        boolean isTrl;
        ArrayList<MColumn> list = new ArrayList<MColumn>();
        MTable mTableTrl = MTable.get(this.getCtx(), tableName + "_Trl");
        String tableNameTrl = "";
        String reportLang = this.getLanguageID() > 0 ? new MLanguage(this.getCtx(), this.getLanguageID(), null).getAD_Language() : Language.getLoginLanguage().getAD_Language();
        boolean bl = isTrl = !Env.isBaseLanguage(Language.getLanguage(reportLang), tableName);
        if (isTrl && mTableTrl != null) {
            tableNameTrl = mTableTrl.getTableName();
        } else {
            isTrl = false;
        }
        String[] stringArray = mTable.getIdentifierColumns();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String idColumnName = stringArray[n2];
            MColumn column = mTable.getColumn(idColumnName);
            list.add(column);
            ++n2;
        }
        if (list.size() <= 0) {
            return String.valueOf(recordID);
        }
        StringBuilder displayColumn = new StringBuilder();
        String separator = MSysConfig.getValue("IDENTIFIER_SEPARATOR", "_", Env.getAD_Client_ID(Env.getCtx()));
        int i2 = 0;
        while (i2 < list.size()) {
            MColumn identifierColumn = (MColumn)list.get(i2);
            if (i2 > 0) {
                displayColumn.append("||'").append(separator).append("'||");
            }
            displayColumn.append("COALESCE(").append(DB.TO_CHAR(this.addTrlSuffix(identifierColumn, tableName, isTrl) + "." + identifierColumn.getColumnName(), identifierColumn.getAD_Reference_ID(), Env.getAD_Language(Env.getCtx()))).append(",").append(DB.TO_CHAR(tableName + "." + identifierColumn.getColumnName(), identifierColumn.getAD_Reference_ID(), Env.getAD_Language(Env.getCtx()))).append(",'')");
            ++i2;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(displayColumn.toString());
        sql.append(" FROM ").append(tableName);
        if (isTrl) {
            sql.append(" LEFT JOIN ").append(tableNameTrl).append(" ON ").append(tableName).append(".").append(tableName).append("_ID = ").append(tableNameTrl).append(".").append(tableName).append("_ID AND ").append(tableNameTrl).append(".AD_Language=?");
            params.add(reportLang);
        }
        sql.append(" WHERE ").append(tableName).append(".").append(tableName).append("_ID=?");
        params.add(recordID);
        return DB.getSQLValueStringEx(null, sql.toString(), params);
    }

    private String addTrlSuffix(MColumn column, String tableName, boolean isTrl) {
        if (column.isTranslated() && isTrl) {
            return tableName + "_Trl";
        }
        return tableName;
    }

    public boolean createCSV(File file, char delimiter, Language language) {
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Ini.getCharset());
            return this.createCSV(new BufferedWriter(fw), delimiter, language);
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
        }
        return false;
    }

    public boolean createCSV(Writer writer, char delimiter, Language language) {
        switch (delimiter) {
            case ',': {
                CSVReportRendererConfiguration config = new CSVReportRendererConfiguration().setLanguage(language).setOutputWriter(writer);
                new CSVReportRenderer().renderReport(this, config);
                break;
            }
            case ';': {
                SSVReportRendererConfiguration config = new SSVReportRendererConfiguration().setLanguage(language).setOutputWriter(writer);
                new SSVReportRenderer().renderReport(this, config);
                break;
            }
            case '\t': {
                TabDelimitedReportRendererConfiguration config = new TabDelimitedReportRendererConfiguration().setLanguage(language).setOutputWriter(writer);
                new TabDelimitedReportRenderer().renderReport(this, config);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + delimiter);
            }
        }
        return true;
    }

    public boolean createXML(File file) {
        XMLReportRendererConfiguration config = new XMLReportRendererConfiguration().setOutputFile(file);
        new XMLReportRenderer().renderReport(this, config);
        return true;
    }

    public boolean createXML(Writer writer) {
        XMLReportRendererConfiguration config = new XMLReportRendererConfiguration().setOutputWriter(writer);
        new XMLReportRenderer().renderReport(this, config);
        return true;
    }

    public File getPDF() {
        return this.getPDF(null);
    }

    public File getPDF(File file) {
        try {
            if (file == null) {
                file = this.m_pi != null && !Util.isEmpty(this.m_pi.getPDFFileName(), true) ? FileUtil.createFile(this.m_pi.getPDFFileName()) : FileUtil.createTempFile(FileUtil.makePrefix(this.getName()), ".pdf");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        if (this.createPDF(file)) {
            return file;
        }
        return null;
    }

    public File getHTML() {
        return this.getHTML(null);
    }

    public File getHTML(File file) {
        try {
            if (file == null) {
                file = FileUtil.createTempFile(FileUtil.makePrefix(this.getName()), ".html");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        if (this.createHTML(file, false, Env.getLanguage(this.getCtx()))) {
            return file;
        }
        return null;
    }

    public File getCSV() {
        return this.getCSV(null);
    }

    public File getCSV(File file) {
        try {
            if (file == null) {
                file = FileUtil.createTempFile(FileUtil.makePrefix(this.getName()), ".csv");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        if (this.createCSV(file, ',', Env.getLanguage(this.getCtx()))) {
            return file;
        }
        return null;
    }

    public File getXLS() {
        return this.getXLS(null);
    }

    public File getXLS(File file) {
        try {
            if (file == null) {
                file = FileUtil.createTempFile(FileUtil.makePrefix(this.getName()), ".xls");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        try {
            this.createXLS(file, Env.getLanguage(this.getCtx()));
            return file;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public File getXLSX() {
        return this.getXLSX(null);
    }

    public File getXLSX(File file) {
        try {
            if (file == null) {
                file = FileUtil.createTempFile(FileUtil.makePrefix(this.getName()), ".xlsx");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        try {
            this.createXLSX(file, Env.getLanguage(this.getCtx()));
            return file;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public boolean createPDF(File file) {
        String fileName = null;
        URI uri = null;
        try {
            if (file == null) {
                file = FileUtil.createTempFile("ReportEngine", ".pdf");
            } else if (file.exists()) {
                file.delete();
                file = new File(file.getAbsolutePath());
            }
            uri = file.toURI();
            fileName = file.getAbsolutePath();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "file", e);
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(uri.toString());
        }
        try {
            if (this.m_printFormat != null && this.m_printFormat.getJasperProcess_ID() > 0) {
                ProcessInfo pi = new ProcessInfo("", this.m_printFormat.getJasperProcess_ID(), this.m_printFormat.getAD_Table_ID(), this.m_info.getRecord_ID());
                if (this.m_printFormat.getLanguage() != null && this.m_printFormat.getLanguage().getAD_Language() != null) {
                    ProcessInfoParameter reportLanguagePip = new ProcessInfoParameter("AD_Language", this.m_printFormat.getLanguage().getAD_Language(), null, null, null);
                    pi.setParameter(new ProcessInfoParameter[]{reportLanguagePip});
                }
                pi.setIsBatch(true);
                pi.setPDFFileName(fileName);
                pi.setTransientObject(this.m_printFormat);
                ServerProcessCtl.process(pi, this.m_trxName == null ? null : Trx.get(this.m_trxName, false), false);
            } else {
                PDFReportRendererConfiguration config = new PDFReportRendererConfiguration().setOutputFile(file);
                new PDFReportRenderer().renderReport(this, config);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "PDF", e);
            throw new AdempiereException(e);
        }
        File file2 = new File(fileName);
        if (log.isLoggable(Level.INFO)) {
            log.info(file2.getAbsolutePath() + " - " + file2.length());
        }
        return file2.exists();
    }

    public byte[] createPDFData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PDFReportRendererConfiguration config = new PDFReportRendererConfiguration().setOutputStream(os);
        new PDFReportRenderer().renderReport(this, config);
        return os.toByteArray();
    }

    public boolean createPS(File file) {
        PSReportRendererConfiguration config = new PSReportRendererConfiguration().setOutputFile(file);
        new PSReportRenderer().renderReport(this, config);
        return true;
    }

    public boolean createPS(OutputStream os) {
        PSReportRendererConfiguration config = new PSReportRendererConfiguration().setOutputStream(os);
        new PSReportRenderer().renderReport(this, config);
        return true;
    }

    public void createXLS(File outFile, Language language) throws Exception {
        XLSReportRendererConfiguration config = new XLSReportRendererConfiguration().setOutputFile(outFile).setLanguage(language);
        new XLSReportRenderer().renderReport(this, config);
    }

    public void createXLSX(File outFile, Language language) throws Exception {
        XLSXReportRendererConfiguration config = new XLSXReportRendererConfiguration().setOutputFile(outFile).setLanguage(language);
        new XLSXReportRenderer().renderReport(this, config);
    }

    public static ReportEngine get(Properties ctx, ProcessInfo pi) {
        return ReportEngine.get(ctx, pi, 0);
    }

    public static ReportEngine get(Properties ctx, ProcessInfo pi, int windowNo) {
        ResultSet rs;
        CPreparedStatement pstmt;
        StringBuilder sql;
        MPInstance instance;
        int Client_ID;
        boolean IsForm;
        int AD_PrintFormat_ID;
        String TableName;
        int AD_ReportView_ID;
        int AD_Table_ID;
        int AD_Client_ID;
        block22: {
            AD_Client_ID = pi.getAD_Client_ID();
            AD_Table_ID = 0;
            AD_ReportView_ID = 0;
            TableName = null;
            AD_PrintFormat_ID = 0;
            IsForm = false;
            Client_ID = -1;
            instance = null;
            sql = new StringBuilder("SELECT rv.AD_ReportView_ID,rv.WhereClause,").append(" t.AD_Table_ID,t.TableName, pf.AD_PrintFormat_ID, pf.IsForm, pf.AD_Client_ID ").append("FROM AD_PInstance pi").append(" INNER JOIN AD_Process p ON (pi.AD_Process_ID=p.AD_Process_ID)").append(" INNER JOIN AD_ReportView rv ON (p.AD_ReportView_ID=rv.AD_ReportView_ID)").append(" INNER JOIN AD_Table t ON (rv.AD_Table_ID=t.AD_Table_ID)").append(" LEFT OUTER JOIN AD_PrintFormat pf ON (p.AD_ReportView_ID=pf.AD_ReportView_ID AND pf.AD_Client_ID IN (0,?) AND pf.IsActive='Y') ").append("WHERE pi.AD_PInstance_ID=? ").append("ORDER BY pf.AD_Client_ID DESC, pf.IsDefault DESC");
            pstmt = null;
            rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setInt(2, pi.getAD_PInstance_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        AD_ReportView_ID = rs.getInt(1);
                        AD_Table_ID = rs.getInt(3);
                        TableName = rs.getString(4);
                        AD_PrintFormat_ID = rs.getInt(5);
                        IsForm = "Y".equals(rs.getString(6));
                        Client_ID = rs.getInt(7);
                        instance = new MPInstance(ctx, pi.getAD_PInstance_ID(), null);
                        if (instance.getAD_PrintFormat_ID() <= 0) {
                            instance.setAD_PrintFormat_ID(AD_PrintFormat_ID);
                        } else {
                            AD_PrintFormat_ID = instance.getAD_PrintFormat_ID();
                        }
                        ReportEngine.setDefaultReportTypeToPInstance(ctx, instance, AD_PrintFormat_ID);
                        instance.saveEx();
                    }
                }
                catch (SQLException e1) {
                    log.log(Level.SEVERE, "(1) - " + String.valueOf(sql), e1);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block22;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (AD_ReportView_ID == 0) {
            block24: {
                sql = new StringBuilder("SELECT t.AD_Table_ID,t.TableName, pf.AD_PrintFormat_ID, pf.IsForm ").append("FROM AD_PInstance pi").append(" INNER JOIN AD_Process p ON (pi.AD_Process_ID=p.AD_Process_ID)").append(" INNER JOIN AD_PrintFormat pf ON (p.AD_PrintFormat_ID=pf.AD_PrintFormat_ID)").append(" INNER JOIN AD_Table t ON (pf.AD_Table_ID=t.AD_Table_ID) ").append("WHERE pi.AD_PInstance_ID=?");
                try {
                    try {
                        pstmt = DB.prepareStatement(sql.toString(), null);
                        pstmt.setInt(1, pi.getAD_PInstance_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            AD_Table_ID = rs.getInt(1);
                            TableName = rs.getString(2);
                            AD_PrintFormat_ID = rs.getInt(3);
                            IsForm = "Y".equals(rs.getString(4));
                            Client_ID = AD_Client_ID;
                            instance = new MPInstance(ctx, pi.getAD_PInstance_ID(), null);
                        }
                    }
                    catch (SQLException e1) {
                        log.log(Level.SEVERE, "(2) - " + String.valueOf(sql), e1);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (AD_PrintFormat_ID == 0) {
                log.log(Level.SEVERE, "Report Info NOT found AD_PInstance_ID=" + pi.getAD_PInstance_ID() + ",AD_Client_ID=" + AD_Client_ID);
                return null;
            }
            if (instance != null) {
                instance.setAD_PrintFormat_ID(AD_PrintFormat_ID);
                ReportEngine.setDefaultReportTypeToPInstance(ctx, instance, AD_PrintFormat_ID);
                instance.saveEx();
            }
        }
        MQuery query = null;
        query = !(!IsForm || pi.getRecord_ID() <= 0 && Util.isEmpty(pi.getRecord_UU()) || TableName.startsWith("T_")) ? (pi.getRecord_ID() > 0 ? MQuery.getEqualQuery(TableName + "_ID", pi.getRecord_ID()) : MQuery.getEqualQuery(PO.getUUIDColumnName(TableName), pi.getRecord_UU())) : MQuery.get(ctx, pi.getAD_PInstance_ID(), TableName);
        MPrintFormat format = null;
        Serializable so = pi.getSerializableObject();
        if (so instanceof MPrintFormat) {
            format = (MPrintFormat)so;
        }
        if (format == null && AD_PrintFormat_ID != 0) {
            format = Client_ID == AD_Client_ID ? MPrintFormat.get(ctx, AD_PrintFormat_ID, false) : MPrintFormat.copyToClient(ctx, AD_PrintFormat_ID, AD_Client_ID);
        }
        if (format != null && format.getItemCount() == 0) {
            if (log.isLoggable(Level.INFO)) {
                log.info("No Items - recreating:  " + String.valueOf(format));
            }
            format.delete(true);
            format = null;
        }
        if (format == null && AD_ReportView_ID != 0) {
            format = MPrintFormat.createFromReportView(ctx, AD_ReportView_ID, pi.getTitle());
        }
        if (format == null) {
            return null;
        }
        format.setTranslationLanguage(format.getLanguage());
        PrintInfo info = new PrintInfo(pi);
        info.setAD_Table_ID(AD_Table_ID);
        return new ReportEngine(ctx, format, query, info, pi.isSummary(), pi.getTransactionName(), windowNo);
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID) {
        return ReportEngine.get(ctx, type, Record_ID, null, 0);
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID, int windowNo) {
        return ReportEngine.get(ctx, type, Record_ID, null, windowNo);
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID, String trxName) {
        return ReportEngine.get(ctx, type, Record_ID, trxName, 0);
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID, String trxName, int windowNo) {
        Language language;
        int copies;
        String DocumentNo;
        int C_BPartner_ID;
        int AD_PrintFormat_ID;
        block19: {
            int[] what;
            if (Record_ID < 1) {
                log.log(Level.WARNING, "No PrintFormat for Record_ID=" + Record_ID + ", Type=" + type);
                return null;
            }
            if (type == 0 && (what = ReportEngine.getDocumentWhat(Record_ID)) != null) {
                type = what[0];
                Record_ID = what[1];
            }
            AD_PrintFormat_ID = 0;
            C_BPartner_ID = 0;
            DocumentNo = null;
            copies = 1;
            MClient client = MClient.get(ctx);
            language = client.getLanguage();
            StringBuilder sql = null;
            sql = type == 6 ? new StringBuilder("SELECT bad.Check_PrintFormat_ID,").append("\tc.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.DocumentNo ").append("FROM C_PaySelectionCheck d").append(" INNER JOIN C_PaySelection ps ON (d.C_PaySelection_ID=ps.C_PaySelection_ID)").append(" INNER JOIN C_BankAccountDoc bad ON (ps.C_BankAccount_ID=bad.C_BankAccount_ID AND d.PaymentRule=bad.PaymentRule)").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) ").append("WHERE d.C_PaySelectionCheck_ID=?") : (type == 7 ? new StringBuilder("SELECT dl.Dunning_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,dr.DunningDate ").append("FROM C_DunningRunEntry d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID)").append(" INNER JOIN C_DunningRun dr ON (d.C_DunningRun_ID=dr.C_DunningRun_ID)").append(" INNER JOIN C_DunningLevel dl ON (dl.C_DunningLevel_ID=d.C_DunningLevel_ID) ").append("WHERE d.C_DunningRunEntry_ID=?") : (type == 5 ? new StringBuilder("SELECT pf.Remittance_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.DocumentNo ").append("FROM C_PaySelectionCheck d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) ").append("WHERE d.C_PaySelectionCheck_ID=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC") : (type == 3 ? new StringBuilder("SELECT pf.Project_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.Value ").append("FROM C_Project d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" LEFT OUTER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) ").append("WHERE d.C_Project_ID=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC") : (type == 8 ? new StringBuilder("SELECT pf.Manuf_Order_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language, 0 , d.DocumentNo ").append("FROM PP_Order d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" LEFT OUTER JOIN AD_User u ON (u.AD_User_ID=d.Planner_ID)").append(" LEFT OUTER JOIN C_BPartner bp ON (u.C_BPartner_ID=bp.C_BPartner_ID) ").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append("WHERE d.PP_Order_ID=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC") : (type == 9 ? new StringBuilder("SELECT pf.Distrib_Order_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language, bp.C_BPartner_ID , d.DocumentNo ").append("FROM DD_Order d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" LEFT OUTER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) ").append("WHERE d.DD_Order_ID=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC") : (type == 4 ? new StringBuilder("SELECT COALESCE(t.AD_PrintFormat_ID, pf.AD_PrintFormat_ID),").append(" c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,rr.Name ").append("FROM C_RfQResponse rr").append(" INNER JOIN C_RfQ r ON (rr.C_RfQ_ID=r.C_RfQ_ID)").append(" INNER JOIN C_RfQ_Topic t ON (r.C_RfQ_Topic_ID=t.C_RfQ_Topic_ID)").append(" INNER JOIN AD_Client c ON (rr.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (rr.C_BPartner_ID=bp.C_BPartner_ID),").append(" AD_PrintFormat pf ").append("WHERE pf.AD_Client_ID IN (0,rr.AD_Client_ID)").append(" AND pf.AD_Table_ID=725 AND pf.IsTableBased='N'").append(" AND rr.C_RfQResponse_ID=? ").append("ORDER BY t.AD_PrintFormat_ID, pf.AD_Client_ID DESC, pf.AD_Org_ID DESC") : (type == 0 || type == 2 ? new StringBuilder("SELECT pf.Order_PrintFormat_ID,pf.Shipment_PrintFormat_ID,").append(" COALESCE (bp.Invoice_PrintFormat_ID,dt.AD_PrintFormat_ID,pf.Invoice_PrintFormat_ID),").append(" pf.Project_PrintFormat_ID, pf.Remittance_PrintFormat_ID,").append(" c.IsMultiLingualDocument, bp.AD_Language,").append(" COALESCE(dt.DocumentCopies,0)+COALESCE(bp.DocumentCopies,1), ").append(" dt.AD_PrintFormat_ID,bp.C_BPartner_ID,d.DocumentNo ").append("FROM " + DOC_BASETABLES[type] + " d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID)").append(" LEFT OUTER JOIN C_DocType dt ON ((d.C_DocType_ID>0 AND d.C_DocType_ID=dt.C_DocType_ID) OR (d.C_DocType_ID=0 AND d.C_DocTypeTarget_ID=dt.C_DocType_ID)) ").append("WHERE d." + DOC_IDS[type] + "=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ").append("ORDER BY pf.AD_Org_ID DESC") : (type == 10 || type == 11 ? new StringBuilder("SELECT COALESCE (dt.AD_PrintFormat_ID, 0), 0,").append(" NULL, 0 , d.DocumentNo ").append("FROM " + DOC_BASETABLES[type] + " d").append(" LEFT OUTER JOIN C_DocType dt ON (d.C_DocType_ID=dt.C_DocType_ID) ").append("WHERE d." + DOC_IDS[type] + "=?") : new StringBuilder("SELECT pf.Order_PrintFormat_ID,pf.Shipment_PrintFormat_ID,").append(" COALESCE (bp.Invoice_PrintFormat_ID,dt.AD_PrintFormat_ID,pf.Invoice_PrintFormat_ID),").append(" pf.Project_PrintFormat_ID, pf.Remittance_PrintFormat_ID,").append(" c.IsMultiLingualDocument, bp.AD_Language,").append(" COALESCE(dt.DocumentCopies,0)+COALESCE(bp.DocumentCopies,1), ").append(" dt.AD_PrintFormat_ID,bp.C_BPartner_ID,d.DocumentNo, ").append(" pf.Manuf_Order_PrintFormat_ID, pf.Distrib_Order_PrintFormat_ID ").append("FROM " + DOC_BASETABLES[type] + " d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID)").append(" LEFT OUTER JOIN C_DocType dt ON (d.C_DocType_ID=dt.C_DocType_ID) ").append("WHERE d." + DOC_IDS[type] + "=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ").append("ORDER BY pf.AD_Org_ID DESC")))))))));
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), trxName);
                    pstmt.setInt(1, Record_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        if (type == 6 || type == 7 || type == 5 || type == 3 || type == 4 || type == 8 || type == 9 || type == 10 || type == 11) {
                            MProcess process;
                            AD_PrintFormat_ID = rs.getInt(1);
                            copies = 1;
                            AD_Language = rs.getString(3);
                            if (AD_Language != null) {
                                language = Language.getLanguage(AD_Language);
                            }
                            C_BPartner_ID = rs.getInt(4);
                            if (type == 7) {
                                Timestamp ts = rs.getTimestamp(5);
                                DocumentNo = ts.toString();
                            } else {
                                DocumentNo = rs.getString(5);
                            }
                            if (AD_PrintFormat_ID == 0 && type == 10) {
                                process = MProcess.get(ctx, 291);
                                AD_PrintFormat_ID = process.getAD_PrintFormat_ID();
                            }
                            if (AD_PrintFormat_ID == 0 && type == 11) {
                                process = MProcess.get(ctx, 290);
                                AD_PrintFormat_ID = process.getAD_PrintFormat_ID();
                            }
                        } else {
                            AD_PrintFormat_ID = rs.getInt(type + 1);
                            if (type != 2 && rs.getInt(9) != 0) {
                                AD_PrintFormat_ID = rs.getInt(9);
                            }
                            copies = rs.getInt(8);
                            AD_Language = rs.getString(7);
                            if (AD_Language != null) {
                                language = Language.getLanguage(AD_Language);
                            }
                            C_BPartner_ID = rs.getInt(10);
                            DocumentNo = rs.getString(11);
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Record_ID=" + Record_ID + ", SQL=" + String.valueOf(sql), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (AD_PrintFormat_ID == 0) {
            log.log(Level.SEVERE, "No PrintFormat found for Type=" + type + ", Record_ID=" + Record_ID);
            return null;
        }
        MPrintFormat format = MPrintFormat.get(ctx, AD_PrintFormat_ID, false);
        format.setLanguage(language);
        format.setTranslationLanguage(language);
        MQuery query = new MQuery(format.getAD_Table_ID());
        query.addRestriction(DOC_IDS[type], "=", Record_ID);
        if (DocumentNo == null || DocumentNo.length() == 0) {
            DocumentNo = "DocPrint";
        }
        PrintInfo info = new PrintInfo(DocumentNo, DOC_TABLE_ID[type], Record_ID, C_BPartner_ID);
        info.setCopies(copies);
        info.setDocumentCopy(false);
        info.setPrinterName(format.getPrinterName());
        ReportEngine re = new ReportEngine(ctx, format, query, info, trxName, windowNo);
        return re;
    }

    private static int[] getDocumentWhat(int C_Order_ID) {
        int[] what = new int[]{0, C_Order_ID};
        StringBuilder sql = new StringBuilder("SELECT dt.DocSubTypeSO ").append("FROM C_DocType dt, C_Order o ").append("WHERE o.C_DocType_ID=dt.C_DocType_ID").append(" AND o.C_Order_ID=?");
        String DocSubTypeSO = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, C_Order_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DocSubTypeSO = rs.getString(1);
                }
                if (DocSubTypeSO == null || "".equals(DocSubTypeSO)) {
                    sql = new StringBuilder("SELECT dt.DocSubTypeSO ").append("FROM C_DocType dt, C_Order o ").append("WHERE o.C_DocTypeTarget_ID=dt.C_DocType_ID").append(" AND o.C_Order_ID=?");
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, C_Order_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        DocSubTypeSO = rs.getString(1);
                    }
                }
            }
            catch (SQLException e1) {
                log.log(Level.SEVERE, "(1) - " + String.valueOf(sql), e1);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (DocSubTypeSO == null) {
            DocSubTypeSO = "";
        }
        if (DocSubTypeSO.equals("WR") || DocSubTypeSO.equals("WI")) {
            what[0] = 2;
        } else if (DocSubTypeSO.equals("WP")) {
            what[0] = 1;
        } else {
            return what;
        }
        sql = what[0] == 2 ? new StringBuilder("SELECT C_Invoice_ID REC FROM C_Invoice WHERE C_Order_ID=?").append(" ORDER BY C_Invoice_ID DESC") : new StringBuilder("SELECT M_InOut_ID REC FROM M_InOut WHERE C_Order_ID=?").append(" ORDER BY M_InOut_ID DESC");
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, C_Order_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    what[1] = rs.getInt(1);
                } else {
                    what[0] = 0;
                }
            }
            catch (SQLException e2) {
                log.log(Level.SEVERE, "(2) - " + String.valueOf(sql), e2);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Order => " + what[0] + " ID=" + what[1]);
        }
        return what;
    }

    public static void printConfirm(int type, int Record_ID) {
        int no;
        StringBuilder sql = new StringBuilder();
        if (type == 0 || type == 1 || type == 2) {
            sql.append("UPDATE ").append(DOC_BASETABLES[type]).append(" SET DatePrinted=getDate(), IsPrinted='Y' WHERE ").append(DOC_IDS[type]).append("=").append(Record_ID);
        }
        if (sql.length() > 0 && (no = DB.executeUpdate(sql.toString(), null)) != 1) {
            log.log(Level.SEVERE, "Updated records=" + no + " - should be just one");
        }
    }

    public void setWhereExtended(String whereExtended) {
        this.m_whereExtended = whereExtended;
    }

    public String getWhereExtended() {
        return this.m_whereExtended;
    }

    public void setWindowNo(int windowNo) {
        this.m_windowNo = windowNo;
    }

    public int getWindowNo() {
        return this.m_windowNo;
    }

    public void setSummary(boolean summary) {
        this.m_summary = summary;
    }

    public boolean isSummary() {
        return this.m_summary;
    }

    public void setLanguageID(int languageID) {
        this.m_language_id = languageID;
    }

    public int getLanguageID() {
        return this.m_language_id;
    }

    public void setReportType(String type) {
        this.reportType = type;
    }

    public String getReportType() {
        return this.reportType;
    }

    public boolean isReplaceTabContent() {
        return this.m_isReplaceTabContent;
    }

    public void setIsReplaceTabContent(boolean m_isReplaceTabContent) {
        this.m_isReplaceTabContent = m_isReplaceTabContent;
    }

    public static int getReportEngineType(int tableID) {
        int i2 = 0;
        while (i2 < DOC_TABLE_ID.length) {
            if (DOC_TABLE_ID[i2] == tableID) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static void setDefaultReportTypeToPInstance(Properties ctx, MPInstance instance, int printFormatID) {
        if (Util.isEmpty(instance.getReportType())) {
            MPrintFormat pf = new MPrintFormat(ctx, printFormatID, null);
            String type = pf.isForm() ? MSysConfig.getValue("ZK_REPORT_FORM_OUTPUT_TYPE", "PDF", Env.getAD_Client_ID(ctx), Env.getAD_Org_ID(ctx)) : MSysConfig.getValue("ZK_REPORT_TABLE_OUTPUT_TYPE", "PDF", Env.getAD_Client_ID(ctx), Env.getAD_Org_ID(ctx));
            instance.setReportType(type);
        }
    }

    public void setProcessInfo(ProcessInfo pi) {
        this.m_pi = pi;
    }

    public ProcessInfo getProcessInfo() {
        return this.m_pi;
    }

    public static boolean isDisplayPFItem(PrintData printData, MPrintFormatItem item) {
        if (Util.isEmpty(item.getDisplayLogic())) {
            return true;
        }
        return Evaluator.evaluateLogic(new PrintDataEvaluatee(null, printData), item.getDisplayLogic());
    }
}

