/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MStatus;
import org.compiere.model.X_R_StatusCategory;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MStatusCategory
extends X_R_StatusCategory
implements ImmutablePOSupport {
    private static final long serialVersionUID = -5527646898927619293L;
    private static ImmutableIntPOCache<Integer, MStatusCategory> s_cache = new ImmutableIntPOCache("R_StatusCategory", 20);
    private static CLogger s_log = CLogger.getCLogger(MStatusCategory.class);
    private MStatus[] m_status = null;

    public static MStatusCategory getDefault(Properties ctx) {
        MStatusCategory retValue;
        block6: {
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            String sql = "SELECT * FROM R_StatusCategory WHERE AD_Client_ID in (0,?) AND IsDefault='Y' ORDER BY AD_Client_ID DESC";
            retValue = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MStatusCategory(ctx, rs, null);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public static MStatusCategory createDefault(Properties ctx) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        MStatusCategory retValue = new MStatusCategory(ctx, 0, null);
        retValue.setClientOrg(AD_Client_ID, 0);
        retValue.setName(Msg.getMsg(ctx, "Standard"));
        retValue.setIsDefault(true);
        if (!retValue.save()) {
            return null;
        }
        String sql = "UPDATE R_Status SET R_StatusCategory_ID=" + retValue.getR_StatusCategory_ID() + " WHERE R_StatusCategory_ID IS NULL AND AD_Client_ID=" + AD_Client_ID;
        int no = DB.executeUpdate(sql, null);
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("Default for AD_Client_ID=" + AD_Client_ID + " - Status #" + no);
        }
        return retValue;
    }

    public static MStatusCategory get(int R_StatusCategory_ID) {
        return MStatusCategory.get(Env.getCtx(), R_StatusCategory_ID);
    }

    public static MStatusCategory get(Properties ctx, int R_StatusCategory_ID) {
        Integer key = R_StatusCategory_ID;
        MStatusCategory retValue = s_cache.get(ctx, key, e -> new MStatusCategory(ctx, (MStatusCategory)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MStatusCategory(ctx, R_StatusCategory_ID, null);
        if (retValue.get_ID() == R_StatusCategory_ID) {
            s_cache.put(key, retValue, e -> new MStatusCategory(Env.getCtx(), (MStatusCategory)e));
            return retValue;
        }
        return null;
    }

    public MStatusCategory(Properties ctx, String R_StatusCategory_UU, String trxName) {
        super(ctx, R_StatusCategory_UU, trxName);
        if (Util.isEmpty(R_StatusCategory_UU)) {
            this.setInitialDefaults();
        }
    }

    public MStatusCategory(Properties ctx, int R_StatusCategory_ID, String trxName) {
        super(ctx, R_StatusCategory_ID, trxName);
        if (R_StatusCategory_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsDefault(false);
    }

    public MStatusCategory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MStatusCategory(MStatusCategory copy) {
        this(Env.getCtx(), copy);
    }

    public MStatusCategory(Properties ctx, MStatusCategory copy) {
        this(ctx, copy, null);
    }

    public MStatusCategory(Properties ctx, MStatusCategory copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_status = copy.m_status != null ? (MStatus[])Arrays.stream(copy.m_status).map(e -> new MStatus(ctx, (MStatus)e, trxName)).toArray(MStatus[]::new) : null;
    }

    public MStatus[] getStatus(boolean reload) {
        ArrayList<MStatus> list;
        block8: {
            if (this.m_status != null && !reload) {
                return this.m_status;
            }
            String sql = "SELECT * FROM R_Status WHERE R_StatusCategory_ID=? ORDER BY SeqNo";
            list = new ArrayList<MStatus>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getR_StatusCategory_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MStatus(this.getCtx(), rs, null));
                    }
                }
                catch (Exception e2) {
                    this.log.log(Level.SEVERE, sql, e2);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (list.size() > 0 && this.is_Immutable()) {
            list.stream().forEach(e -> {
                MStatus mStatus = e.markImmutable();
            });
        }
        this.m_status = new MStatus[list.size()];
        list.toArray(this.m_status);
        return this.m_status;
    }

    public int getDefaultR_Status_ID() {
        if (this.m_status == null) {
            this.getStatus(false);
        }
        int i = 0;
        while (i < this.m_status.length) {
            if (this.m_status[i].isDefault() && this.m_status[i].isActive()) {
                return this.m_status[i].getR_Status_ID();
            }
            ++i;
        }
        if (this.m_status.length > 0 && this.m_status[0].isActive()) {
            return this.m_status[0].getR_Status_ID();
        }
        return 0;
    }

    @Override
    public MStatusCategory markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_status != null && this.m_status.length > 0) {
            Arrays.stream(this.m_status).forEach(e -> {
                MStatus mStatus = e.markImmutable();
            });
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("RStatusCategory[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

