/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.model.MUOM;
import org.compiere.model.X_C_RfQLineQty;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MRfQLineQty
extends X_C_RfQLineQty {
    private static final long serialVersionUID = 2742007712266317681L;
    private static CCache<Integer, MRfQLineQty> s_cache = new CCache("C_RfQLineQty", 20);
    private MUOM m_uom = null;

    public static MRfQLineQty get(Properties ctx, int C_RfQLineQty_ID, String trxName) {
        Integer key = C_RfQLineQty_ID;
        MRfQLineQty retValue = s_cache.get(key);
        if (retValue != null) {
            return new MRfQLineQty(ctx, retValue, trxName);
        }
        retValue = new MRfQLineQty(ctx, C_RfQLineQty_ID, trxName);
        if (retValue.get_ID() == C_RfQLineQty_ID) {
            s_cache.put(key, new MRfQLineQty(Env.getCtx(), retValue));
            return retValue;
        }
        return null;
    }

    public MRfQLineQty(Properties ctx, String C_RfQLineQty_UU, String trxName) {
        super(ctx, C_RfQLineQty_UU, trxName);
        if (Util.isEmpty(C_RfQLineQty_UU)) {
            this.setInitialDefaults();
        }
    }

    public MRfQLineQty(Properties ctx, int C_RfQLineQty_ID, String trxName) {
        super(ctx, C_RfQLineQty_ID, trxName);
        if (C_RfQLineQty_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsOfferQty(false);
        this.setIsPurchaseQty(false);
        this.setQty(Env.ONE);
    }

    public MRfQLineQty(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRfQLineQty(MRfQLine line) {
        this(line.getCtx(), 0, line.get_TrxName());
        this.setClientOrg(line);
        this.setC_RfQLine_ID(line.getC_RfQLine_ID());
    }

    public MRfQLineQty(MRfQLineQty copy) {
        this(Env.getCtx(), copy);
    }

    public MRfQLineQty(Properties ctx, MRfQLineQty copy) {
        this(ctx, copy, null);
    }

    public MRfQLineQty(Properties ctx, MRfQLineQty copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_uom = copy.m_uom != null ? new MUOM(ctx, copy.m_uom, trxName) : null;
    }

    public String getUomName() {
        if (this.m_uom == null) {
            this.m_uom = MUOM.get(this.getCtx(), this.getC_UOM_ID());
        }
        return this.m_uom.getName();
    }

    public MRfQResponseLineQty[] getResponseQtys(boolean onlyValidAmounts) {
        ArrayList<MRfQResponseLineQty> list;
        block6: {
            list = new ArrayList<MRfQResponseLineQty>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "SELECT * FROM C_RfQResponseLineQty WHERE C_RfQLineQty_ID=? AND IsActive='Y'";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_RfQLineQty_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MRfQResponseLineQty qty = new MRfQResponseLineQty(this.getCtx(), rs, this.get_TrxName());
                        if (onlyValidAmounts && !qty.isValidAmt()) continue;
                        list.add(qty);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MRfQResponseLineQty[] retValue = new MRfQResponseLineQty[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRfQLineQty[");
        sb.append(this.get_ID()).append(",Qty=").append(this.getQty()).append(",Offer=").append(this.isOfferQty()).append(",Purchase=").append(this.isPurchaseQty()).append("]");
        return sb.toString();
    }
}

