/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MGoalRestriction;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.X_PA_MeasureCalc;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MMeasureCalc
extends X_PA_MeasureCalc
implements ImmutablePOSupport {
    private static final long serialVersionUID = -1334100963468705584L;
    private static ImmutableIntPOCache<Integer, MMeasureCalc> s_cache = new ImmutableIntPOCache("PA_MeasureCalc", 10);

    public static MMeasureCalc get(int PA_MeasureCalc_ID) {
        return MMeasureCalc.get(Env.getCtx(), PA_MeasureCalc_ID);
    }

    public static MMeasureCalc get(Properties ctx, int PA_MeasureCalc_ID) {
        Integer key = PA_MeasureCalc_ID;
        MMeasureCalc retValue = s_cache.get(ctx, key, e -> new MMeasureCalc(ctx, (MMeasureCalc)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MMeasureCalc(ctx, PA_MeasureCalc_ID, null);
        if (retValue.get_ID() == PA_MeasureCalc_ID) {
            s_cache.put(key, retValue, e -> new MMeasureCalc(Env.getCtx(), (MMeasureCalc)e));
            return retValue;
        }
        return null;
    }

    public MMeasureCalc(Properties ctx, String PA_MeasureCalc_UU, String trxName) {
        super(ctx, PA_MeasureCalc_UU, trxName);
    }

    public MMeasureCalc(Properties ctx, int PA_MeasureCalc_ID, String trxName) {
        super(ctx, PA_MeasureCalc_ID, trxName);
    }

    public MMeasureCalc(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMeasureCalc(MMeasureCalc copy) {
        this(Env.getCtx(), copy);
    }

    public MMeasureCalc(Properties ctx, MMeasureCalc copy) {
        this(ctx, copy, null);
    }

    public MMeasureCalc(Properties ctx, MMeasureCalc copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public String getSqlPI(MGoalRestriction[] restrictions, String MeasureScope, String MeasureDataType, Timestamp reportDate, MRole role) {
        String sql;
        StringBuilder sb = new StringBuilder(this.getSelectClause()).append(" ").append(this.getWhereClause());
        if (this.getDateColumn() != null && "T".equals(MeasureDataType) && !"0".equals(MeasureScope)) {
            if (reportDate == null) {
                reportDate = new Timestamp(System.currentTimeMillis());
            }
            DB.TO_DATE(reportDate);
            String trunc = "DD";
            if ("1".equals(MeasureScope)) {
                trunc = "Y";
            } else if ("3".equals(MeasureScope)) {
                trunc = "Q";
            } else if ("5".equals(MeasureScope)) {
                trunc = "MM";
            } else if ("7".equals(MeasureScope)) {
                trunc = "D";
            }
            sb.append(" AND TRUNC(").append(this.getDateColumn()).append(",'").append(trunc).append("')=TRUNC(").append(DB.TO_DATE(reportDate)).append(",'").append(trunc).append("')");
        }
        if ((sql = this.addRestrictions(sb.toString(), restrictions, role)).indexOf("@") >= 0) {
            sql = Env.parseContext(this.getCtx(), 0, sql.toString(), false, false);
        }
        this.log.fine(sql);
        return sql;
    }

    public String getSqlBarChart(MGoalRestriction[] restrictions, String MeasureDisplay, Timestamp startDate, MRole role) {
        StringBuilder sb = new StringBuilder();
        String dateCol = null;
        String groupBy = null;
        if (this.getDateColumn() != null && !"0".equals(MeasureDisplay)) {
            String trunc = "D";
            if ("1".equals(MeasureDisplay)) {
                trunc = "Y";
            } else if ("3".equals(MeasureDisplay)) {
                trunc = "Q";
            } else if ("5".equals(MeasureDisplay)) {
                trunc = "MM";
            } else if ("7".equals(MeasureDisplay)) {
                trunc = "W";
            }
            groupBy = dateCol = "TRUNC(" + this.getDateColumn() + ",'" + trunc + "') ";
        } else {
            dateCol = "MAX(" + this.getDateColumn() + ") ";
        }
        String selectFrom = this.getSelectClause();
        int index = selectFrom.indexOf("FROM ");
        if (index == -1) {
            index = selectFrom.toUpperCase().indexOf("FROM ");
        }
        if (index == -1) {
            throw new IllegalArgumentException("Cannot find FROM in sql - " + selectFrom);
        }
        sb.append(selectFrom.substring(0, index)).append(",").append(dateCol).append(selectFrom.substring(index));
        sb.append(" ").append(this.getWhereClause());
        if (this.getDateColumn() != null && startDate != null && !"0".equals(MeasureDisplay)) {
            String dateString = DB.TO_DATE(startDate);
            sb.append(" AND ").append(this.getDateColumn()).append(">=").append(dateString);
        }
        Object sql = this.addRestrictions(sb.toString(), restrictions, role);
        if (groupBy != null) {
            sql = (String)sql + " GROUP BY " + groupBy + " ORDER BY " + groupBy;
        }
        if (((String)sql).indexOf("@") >= 0) {
            sql = Env.parseContext(this.getCtx(), 0, (String)sql, false, false);
        }
        this.log.fine((String)sql);
        return sql;
    }

    public MQuery getQuery(MGoalRestriction[] restrictions, String MeasureDisplay, Timestamp date, MRole role) {
        StringBuilder where;
        MQuery query;
        block18: {
            String finalSQL;
            query = new MQuery(this.getAD_Table_ID());
            StringBuilder sql = new StringBuilder("SELECT ").append(this.getKeyColumn()).append(" ");
            String from = this.getSelectClause();
            int index = from.indexOf("FROM ");
            if (index == -1) {
                throw new IllegalArgumentException("Cannot find FROM " + from);
            }
            sql.append(from.substring(index)).append(" ").append(this.getWhereClause());
            if (this.getDateColumn() != null && !"0".equals(MeasureDisplay)) {
                String trunc = "D";
                if ("1".equals(MeasureDisplay)) {
                    trunc = "Y";
                } else if ("3".equals(MeasureDisplay)) {
                    trunc = "Q";
                } else if ("5".equals(MeasureDisplay)) {
                    trunc = "MM";
                } else if ("7".equals(MeasureDisplay)) {
                    trunc = "W";
                }
                sql.append(" AND TRUNC(").append(this.getDateColumn()).append(",'").append(trunc).append("')=TRUNC(").append(DB.TO_DATE(date)).append(",'").append(trunc).append("')");
            }
            if ((finalSQL = this.addRestrictions(sql.toString(), restrictions, role)).indexOf("@") >= 0) {
                finalSQL = Env.parseContext(this.getCtx(), 0, finalSQL, false, false);
            }
            where = new StringBuilder();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(finalSQL, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int id = rs.getInt(1);
                        if (where.length() > 0) {
                            where.append(",");
                        }
                        where.append(id);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, finalSQL, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block18;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (where.length() == 0) {
            return MQuery.getNoRecordQuery(query.getTableName(), false);
        }
        StringBuilder whereClause = new StringBuilder(this.getKeyColumn()).append(" IN (").append((CharSequence)where).append(")");
        query.addRestriction(whereClause.toString());
        query.setRecordCount(1);
        return query;
    }

    private String addRestrictions(String sql, MGoalRestriction[] restrictions, MRole role) {
        return MMeasureCalc.addRestrictions(sql, false, restrictions, role, this.getTableName(), this.getOrgColumn(), this.getBPartnerColumn(), this.getProductColumn());
    }

    public static String addRestrictions(String sql, boolean queryOnly, MGoalRestriction[] restrictions, MRole role, String tableName, String orgColumn, String bpColumn, String pColumn) {
        int i;
        StringBuilder sb = new StringBuilder(sql);
        if (orgColumn != null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int i2 = 0;
            while (i2 < restrictions.length) {
                if ("O".equals(restrictions[i2].getGoalRestrictionType())) {
                    list.add(restrictions[i2].getOrg_ID());
                }
                ++i2;
            }
            if (list.size() == 1) {
                sb.append(" AND ").append(orgColumn).append("=").append(list.get(0));
            } else if (list.size() > 1) {
                sb.append(" AND ").append(orgColumn).append(" IN (");
                i2 = 0;
                while (i2 < list.size()) {
                    if (i2 > 0) {
                        sb.append(",");
                    }
                    sb.append(list.get(i2));
                    ++i2;
                }
                sb.append(")");
            }
        }
        if (bpColumn != null) {
            ArrayList<Integer> listBP = new ArrayList<Integer>();
            ArrayList<Integer> listBPG = new ArrayList<Integer>();
            i = 0;
            while (i < restrictions.length) {
                if ("B".equals(restrictions[i].getGoalRestrictionType())) {
                    listBP.add(restrictions[i].getC_BPartner_ID());
                }
                if ("G".equals(restrictions[i].getGoalRestrictionType())) {
                    listBPG.add(restrictions[i].getC_BP_Group_ID());
                }
                ++i;
            }
            if (listBP.size() == 1) {
                sb.append(" AND ").append((String)bpColumn).append("=").append(listBP.get(0));
            } else if (listBP.size() > 1) {
                sb.append(" AND ").append((String)bpColumn).append(" IN (");
                i = 0;
                while (i < listBP.size()) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(listBP.get(i));
                    ++i;
                }
                sb.append(")");
            }
            if (((String)bpColumn).indexOf(46) == -1) {
                bpColumn = tableName + "." + (String)bpColumn;
            }
            if (listBPG.size() == 1) {
                sb.append(" AND EXISTS (SELECT * FROM C_BPartner bpx WHERE ").append((String)bpColumn).append("=bpx.C_BPartner_ID AND bpx.C_BP_GROUP_ID=").append(listBPG.get(0)).append(")");
            } else if (listBPG.size() > 1) {
                sb.append(" AND EXISTS (SELECT * FROM C_BPartner bpx WHERE ").append((String)bpColumn).append("=bpx.C_BPartner_ID AND bpx.C_BP_GROUP_ID IN (");
                i = 0;
                while (i < listBPG.size()) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(listBPG.get(i));
                    ++i;
                }
                sb.append("))");
            }
        }
        if (pColumn != null) {
            ArrayList<Integer> listP = new ArrayList<Integer>();
            ArrayList<Integer> listPC = new ArrayList<Integer>();
            i = 0;
            while (i < restrictions.length) {
                if ("P".equals(restrictions[i].getGoalRestrictionType())) {
                    listP.add(restrictions[i].getM_Product_ID());
                }
                if ("C".equals(restrictions[i].getGoalRestrictionType())) {
                    listPC.add(restrictions[i].getM_Product_Category_ID());
                }
                ++i;
            }
            if (listP.size() == 1) {
                sb.append(" AND ").append((String)pColumn).append("=").append(listP.get(0));
            } else if (listP.size() > 1) {
                sb.append(" AND ").append((String)pColumn).append(" IN (");
                i = 0;
                while (i < listP.size()) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(listP.get(i));
                    ++i;
                }
                sb.append(")");
            }
            if (((String)pColumn).indexOf(46) == -1) {
                pColumn = tableName + "." + (String)pColumn;
            }
            if (listPC.size() == 1) {
                sb.append(" AND EXISTS (SELECT * FROM M_Product px WHERE ").append((String)pColumn).append("=px.M_Product_ID AND px.M_Product_Category_ID=").append(listPC.get(0)).append(")");
            } else if (listPC.size() > 1) {
                sb.append(" AND EXISTS (SELECT * FROM M_Product px WHERE ").append((String)pColumn).append("=px.M_Product_ID AND px.M_Product_Category_ID IN (");
                i = 0;
                while (i < listPC.size()) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(listPC.get(i));
                    ++i;
                }
                sb.append("))");
            }
        }
        String finalSQL = sb.toString();
        if (queryOnly) {
            return finalSQL;
        }
        if (role == null) {
            role = MRole.getDefault();
        }
        String retValue = role.addAccessSQL(finalSQL, null, true, false);
        return retValue;
    }

    public String getTableName() {
        return MTable.getTableName(Env.getCtx(), this.getAD_Table_ID());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MMeasureCalc[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    public MMeasureCalc markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    @Override
    public String getWhereClause() {
        Object whereClause = super.getWhereClause();
        if (!((String)whereClause).matches("(?si)\\s*where\\s+.*")) {
            whereClause = "WHERE " + (String)whereClause;
        }
        return whereClause;
    }
}

