/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.adempiere.base.Core;
import org.compiere.model.IImageStore;
import org.compiere.model.MClientInfo;
import org.compiere.model.MStorageProvider;
import org.compiere.model.X_AD_Image;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MImage
extends X_AD_Image
implements ImmutablePOSupport {
    private static final long serialVersionUID = 1850627989276185947L;
    private MStorageProvider provider;
    private static ImmutableIntPOCache<Integer, MImage> s_cache = new ImmutableIntPOCache("AD_Image", 20, 10);
    private Image m_image = null;
    private Icon m_icon = null;

    public static MImage get(int AD_Image_ID) {
        return MImage.get(Env.getCtx(), AD_Image_ID);
    }

    public static MImage get(Properties ctx, int AD_Image_ID) {
        if (AD_Image_ID == 0) {
            return new MImage(ctx, AD_Image_ID, null);
        }
        Integer key = AD_Image_ID;
        MImage retValue = s_cache.get(ctx, key, e -> new MImage(ctx, (MImage)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MImage(ctx, AD_Image_ID, null);
        if (retValue.get_ID() == AD_Image_ID) {
            s_cache.put(key, retValue, e -> new MImage(Env.getCtx(), (MImage)e));
            return retValue;
        }
        return null;
    }

    public static MImage getCopy(Properties ctx, int AD_Image_ID, String trxName) {
        MImage img2 = MImage.get(AD_Image_ID);
        if (img2 != null && img2.getAD_Image_ID() > 0) {
            MStorageProvider copyprov = img2.provider;
            img2 = new MImage(ctx, img2, trxName);
            img2.setStorageProvider(copyprov);
        }
        return img2;
    }

    public MImage(Properties ctx, String AD_Image_UU, String trxName) {
        super(ctx, AD_Image_UU, trxName);
        if (Util.isEmpty(AD_Image_UU)) {
            this.setName("-");
        }
        this.initImageStoreDetails(ctx, trxName);
    }

    public MImage(Properties ctx, int AD_Image_ID, String trxName) {
        super(ctx, AD_Image_ID, trxName);
        if (AD_Image_ID < 1) {
            this.setName("-");
        }
        this.initImageStoreDetails(ctx, trxName);
    }

    public MImage(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.initImageStoreDetails(ctx, trxName);
    }

    public MImage(MImage copy) {
        this(Env.getCtx(), copy);
    }

    public MImage(Properties ctx, MImage copy) {
        this(ctx, copy, null);
    }

    public MImage(Properties ctx, MImage copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public Image getImage() {
        if (this.m_image != null) {
            return this.m_image;
        }
        byte[] data = this.getBinaryData();
        if (data != null && data.length > 0) {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                this.m_image = tk.createImage(data);
                MediaTracker mediaTracker = new MediaTracker(new Container());
                mediaTracker.addImage(this.m_image, 0);
                mediaTracker.waitForID(0);
                return this.m_image;
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "(byteArray)", e);
                return null;
            }
        }
        URL url = this.getURL();
        if (url == null) {
            return null;
        }
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            this.m_image = tk.getImage(url);
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(this.m_image, 0);
            mediaTracker.waitForID(0);
            return this.m_image;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "(URL)", e);
            return null;
        }
    }

    public Icon getIcon() {
        if (this.m_icon != null) {
            return this.m_icon;
        }
        byte[] data = this.getBinaryData();
        if (data != null && data.length > 0) {
            try {
                this.m_icon = new ImageIcon(data, this.getName());
                return this.m_icon;
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "(byteArray)", e);
                return null;
            }
        }
        URL url = this.getURL();
        if (url == null) {
            return null;
        }
        try {
            this.m_icon = new ImageIcon(url, this.getName());
            return this.m_icon;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "(URL)", e);
            return null;
        }
    }

    private URL getURL() {
        String str = this.getImageURL();
        if (str == null || str.length() == 0) {
            return null;
        }
        URL url = null;
        try {
            url = str.indexOf("://") != -1 ? new URL(str) : this.getClass().getResource(str);
            if (url == null && this.log.isLoggable(Level.INFO)) {
                this.log.info("Not found as resource: " + str);
            }
        }
        catch (Exception e) {
            this.log.warning("Not found: " + str + " - " + e.getMessage());
        }
        return url;
    }

    @Override
    public void setImageURL(String ImageURL) {
        this.m_image = null;
        this.m_icon = null;
        super.setImageURL(ImageURL);
    }

    @Override
    public void setBinaryData(byte[] BinaryData) {
        this.m_image = null;
        this.m_icon = null;
        IImageStore prov = this.provider.getImageStore();
        if (prov != null) {
            prov.save(this, this.provider, BinaryData);
        }
    }

    @Override
    public byte[] getBinaryData() {
        IImageStore prov = this.provider.getImageStore();
        if (prov != null) {
            return prov.load(this, this.provider);
        }
        return null;
    }

    public byte[] getData() {
        byte[] data;
        block7: {
            data = this.getBinaryData();
            if (data != null) {
                return data;
            }
            String str = this.getImageURL();
            if (str == null || str.length() == 0) {
                this.log.config("No Image URL");
                return null;
            }
            URL url = this.getURL();
            if (url == null) {
                url = Core.getResourceFinder().getResource(str);
            }
            if (url == null) {
                this.log.config("No URL");
                return null;
            }
            try {
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                InputStream is = conn.getInputStream();
                byte[] buffer = new byte[8192];
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int length = -1;
                while ((length = is.read(buffer)) != -1) {
                    os.write(buffer, 0, length);
                }
                is.close();
                data = os.toByteArray();
                os.close();
            }
            catch (Exception e) {
                if (!this.log.isLoggable(Level.CONFIG)) break block7;
                this.log.config(e.toString());
            }
        }
        return data;
    }

    @Override
    public String toString() {
        StringBuilder msgreturn = new StringBuilder("MImage[ID=").append(this.get_ID()).append(",Name=").append(this.getName()).append("]");
        return msgreturn.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        return true;
    }

    public String getImageStoragePath() {
        StringBuilder path = new StringBuilder("AD_Image").append(File.separator).append(this.getAD_Client_ID()).append(File.separator);
        return path.toString();
    }

    private void initImageStoreDetails(Properties ctx, String trxName) {
        if (this.is_new()) {
            MClientInfo clientInfo = MClientInfo.get(ctx, this.getAD_Client_ID());
            this.setStorageProvider(MStorageProvider.get(ctx, clientInfo.getStorageImage_ID()));
        } else {
            this.setStorageProvider(MStorageProvider.get(ctx, this.getAD_StorageProvider_ID()));
        }
    }

    public void setStorageProvider(MStorageProvider p2) {
        this.provider = p2;
        this.setAD_StorageProvider_ID(p2.getAD_StorageProvider_ID());
    }

    public byte[] getByteData() {
        return super.getBinaryData();
    }

    public void setByteData(byte[] BinaryData) {
        super.setBinaryData(BinaryData);
    }

    @Override
    protected boolean postDelete() {
        IImageStore prov = this.provider.getImageStore();
        if (prov != null) {
            return prov.delete(this, this.provider);
        }
        return true;
    }

    @Override
    protected void saveNew_afterSetID() {
        IImageStore prov = this.provider.getImageStore();
        if (prov != null && prov.isPendingFlush()) {
            prov.flush(this, this.provider);
        }
    }

    @Override
    public MImage markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

