/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.ICostInfo;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostHistory;
import org.compiere.model.MCostQueue;
import org.compiere.model.MDocType;
import org.compiere.model.MMatchInv;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductionLine;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_CostDetail;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MCostDetail
extends X_M_CostDetail {
    private static final long serialVersionUID = -7909571771846993407L;
    protected static final String INOUTLINE_DOCBASETYPE_SQL = "SELECT c.DocBaseType From M_InOut io INNER JOIN M_InOutLine iol ON io.M_InOut_ID=iol.M_InOut_ID INNER JOIN C_DocType c ON io.C_DocType_ID=c.C_DocType_ID WHERE iol.M_InOutLine_ID=?";
    private static CLogger s_log = CLogger.getCLogger(MCostDetail.class);

    @Deprecated
    public static boolean createOrder(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_OrderLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        return MCostDetail.createOrder(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, C_OrderLine_ID, M_CostElement_ID, Amt, Qty, Description, null, 0, trxName);
    }

    public static boolean createOrder(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_OrderLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, Timestamp DateAcct, int Ref_CostDetail_ID, String trxName) {
        MCostDetail cd = MCostDetail.getOrder(as, M_Product_ID, M_AttributeSetInstance_ID, C_OrderLine_ID, M_CostElement_ID, DateAcct, trxName);
        if (cd != null && !cd.isDelta() && Ref_CostDetail_ID > 0) {
            cd.setIsBackDate(true);
        }
        if (cd == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, DateAcct, Ref_CostDetail_ID, trxName);
            cd.setC_OrderLine_ID(C_OrderLine_ID);
        } else {
            if (cd.isProcessed()) {
                cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
                cd.setDeltaQty(Qty.subtract(cd.getQty()));
            } else {
                cd.setDeltaAmt(BigDecimal.ZERO);
                cd.setDeltaQty(BigDecimal.ZERO);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else if (cd.isProcessed()) {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed()) {
            ok = cd.process();
        }
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("(" + ok + ") " + String.valueOf(cd));
        }
        return ok;
    }

    @Deprecated
    public static boolean createInvoice(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_InvoiceLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        return MCostDetail.createInvoice(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, C_InvoiceLine_ID, M_CostElement_ID, Amt, Qty, Description, null, 0, trxName);
    }

    public static boolean createInvoice(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_InvoiceLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, Timestamp DateAcct, int Ref_CostDetail_ID, String trxName) {
        MCostDetail cd = MCostDetail.getInvoice(as, M_Product_ID, M_AttributeSetInstance_ID, C_InvoiceLine_ID, M_CostElement_ID, DateAcct, trxName);
        if (cd != null && !cd.isDelta() && Ref_CostDetail_ID > 0) {
            cd.setIsBackDate(true);
        }
        if (cd == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, DateAcct, Ref_CostDetail_ID, trxName);
            cd.setC_InvoiceLine_ID(C_InvoiceLine_ID);
        } else {
            if (cd.isProcessed()) {
                cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
                cd.setDeltaQty(Qty.subtract(cd.getQty()));
            } else {
                cd.setDeltaAmt(BigDecimal.ZERO);
                cd.setDeltaQty(BigDecimal.ZERO);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else if (cd.isProcessed()) {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed()) {
            ok = cd.process();
        }
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("(" + ok + ") " + String.valueOf(cd));
        }
        return ok;
    }

    @Deprecated
    public static boolean createShipment(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InOutLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, boolean IsSOTrx, String trxName) {
        return MCostDetail.createShipment(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_InOutLine_ID, M_CostElement_ID, Amt, Qty, Description, IsSOTrx, null, 0, trxName);
    }

    public static boolean createShipment(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InOutLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, boolean IsSOTrx, Timestamp DateAcct, int Ref_CostDetail_ID, String trxName) {
        MCostDetail cd = MCostDetail.getShipment(as, M_Product_ID, M_AttributeSetInstance_ID, M_InOutLine_ID, M_CostElement_ID, trxName);
        if (cd == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, DateAcct, Ref_CostDetail_ID, trxName);
            cd.setM_InOutLine_ID(M_InOutLine_ID);
            cd.setIsSOTrx(IsSOTrx);
        } else {
            if (cd.isProcessed()) {
                cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
                cd.setDeltaQty(Qty.subtract(cd.getQty()));
            } else {
                cd.setDeltaAmt(BigDecimal.ZERO);
                cd.setDeltaQty(BigDecimal.ZERO);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else if (cd.isProcessed()) {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed()) {
            ok = cd.process();
        }
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("(" + ok + ") " + String.valueOf(cd));
        }
        return ok;
    }

    @Deprecated
    public static boolean createInventory(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InventoryLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        return MCostDetail.createInventory(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_InventoryLine_ID, M_CostElement_ID, Amt, Qty, Description, null, 0, trxName);
    }

    public static boolean createInventory(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InventoryLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, Timestamp DateAcct, int Ref_CostDetail_ID, String trxName) {
        MCostDetail cd = MCostDetail.getInventory(as, M_Product_ID, M_AttributeSetInstance_ID, M_InventoryLine_ID, M_CostElement_ID, trxName);
        if (cd == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, DateAcct, Ref_CostDetail_ID, trxName);
            cd.setM_InventoryLine_ID(M_InventoryLine_ID);
        } else {
            if (cd.isProcessed()) {
                cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
                cd.setDeltaQty(Qty.subtract(cd.getQty()));
            } else {
                cd.setDeltaAmt(BigDecimal.ZERO);
                cd.setDeltaQty(BigDecimal.ZERO);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else if (cd.isProcessed()) {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed()) {
            ok = cd.process();
        }
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("(" + ok + ") " + String.valueOf(cd));
        }
        return ok;
    }

    @Deprecated
    public static boolean createMovement(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_MovementLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, boolean from, String Description, String trxName) {
        return MCostDetail.createMovement(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_MovementLine_ID, M_CostElement_ID, Amt, Qty, from, Description, null, 0, trxName);
    }

    public static boolean createMovement(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_MovementLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, boolean from, String Description, Timestamp DateAcct, int Ref_CostDetail_ID, String trxName) {
        MCostDetail cd = MCostDetail.getMovement(as, M_Product_ID, M_AttributeSetInstance_ID, M_MovementLine_ID, M_CostElement_ID, from, trxName);
        if (cd == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, DateAcct, Ref_CostDetail_ID, trxName);
            cd.setM_MovementLine_ID(M_MovementLine_ID);
            cd.setIsSOTrx(from);
        } else {
            if (cd.isProcessed()) {
                cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
                cd.setDeltaQty(Qty.subtract(cd.getQty()));
            } else {
                cd.setDeltaAmt(BigDecimal.ZERO);
                cd.setDeltaQty(BigDecimal.ZERO);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else if (cd.isProcessed()) {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed()) {
            ok = cd.process();
        }
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("(" + ok + ") " + String.valueOf(cd));
        }
        return ok;
    }

    @Deprecated
    public static boolean createProduction(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_ProductionLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        return MCostDetail.createProduction(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_ProductionLine_ID, M_CostElement_ID, Amt, Qty, Description, null, 0, trxName);
    }

    public static boolean createProduction(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_ProductionLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, Timestamp DateAcct, int Ref_CostDetail_ID, String trxName) {
        MCostDetail cd = MCostDetail.getProduction(as, M_Product_ID, M_AttributeSetInstance_ID, M_ProductionLine_ID, M_CostElement_ID, trxName);
        if (cd == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, DateAcct, Ref_CostDetail_ID, trxName);
            cd.setM_ProductionLine_ID(M_ProductionLine_ID);
        } else {
            if (cd.isProcessed()) {
                cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
                cd.setDeltaQty(Qty.subtract(cd.getQty()));
            } else {
                cd.setDeltaAmt(BigDecimal.ZERO);
                cd.setDeltaQty(BigDecimal.ZERO);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else if (cd.isProcessed()) {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed()) {
            ok = cd.process();
        }
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("(" + ok + ") " + String.valueOf(cd));
        }
        return ok;
    }

    @Deprecated
    public static boolean createMatchInvoice(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_MatchInv_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        return MCostDetail.createMatchInvoice(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_MatchInv_ID, M_CostElement_ID, Amt, Qty, Description, null, 0, trxName);
    }

    public static boolean createMatchInvoice(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_MatchInv_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, Timestamp DateAcct, int Ref_CostDetail_ID, String trxName) {
        MCostDetail cd = MCostDetail.getMatchInvoice(as, M_Product_ID, M_AttributeSetInstance_ID, M_MatchInv_ID, M_CostElement_ID, trxName);
        if (cd == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, DateAcct, Ref_CostDetail_ID, trxName);
            cd.setM_MatchInv_ID(M_MatchInv_ID);
        } else {
            if (cd.isProcessed()) {
                cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
                cd.setDeltaQty(Qty.subtract(cd.getQty()));
            } else {
                cd.setDeltaAmt(BigDecimal.ZERO);
                cd.setDeltaQty(BigDecimal.ZERO);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else if (cd.isProcessed()) {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed()) {
            ok = cd.process();
        }
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("(" + ok + ") " + String.valueOf(cd));
        }
        return ok;
    }

    @Deprecated
    public static boolean createProjectIssue(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_ProjectIssue_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        return MCostDetail.createProjectIssue(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, C_ProjectIssue_ID, M_CostElement_ID, Amt, Qty, Description, null, 0, trxName);
    }

    public static boolean createProjectIssue(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_ProjectIssue_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, Timestamp DateAcct, int Ref_CostDetail_ID, String trxName) {
        MCostDetail cd = MCostDetail.getProjectIssue(as, M_Product_ID, M_AttributeSetInstance_ID, C_ProjectIssue_ID, M_CostElement_ID, trxName);
        if (cd == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, DateAcct, Ref_CostDetail_ID, trxName);
            cd.setC_ProjectIssue_ID(C_ProjectIssue_ID);
        } else {
            if (cd.isProcessed()) {
                cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
                cd.setDeltaQty(Qty.subtract(cd.getQty()));
            } else {
                cd.setDeltaAmt(BigDecimal.ZERO);
                cd.setDeltaQty(BigDecimal.ZERO);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else if (cd.isProcessed()) {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed()) {
            ok = cd.process();
        }
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("(" + ok + ") " + String.valueOf(cd));
        }
        return ok;
    }

    public static MCostDetail getOrder(MAcctSchema as, int M_Product_ID, int M_AttributeSetInstance_ID, int C_OrderLine_ID, int M_CostElement_ID, Timestamp DateAcct, String trxName) {
        MCostDetail cd = MCostDetail.get(as.getCtx(), "C_OrderLine_ID=? AND Coalesce(M_CostElement_ID,0)=" + M_CostElement_ID + " AND TRUNC(DateAcct)=" + DB.TO_DATE(DateAcct, true), C_OrderLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName);
        if (cd == null && (cd = MCostDetail.get(as.getCtx(), "C_OrderLine_ID=? AND Coalesce(M_CostElement_ID,0)=" + M_CostElement_ID, C_OrderLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) != null && !cd.isDelta()) {
            cd = null;
        }
        return cd;
    }

    public static MCostDetail getInvoice(MAcctSchema as, int M_Product_ID, int M_AttributeSetInstance_ID, int C_InvoiceLine_ID, int M_CostElement_ID, Timestamp DateAcct, String trxName) {
        MCostDetail cd = MCostDetail.get(as.getCtx(), "C_InvoiceLine_ID=? AND Coalesce(M_CostElement_ID,0)=" + M_CostElement_ID + " AND M_Product_ID=" + M_Product_ID + " AND TRUNC(DateAcct)=" + DB.TO_DATE(DateAcct, true), C_InvoiceLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName);
        if (cd == null && (cd = MCostDetail.get(as.getCtx(), "C_InvoiceLine_ID=? AND Coalesce(M_CostElement_ID,0)=" + M_CostElement_ID + " AND M_Product_ID=" + M_Product_ID, C_InvoiceLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) != null && !cd.isDelta()) {
            cd = null;
        }
        return cd;
    }

    public static MCostDetail getShipment(MAcctSchema as, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InOutLine_ID, int M_CostElement_ID, String trxName) {
        return MCostDetail.get(as.getCtx(), "M_InOutLine_ID=? AND Coalesce(M_CostElement_ID,0)=" + M_CostElement_ID, M_InOutLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName);
    }

    public static MCostDetail getInventory(MAcctSchema as, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InventoryLine_ID, int M_CostElement_ID, String trxName) {
        return MCostDetail.get(as.getCtx(), "M_InventoryLine_ID=? AND Coalesce(M_CostElement_ID,0)=" + M_CostElement_ID + " AND M_Product_ID=" + M_Product_ID, M_InventoryLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName);
    }

    public static MCostDetail getMovement(MAcctSchema as, int M_Product_ID, int M_AttributeSetInstance_ID, int M_MovementLine_ID, int M_CostElement_ID, boolean from, String trxName) {
        StringBuilder msget = new StringBuilder("M_MovementLine_ID=? AND IsSOTrx=").append(from ? "'Y'" : "'N'").append(" AND Coalesce(M_CostElement_ID,0)=").append(M_CostElement_ID);
        return MCostDetail.get(as.getCtx(), msget.toString(), M_MovementLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName);
    }

    public static MCostDetail getProduction(MAcctSchema as, int M_Product_ID, int M_AttributeSetInstance_ID, int M_ProductionLine_ID, String trxName) {
        return MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=?", M_ProductionLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName);
    }

    public static MCostDetail getProduction(MAcctSchema as, int M_Product_ID, int M_AttributeSetInstance_ID, int M_ProductionLine_ID, int M_CostElement_ID, String trxName) {
        return MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=? AND Coalesce(M_CostElement_ID,0)=" + M_CostElement_ID, M_ProductionLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName);
    }

    public static MCostDetail getMatchInvoice(MAcctSchema as, int M_Product_ID, int M_AttributeSetInstance_ID, int M_MatchInv_ID, int M_CostElement_ID, String trxName) {
        return MCostDetail.get(as.getCtx(), "M_MatchInv_ID=? AND Coalesce(M_CostElement_ID,0)=" + M_CostElement_ID, M_MatchInv_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName);
    }

    public static MCostDetail getProjectIssue(MAcctSchema as, int M_Product_ID, int M_AttributeSetInstance_ID, int C_ProjectIssue_ID, int M_CostElement_ID, String trxName) {
        return MCostDetail.get(as.getCtx(), "C_ProjectIssue_ID=? AND Coalesce(M_CostElement_ID,0)=" + M_CostElement_ID, C_ProjectIssue_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName);
    }

    @Deprecated
    public static MCostDetail get(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, String trxName) {
        MCostDetail retValue;
        block8: {
            int C_AcctSchema_ID;
            StringBuilder sql = new StringBuilder("SELECT * FROM M_CostDetail WHERE ").append(whereClause);
            MClientInfo clientInfo = MClientInfo.get(ctx);
            MAcctSchema primary = clientInfo.getMAcctSchema1();
            int n = C_AcctSchema_ID = primary != null ? primary.getC_AcctSchema_ID() : 0;
            if (C_AcctSchema_ID > 0) {
                sql.append(" AND C_AcctSchema_ID=?");
            }
            retValue = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, ID);
                    pstmt.setInt(2, M_AttributeSetInstance_ID);
                    if (C_AcctSchema_ID > 0) {
                        pstmt.setInt(3, C_AcctSchema_ID);
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        retValue = new MCostDetail(ctx, rs, trxName);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, String.valueOf(sql) + " - " + ID, e);
                    DB.close(rs, pstmt);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        return retValue;
    }

    public static MCostDetail get(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, int C_AcctSchema_ID, String trxName) {
        StringBuilder localWhereClause = new StringBuilder(whereClause).append(" AND M_AttributeSetInstance_ID=?").append(" AND C_AcctSchema_ID=?");
        MCostDetail retValue = (MCostDetail)new Query(ctx, "M_CostDetail", localWhereClause.toString(), trxName).setParameters(ID, M_AttributeSetInstance_ID, C_AcctSchema_ID).first();
        return retValue;
    }

    public static List<MCostDetail> list(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, int C_AcctSchema_ID, String trxName) {
        StringBuilder localWhereClause = new StringBuilder(whereClause).append(" AND M_AttributeSetInstance_ID=?").append(" AND C_AcctSchema_ID=?");
        List<MCostDetail> retValue = new Query(ctx, "M_CostDetail", localWhereClause.toString(), trxName).setParameters(ID, M_AttributeSetInstance_ID, C_AcctSchema_ID).list();
        return retValue;
    }

    public static boolean processProduct(MProduct product, String trxName) {
        int counterOK = 0;
        int counterError = 0;
        List list = new Query(product.getCtx(), "M_CostDetail", "M_CostDetail.M_Product_ID=? AND M_CostDetail.Processed=?", trxName).addJoinClause(" LEFT JOIN M_CostDetail refcd ON (refcd.M_CostDetail_ID=M_CostDetail.Ref_CostDetail_ID) ").setParameters(product.getM_Product_ID(), false).setOrderBy("M_CostDetail.C_AcctSchema_ID, M_CostDetail.M_CostElement_ID, M_CostDetail.AD_Org_ID, M_CostDetail.M_AttributeSetInstance_ID, M_CostDetail.DateAcct, CASE WHEN COALESCE(refcd.DateAcct,M_CostDetail.DateAcct) = M_CostDetail.DateAcct THEN COALESCE(M_CostDetail.Ref_CostDetail_ID,M_CostDetail.M_CostDetail_ID) ELSE M_CostDetail.M_CostDetail_ID END, M_CostDetail.M_CostDetail_ID").list();
        for (MCostDetail cd : list) {
            if (cd.process()) {
                ++counterOK;
                continue;
            }
            ++counterError;
        }
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("OK=" + counterOK + ", Errors=" + counterError);
        }
        return counterError == 0;
    }

    public static boolean processProduct(MAcctSchema as, MProduct product, Timestamp dateAcct, String trxName) {
        if (dateAcct == null) {
            dateAcct = TimeUtil.getDay(System.currentTimeMillis());
        }
        int counterOK = 0;
        int counterError = 0;
        List list = new Query(product.getCtx(), "M_CostDetail", "M_CostDetail.C_AcctSchema_ID=? AND M_CostDetail.M_Product_ID=? AND M_CostDetail.DateAcct<=? AND M_CostDetail.Processed=?", trxName).addJoinClause(" LEFT JOIN M_CostDetail refcd ON (refcd.M_CostDetail_ID=M_CostDetail.Ref_CostDetail_ID) ").setParameters(as.getC_AcctSchema_ID(), product.getM_Product_ID(), dateAcct, false).setOrderBy("M_CostDetail.M_CostElement_ID, M_CostDetail.AD_Org_ID, M_CostDetail.M_AttributeSetInstance_ID, M_CostDetail.DateAcct, CASE WHEN COALESCE(refcd.DateAcct,M_CostDetail.DateAcct) = M_CostDetail.DateAcct THEN COALESCE(M_CostDetail.Ref_CostDetail_ID,M_CostDetail.M_CostDetail_ID) ELSE M_CostDetail.M_CostDetail_ID END, M_CostDetail.M_CostDetail_ID").list();
        for (MCostDetail cd : list) {
            if (cd.process()) {
                ++counterOK;
                continue;
            }
            ++counterError;
        }
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("OK=" + counterOK + ", Errors=" + counterError);
        }
        return counterError == 0;
    }

    public MCostDetail(Properties ctx, String M_CostDetail_UU, String trxName) {
        super(ctx, M_CostDetail_UU, trxName);
        if (Util.isEmpty(M_CostDetail_UU)) {
            this.setInitialDefaults();
        }
    }

    public MCostDetail(Properties ctx, int M_CostDetail_ID, String trxName) {
        super(ctx, M_CostDetail_ID, trxName);
        if (M_CostDetail_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setM_AttributeSetInstance_ID(0);
        this.setProcessed(false);
        this.setAmt(Env.ZERO);
        this.setQty(Env.ZERO);
        this.setIsSOTrx(false);
        this.setDeltaAmt(Env.ZERO);
        this.setDeltaQty(Env.ZERO);
    }

    public MCostDetail(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Deprecated
    public MCostDetail(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_CostElement_ID, BigDecimal amt, BigDecimal qty, String description, String trxName) {
        this(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, amt, qty, description, null, 0, trxName);
    }

    public MCostDetail(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_CostElement_ID, BigDecimal amt, BigDecimal qty, String description, Timestamp dateAcct, int Ref_CostDetail_ID, String trxName) {
        this(as.getCtx(), 0, trxName);
        this.setClientOrg(as.getAD_Client_ID(), AD_Org_ID);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_CostElement_ID(M_CostElement_ID);
        this.setAmt(amt);
        this.setQty(qty);
        this.setDescription(description);
        this.setDateAcct(dateAcct);
        if (Ref_CostDetail_ID > 0) {
            this.setRef_CostDetail_ID(Ref_CostDetail_ID);
        }
    }

    @Override
    public void setAmt(BigDecimal Amt) {
        if (this.isProcessed()) {
            throw new IllegalStateException("Cannot change Amt - processed");
        }
        if (Amt == null) {
            super.setAmt(Env.ZERO);
        } else {
            super.setAmt(Amt);
        }
    }

    @Override
    public void setQty(BigDecimal Qty) {
        if (this.isProcessed()) {
            throw new IllegalStateException("Cannot change Qty - processed");
        }
        if (Qty == null) {
            super.setQty(Env.ZERO);
        } else {
            super.setQty(Qty);
        }
    }

    public boolean isOrder() {
        return this.getC_OrderLine_ID() != 0;
    }

    public boolean isInvoice() {
        return this.getC_InvoiceLine_ID() != 0;
    }

    public boolean isShipment() {
        return this.isSOTrx() && this.getM_InOutLine_ID() != 0;
    }

    public boolean isVendorRMA() {
        if (!this.isSOTrx() && this.getM_InOutLine_ID() > 0) {
            String docBaseType = DB.getSQLValueString(null, INOUTLINE_DOCBASETYPE_SQL, this.getM_InOutLine_ID());
            return "MMS".equals(docBaseType);
        }
        return false;
    }

    public boolean isDelta() {
        return this.getDeltaAmt().signum() != 0 || this.getDeltaQty().signum() != 0;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord) {
            Timestamp today = TimeUtil.getDay(System.currentTimeMillis());
            Timestamp dateAcct = this.getDateAcct();
            if (dateAcct == null) {
                this.setDateAcct(today);
                this.setIsBackDate(false);
            } else {
                int Ref_CostDetail_ID = this.getRef_CostDetail_ID();
                if (Ref_CostDetail_ID > 0) {
                    this.setDateAcct(dateAcct);
                    this.setIsBackDate(true);
                } else {
                    Timestamp MaxDateAcct = DB.getSQLValueTS(this.get_TrxName(), "SELECT MAX(DateAcct) FROM M_CostDetail WHERE M_Product_ID=? AND Processed='Y'", this.getM_Product_ID());
                    if (MaxDateAcct != null && MaxDateAcct.after(today)) {
                        today = MaxDateAcct;
                    }
                    this.setDateAcct(dateAcct);
                    this.setIsBackDate(dateAcct.before(today));
                }
            }
        } else if (this.is_ValueChanged("DateAcct")) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotChangeAccountDate"));
            return false;
        }
        return super.beforeSave(newRecord);
    }

    @Override
    protected boolean beforeDelete() {
        return !this.isProcessed();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MCostDetail[");
        sb.append(this.get_ID());
        if (this.getC_OrderLine_ID() != 0) {
            sb.append(",C_OrderLine_ID=").append(this.getC_OrderLine_ID());
        }
        if (this.getM_InOutLine_ID() != 0) {
            sb.append(",M_InOutLine_ID=").append(this.getM_InOutLine_ID());
        }
        if (this.getC_InvoiceLine_ID() != 0) {
            sb.append(",C_InvoiceLine_ID=").append(this.getC_InvoiceLine_ID());
        }
        if (this.getC_ProjectIssue_ID() != 0) {
            sb.append(",C_ProjectIssue_ID=").append(this.getC_ProjectIssue_ID());
        }
        if (this.getM_MovementLine_ID() != 0) {
            sb.append(",M_MovementLine_ID=").append(this.getM_MovementLine_ID());
        }
        if (this.getM_InventoryLine_ID() != 0) {
            sb.append(",M_InventoryLine_ID=").append(this.getM_InventoryLine_ID());
        }
        if (this.getM_ProductionLine_ID() != 0) {
            sb.append(",M_ProductionLine_ID=").append(this.getM_ProductionLine_ID());
        }
        sb.append(",Amt=").append(this.getAmt()).append(",Qty=").append(this.getQty());
        if (this.isDelta()) {
            sb.append(",DeltaAmt=").append(this.getDeltaAmt()).append(",DeltaQty=").append(this.getDeltaQty());
        }
        sb.append("]");
        return sb.toString();
    }

    public synchronized boolean process() {
        if (this.isProcessed()) {
            this.log.info("Already processed");
            return true;
        }
        boolean ok = false;
        MAcctSchema as = MAcctSchema.get(this.getCtx(), this.getC_AcctSchema_ID());
        MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        String CostingLevel = product.getCostingLevel(as);
        int Org_ID = this.getAD_Org_ID();
        int M_ASI_ID = this.getM_AttributeSetInstance_ID();
        if ("C".equals(CostingLevel)) {
            Org_ID = 0;
            M_ASI_ID = 0;
        } else if ("O".equals(CostingLevel)) {
            M_ASI_ID = 0;
        } else if ("B".equals(CostingLevel)) {
            Org_ID = 0;
        }
        if (this.getM_CostElement_ID() == 0) {
            MCostElement[] ces = MCostElement.getCostingMethods(this);
            int i2 = 0;
            while (i2 < ces.length) {
                MCostElement ce = ces[i2];
                if ((ce.isAverageInvoice() || ce.isAveragePO() || ce.isLifo() || ce.isFifo()) && !product.isStocked() || (ok = this.process(as, product, ce, Org_ID, M_ASI_ID))) {
                    ++i2;
                    continue;
                }
                break;
            }
        } else {
            MCostElement ce = MCostElement.get(this.getCtx(), this.getM_CostElement_ID());
            if (ce.getCostingMethod() == null) {
                MCostElement[] ces;
                MCostElement[] mCostElementArray = ces = MCostElement.getCostingMethods(this);
                int n = ces.length;
                int n2 = 0;
                while (n2 < n) {
                    MCostElement costingElement = mCostElementArray[n2];
                    if ((costingElement.isAverageInvoice() || costingElement.isAveragePO() || costingElement.isLifo() || costingElement.isFifo()) && !product.isStocked() || (ok = this.process(as, product, costingElement, Org_ID, M_ASI_ID))) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else if (ce.isAverageInvoice() || ce.isAveragePO() || ce.isLifo() || ce.isFifo()) {
                if (product.isStocked()) {
                    ok = this.process(as, product, ce, Org_ID, M_ASI_ID);
                }
            } else {
                ok = this.process(as, product, ce, Org_ID, M_ASI_ID);
            }
        }
        if (ok) {
            this.setDeltaAmt(null);
            this.setDeltaQty(null);
            this.setProcessed(true);
            ok = this.save();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(ok + " - " + this.toString());
        }
        return ok;
    }

    protected boolean process(MAcctSchema as, MProduct product, MCostElement ce, int Org_ID, int M_ASI_ID) {
        MCostElement thisCostElement;
        String costingMethod = product.getCostingMethod(as);
        if ("I".equals(costingMethod) ? ce.isAveragePO() : "A".equals(costingMethod) && ce.isAverageInvoice()) {
            return true;
        }
        MCost cost = MCost.get(product, M_ASI_ID, as, Org_ID, ce.getM_CostElement_ID(), this.get_TrxName());
        ICostInfo costInfo = MCost.getCostInfo(product.getCtx(), product.getAD_Client_ID(), Org_ID, product.getM_Product_ID(), as.getM_CostType_ID(), as.getC_AcctSchema_ID(), ce.getM_CostElement_ID(), M_ASI_ID, this.getDateAcct(), this, this.get_TrxName());
        if (costInfo != null) {
            cost.setCurrentQty(costInfo.getCurrentQty());
            cost.setCurrentCostPrice(costInfo.getCurrentCostPrice());
            cost.setCumulatedQty(costInfo.getCumulatedQty());
            cost.setCumulatedAmt(costInfo.getCumulatedAmt());
        }
        DB.getDatabase().forUpdate(cost, 120);
        MCostHistory history = new MCostHistory(this, cost, ce);
        BigDecimal qty = Env.ZERO;
        BigDecimal amt = Env.ZERO;
        if (this.isDelta()) {
            qty = this.getDeltaQty();
            amt = this.getDeltaAmt();
        } else {
            qty = this.getQty();
            amt = this.getAmt();
        }
        boolean costAdjustment = false;
        if (this.getM_CostElement_ID() > 0 && this.getM_CostElement_ID() != ce.getM_CostElement_ID() && (thisCostElement = MCostElement.get(this.getCtx(), this.getM_CostElement_ID())).getCostingMethod() == null && ce.getCostingMethod() != null) {
            qty = BigDecimal.ZERO;
            costAdjustment = true;
        }
        int precision = as.getCostingPrecision();
        BigDecimal price = amt;
        if (qty.signum() != 0) {
            price = amt.divide(qty, precision, RoundingMode.HALF_UP);
        }
        if (this.getC_OrderLine_ID() != 0) {
            boolean isReturnTrx;
            boolean bl = isReturnTrx = qty.signum() < 0;
            if (ce.isAveragePO()) {
                cost.setWeightedAverage(amt, qty);
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("PO - AveragePO - " + String.valueOf(cost));
                }
            } else if (ce.isLastPOPrice() && !costAdjustment) {
                if (!isReturnTrx) {
                    if (qty.signum() != 0) {
                        cost.setCurrentCostPrice(price);
                    } else {
                        BigDecimal cCosts = cost.getCurrentCostPrice().add(amt);
                        cost.setCurrentCostPrice(cCosts);
                    }
                }
                cost.add(amt, qty);
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("PO - LastPO - " + String.valueOf(cost));
                }
            } else if (ce.isStandardCosting() && !costAdjustment) {
                if (cost.getCurrentCostPrice().signum() == 0 && cost.getCurrentCostPriceLL().signum() == 0) {
                    cost.setCurrentCostPrice(price);
                    if (cost.getCurrentCostPrice().signum() == 0) {
                        cost.setCurrentCostPrice(MCost.getSeedCosts(product, M_ASI_ID, as, Org_ID, ce.getCostingMethod(), this.getC_OrderLine_ID()));
                    }
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("PO - Standard - CurrentCostPrice(seed)=" + String.valueOf(cost.getCurrentCostPrice()) + ", price=" + String.valueOf(price));
                    }
                }
                cost.add(amt, qty);
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("PO - Standard - " + String.valueOf(cost));
                }
            } else if (ce.isUserDefined()) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("PO - UserDef - " + String.valueOf(cost));
                }
            } else if (!ce.isCostingMethod() && this.log.isLoggable(Level.FINER)) {
                this.log.finer("PO - " + String.valueOf(ce) + " - " + String.valueOf(cost));
            }
        } else if (this.getC_InvoiceLine_ID() != 0) {
            boolean isReturnTrx;
            boolean bl = isReturnTrx = qty.signum() < 0;
            if (ce.isAverageInvoice()) {
                cost.setWeightedAverage(amt, qty);
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Inv - AverageInv - " + String.valueOf(cost));
                }
            } else if (ce.isAveragePO() && costAdjustment) {
                cost.setWeightedAverage(amt, qty);
            } else if (ce.isFifo() || ce.isLifo()) {
                MCostQueue cq = MCostQueue.get(product, this.getM_AttributeSetInstance_ID(), as, Org_ID, ce.getM_CostElement_ID(), this.get_TrxName());
                cq.setCosts(amt, qty, precision);
                cq.saveEx();
                MCostQueue[] cQueue = MCostQueue.getQueue(product, M_ASI_ID, as, Org_ID, ce, this.get_TrxName());
                if (cQueue != null && cQueue.length > 0) {
                    cost.setCurrentCostPrice(cQueue[0].getCurrentCostPrice());
                }
                cost.add(amt, qty);
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Inv - FiFo/LiFo - " + String.valueOf(cost));
                }
            } else if (ce.isLastInvoice() && !costAdjustment) {
                if (!isReturnTrx) {
                    if (qty.signum() != 0) {
                        cost.setCurrentCostPrice(price);
                    } else {
                        BigDecimal cCosts = cost.getCurrentCostPrice().add(amt);
                        cost.setCurrentCostPrice(cCosts);
                    }
                }
                cost.add(amt, qty);
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Inv - LastInv - " + String.valueOf(cost));
                }
            } else if (ce.isStandardCosting() && !costAdjustment) {
                if (cost.getCurrentCostPrice().signum() == 0 && cost.getCurrentCostPriceLL().signum() == 0) {
                    cost.setCurrentCostPrice(price);
                    if (cost.getCurrentCostPrice().signum() == 0) {
                        cost.setCurrentCostPrice(MCost.getSeedCosts(product, M_ASI_ID, as, Org_ID, ce.getCostingMethod(), this.getC_OrderLine_ID()));
                        if (this.log.isLoggable(Level.FINEST)) {
                            this.log.finest("Inv - Standard - CurrentCostPrice(seed)=" + String.valueOf(cost.getCurrentCostPrice()) + ", price=" + String.valueOf(price));
                        }
                    }
                    cost.add(amt, qty);
                }
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Inv - Standard - " + String.valueOf(cost));
                }
            } else if (ce.isUserDefined()) {
                cost.add(amt, qty);
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Inv - UserDef - " + String.valueOf(cost));
                }
            }
        } else if (this.getM_InOutLine_ID() != 0 && costAdjustment) {
            if (ce.isAverageInvoice()) {
                cost.setWeightedAverage(amt, qty);
            }
        } else if (this.getM_InOutLine_ID() != 0 || this.getM_MovementLine_ID() != 0 || this.getM_InventoryLine_ID() != 0 || this.getM_ProductionLine_ID() != 0 || this.getC_ProjectIssue_ID() != 0 || this.getPP_Cost_Collector_ID() != 0) {
            boolean addition = qty.signum() > 0;
            boolean adjustment = this.getM_InventoryLine_ID() > 0 && qty.signum() == 0 && amt.signum() != 0;
            boolean isVendorRMA = this.isVendorRMA();
            if (ce.isAverageInvoice()) {
                if (!isVendorRMA) {
                    if (adjustment) {
                        costingMethod = this.getM_InventoryLine().getM_Inventory().getCostingMethod();
                        if ("I".equals(costingMethod)) {
                            if (cost.getCurrentQty().signum() == 0 && qty.signum() == 0) {
                                cost.setWeightedAverageInitial(amt);
                            } else {
                                cost.setWeightedAverage(amt.multiply(cost.getCurrentQty()), qty);
                            }
                        }
                    } else if (addition) {
                        cost.setWeightedAverage(amt, qty);
                        if (this.isShipment()) {
                            cost.setCumulatedQty(history.getOldCQty());
                            cost.setCumulatedAmt(history.getOldCAmt());
                        }
                    } else {
                        cost.setCurrentQty(cost.getCurrentQty().add(qty));
                    }
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer("QtyAdjust - AverageInv - " + String.valueOf(cost));
                    }
                }
            } else if (ce.isAveragePO()) {
                if (adjustment) {
                    costingMethod = this.getM_InventoryLine().getM_Inventory().getCostingMethod();
                    if ("A".equals(costingMethod)) {
                        if (cost.getCurrentQty().signum() == 0 && qty.signum() == 0) {
                            cost.setWeightedAverageInitial(amt);
                        } else {
                            cost.setWeightedAverage(amt.multiply(cost.getCurrentQty()), qty);
                        }
                    }
                } else if (addition) {
                    cost.setWeightedAverage(amt, qty);
                    if (this.isShipment() && !this.isVendorRMA()) {
                        cost.setCumulatedQty(history.getOldCQty());
                        cost.setCumulatedAmt(history.getOldCAmt());
                    }
                } else if (isVendorRMA) {
                    cost.setWeightedAverage(amt, qty);
                } else {
                    cost.setCurrentQty(cost.getCurrentQty().add(qty));
                }
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("QtyAdjust - AveragePO - " + String.valueOf(cost));
                }
            } else if (ce.isFifo() || ce.isLifo()) {
                if (!isVendorRMA && !adjustment) {
                    if (addition) {
                        MCostQueue cq = MCostQueue.get(product, this.getM_AttributeSetInstance_ID(), as, Org_ID, ce.getM_CostElement_ID(), this.get_TrxName());
                        cq.setCosts(amt, qty, precision);
                        cq.saveEx();
                    } else {
                        MCostQueue.adjustQty(product, M_ASI_ID, as, Org_ID, ce, qty.negate(), this.get_TrxName());
                    }
                    MCostQueue[] cQueue = MCostQueue.getQueue(product, M_ASI_ID, as, Org_ID, ce, this.get_TrxName());
                    if (cQueue != null && cQueue.length > 0) {
                        cost.setCurrentCostPrice(cQueue[0].getCurrentCostPrice());
                    }
                    cost.setCurrentQty(cost.getCurrentQty().add(qty));
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer("QtyAdjust - FiFo/Lifo - " + String.valueOf(cost));
                    }
                }
            } else if (ce.isLastInvoice() && !isVendorRMA && !adjustment) {
                cost.setCurrentQty(cost.getCurrentQty().add(qty));
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("QtyAdjust - LastInv - " + String.valueOf(cost));
                }
            } else if (ce.isLastPOPrice() && !isVendorRMA && !adjustment) {
                cost.setCurrentQty(cost.getCurrentQty().add(qty));
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("QtyAdjust - LastPO - " + String.valueOf(cost));
                }
            } else if (ce.isStandardCosting() && !isVendorRMA) {
                if (adjustment) {
                    costingMethod = this.getM_InventoryLine().getM_Inventory().getCostingMethod();
                    if ("S".equals(costingMethod)) {
                        cost.add(amt.multiply(cost.getCurrentQty()), qty);
                        cost.setCurrentCostPrice(cost.getCurrentCostPrice().add(amt));
                    }
                } else if (addition) {
                    MProductionLine productionLine;
                    MProductionLine mProductionLine = productionLine = this.getM_ProductionLine_ID() > 0 ? new MProductionLine(this.getCtx(), this.getM_ProductionLine_ID(), this.get_TrxName()) : null;
                    if (productionLine != null && productionLine.getProductionReversalId() > 0) {
                        cost.setCurrentQty(cost.getCurrentQty().add(qty));
                    } else {
                        cost.add(amt, qty);
                    }
                    if (cost.getCurrentCostPrice().signum() == 0 && cost.getCurrentCostPriceLL().signum() == 0 && cost.is_new()) {
                        cost.setCurrentCostPrice(price);
                        if (this.log.isLoggable(Level.FINEST)) {
                            this.log.finest("QtyAdjust - Standard - CurrentCostPrice=" + String.valueOf(price));
                        }
                    }
                } else {
                    cost.setCurrentQty(cost.getCurrentQty().add(qty));
                }
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("QtyAdjust - Standard - " + String.valueOf(cost));
                }
            } else if (ce.isUserDefined() && !isVendorRMA && !adjustment) {
                if (addition) {
                    cost.add(amt, qty);
                } else {
                    cost.setCurrentQty(cost.getCurrentQty().add(qty));
                }
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("QtyAdjust - UserDef - " + String.valueOf(cost));
                }
            } else if (!ce.isCostingMethod()) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("QtyAdjust - ?none? - " + String.valueOf(cost));
                }
            } else if (ce.isStandardCosting() && isVendorRMA) {
                cost.add(amt, qty);
            } else {
                this.log.warning("QtyAdjust - " + String.valueOf(ce) + " - " + String.valueOf(cost));
            }
        } else if (this.getM_MatchInv_ID() > 0) {
            if (ce.isAveragePO()) {
                cost.setWeightedAverage(amt, qty);
            }
        } else {
            this.log.warning("Unknown Type: " + this.toString());
            return false;
        }
        if (as.getCostingMethod().equals(ce.getCostingMethod())) {
            this.setCurrentCostPrice(cost.getCurrentCostPrice());
            this.setCurrentQty(cost.getCurrentQty());
            this.setCumulatedAmt(cost.getCumulatedAmt());
            this.setCumulatedQty(cost.getCumulatedQty());
        }
        history.setNewQty(cost.getCurrentQty());
        history.setNewCostPrice(cost.getCurrentCostPrice());
        history.setNewCAmt(cost.getCumulatedAmt());
        history.setNewCQty(cost.getCumulatedQty());
        if ((history.getNewQty().compareTo(history.getOldQty()) != 0 || history.getNewCostPrice().compareTo(history.getOldCostPrice()) != 0 || ce.isAveragePO() || ce.isAverageInvoice()) && !history.save()) {
            return false;
        }
        return cost.save();
    }

    public static void periodClosedCheckForDocsAfterBackDateTrx(int AD_Client_ID, int C_AcctSchema_ID, int M_Product_ID, int M_CostDetail_ID, Timestamp DateAcct, String trxName) {
        ArrayList<CallSite> repostedRecordIds = new ArrayList<CallSite>();
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT mpo.M_MatchPO_ID, il.C_Invoice_ID, iol.M_InOut_ID, mi.M_MatchInv_ID, invl.M_Inventory_ID, ");
        selectSql.append("ml.M_Movement_ID, pl.M_Production_ID, pi.C_ProjectIssue_ID ");
        selectSql.append("FROM M_CostDetail cd ");
        selectSql.append("LEFT JOIN M_CostDetail refcd ON (refcd.M_CostDetail_ID=cd.Ref_CostDetail_ID) ");
        selectSql.append("LEFT JOIN M_MatchPO mpo ON (mpo.C_OrderLine_ID = cd.C_OrderLine_ID) ");
        selectSql.append("LEFT JOIN C_InvoiceLine il ON (il.C_InvoiceLine_ID = cd.C_InvoiceLine_ID) ");
        selectSql.append("LEFT JOIN M_InOutLine iol ON (iol.M_InOutLine_ID = cd.M_InOutLine_ID) ");
        selectSql.append("LEFT JOIN M_MatchInv mi ON (mi.M_MatchInv_ID = cd.M_MatchInv_ID) ");
        selectSql.append("LEFT JOIN M_InventoryLine invl ON (invl.M_InventoryLine_ID = cd.M_InventoryLine_ID) ");
        selectSql.append("LEFT JOIN M_MovementLine ml ON (ml.M_MovementLine_ID = cd.M_MovementLine_ID) ");
        selectSql.append("LEFT JOIN M_ProductionLine pl ON (pl.M_ProductionLine_ID = cd.M_ProductionLine_ID) ");
        selectSql.append("LEFT JOIN C_ProjectIssue pi ON (pi.C_ProjectIssue_ID = cd.C_ProjectIssue_ID) ");
        selectSql.append("WHERE cd.AD_Client_ID=? ");
        selectSql.append("AND cd.C_AcctSchema_ID=? ");
        selectSql.append("AND cd.M_Product_ID=? ");
        selectSql.append("AND (cd.DateAcct, COALESCE(cd.Ref_CostDetail_ID,cd.M_CostDetail_ID), cd.M_CostDetail_ID) > (");
        selectSql.append(" SELECT cd.DateAcct, ");
        selectSql.append(" CASE WHEN COALESCE(refcd.DateAcct,cd.DateAcct) = cd.DateAcct ");
        selectSql.append(" THEN COALESCE(cd.Ref_CostDetail_ID,cd.M_CostDetail_ID) ELSE cd.M_CostDetail_ID END, ");
        selectSql.append(" cd.M_CostDetail_ID ");
        selectSql.append(" FROM M_CostDetail cd ");
        selectSql.append(" LEFT JOIN M_CostDetail refcd ON (refcd.M_CostDetail_ID=cd.Ref_CostDetail_ID) ");
        selectSql.append(" WHERE cd.M_CostDetail_ID=? ");
        selectSql.append(") ");
        selectSql.append("AND cd.DateAcct >= ? ");
        selectSql.append("AND cd.Processed='Y' ");
        selectSql.append("ORDER BY cd.DateAcct, ");
        selectSql.append("CASE WHEN COALESCE(refcd.DateAcct,cd.DateAcct) = cd.DateAcct ");
        selectSql.append("THEN COALESCE(cd.Ref_CostDetail_ID,cd.M_CostDetail_ID) ELSE cd.M_CostDetail_ID END, ");
        selectSql.append("cd.M_CostDetail_ID ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(selectSql.toString(), trxName);
                DB.setParameters((PreparedStatement)pstmt, new Object[]{AD_Client_ID, C_AcctSchema_ID, M_Product_ID, M_CostDetail_ID, DateAcct});
                rs = pstmt.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                while (rs.next()) {
                    MMatchInv[] miList;
                    String repostedRecordId;
                    Timestamp dateAcct;
                    int tableID = 0;
                    int recordID = 0;
                    int i2 = 1;
                    while (i2 <= rsmd.getColumnCount()) {
                        MTable docTable;
                        String key = rsmd.getColumnName(i2);
                        Object value = rs.getObject(i2);
                        if (value != null && value instanceof Number && (docTable = MTable.get(Env.getCtx(), key.substring(0, key.length() - 3))) != null) {
                            tableID = docTable.getAD_Table_ID();
                            recordID = ((Number)value).intValue();
                            break;
                        }
                        ++i2;
                    }
                    if (tableID == 0 || recordID == 0 || (dateAcct = MCostDetail.getDateAcct(tableID, recordID, trxName)) == null) continue;
                    MTable table2 = MTable.get(Env.getCtx(), tableID);
                    PO po = table2.getPO(recordID, trxName);
                    int index = po.get_ColumnIndex("C_DocType_ID");
                    String docBaseType = null;
                    if (index < 0) {
                        if (tableID == 472) {
                            docBaseType = "MXI";
                        } else if (tableID == 473) {
                            docBaseType = "MXP";
                        } else {
                            if (tableID != 623) continue;
                            docBaseType = "PJI";
                        }
                    } else {
                        int C_DocType_ID = 0;
                        Object objts = po.get_Value(index);
                        if (objts != null && objts instanceof Number) {
                            C_DocType_ID = ((Number)objts).intValue();
                        }
                        MDocType dt = MDocType.get(Env.getCtx(), C_DocType_ID);
                        docBaseType = dt.getDocBaseType();
                    }
                    if (docBaseType == null || repostedRecordIds.contains(repostedRecordId = tableID + "_" + recordID)) continue;
                    repostedRecordIds.add((CallSite)((Object)repostedRecordId));
                    if (!MPeriod.isOpen(Env.getCtx(), dateAcct, docBaseType, po.getAD_Org_ID(), true)) {
                        throw new PeriodClosedException(dateAcct, docBaseType);
                    }
                    if (tableID != 318) continue;
                    MMatchInv[] mMatchInvArray = miList = MMatchInv.getInvoice(Env.getCtx(), recordID, trxName);
                    int n = miList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MMatchInv mi = mMatchInvArray[n2];
                        repostedRecordId = "472_" + mi.get_ID();
                        if (!repostedRecordIds.contains(repostedRecordId)) {
                            repostedRecordIds.add((CallSite)((Object)repostedRecordId));
                            dateAcct = mi.getDateAcct();
                            docBaseType = "MXI";
                            if (!MPeriod.isOpen(Env.getCtx(), dateAcct, docBaseType, mi.getAD_Org_ID(), true)) {
                                throw new PeriodClosedException(dateAcct, docBaseType);
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (SQLException e) {
                throw new DBException(e, selectSql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    public static Timestamp getDateAcct(int tableID, int recordID, String trxName) {
        MTable table2 = MTable.get(Env.getCtx(), tableID);
        PO po = table2.getPO(recordID, trxName);
        int index = -1;
        if (tableID == 321 || tableID == 323 || tableID == 325 || tableID == 623) {
            index = po.get_ColumnIndex("MovementDate");
        } else if (tableID == 473 || tableID == 318 || tableID == 319 || tableID == 472) {
            index = po.get_ColumnIndex("DateAcct");
        }
        if (index < 0) {
            return null;
        }
        Timestamp dateAcct = null;
        Object objts = po.get_Value(index);
        if (objts != null && objts instanceof Timestamp) {
            dateAcct = (Timestamp)objts;
        }
        return dateAcct;
    }
}

