/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.adempiere.apps.graph.ChartBuilder;
import org.compiere.model.MChartDatasource;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Chart;
import org.compiere.util.Env;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;

public class MChart
extends X_AD_Chart {
    private static final long serialVersionUID = -6709381648397609341L;
    private int windowNo = 0;

    public MChart(Properties ctx, String AD_Chart_UU, String trxName) {
        super(ctx, AD_Chart_UU, trxName);
    }

    public MChart(Properties ctx, int AD_Chart_ID, String trxName) {
        super(ctx, AD_Chart_ID, trxName);
    }

    public MChart(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public List<MChartDatasource> getDatasources() {
        return new Query(this.getCtx(), "AD_ChartDatasource", "AD_Chart_ID = ? AND AD_Client_ID IN (0, ?)", null).setParameters(this.getAD_Chart_ID(), Env.getAD_Client_ID(this.getCtx())).setOnlyActiveRecords(true).list();
    }

    public void setWindowNo(int windowNo) {
        this.windowNo = windowNo;
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public BufferedImage getChartImage(int width, int height) {
        if (width <= 0) {
            width = this.getWinHeight();
        }
        if (width <= 0) {
            width = 100;
        }
        if (height <= 0) {
            height = this.getWinHeight();
        }
        if (height <= 0) {
            height = 100;
        }
        ChartBuilder chartBuilder = new ChartBuilder(this);
        JFreeChart chart = chartBuilder.createChart();
        chart.getPlot().setForegroundAlpha(0.8f);
        ChartRenderingInfo info = new ChartRenderingInfo();
        BufferedImage bi = chart.createBufferedImage(width, height, 3, info);
        return bi;
    }

    public JsonObject getData() {
        JsonObject json = new JsonObject();
        ChartBuilder cb = new ChartBuilder(this);
        JsonArray array = new JsonArray();
        String type = this.getChartType();
        Object ds = this.isTimeSeries() && ("BC".equals(type) || "LC".equals(type) || "BS".equals(type)) ? cb.getXYDataset() : ("P3".equals(type) || "PC".equals(type) || "RC".equals(type) ? cb.getPieDataset() : cb.getCategoryDataset());
        if (ds instanceof CategoryDataset) {
            json.addProperty("name", this.get_Translation("Name"));
            json.addProperty("domainLabel", this.get_Translation("DomainLabel"));
            json.addProperty("rangeLabel", this.get_Translation("RangeLabel"));
            json.addProperty("displayLegend", Boolean.valueOf(this.isDisplayLegend()));
            json.addProperty("chartOrientation", this.getChartOrientation());
            json.addProperty("chartType", this.getChartType());
            CategoryDataset cds = (CategoryDataset)ds;
            int rowCount = cds.getRowCount();
            int columnCount = cds.getColumnCount();
            int row = 0;
            while (row < rowCount) {
                int col = 0;
                while (col < columnCount) {
                    Number value = cds.getValue(row, col);
                    Comparable rowKey = cds.getRowKey(row);
                    Comparable colKey = cds.getColumnKey(col);
                    JsonObject rec = new JsonObject();
                    rec.addProperty("row", rowKey.toString());
                    rec.addProperty("column", colKey.toString());
                    rec.addProperty("value", value);
                    array.add((JsonElement)rec);
                    ++col;
                }
                ++row;
            }
        } else if (ds instanceof XYDataset) {
            json.addProperty("name", this.get_Translation("Name"));
            json.addProperty("domainLabel", this.get_Translation("DomainLabel"));
            json.addProperty("rangeLabel", this.get_Translation("RangeLabel"));
            json.addProperty("displayLegend", Boolean.valueOf(this.isDisplayLegend()));
            json.addProperty("chartOrientation", this.getChartOrientation());
            json.addProperty("chartType", this.getChartType());
            XYDataset xyds = (XYDataset)ds;
            int seriesCount = xyds.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                Comparable seriesKey = xyds.getSeriesKey(series);
                int itemCount = xyds.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    Number xValue = xyds.getX(series, item);
                    Date date = new Date((Long)xValue);
                    String strDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
                    Number yValue = xyds.getY(series, item);
                    JsonObject rec = new JsonObject();
                    rec.addProperty("series", seriesKey.toString());
                    rec.addProperty("x", strDate);
                    rec.addProperty("y", yValue);
                    array.add((JsonElement)rec);
                    ++item;
                }
                ++series;
            }
        } else if (ds instanceof PieDataset) {
            json.addProperty("name", this.get_Translation("Name"));
            json.addProperty("displayLegend", Boolean.valueOf(this.isDisplayLegend()));
            json.addProperty("chartType", this.getChartType());
            PieDataset pds = (PieDataset)ds;
            int i = 0;
            while (i < pds.getKeys().size()) {
                Comparable key = pds.getKey(i);
                Number value = pds.getValue(key);
                JsonObject rec = new JsonObject();
                rec.addProperty("key", key.toString());
                rec.addProperty("value", value);
                array.add((JsonElement)rec);
                ++i;
            }
        }
        json.add("data", (JsonElement)array);
        return json;
    }
}

