/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.IInfoColumn;
import org.adempiere.model.MInfoRelated;
import org.compiere.model.I_AD_InfoColumn;
import org.compiere.model.I_AD_InfoWindow;
import org.compiere.model.MInfoColumn;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MUserDefInfoRelated;
import org.compiere.util.CLogger;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Util;

public class InfoRelatedVO
implements Serializable,
Cloneable,
IInfoColumn {
    private static final long serialVersionUID = 3683704870522235708L;
    private static CLogger log = CLogger.getCLogger(InfoRelatedVO.class);
    private Properties ctx;
    private int AD_InfoRelated_ID;
    private int AD_InfoWindow_ID;
    private MInfoRelated infoRelated;
    private int SeqNo;
    private String DisplayLogic;
    private String Name;
    private int WindowNo;

    public InfoRelatedVO(Properties ctx, MInfoRelated infoRelated, int windowNo) {
        this.ctx = ctx;
        this.infoRelated = infoRelated;
        this.AD_InfoRelated_ID = infoRelated.getAD_InfoRelated_ID();
        this.AD_InfoWindow_ID = infoRelated.getAD_InfoWindow_ID();
        this.SeqNo = infoRelated.getSeqNo();
        this.DisplayLogic = infoRelated.getDisplayLogic();
        MInfoWindow riw = (MInfoWindow)infoRelated.getRelatedInfo();
        this.Name = riw != null ? Util.cleanAmp(riw.get_Translation("Name")) : infoRelated.getName();
        this.WindowNo = windowNo;
        this.afterCreate();
    }

    public void afterCreate() {
        InfoRelatedVO vo = this;
        MUserDefInfoRelated userDef = null;
        userDef = MUserDefInfoRelated.get(vo.ctx, vo.AD_InfoRelated_ID, vo.AD_InfoWindow_ID);
        if (userDef != null) {
            if (userDef.getName() != null) {
                vo.Name = userDef.getName();
            }
            if (userDef.get_Translation("Name") != null) {
                vo.Name = userDef.get_Translation("Name");
            }
            if (userDef.getSeqNo() > 0) {
                vo.SeqNo = userDef.getSeqNo();
            }
            if (userDef.getDisplayLogic() != null) {
                vo.DisplayLogic = userDef.getDisplayLogic();
            }
        }
    }

    public static InfoRelatedVO[] getInfoRelatedVOList(Properties ctx, MInfoRelated[] infoRelatedList, int windowNo) {
        ArrayList<InfoRelatedVO> infoRelatedVOList = new ArrayList<InfoRelatedVO>();
        MInfoRelated[] mInfoRelatedArray = infoRelatedList;
        int n = infoRelatedList.length;
        int n2 = 0;
        while (n2 < n) {
            MInfoRelated infoRelated = mInfoRelatedArray[n2];
            InfoRelatedVO infoRelatedVO = new InfoRelatedVO(ctx, infoRelated, windowNo);
            infoRelatedVOList.add(infoRelatedVO);
            ++n2;
        }
        infoRelatedVOList.sort(new Comparator<InfoRelatedVO>(){

            @Override
            public int compare(InfoRelatedVO o1, InfoRelatedVO o2) {
                Integer o1SeqNo = o1.getSeqNo();
                Integer o2SeqNo = o2.getSeqNo();
                return o1SeqNo.compareTo(o2SeqNo);
            }
        });
        return infoRelatedVOList.toArray(new InfoRelatedVO[infoRelatedVOList.size()]);
    }

    public int getRelatedInfo_ID() {
        return this.infoRelated.getRelatedInfo_ID();
    }

    public String getLinkColumnName() {
        return this.infoRelated.getLinkColumnName();
    }

    public int getParentRelatedColumn_ID() {
        return this.infoRelated.getParentRelatedColumn_ID();
    }

    public I_AD_InfoWindow getRelatedInfo() {
        return this.infoRelated.getRelatedInfo();
    }

    public MInfoColumn getLinkInfoColumn() {
        return this.infoRelated.getLinkInfoColumn();
    }

    public String getName() {
        return this.Name;
    }

    public I_AD_InfoColumn getParentRelatedColumn() {
        return this.infoRelated.getParentRelatedColumn();
    }

    public int getSeqNo() {
        return this.SeqNo;
    }

    @Override
    public int getInfoColumnID() {
        return this.getParentRelatedColumn_ID();
    }

    @Override
    public MInfoColumn getAD_InfoColumn() {
        return (MInfoColumn)this.getParentRelatedColumn();
    }

    public String getDisplayLogic() {
        return this.DisplayLogic;
    }

    public boolean isDisplayed(Properties ctx) {
        if (Util.isEmpty(this.getDisplayLogic())) {
            return true;
        }
        if (this.getDisplayLogic().startsWith("@SQL=")) {
            return Evaluator.parseSQLLogic(this.DisplayLogic, ctx, this.WindowNo, 0, this.infoRelated.toString());
        }
        Evaluatee evaluatee = variableName -> this.get_ValueAsString(ctx, variableName);
        boolean retValue = Evaluator.evaluateLogic(evaluatee, this.getDisplayLogic());
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.infoRelated.toString() + " (" + this.getDisplayLogic() + ") => " + retValue);
        }
        return retValue;
    }

    public String get_ValueAsString(Properties ctx, String variableName) {
        DefaultEvaluatee evaluatee = new DefaultEvaluatee(null, this.WindowNo, -1, true);
        return evaluatee.get_ValueAsString(ctx, variableName);
    }
}

