/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.util.CLogger;

public class AccessSqlParser {
    private static final String FROM = " FROM ";
    private static final int FROM_LENGTH = " FROM ".length();
    private static final String WHERE = " WHERE ";
    private static final String ON = " ON ";
    private static final CLogger log = CLogger.getCLogger(AccessSqlParser.class);
    private String m_sqlOriginal;
    private String[] m_sql;
    private ArrayList<TableInfo[]> m_tableInfo = new ArrayList();

    public AccessSqlParser() {
    }

    public AccessSqlParser(String sql) {
        this.setSql(sql);
    }

    public void setSql(String sql) {
        if (sql == null) {
            throw new IllegalArgumentException("No SQL");
        }
        this.m_sqlOriginal = sql;
        int index = this.m_sqlOriginal.indexOf("\nFROM ");
        if (index != -1) {
            this.m_sqlOriginal = this.m_sqlOriginal.replace("\nFROM ", FROM);
        }
        if ((index = this.m_sqlOriginal.indexOf("\nWHERE ")) != -1) {
            this.m_sqlOriginal = this.m_sqlOriginal.replace("\nWHERE ", WHERE);
        }
        this.parse();
    }

    public String getSql() {
        return this.m_sqlOriginal;
    }

    public boolean parse() {
        if (this.m_sqlOriginal == null || this.m_sqlOriginal.length() == 0) {
            throw new IllegalArgumentException("No SQL");
        }
        this.getSelectStatements();
        int i = 0;
        while (i < this.m_sql.length) {
            TableInfo[] info = this.getTableInfo(this.m_sql[i].trim());
            this.m_tableInfo.add(info);
            ++i;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.toString());
        }
        return this.m_tableInfo.size() > 0;
    }

    /*
     * Unable to fully structure code
     */
    private void getSelectStatements() {
        sqlIn = new String[]{this.m_sqlOriginal};
        sqlOut = null;
        try {
            sqlOut = this.getSubSQL(sqlIn);
            if (true) ** GOTO lbl17
        }
        catch (Exception e) {
            AccessSqlParser.log.log(Level.SEVERE, this.m_sqlOriginal, e);
            throw new IllegalArgumentException(this.m_sqlOriginal);
        }
        do {
            sqlIn = sqlOut;
            try {
                sqlOut = this.getSubSQL(sqlIn);
            }
            catch (Exception e) {
                AccessSqlParser.log.log(Level.SEVERE, this.m_sqlOriginal, e);
                throw new IllegalArgumentException(sqlOut.length + ": " + this.m_sqlOriginal);
            }
lbl17:
            // 2 sources

        } while (sqlIn.length != sqlOut.length);
        this.m_sql = sqlOut;
    }

    private String[] getSubSQL(String[] sqlIn) {
        ArrayList<String> list = new ArrayList<String>();
        int sqlIndex = 0;
        while (sqlIndex < sqlIn.length) {
            Object sql = sqlIn[sqlIndex];
            int index = ((String)sql).indexOf("(SELECT ", 7);
            while (index != -1) {
                int endIndex = index + 1;
                int parenthesisLevel = 0;
                while (endIndex++ < ((String)sql).length()) {
                    char c = ((String)sql).charAt(endIndex);
                    if (c == ')') {
                        if (parenthesisLevel == 0) break;
                        --parenthesisLevel;
                        continue;
                    }
                    if (c != '(') continue;
                    ++parenthesisLevel;
                }
                String subSQL = ((String)sql).substring(index, endIndex + 1);
                list.add(subSQL);
                sql = ((String)sql).substring(0, index + 1) + "##" + ((String)sql).substring(endIndex);
                index = ((String)sql).indexOf("(SELECT ", 7);
            }
            list.add((String)sql);
            ++sqlIndex;
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private TableInfo[] getTableInfo(String sql) {
        int fromIndex;
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        if (sql.startsWith("(") && sql.endsWith(")")) {
            sql = sql.substring(1, sql.length() - 1);
        }
        if ((fromIndex = sql.indexOf(FROM)) != sql.lastIndexOf(FROM)) {
            log.log(Level.WARNING, "More than one FROM clause - " + sql);
        }
        while (fromIndex != -1) {
            Object from = sql.substring(fromIndex + FROM_LENGTH);
            int index = ((String)from).lastIndexOf(WHERE);
            if (index != -1) {
                from = ((String)from).substring(0, index);
            }
            from = ((String)from).replaceAll("[\r\n\t ]+AS[\r\n\t ]+", " ");
            from = ((String)from).replaceAll("[\r\n\t ]+as[\r\n\t ]+", " ");
            from = ((String)from).replaceAll("[\r\n\t ]+INNER[\r\n\t ]+JOIN[\r\n\t ]+", ", ");
            from = ((String)from).replaceAll("[\r\n\t ]+LEFT[\r\n\t ]+OUTER[\r\n\t ]+JOIN[\r\n\t ]+", ", ");
            from = ((String)from).replaceAll("[\r\n\t ]+RIGHT[\r\n\t ]+OUTER[\r\n\t ]+JOIN[\r\n\t ]+", ", ");
            from = ((String)from).replaceAll("[\r\n\t ]+FULL[\r\n\t ]+JOIN[\r\n\t ]+", ", ");
            from = ((String)from).replaceAll("[\r\n\t ]+LEFT[\r\n\t ]+JOIN[\r\n\t ]+", ", ");
            from = ((String)from).replaceAll("[\r\n\t ]+RIGHT[\r\n\t ]+JOIN[\r\n\t ]+", ", ");
            from = ((String)from).replaceAll("[\r\n\t ]+JOIN[\r\n\t ]+", ", ");
            from = ((String)from).replaceAll("[\r\n\t ]+[Oo][Nn][\r\n\t ]+", ON);
            index = ((String)from).indexOf(ON);
            while (index != -1) {
                int indexClose = this.getIndexClose((String)from);
                int indexNextOn = ((String)from).indexOf(ON, index + 4);
                if (indexNextOn != -1) {
                    indexClose = ((String)from).lastIndexOf(41, indexNextOn);
                }
                if (indexClose == -1) {
                    log.log(Level.SEVERE, "Could not remove ON " + (String)from);
                    break;
                }
                if (index > indexClose) {
                    throw new IllegalStateException("Could not remove (index=" + index + " > indexClose=" + indexClose + ") - " + (String)from);
                }
                from = ((String)from).substring(0, index) + ((String)from).substring(indexClose + 1);
                index = ((String)from).indexOf(ON);
            }
            StringTokenizer tableST = new StringTokenizer((String)from, ",");
            while (tableST.hasMoreTokens()) {
                String tableString = tableST.nextToken().trim();
                StringTokenizer synST = new StringTokenizer(tableString, " \r\n\t");
                TableInfo tableInfo = null;
                tableInfo = synST.countTokens() > 1 ? new TableInfo(synST.nextToken(), synST.nextToken()) : new TableInfo(tableString);
                list.add(tableInfo);
            }
            sql = sql.substring(0, fromIndex);
            fromIndex = sql.lastIndexOf(FROM);
        }
        TableInfo[] retValue = new TableInfo[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AccessSqlParser[");
        if (this.m_tableInfo == null) {
            sb.append(this.m_sqlOriginal);
        } else {
            int i = 0;
            while (i < this.m_tableInfo.size()) {
                if (i > 0) {
                    sb.append("|");
                }
                TableInfo[] info = this.m_tableInfo.get(i);
                int ii = 0;
                while (ii < info.length) {
                    if (ii > 0) {
                        sb.append(",");
                    }
                    sb.append(info[ii].toString());
                    ++ii;
                }
                ++i;
            }
        }
        sb.append("|").append(this.getMainSqlIndex());
        sb.append("]");
        return sb.toString();
    }

    public TableInfo[] getTableInfo(int index) {
        if (index < 0 || index > this.m_tableInfo.size()) {
            return null;
        }
        TableInfo[] retValue = this.m_tableInfo.get(index);
        return retValue;
    }

    public String getSqlStatement(int index) {
        if (index < 0 || index > this.m_sql.length) {
            return null;
        }
        return this.m_sql[index];
    }

    public int getNoSqlStatments() {
        if (this.m_sql == null) {
            return 0;
        }
        return this.m_sql.length;
    }

    public int getMainSqlIndex() {
        if (this.m_sql == null) {
            return -1;
        }
        if (this.m_sql.length == 1) {
            return 0;
        }
        int i = this.m_sql.length - 1;
        while (i >= 0) {
            if (this.m_sql[i].charAt(0) != '(') {
                return i;
            }
            --i;
        }
        return -1;
    }

    public String getMainSql() {
        if (this.m_sql == null) {
            return this.m_sqlOriginal;
        }
        if (this.m_sql.length == 1) {
            return this.m_sql[0];
        }
        int i = this.m_sql.length - 1;
        while (i >= 0) {
            if (this.m_sql[i].charAt(0) != '(') {
                return this.m_sql[i];
            }
            --i;
        }
        return "";
    }

    public int getIndexClose(String from) {
        int parenthesisLevel = 0;
        int indexOpen = from.indexOf(40);
        int index = -1;
        while (indexOpen != -1) {
            ++parenthesisLevel;
            int indexNextOpen = from.indexOf(40, indexOpen + 1);
            int indexClose = from.indexOf(41, indexOpen + 1);
            if (indexNextOpen == -1 || indexClose < indexNextOpen) break;
            indexOpen = from.indexOf(40, indexNextOpen);
        }
        while (parenthesisLevel > 0) {
            index = from.indexOf(41, index + 1);
            --parenthesisLevel;
        }
        return index;
    }

    public static class TableInfo {
        private String m_tableName;
        private String m_synonym;

        public TableInfo(String tableName, String synonym) {
            this.m_tableName = tableName;
            this.m_synonym = synonym;
        }

        public TableInfo(String tableName) {
            this(tableName, null);
        }

        public String getSynonym() {
            if (this.m_synonym == null) {
                return "";
            }
            return this.m_synonym;
        }

        public String getTableName() {
            return this.m_tableName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.m_tableName);
            if (this.getSynonym().length() > 0) {
                sb.append("=").append(this.m_synonym);
            }
            return sb.toString();
        }
    }
}

