/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MLanguage;
import org.compiere.model.MRegion;
import org.compiere.model.Query;
import org.compiere.model.X_C_Country;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MCountry
extends X_C_Country
implements Comparator<Object>,
Serializable,
ImmutablePOSupport {
    private static final long serialVersionUID = 6102749517340832365L;
    private static String s_AD_Language = null;
    private static ImmutableIntPOCache<Integer, MCountry> s_countries = new ImmutableIntPOCache<Integer, MCountry>("C_Country", 250, 0, false){
        private static final long serialVersionUID = 1106078701451046946L;

        @Override
        public int reset(int recordId) {
            if (recordId <= 0) {
                return super.reset(recordId);
            }
            return 0;
        }
    };
    private static ImmutableIntPOCache<Integer, MCountry> s_default = new ImmutableIntPOCache("C_Country", "C_Country|Default", 3);
    private static CLogger s_log = CLogger.getCLogger(MCountry.class);
    private static String DISPLAYSEQUENCE = "@C@, @P@";

    public static MCountry get(int C_Country_ID) {
        return MCountry.get(Env.getCtx(), C_Country_ID);
    }

    public static MCountry get(Properties ctx, int C_Country_ID) {
        if (C_Country_ID <= 0) {
            return null;
        }
        MCountry.loadAllCountriesIfNeeded();
        MCountry c = s_countries.get(ctx, C_Country_ID, e -> new MCountry(ctx, (MCountry)e));
        if (c != null) {
            return c;
        }
        c = new MCountry(ctx, C_Country_ID, null);
        if (c.getC_Country_ID() == C_Country_ID) {
            s_countries.put(C_Country_ID, c, e -> new MCountry(Env.getCtx(), (MCountry)e));
            return c;
        }
        return null;
    }

    @Deprecated
    public static MCountry getDefault(Properties ctx) {
        return MCountry.getDefault();
    }

    public static MCountry getDefault() {
        int clientID = Env.getAD_Client_ID(Env.getCtx());
        MCountry c = (MCountry)s_default.get(clientID);
        if (c != null) {
            return c;
        }
        MCountry.loadDefaultCountry();
        c = (MCountry)s_default.get(clientID);
        return c;
    }

    @Deprecated
    public static MCountry[] getCountries(Properties ctx) {
        return MCountry.getCountries();
    }

    public static MCountry[] getCountries() {
        MCountry.loadAllCountriesIfNeeded();
        MCountry[] retValue = s_countries.values().toArray(new MCountry[0]);
        Arrays.sort(retValue, new MCountry(Env.getCtx(), 0, null));
        return retValue;
    }

    private static synchronized void loadAllCountriesIfNeeded() {
        if (s_countries == null || s_countries.isEmpty()) {
            MCountry.loadAllCountries();
        }
    }

    private static synchronized void loadAllCountries() {
        MClient client = MClient.get(Env.getCtx());
        MLanguage lang = MLanguage.get(Env.getCtx(), client.getAD_Language());
        if (s_countries == null) {
            s_countries = new ImmutableIntPOCache("C_Country", 250);
        }
        List countries = new Query(Env.getCtx(), "C_Country", "", null).setOnlyActiveRecords(true).list();
        for (MCountry c : countries) {
            s_countries.put(c.getC_Country_ID(), c);
            if (lang == null || !lang.getCountryCode().equals(c.getCountryCode())) continue;
            s_default.put(client.getAD_Client_ID(), c);
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("#" + s_countries.size() + " - Default=" + String.valueOf(s_default));
        }
    }

    private static void loadDefaultCountry() {
        MCountry.loadAllCountriesIfNeeded();
        MClient client = MClient.get(Env.getCtx());
        MCountry found = (MCountry)s_default.get(client.getAD_Client_ID());
        if (found != null) {
            return;
        }
        MLanguage lang = MLanguage.get(Env.getCtx(), client.getAD_Language());
        MCountry usa = null;
        HashMap<Integer, MCountry> countries = new HashMap<Integer, MCountry>(s_countries);
        for (Map.Entry cachedEntry : countries.entrySet()) {
            MCountry c = (MCountry)cachedEntry.getValue();
            if (lang != null && lang.getCountryCode().equals(c.getCountryCode())) {
                found = c;
                break;
            }
            if (c.getC_Country_ID() != 100) continue;
            usa = c;
        }
        if (found != null) {
            s_default.put(client.getAD_Client_ID(), found);
        } else {
            s_default.put(client.getAD_Client_ID(), usa);
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("#" + countries.size() + " - Default=" + String.valueOf(s_default));
        }
    }

    @Deprecated(forRemoval=true, since="11")
    public static void setDisplayLanguage(String AD_Language) {
        s_AD_Language = AD_Language;
        if (Language.isBaseLanguage(AD_Language)) {
            s_AD_Language = null;
        }
    }

    public MCountry(Properties ctx, String C_Country_UU, String trxName) {
        super(ctx, C_Country_UU, trxName);
        if (Util.isEmpty(C_Country_UU)) {
            this.setInitialDefaults();
        }
    }

    public MCountry(Properties ctx, int C_Country_ID, String trxName) {
        super(ctx, C_Country_ID, trxName);
        if (C_Country_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setDisplaySequence(DISPLAYSEQUENCE);
        this.setHasRegion(false);
        this.setHasPostal_Add(false);
        this.setIsAddressLinesLocalReverse(false);
        this.setIsAddressLinesReverse(false);
    }

    public MCountry(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCountry(MCountry copy) {
        this(Env.getCtx(), copy);
    }

    public MCountry(Properties ctx, MCountry copy) {
        this(ctx, copy, null);
    }

    public MCountry(Properties ctx, MCountry copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    public String toString() {
        return this.getTrlName();
    }

    public String getTrlName() {
        return this.getTrlName(Env.getAD_Language(Env.getCtx()));
    }

    public String getTrlName(String language) {
        return this.get_Translation("Name", language);
    }

    @Override
    public String getDisplaySequence() {
        String ds = super.getDisplaySequence();
        if (ds == null || ds.length() == 0) {
            ds = DISPLAYSEQUENCE;
        }
        return ds;
    }

    @Override
    public String getDisplaySequenceLocal() {
        String ds = super.getDisplaySequenceLocal();
        if (ds == null || ds.length() == 0) {
            ds = this.getDisplaySequence();
        }
        return ds;
    }

    @Override
    public int compare(Object o1, Object o2) {
        String s2;
        String s1 = o1.toString();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = o2.toString()) == null) {
            s2 = "";
        }
        Collator collator = Collator.getInstance();
        return collator.compare(s1, s2);
    }

    public boolean isValidRegion(int C_Region_ID) {
        if (C_Region_ID == 0 || this.getC_Country_ID() == 0 || !this.isHasRegion()) {
            return false;
        }
        MRegion[] regions = MRegion.getRegions(this.getC_Country_ID());
        int i = 0;
        while (i < regions.length) {
            if (C_Region_ID == regions[i].getC_Region_ID()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public MCountry markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

