/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MInvoice;
import org.compiere.model.MPriceList;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectType;
import org.compiere.model.MProjectTypePhase;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Project;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MProject
extends X_C_Project {
    private static final long serialVersionUID = 8631795136761641303L;
    private int m_M_PriceList_ID = 0;

    public static MProject copyFrom(Properties ctx, int C_Project_ID, Timestamp dateDoc, String trxName) {
        MProject from = new MProject(ctx, C_Project_ID, trxName);
        if (from.getC_Project_ID() == 0) {
            throw new IllegalArgumentException("From Project not found C_Project_ID=" + C_Project_ID);
        }
        MProject to = new MProject(ctx, 0, trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("C_Project_ID", I_ZERO);
        String Value = to.getValue() + " ";
        String Time2 = dateDoc.toString();
        int length = Value.length() + Time2.length();
        Value = length <= 40 ? Value + Time2 : Value + Time2.substring(length - 40);
        to.setValue(Value);
        to.setInvoicedAmt(Env.ZERO);
        to.setProjectBalanceAmt(Env.ZERO);
        to.setProcessed(false);
        if (!to.save()) {
            throw new IllegalStateException("Could not create Project");
        }
        if (to.copyDetailsFrom(from) == 0) {
            throw new IllegalStateException("Could not create Project Details");
        }
        return to;
    }

    public MProject(Properties ctx, String C_Project_UU, String trxName) {
        super(ctx, C_Project_UU, trxName);
        if (Util.isEmpty(C_Project_UU)) {
            this.setInitialDefaults();
        }
    }

    public MProject(Properties ctx, int C_Project_ID, String trxName) {
        super(ctx, C_Project_ID, trxName);
        if (C_Project_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setCommittedAmt(Env.ZERO);
        this.setCommittedQty(Env.ZERO);
        this.setInvoicedAmt(Env.ZERO);
        this.setInvoicedQty(Env.ZERO);
        this.setPlannedAmt(Env.ZERO);
        this.setPlannedMarginAmt(Env.ZERO);
        this.setPlannedQty(Env.ZERO);
        this.setProjectBalanceAmt(Env.ZERO);
        this.setProjInvoiceRule("-");
        this.setProjectLineLevel("P");
        this.setIsCommitCeiling(false);
        this.setIsCommitment(false);
        this.setIsSummary(false);
        this.setProcessed(false);
    }

    public MProject(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Deprecated
    public int getC_ProjectType_ID_Int() {
        return this.getC_ProjectType_ID();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MProject[").append(this.get_ID()).append("-").append(this.getValue()).append(",ProjectCategory=").append(this.getProjectCategory()).append("]");
        return sb.toString();
    }

    public int getM_PriceList_ID() {
        if (this.getM_PriceList_Version_ID() == 0) {
            return 0;
        }
        if (this.m_M_PriceList_ID > 0) {
            return this.m_M_PriceList_ID;
        }
        String sql = "SELECT M_PriceList_ID FROM M_PriceList_Version WHERE M_PriceList_Version_ID=?";
        this.m_M_PriceList_ID = DB.getSQLValue(null, sql, this.getM_PriceList_Version_ID());
        return this.m_M_PriceList_ID;
    }

    @Override
    public void setM_PriceList_Version_ID(int M_PriceList_Version_ID) {
        super.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        this.m_M_PriceList_ID = 0;
    }

    public MProjectLine[] getLines() {
        List<MProjectLine> list = new Query(this.getCtx(), "C_ProjectLine", "C_Project_ID=?", this.get_TrxName()).setParameters(this.getC_Project_ID()).setOrderBy("Line,C_ProjectLine_ID").list();
        MProjectLine[] retValue = new MProjectLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MProjectLine[] getPhaseLines(int phase) {
        List<MProjectLine> list = new Query(this.getCtx(), "C_ProjectLine", "C_Project_ID=? and C_ProjectPhase_ID=?", this.get_TrxName()).setParameters(this.getC_Project_ID(), phase).setOrderBy("Line").list();
        MProjectLine[] retValue = new MProjectLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MProjectIssue[] getIssues() {
        String whereClause = "C_Project_ID=?";
        List<MProjectIssue> list = new Query(this.getCtx(), "C_ProjectIssue", whereClause, this.get_TrxName()).setParameters(this.getC_Project_ID()).setOrderBy("Line").list();
        MProjectIssue[] retValue = new MProjectIssue[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MProjectPhase[] getPhases() {
        String whereClause = "C_Project_ID=?";
        List<MProjectPhase> list = new Query(this.getCtx(), "C_ProjectPhase", whereClause, this.get_TrxName()).setParameters(this.getC_Project_ID()).setOrderBy("SeqNo").list();
        MProjectPhase[] retValue = new MProjectPhase[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int copyDetailsFrom(MProject project) {
        if (this.isProcessed() || project == null) {
            return 0;
        }
        int count = this.copyLinesFrom(project) + this.copyPhasesFrom(project);
        return count;
    }

    public int copyLinesFrom(MProject project) {
        if (this.isProcessed() || project == null) {
            return 0;
        }
        int count = 0;
        MProjectLine[] fromLines = project.getLines();
        int i = 0;
        while (i < fromLines.length) {
            if (fromLines[i].getC_ProjectPhase_ID() == 0 && fromLines[i].getC_ProjectTask_ID() == 0) {
                MProjectLine line = new MProjectLine(this.getCtx(), 0, project.get_TrxName());
                PO.copyValues(fromLines[i], line, this.getAD_Client_ID(), this.getAD_Org_ID());
                line.setC_Project_ID(this.getC_Project_ID());
                line.setInvoicedAmt(Env.ZERO);
                line.setInvoicedQty(Env.ZERO);
                line.setC_OrderPO_ID(0);
                line.setC_Order_ID(0);
                line.setProcessed(false);
                if (line.save()) {
                    ++count;
                }
            }
            ++i;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Lines difference - Project=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    public int copyPhasesFrom(MProject fromProject) {
        if (this.isProcessed() || fromProject == null) {
            return 0;
        }
        int count = 0;
        int taskCount = 0;
        int lineCount = 0;
        MProjectPhase[] myPhases = this.getPhases();
        MProjectPhase[] fromPhases = fromProject.getPhases();
        int i = 0;
        while (i < fromPhases.length) {
            int C_Phase_ID = fromPhases[i].getC_Phase_ID();
            boolean exists = false;
            if (C_Phase_ID == 0) {
                exists = false;
            } else {
                int ii = 0;
                while (ii < myPhases.length) {
                    if (myPhases[ii].getC_Phase_ID() == C_Phase_ID) {
                        exists = true;
                        break;
                    }
                    ++ii;
                }
            }
            if (exists) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Phase already exists here, ignored - " + String.valueOf(fromPhases[i]));
                }
            } else {
                MProjectPhase toPhase = new MProjectPhase(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues(fromPhases[i], toPhase, this.getAD_Client_ID(), this.getAD_Org_ID());
                toPhase.setC_Project_ID(this.getC_Project_ID());
                toPhase.setC_Order_ID(0);
                toPhase.setIsComplete(false);
                toPhase.saveEx();
                ++count;
                taskCount += toPhase.copyTasksFrom(fromPhases[i]);
                lineCount += toPhase.copyLinesFrom(fromPhases[i]);
            }
            ++i;
        }
        if (fromPhases.length != count) {
            this.log.warning("Count difference - Project=" + fromPhases.length + " <> Saved=" + count);
        }
        return count + taskCount + lineCount;
    }

    public void setProjectType(MProjectType type) {
        if (type == null) {
            return;
        }
        this.setC_ProjectType_ID(type.getC_ProjectType_ID());
        this.setProjectCategory(type.getProjectCategory());
        if ("S".equals(this.getProjectCategory())) {
            this.copyPhasesFrom(type);
        }
    }

    public int copyPhasesFrom(MProjectType type) {
        int count = 0;
        int taskCount = 0;
        MProjectTypePhase[] typePhases = type.getPhases();
        int i = 0;
        while (i < typePhases.length) {
            MProjectPhase toPhase = new MProjectPhase(this, typePhases[i]);
            if (toPhase.save()) {
                ++count;
                taskCount += toPhase.copyTasksFrom(typePhases[i]);
            }
            ++i;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + count + "/" + taskCount + " - " + String.valueOf(type));
        }
        if (typePhases.length != count) {
            this.log.log(Level.SEVERE, "Count difference - Type=" + typePhases.length + " <> Saved=" + count);
        }
        return count;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MPriceList pl;
        if (this.getAD_User_ID() == -1) {
            this.setAD_User_ID(0);
        }
        if (this.is_ValueChanged("M_PriceList_Version_ID") && this.getM_PriceList_Version_ID() != 0 && (pl = MPriceList.get(this.getCtx(), this.getM_PriceList_ID(), null)) != null && pl.get_ID() != 0) {
            this.setC_Currency_ID(pl.getC_Currency_ID());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord) {
            this.insert_Accounting("C_Project_Acct", "C_AcctSchema_Default", null);
            this.insert_Tree("PJ");
        }
        if (newRecord || this.is_ValueChanged("Value")) {
            this.update_Tree("PJ");
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "C_Project_ID=" + this.getC_Project_ID(), this.get_TrxName());
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.delete_Tree("PJ");
        }
        return success;
    }

    public MInvoice[] getMInvoices() {
        StringBuilder sb = new StringBuilder();
        sb.append("C_Project_ID").append("=?");
        List<MInvoice> list = new Query(this.getCtx(), "C_Invoice", sb.toString(), this.get_TrxName()).setParameters(this.getC_Project_ID()).list();
        return list.toArray(new MInvoice[list.size()]);
    }
}

