/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class AmtInWords_ES
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", " MIL", " MILL\u00d3N", " MILLARDO", " BILL\u00d3N", " BILLARDO", " TRILL\u00d3N"};
    private static final String[] majorNamesPlural = new String[]{"", " MIL", " MILLONES", " MILLARDOS", " BILLONES", " BILLARDOS", " TRILLONES"};
    private static final String[] tensNames = new String[]{"", " DIEZ", " VEINTE", " TREINTA", " CUARENTA", " CINCUENTA", " SESENTA", " SETENTA", " OCHENTA", " NOVENTA"};
    private static final String[] numNames = new String[]{"", " UN", " DOS", " TRES", " CUATRO", " CINCO", " SEIS", " SIETE", " OCHO", " NUEVE", " DIEZ", " ONCE", " DOCE", " TRECE", " CATORCE", " QUINCE", " DIECIS\u00c9IS", " DIECISIETE", " DIECIOCHO", " DIECINUEVE"};

    private String convertLessThanOneThousand(int number) {
        Object soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            String s = Integer.toString(number /= 10);
            soFar = s.endsWith("2") && !((String)soFar).equals("") ? " VEINTI" + ((String)soFar).trim() : (((String)soFar).equals("") ? tensNames[number % 10] + (String)soFar : tensNames[number % 10] + " Y" + (String)soFar);
            number /= 10;
        }
        if (number == 0) {
            return tensNames[number % 10] + (String)soFar;
        }
        if (number > 1) {
            soFar = "S" + (String)soFar;
        }
        if (number == 1 && !((String)soFar).equals("")) {
            number = 0;
        }
        return numNames[number] + " CIENTO" + (String)soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "CERO";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "MENOS";
        }
        Object soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                if (s.startsWith("UN CIENTO", 1)) {
                    s = s.replaceFirst("UN CIENTO", "CIEN");
                }
                if (s.startsWith("DOS CIENTOS", 1)) {
                    s = s.replaceFirst("DOS CIENTOS", "DOSCIENTOS");
                }
                if (s.startsWith("TRES CIENTOS", 1)) {
                    s = s.replaceFirst("TRES CIENTOS", "TRESCIENTOS");
                }
                if (s.startsWith("CUATRO CIENTOS", 1)) {
                    s = s.replaceFirst("CUATRO CIENTOS", "CUATROCIENTOS");
                }
                if (s.startsWith("CINCO CIENTOS", 1)) {
                    s = s.replaceFirst("CINCO CIENTOS", "QUINIENTOS");
                }
                if (s.startsWith("SEIS CIENTOS", 1)) {
                    s = s.replaceFirst("SEIS CIENTOS", "SEISCIENTOS");
                }
                if (s.startsWith("SIETE CIENTOS", 1)) {
                    s = s.replaceFirst("SIETE CIENTOS", "SETECIENTOS");
                }
                if (s.startsWith("OCHO CIENTOS", 1)) {
                    s = s.replaceFirst("OCHO CIENTOS", "OCHOCIENTOS");
                }
                if (s.startsWith("NUEVE CIENTOS", 1)) {
                    s = s.replaceFirst("NUEVE CIENTOS", "NOVECIENTOS");
                }
                soFar = s.equals(" UNO") ? majorNames[place] + (String)soFar : (n > 1L ? s + majorNamesPlural[place] + (String)soFar : s + majorNames[place] + (String)soFar);
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + (String)soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        Language lang = Env.getLanguage(Env.getCtx());
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        pos = lang.isDecimalPoint() ? amount.lastIndexOf(46) : amount.lastIndexOf(44);
        int pos2 = 0;
        pos2 = lang.isDecimalPoint() ? amount.lastIndexOf(44) : amount.lastIndexOf(46);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = lang.isDecimalPoint() ? amount.replace(",", "") : amount.replace(".", "");
        int newpos = 0;
        newpos = lang.isDecimalPoint() ? amount.lastIndexOf(46) : amount.lastIndexOf(44);
        if (newpos < 0) {
            newpos = amount.length();
        }
        long pesos = Long.parseLong(amount.substring(0, newpos));
        sb.append(this.convert(pesos));
        int i2 = 0;
        while (i2 < oldamt.length()) {
            if (pos == i2) {
                String cents = oldamt.substring(i2 + 1);
                sb.append(' ').append(cents).append("/100");
                break;
            }
            ++i2;
        }
        return sb.toString();
    }
}

