/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MPackage;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

@Process
public class VoidShipmentProcess
extends SvrProcess {
    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            if (para[i2].getParameter() != null) {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
            }
            ++i2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MPackage m_package = new MPackage(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        boolean ok = m_package.processOnline("VS", false);
        m_package.saveEx();
        if (!ok) {
            this.getProcessInfo().setError(true);
            this.getProcessInfo().addLog(new ProcessInfoLog(this.getProcessInfo().getAD_Process_ID(), new Timestamp(System.currentTimeMillis()), null, m_package.getErrorMessage()));
            return m_package.getErrorMessage();
        }
        m_package.setPrice(BigDecimal.ZERO);
        m_package.setSurcharges(BigDecimal.ZERO);
        m_package.saveEx();
        this.getProcessInfo().addLog(new ProcessInfoLog(this.getProcessInfo().getAD_Process_ID(), new Timestamp(System.currentTimeMillis()), null, m_package.getShippingRespMessage()));
        return m_package.getShippingRespMessage();
    }
}

