/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.beans.Expression;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.GridTab;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MRefList;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.CacheChangeListener;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class DefaultEvaluatee
implements Evaluatee {
    private DataProvider m_dataProvider;
    private int m_windowNo;
    private int m_tabNo;
    private boolean m_onlyWindow;
    private Boolean m_onlyTab;
    private boolean m_useMsgForBoolean = false;
    private boolean m_useColumnDateFormat = false;
    private String m_trxName = null;
    private static final ReferenceCache s_ReferenceCache = new ReferenceCache("DefaultEvaluatee_ReferenceCache", 100, 1, 2000);

    public DefaultEvaluatee(GridTab gridTab, int windowNo, int tabNo) {
        this(gridTab, windowNo, tabNo, true);
    }

    public DefaultEvaluatee(GridTab gridTab, int windowNo, int tabNo, boolean onlyWindow) {
        this.m_dataProvider = gridTab != null ? new GridTabDataProvider(gridTab) : null;
        this.m_windowNo = windowNo;
        this.m_tabNo = tabNo;
        this.m_onlyWindow = onlyWindow;
    }

    public DefaultEvaluatee(GridTab gridTab, int windowNo, int tabNo, boolean onlyTab, boolean onlyWindow) {
        this.m_dataProvider = gridTab != null ? new GridTabDataProvider(gridTab) : null;
        this.m_windowNo = windowNo;
        this.m_tabNo = tabNo;
        this.m_onlyWindow = onlyWindow;
        this.m_onlyTab = onlyTab;
    }

    public DefaultEvaluatee(PO po) {
        this(new PODataProvider(po));
    }

    public DefaultEvaluatee(DataProvider dataProvider, int windowNo, int tabNo) {
        this(dataProvider);
        this.m_windowNo = windowNo;
        this.m_tabNo = tabNo;
    }

    public DefaultEvaluatee(DataProvider dataProvider) {
        this.m_dataProvider = dataProvider;
        this.m_windowNo = 0;
        this.m_tabNo = -1;
        this.m_onlyWindow = false;
        this.m_onlyTab = null;
    }

    public DefaultEvaluatee() {
        this.m_dataProvider = null;
        this.m_windowNo = 0;
        this.m_tabNo = -1;
        this.m_onlyWindow = false;
        this.m_onlyTab = null;
    }

    public void setTrxName(String trxName) {
        this.m_trxName = trxName;
    }

    @Override
    public String get_ValueAsString(String variableName) {
        return this.get_ValueAsString(Env.getCtx(), variableName);
    }

    public String get_ValueAsString(Properties ctx, String variableName) {
        boolean tabOnly;
        String t;
        String format = "";
        int f = variableName.indexOf("<");
        if (f > 0 && variableName.endsWith(">")) {
            format = variableName.substring(f + 1, variableName.length() - 1);
            variableName = variableName.substring(0, f);
        }
        String foreignColumn = "";
        f = variableName.indexOf(".");
        if (f > 0 && (t = variableName.substring(0, f)).matches(".*[_]ID([:].+)?")) {
            foreignColumn = variableName.substring(f + 1, variableName.length());
            variableName = t;
        }
        String defaultValue = null;
        int idx = variableName.indexOf(":");
        if (idx >= 0) {
            defaultValue = variableName.substring(idx + 1, variableName.length());
            variableName = variableName.substring(0, idx);
        }
        String value = null;
        boolean globalVariable = Env.isGlobalVariable(variableName);
        boolean bl = tabOnly = this.m_onlyTab != null ? this.m_onlyTab : false;
        if (this.m_windowNo != 0) {
            if (variableName.equalsIgnoreCase("_TabInfo_Record_ID")) {
                String keycolumnName = Env.getContext(Env.getCtx(), this.m_windowNo, this.m_tabNo, "_TabInfo_KeyColumnName", this.m_onlyTab != null ? this.m_onlyTab : false);
                value = Env.getContext(Env.getCtx(), this.m_windowNo, this.m_tabNo, keycolumnName, this.m_onlyTab != null ? this.m_onlyTab : false);
            } else if (this.m_tabNo <= 0) {
                value = !tabOnly ? Env.getContext(ctx, this.m_windowNo, variableName, this.m_onlyWindow) : Env.getContext(ctx, this.m_windowNo, this.m_tabNo, variableName, this.m_onlyTab, this.m_onlyWindow);
            } else {
                if (variableName.startsWith("~")) {
                    variableName = variableName.substring(1);
                }
                value = Env.getContext(ctx, this.m_windowNo, this.m_tabNo, variableName, tabOnly, true);
            }
        }
        if (Util.isEmpty(value) && (globalVariable || Env.isPreference(variableName))) {
            value = Env.getContext(ctx, variableName);
        }
        Object dataValue = null;
        if (Util.isEmpty(value) && this.m_dataProvider != null && !globalVariable && variableName.startsWith("=")) {
            dataValue = this.m_dataProvider.getProperty(variableName = variableName.substring(1));
            value = dataValue != null ? dataValue.toString() : "";
        }
        boolean withTabNo = false;
        if (globalVariable) {
            variableName = variableName.substring(1);
        } else if (variableName.indexOf("|") > 0) {
            variableName = variableName.substring(variableName.lastIndexOf("|") + 1);
            withTabNo = true;
        } else if (variableName.startsWith("~")) {
            variableName = variableName.substring(1);
            withTabNo = true;
        }
        if (!globalVariable && Util.isEmpty(value) && this.m_windowNo != 0 && withTabNo && !tabOnly) {
            value = Env.getContext(ctx, this.m_windowNo, variableName);
        }
        if (Util.isEmpty(value) && this.m_dataProvider != null && !globalVariable) {
            dataValue = this.m_dataProvider.getValue(variableName);
            String string = value = dataValue != null ? dataValue.toString() : "";
        }
        if (!(globalVariable || this.m_dataProvider != null || !Util.isEmpty(value) || this.m_onlyWindow || this.m_onlyTab != null && this.m_onlyTab.booleanValue())) {
            value = Env.getContext(ctx, variableName);
        }
        if (Util.isEmpty(value) && defaultValue != null) {
            value = defaultValue;
        }
        MColumn column = null;
        if (!globalVariable && this.m_dataProvider != null) {
            column = this.m_dataProvider.getColumn(variableName);
        }
        if (!Util.isEmpty(value) && !Util.isEmpty(foreignColumn) && variableName.endsWith("_ID")) {
            int id = 0;
            try {
                id = Integer.parseInt(value);
            }
            catch (Exception exception) {}
            if (id > 0) {
                MTable table2;
                int tblIndex;
                String defaultReferenceValue = "";
                String foreignTable = DefaultEvaluatee.getForeignTableName(variableName, column);
                if (!Util.isEmpty(foreignTable) && (tblIndex = foreignColumn.indexOf(".")) > 0) {
                    String qualifiedTable = foreignColumn.substring(0, tblIndex);
                    if (qualifiedTable.equalsIgnoreCase(foreignTable)) {
                        foreignColumn = foreignColumn.substring(tblIndex + 1);
                    } else {
                        foreignTable = null;
                    }
                }
                if (!Util.isEmpty(foreignTable) && (table2 = MTable.get(Env.getCtx(), foreignTable)) != null) {
                    Boolean booleanValue;
                    dataValue = this.getColumnValue(table2, foreignTable, foreignColumn, id, defaultReferenceValue);
                    value = dataValue == null ? "" : (dataValue instanceof Boolean ? ((booleanValue = (Boolean)dataValue) != false ? "Y" : "N") : dataValue.toString());
                }
            }
        }
        if (format != null && format.length() > 0) {
            String foreignTable = DefaultEvaluatee.getForeignTableName(variableName, column);
            if (foreignTable == null && column != null && this.getPO() != null && this.getPO().get_KeyColumns() != null && this.getPO().get_KeyColumns().length == 1 && this.getPO().get_KeyColumns()[0].equalsIgnoreCase(column.getColumnName())) {
                foreignTable = this.getPO().get_TableName();
            }
            if (Util.isEmpty(foreignColumn) && variableName.endsWith("_ID")) {
                int id = 0;
                try {
                    id = Integer.parseInt(value);
                }
                catch (Exception exception) {}
                if (id > 0) {
                    MTable table3;
                    int tblIndex;
                    if (!Util.isEmpty(foreignTable) && (tblIndex = format.indexOf(".")) > 0) {
                        String qualifiedTable = format.substring(0, tblIndex);
                        if (qualifiedTable.equalsIgnoreCase(foreignTable)) {
                            format = format.substring(tblIndex + 1);
                        } else {
                            foreignTable = null;
                        }
                    }
                    if (!Util.isEmpty(foreignTable) && (table3 = MTable.get(Env.getCtx(), foreignTable)) != null && (column = table3.getColumn(format)) != null) {
                        if (column.isSecure()) {
                            value = "********";
                        } else {
                            String trxName = this.m_trxName != null ? this.m_trxName : (this.m_dataProvider != null ? this.m_dataProvider.getTrxName() : null);
                            String keyCol = foreignTable + "_ID";
                            value = DB.getSQLValueString(trxName, "SELECT " + format + " FROM " + foreignTable + " WHERE " + keyCol + "=?", id);
                        }
                    }
                }
            } else if (!Util.isEmpty(value) && !Util.isEmpty(foreignTable) && foreignTable.equals("AD_Ref_List") && column != null) {
                int refID = column.getAD_Reference_Value_ID();
                if (format.equals("Name")) {
                    value = MRefList.getListName(Env.getCtx(), refID, value);
                } else if (format.equals("Description")) {
                    value = MRefList.getListDescription(Env.getCtx(), DB.getSQLValueStringEx(null, "SELECT Name FROM AD_Reference WHERE AD_Reference_ID = ?", refID), value);
                }
            } else if (dataValue != null && dataValue instanceof Date) {
                dateValue = (Date)dataValue;
                SimpleDateFormat df = new SimpleDateFormat(format);
                value = df.format(dateValue);
            } else if (dataValue != null && dataValue instanceof Number) {
                Number numberValue = (Number)dataValue;
                DecimalFormat df = new DecimalFormat(format);
                value = df.format(numberValue.doubleValue());
            } else if (dataValue != null) {
                MessageFormat mf = new MessageFormat(format);
                value = mf.format(dataValue);
            }
        } else if (column != null) {
            if (column.isSecure()) {
                value = "********";
            } else if (column != null && column.getAD_Reference_ID() == 20 && dataValue != null && dataValue instanceof Boolean) {
                Boolean booleanValue = (Boolean)dataValue;
                value = this.m_useMsgForBoolean ? (booleanValue.booleanValue() ? Msg.getMsg(Env.getCtx(), "Yes") : Msg.getMsg(Env.getCtx(), "No")) : (booleanValue != false ? "Y" : "N");
            } else if (column != null && DisplayType.isDate(column.getAD_Reference_ID()) && dataValue != null && dataValue instanceof Date) {
                dateValue = (Date)dataValue;
                if (this.m_useColumnDateFormat) {
                    SimpleDateFormat sdf = DisplayType.getDateFormat(column.getAD_Reference_ID());
                    value = sdf.format(dateValue);
                }
            }
        } else if (dataValue != null && dataValue instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)dataValue;
            int precision = MClient.get(Env.getCtx()).getAcctSchema().getStdPrecision();
            value = decimalValue.setScale(precision, RoundingMode.HALF_UP).toPlainString();
        }
        return value != null ? value : "";
    }

    private static String getForeignTableName(String variableName, MColumn column) {
        String foreignTable = null;
        if (column != null) {
            foreignTable = column.getReferenceTableName();
        } else if (variableName.endsWith("_ID")) {
            foreignTable = variableName.substring(0, variableName.length() - 3);
            if (MTable.get(Env.getCtx(), foreignTable) == null) {
                foreignTable = null;
            }
        }
        return foreignTable;
    }

    private Object getColumnValue(MTable table2, String foreignTable, String foreignColumn, int id, String defaultValue) {
        Object returnValue = defaultValue;
        String key = foreignTable + "|" + id;
        PO po = null;
        if (s_ReferenceCache.containsKey(key)) {
            po = (PO)s_ReferenceCache.get(key);
            if (po != null && po.get_ID() == id) {
                returnValue = po.get_Value(foreignColumn);
            } else {
                po = null;
            }
        }
        if (po == null && (po = table2.getPO(id, null)) != null && po.get_ID() == id) {
            s_ReferenceCache.put(key, po);
            returnValue = po.get_Value(foreignColumn);
        }
        return returnValue;
    }

    public boolean isUseMsgForBoolean() {
        return this.m_useMsgForBoolean;
    }

    public void setUseMsgForBoolean(boolean useMsgForBoolean) {
        this.m_useMsgForBoolean = useMsgForBoolean;
    }

    public boolean isUseColumnDateFormat() {
        return this.m_useColumnDateFormat;
    }

    public void setUseColumnDateFormat(boolean useColumnDateFormat) {
        this.m_useColumnDateFormat = useColumnDateFormat;
    }

    public PO getPO() {
        DataProvider dataProvider;
        if (this.m_dataProvider != null && (dataProvider = this.m_dataProvider) instanceof PODataProvider) {
            PODataProvider pdp = (PODataProvider)dataProvider;
            return pdp.po;
        }
        return null;
    }

    public static interface DataProvider {
        public Object getValue(String var1);

        public Object getProperty(String var1);

        public MColumn getColumn(String var1);

        public String getTrxName();
    }

    public static class GridTabDataProvider
    implements DataProvider {
        private GridTab gridTab;

        public GridTabDataProvider(GridTab gridTab) {
            this.gridTab = gridTab;
        }

        @Override
        public Object getValue(String columnName) {
            if (this.gridTab != null && this.gridTab.getField(columnName) != null) {
                return this.gridTab.getValue(columnName);
            }
            return null;
        }

        @Override
        public Object getProperty(String propertyName) {
            return null;
        }

        @Override
        public MColumn getColumn(String columnName) {
            MColumn column = null;
            if (this.gridTab != null && (column = MColumn.get(Env.getCtx(), this.gridTab.getTableName(), columnName)) == null) {
                GridTab parent = this.gridTab.getParentTab();
                while (column == null && parent != null) {
                    column = MColumn.get(Env.getCtx(), parent.getTableName(), columnName);
                    parent = parent.getParentTab();
                }
            }
            return column;
        }

        @Override
        public String getTrxName() {
            return null;
        }
    }

    public static class PODataProvider
    implements DataProvider {
        private PO po;

        public PODataProvider(PO po) {
            this.po = po;
        }

        @Override
        public Object getValue(String columnName) {
            if (this.po != null && this.po.get_ColumnIndex(columnName) >= 0) {
                return this.po.get_Value(columnName);
            }
            return null;
        }

        @Override
        public Object getProperty(String propertyName) {
            char startChar = ((String)propertyName).charAt(0);
            if (startChar != Character.toUpperCase(startChar)) {
                propertyName = Character.toUpperCase(startChar) + ((String)propertyName).substring(1);
            }
            String methodName = "get" + (String)propertyName;
            Expression methodExpression = new Expression(this.po, methodName, null);
            Object poValue = null;
            try {
                poValue = methodExpression.getValue();
            }
            catch (Exception exception) {}
            return poValue;
        }

        @Override
        public MColumn getColumn(String columnName) {
            MColumn column = null;
            if (this.po != null && this.po.get_ColumnIndex(columnName) >= 0) {
                column = MColumn.get(Env.getCtx(), this.po.get_TableName(), columnName);
            }
            return column;
        }

        @Override
        public String getTrxName() {
            return this.po != null ? this.po.get_TrxName() : null;
        }
    }

    private static final class ReferenceCache
    extends CCache<String, PO>
    implements CacheChangeListener {
        private static final long serialVersionUID = 6884795644185015913L;

        private ReferenceCache(String name, int initialCapacity, int expireMinutes, int maxSize) {
            super(null, name, initialCapacity, expireMinutes, false, maxSize);
        }

        @Override
        public void reset(String tableName) {
            String filter = tableName + "|";
            List keys = this.keySet().stream().filter(e -> e.startsWith(filter)).collect(Collectors.toList());
            if (!keys.isEmpty()) {
                for (String key : keys) {
                    this.remove(key);
                }
            }
        }

        @Override
        public void reset(String tableName, int recordId) {
            String key = tableName + "|" + recordId;
            this.remove(key);
        }

        @Override
        public void reset(String tableName, String key) {
            this.remove(key);
        }
    }
}

