/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.HtmlCode;
import org.compiere.util.Language;
import org.compiere.util.MimeType;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUser;

public final class WebUtil {
    private static CLogger log = CLogger.getCLogger(WebUtil.class);

    @Deprecated
    public static void createLoginPage(HttpServletRequest request, HttpServletResponse response, HttpServlet servlet, Properties ctx, String AD_Message) throws ServletException, IOException {
        request.getSession().invalidate();
        String url = WebEnv.getBaseDirectory("index.html");
        WebDoc doc = null;
        doc = ctx != null && AD_Message != null && !AD_Message.equals("") ? WebDoc.create(Msg.getMsg(ctx, AD_Message)) : (AD_Message != null ? WebDoc.create(AD_Message) : WebDoc.create(false));
        script script2 = new script("window.top.location.replace('" + url + "');");
        doc.getBody().addElement((Element)script2);
        WebUtil.createResponse(request, response, servlet, null, doc, false);
    }

    @Deprecated
    public static input getLoginButton(Properties ctx) {
        String text = "Login";
        if (ctx != null) {
            text = Msg.getMsg(ctx, "Login");
        }
        input button = new input("button", text, "  " + text);
        button.setID(text);
        button.setClass("loginbtn");
        StringBuilder cmd = new StringBuilder("window.top.location.replace('");
        cmd.append(WebEnv.getBaseDirectory("index.html"));
        cmd.append("');");
        button.setOnClick(cmd.toString());
        return button;
    }

    @Deprecated
    public static Properties getCookieProprties(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int i2 = 0;
            while (i2 < cookies.length) {
                if (cookies[i2].getName().equals("adempiereInfo")) {
                    return WebUtil.propertiesDecode(cookies[i2].getValue());
                }
                ++i2;
            }
        }
        return new Properties();
    }

    public static String getParameter(HttpServletRequest request, String parameter) {
        String data;
        if (request == null || parameter == null) {
            return null;
        }
        String enc = request.getCharacterEncoding();
        try {
            if (enc == null) {
                request.setCharacterEncoding("UTF-8");
                enc = request.getCharacterEncoding();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Set CharacterEncoding=UTF-8", e);
            enc = request.getCharacterEncoding();
        }
        if ((data = request.getParameter(parameter)) == null || data.length() == 0) {
            return data;
        }
        if (enc != null && !"UTF-8".equals(enc)) {
            try {
                String dataEnc = new String(data.getBytes(enc), "UTF-8");
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Convert " + data + " (" + enc + ")-> " + dataEnc + " (UTF-8)");
                }
                data = dataEnc;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Convert " + data + " (" + enc + ")->UTF-8");
            }
        }
        Object inStr = data;
        StringBuilder outStr = new StringBuilder();
        int i2 = ((String)inStr).indexOf("&#");
        while (i2 != -1) {
            outStr.append(((String)inStr).substring(0, i2));
            inStr = ((String)inStr).substring(i2 + 2, ((String)inStr).length());
            int j = ((String)inStr).indexOf(59);
            if (j < 0) {
                inStr = "&#" + (String)inStr;
                break;
            }
            String token = ((String)inStr).substring(0, j);
            try {
                int intToken = Integer.parseInt(token);
                outStr.append((char)intToken);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Token=" + token, e);
                outStr.append("&#").append(token).append(";");
            }
            inStr = ((String)inStr).substring(j + 1, ((String)inStr).length());
            i2 = ((String)inStr).indexOf("&#");
        }
        outStr.append((String)inStr);
        String retValue = outStr.toString();
        if (log.isLoggable(Level.FINEST)) {
            log.finest(parameter + "=" + data + " -> " + retValue);
        }
        return retValue;
    }

    public static int getParameterAsInt(HttpServletRequest request, String parameter) {
        if (request == null || parameter == null) {
            return 0;
        }
        String data = WebUtil.getParameter(request, parameter);
        if (data == null || data.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(data);
        }
        catch (Exception e) {
            log.warning(parameter + "=" + data + " - " + String.valueOf(e));
            return 0;
        }
    }

    public static BigDecimal getParameterAsBD(HttpServletRequest request, String parameter) {
        if (request == null || parameter == null) {
            return Env.ZERO;
        }
        String data = WebUtil.getParameter(request, parameter);
        if (data == null || data.length() == 0) {
            return Env.ZERO;
        }
        try {
            return new BigDecimal(data);
        }
        catch (Exception exception) {
            try {
                DecimalFormat format = DisplayType.getNumberFormat(22);
                Object oo = format.parseObject(data);
                if (oo instanceof BigDecimal) {
                    return (BigDecimal)oo;
                }
                if (oo instanceof Number) {
                    return BigDecimal.valueOf(((Number)oo).doubleValue());
                }
                return new BigDecimal(oo.toString());
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(parameter + "=" + data + " - " + String.valueOf(e));
                }
                return Env.ZERO;
            }
        }
    }

    public static Timestamp getParameterAsDate(HttpServletRequest request, String parameter) {
        return WebUtil.getParameterAsDate(request, parameter, null);
    }

    public static Timestamp getParameterAsDate(HttpServletRequest request, String parameter, Language language) {
        Date date;
        SimpleDateFormat format;
        if (request == null || parameter == null) {
            return null;
        }
        String data = WebUtil.getParameter(request, parameter);
        if (data == null || data.length() == 0) {
            return null;
        }
        if (language != null) {
            try {
                format = DisplayType.getDateFormat(15, language);
                date = format.parse(data);
                if (date != null) {
                    return new Timestamp(date.getTime());
                }
            }
            catch (Exception exception) {}
        }
        try {
            format = DisplayType.getDateFormat(15);
            date = format.parse(data);
            if (date != null) {
                return new Timestamp(date.getTime());
            }
        }
        catch (Exception exception) {}
        try {
            return Timestamp.valueOf(data);
        }
        catch (Exception exception) {
            log.warning(parameter + " - cannot parse: " + data);
            return null;
        }
    }

    public static boolean getParameterAsBoolean(HttpServletRequest request, String parameter) {
        return WebUtil.getParameterAsBoolean(request, parameter, null);
    }

    public static boolean getParameterAsBoolean(HttpServletRequest request, String parameter, String expected) {
        if (request == null || parameter == null) {
            return false;
        }
        String data = WebUtil.getParameter(request, parameter);
        if (data == null || data.length() == 0) {
            return false;
        }
        if (expected == null) {
            return true;
        }
        return expected.equalsIgnoreCase(data);
    }

    public static String getParamOrNull(HttpServletRequest request, String parameter) {
        String value = WebUtil.getParameter(request, parameter);
        if (value == null) {
            return value;
        }
        if (value.length() == 0) {
            return null;
        }
        return value;
    }

    public static void createResponse(HttpServletRequest request, HttpServletResponse response, HttpServlet servlet, Properties cookieProperties, WebDoc doc, boolean debug) throws IOException {
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/html; charset=UTF-8");
        if (cookieProperties != null) {
            Cookie cookie = new Cookie("adempiereInfo", WebUtil.propertiesEncode(cookieProperties));
            cookie.setComment("(c) iDempiere, Inc - Jorg Janke");
            cookie.setSecure(true);
            cookie.setPath("/");
            if (cookieProperties.size() == 0) {
                cookie.setMaxAge(0);
            } else {
                cookie.setMaxAge(2592000);
            }
            response.addCookie(cookie);
        }
        PrintWriter out = response.getWriter();
        doc.output(out);
        out.flush();
        if (out.checkError()) {
            log.log(Level.SEVERE, "error writing");
        }
        out.close();
    }

    @Deprecated
    public static script getClearFrame(String targetFrame) {
        StringBuilder cmd = new StringBuilder();
        cmd.append("// <!-- clear frame\n").append("var d = parent.").append(targetFrame).append(".document;\n").append("d.open();\n").append("d.write('<link href=\"").append(WebEnv.getStylesheetURL()).append("\" type=\"text/css\" rel=\"stylesheet\">');\n").append("d.write('<link href=\"/adempiere/css/window.css\" type=\"text/css\" rel=\"stylesheet\">');\n").append("d.write('<br><br><br><br><br><br><br>');").append("d.write('<div style=\"text-align: center;\"><img class=\"CenterImage\" style=\"vertical-align: middle; filter:alpha(opacity=50); -moz-opacity:0.5;\" src=\"Logo.gif\" /></div>');\n").append("d.close();\n").append("// -- clear frame -->");
        return new script(cmd.toString());
    }

    @Deprecated
    public static HtmlCode getForward(String url, int delaySec) {
        if (delaySec <= 0) {
            delaySec = 3;
        }
        HtmlCode retValue = new HtmlCode();
        a a2 = new a(url);
        a2.addElement(url);
        retValue.addElement((Element)a2);
        script script2 = new script("setTimeout(\"window.top.location.replace('" + url + "')\"," + (delaySec + 1000) + ");");
        retValue.addElement((Element)script2);
        return retValue;
    }

    @Deprecated
    public static void createForwardPage(HttpServletResponse response, String title2, String forwardURL, int delaySec) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        WebDoc doc = WebDoc.create(title2);
        body b2 = doc.getBody();
        b2.addElement((Element)WebUtil.getForward(forwardURL, delaySec));
        PrintWriter out = response.getWriter();
        doc.output(out);
        out.flush();
        if (out.checkError()) {
            log.log(Level.SEVERE, "Error writing");
        }
        out.close();
        if (log.isLoggable(Level.FINE)) {
            log.fine(forwardURL + " - " + title2);
        }
    }

    public static boolean exists(String test) {
        if (test == null) {
            return false;
        }
        return test.length() > 0;
    }

    public static boolean exists(HttpServletRequest request, String parameter) {
        if (request == null || parameter == null) {
            return false;
        }
        try {
            String enc = request.getCharacterEncoding();
            if (enc == null) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Set CharacterEncoding=UTF-8", e);
        }
        return WebUtil.exists(request.getParameter(parameter));
    }

    public static boolean isEmailValid(String email) {
        if (email == null || email.length() == 0) {
            return false;
        }
        try {
            InternetAddress ia = new InternetAddress(email, true);
            if (ia != null) {
                return true;
            }
        }
        catch (AddressException ex) {
            log.warning(email + " - " + ex.getLocalizedMessage());
        }
        return false;
    }

    public static String propertiesEncode(Properties pp) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            pp.store(bos, "adempiere");
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "store", e);
        }
        String result = new String(bos.toByteArray());
        try {
            result = URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "encodeUTF-8", e);
            String enc = System.getProperty("file.encoding");
            try {
                result = URLEncoder.encode(result, enc);
                if (log.isLoggable(Level.INFO)) {
                    log.info("encode: " + enc);
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "encode", ex);
            }
        }
        return result;
    }

    public static Properties propertiesDecode(String data) {
        String result = null;
        try {
            result = URLDecoder.decode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "decodeUTF-8", e);
            String enc = System.getProperty("file.encoding");
            try {
                result = URLEncoder.encode(data, enc);
                log.log(Level.SEVERE, "decode: " + enc);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "decode", ex);
            }
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(result.getBytes());
        Properties pp = new Properties();
        try {
            pp.load(bis);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "load", e);
        }
        return pp;
    }

    public static option[] convertToOption(NamePair[] list, String default_ID) {
        int size = list.length;
        option[] retValue = new option[size];
        int i2 = 0;
        while (i2 < size) {
            boolean selected = false;
            if (i2 == 0 && (default_ID == null || default_ID.length() == 0)) {
                selected = true;
            }
            String name = Util.maskHTML(list[i2].getName());
            retValue[i2] = new option(list[i2].getID()).addElement(name);
            if (default_ID != null && default_ID.equals(list[i2].getID())) {
                selected = true;
            }
            retValue[i2].setSelected(selected);
            ++i2;
        }
        return retValue;
    }

    @Deprecated
    public static tr createField(tr line, String FORMNAME, String PARAMETER, String labelText, String inputType, Object value, int sizeDisplay, int size, boolean longField, boolean mandatory, String onChange, StringBuffer script2) {
        if (line == null) {
            line = new tr();
        }
        Object labelInfo = labelText;
        if (mandatory) {
            labelInfo = (String)labelInfo + "&nbsp;<font color=\"red\">*</font>";
            String fName = "document." + FORMNAME + "." + PARAMETER;
            script2.append(fName).append(".required=true; ");
        }
        label llabel = new label().setFor(PARAMETER).addElement((String)labelInfo);
        llabel.setID("ID_" + PARAMETER + "_Label");
        line.addElement((Element)new td().addElement((Element)llabel).setAlign("right"));
        input iinput = new input(inputType, PARAMETER, value == null ? "" : value.toString());
        iinput.setSize(sizeDisplay).setMaxlength(size);
        iinput.setID("ID_" + PARAMETER);
        if (onChange != null && onChange.length() > 0) {
            iinput.setOnChange(onChange);
        }
        iinput.setTitle(labelText);
        td field = new td().addElement((Element)iinput).setAlign("left");
        if (longField) {
            field.setColSpan(3);
        }
        line.addElement((Element)field);
        return line;
    }

    @Deprecated
    public static input createClosePopupButton(Properties ctx) {
        String text = "Close";
        if (ctx != null) {
            text = Msg.getMsg(ctx, "Close");
        }
        input close = new input("button", text, "  " + text);
        close.setID(text);
        close.setClass("closebtn");
        close.setTitle("Close PopUp");
        close.setOnClick("self.close();return false;");
        return close;
    }

    public static String streamAttachment(HttpServletResponse response, MAttachment attachment, int attachmentIndex) {
        if (attachment == null) {
            return "No Attachment";
        }
        int realIndex = -1;
        MAttachmentEntry[] entries = attachment.getEntries();
        int i2 = 0;
        while (i2 < entries.length) {
            MAttachmentEntry entry = entries[i2];
            if (entry.getIndex() == attachmentIndex) {
                realIndex = i2;
                break;
            }
            ++i2;
        }
        if (realIndex < 0) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No Attachment Entry for Index=" + attachmentIndex + " - " + String.valueOf(attachment));
            }
            return "Attachment Entry not found";
        }
        MAttachmentEntry entry = entries[realIndex];
        if (entry.getData() == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Empty Attachment Entry for Index=" + attachmentIndex + " - " + String.valueOf(attachment));
            }
            return "Attachment Entry empty";
        }
        try {
            int bufferSize = 2048;
            int fileLength = entry.getData().length;
            response.setContentType(entry.getContentType());
            response.setBufferSize(bufferSize);
            response.setContentLength(fileLength);
            if (log.isLoggable(Level.FINE)) {
                log.fine(entry.toString());
            }
            long time = System.currentTimeMillis();
            ServletOutputStream out = response.getOutputStream();
            out.write(entry.getData());
            out.flush();
            out.close();
            time = System.currentTimeMillis() - time;
            double speed = (double)fileLength / 1024.0 / ((double)time / 1000.0);
            if (log.isLoggable(Level.INFO)) {
                log.info("Length=" + fileLength + " - " + time + " ms - " + speed + " kB/sec - " + entry.getContentType());
            }
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, ex.toString());
            return "Streaming error - " + String.valueOf(ex);
        }
        return null;
    }

    public static String streamFile(HttpServletResponse response, File file) {
        if (file == null) {
            return "No File";
        }
        if (!file.exists()) {
            return "File not found: " + file.getAbsolutePath();
        }
        MimeType mimeType = MimeType.get(file.getAbsolutePath());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream in = new FileInputStream(file);){
                int bufferSize = 2048;
                int fileLength = (int)file.length();
                response.setContentType(mimeType.getMimeType());
                response.setBufferSize(bufferSize);
                response.setContentLength(fileLength);
                if (log.isLoggable(Level.FINE)) {
                    log.fine(file.toString());
                }
                long time = System.currentTimeMillis();
                Throwable throwable2 = null;
                Object var11_15 = null;
                try (ServletOutputStream out = response.getOutputStream();){
                    int c = 0;
                    while ((c = in.read()) != -1) {
                        out.write(c);
                    }
                    out.flush();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                time = System.currentTimeMillis() - time;
                double speed = (double)fileLength / 1024.0 / ((double)time / 1000.0);
                if (log.isLoggable(Level.INFO)) {
                    log.info("Length=" + fileLength + " - " + time + " ms - " + speed + " kB/sec - " + String.valueOf(mimeType));
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, ex.toString());
            return "Streaming error - " + String.valueOf(ex);
        }
        return null;
    }

    @Deprecated
    public static void deleteCookieWebUser(HttpServletRequest request, HttpServletResponse response, String COOKIE_NAME) {
        Cookie cookie = new Cookie(COOKIE_NAME, " ");
        cookie.setComment("adempiere Web User");
        cookie.setPath(request.getContextPath());
        cookie.setMaxAge(1);
        cookie.setSecure(true);
        response.addCookie(cookie);
    }

    public static String getFrom(HttpServletRequest request) {
        Object host = request.getRemoteHost();
        if (!((String)host).equals(request.getRemoteAddr())) {
            host = (String)host + " (" + request.getRemoteAddr() + ")";
        }
        return host;
    }

    @Deprecated
    public static void addCookieWebUser(HttpServletRequest request, HttpServletResponse response, String webUser, String COOKIE_NAME) {
        try {
            Cookie cookie = new Cookie(COOKIE_NAME, URLEncoder.encode(webUser, "utf-8"));
            cookie.setComment("adempiere Web User");
            cookie.setPath(request.getContextPath());
            cookie.setMaxAge(2592000);
            cookie.setSecure(true);
            response.addCookie(cookie);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static boolean updateFields(HttpServletRequest request, WebUser wu, boolean updateEMailPwd) {
        if (updateEMailPwd) {
            String s = WebUtil.getParameter(request, "PasswordNew");
            wu.setPasswordMessage(null);
            wu.setPassword(s);
            if (wu.getPasswordMessage() != null) {
                return false;
            }
            s = WebUtil.getParameter(request, "EMail");
            if (!WebUtil.isEmailValid(s)) {
                wu.setPasswordMessage("EMail Invalid");
                return false;
            }
            wu.setEmail(s.trim());
        }
        StringBuilder mandatory = new StringBuilder();
        String s = WebUtil.getParameter(request, "Name");
        if (s != null && s.length() != 0) {
            wu.setName(s.trim());
        } else {
            mandatory.append(" - Name");
        }
        s = WebUtil.getParameter(request, "Company");
        if (s != null && s.length() != 0) {
            wu.setCompany(s);
        }
        if ((s = WebUtil.getParameter(request, "Title")) != null && s.length() != 0) {
            wu.setTitle(s);
        }
        if ((s = WebUtil.getParameter(request, "Address")) != null && s.length() != 0) {
            wu.setAddress(s);
        } else {
            mandatory.append(" - Address");
        }
        s = WebUtil.getParameter(request, "Address2");
        if (s != null && s.length() != 0) {
            wu.setAddress2(s);
        }
        if ((s = WebUtil.getParameter(request, "City")) != null && s.length() != 0) {
            wu.setCity(s);
        } else {
            mandatory.append(" - City");
        }
        s = WebUtil.getParameter(request, "Postal");
        if (s != null && s.length() != 0) {
            wu.setPostal(s);
        } else {
            mandatory.append(" - Postal");
        }
        s = WebUtil.getParameter(request, "C_Country_ID");
        if (s != null && s.length() != 0) {
            wu.setC_Country_ID(s);
        }
        if ((s = WebUtil.getParameter(request, "C_Region_ID")) != null && s.length() != 0) {
            wu.setC_Region_ID(s);
        }
        if ((s = WebUtil.getParameter(request, "RegionName")) != null && s.length() != 0) {
            wu.setRegionName(s);
        }
        if ((s = WebUtil.getParameter(request, "Phone")) != null && s.length() != 0) {
            wu.setPhone(s);
        }
        if ((s = WebUtil.getParameter(request, "Phone2")) != null && s.length() != 0) {
            wu.setPhone2(s);
        }
        if ((s = WebUtil.getParameter(request, "C_BP_Group_ID")) != null && s.length() != 0) {
            wu.setC_BP_Group_ID(s);
        }
        if ((s = WebUtil.getParameter(request, "Fax")) != null && s.length() != 0) {
            wu.setFax(s);
        }
        if (mandatory.length() > 0) {
            mandatory.insert(0, "Enter Mandatory");
            wu.setSaveErrorMessage(mandatory.toString());
            return false;
        }
        return wu.save();
    }

    public static String getServerName() {
        StringBuilder strBuilder = new StringBuilder();
        try {
            strBuilder.append(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            log.log(Level.WARNING, "Local host or IP not found", e);
        }
        strBuilder.append(":").append(WebUtil.getHostIP());
        return strBuilder.toString();
    }

    public static String getHostIP() {
        String retVal = null;
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            if (!localAddress.isLinkLocalAddress() && !localAddress.isLoopbackAddress() && localAddress.isSiteLocalAddress()) {
                return localAddress.getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            log.log(Level.WARNING, "UnknownHostException while retrieving host ip");
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            block6: while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !inetAddress.isSiteLocalAddress()) continue;
                    retVal = inetAddress.getHostAddress().toString();
                    continue block6;
                }
            }
        }
        catch (SocketException socketException) {
            log.log(Level.WARNING, "Socket Exeception while retrieving host ip");
        }
        if (retVal == null) {
            try {
                retVal = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                log.log(Level.WARNING, "UnknownHostException while retrieving host ip");
            }
        }
        return retVal;
    }

    public static boolean isUrlOk(String urlString) {
        int responseCode = 0;
        try {
            URL url = new URL(urlString);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setRequestMethod("HEAD");
            responseCode = huc.getResponseCode();
        }
        catch (IOException iOException) {
            responseCode = -1;
        }
        return responseCode == 200;
    }
}

