/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.CreditStatus;
import org.adempiere.base.ICreditManager;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.PeriodClosedException;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.PaymentUtil;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCurrency;
import org.compiere.model.MDepositBatchLine;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MOnlineTrxHistory;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MPaymentTransaction;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.MPeriod;
import org.compiere.model.MRefList;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Obscure;
import org.compiere.model.PO;
import org.compiere.model.PaymentInterface;
import org.compiere.model.PaymentProcessor;
import org.compiere.model.Query;
import org.compiere.model.X_C_Payment;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.IDocsPostProcess;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.IBAN;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class MPayment
extends X_C_Payment
implements DocAction,
ProcessCall,
PaymentInterface,
IDocsPostProcess {
    private static final long serialVersionUID = -1157628050370126666L;
    protected MBankAccountProcessor[] m_mBankAccountProcessors = null;
    protected MBankAccountProcessor m_mBankAccountProcessor = null;
    protected static CLogger s_log = CLogger.getCLogger(MPayment.class);
    protected String m_errorMessage = null;
    public static String REVERSE_INDICATOR = "^";
    protected String m_processMsg = null;
    protected boolean m_justPrepared = false;
    protected IProcessUI m_processUI;
    protected ArrayList<PO> docsPostProcess = new ArrayList();
    protected MAllocationHdr m_justCreatedAllocInv = null;
    public static final int UNALLOCATED_PAYMENT_SELECTED = 0;
    public static final int UNALLOCATED_PAYMENT_TRX_DATE = 1;
    public static final int UNALLOCATED_PAYMENT_DOCUMENT_KEY_NAME_PAIR = 2;
    public static final int UNALLOCATED_PAYMENT_MULTI_CURRENCY_ISO = 3;
    public static final int UNALLOCATED_PAYMENT_MULTI_CURRENCY_PAYMENT_AMT = 4;
    public static final int UNALLOCATED_PAYMENT_MULTI_CURRENCY_CONVERTED_AMT = 5;
    public static final int UNALLOCATED_PAYMENT_MULTI_CURRENCY_OPEN_AMT = 6;
    public static final int UNALLOCATED_PAYMENT_MULTI_CURRENCY_APPLIED_AMT = 7;
    public static final int UNALLOCATED_PAYMENT_SINGLE_CURRENCY_AMT = 3;
    public static final int UNALLOCATED_PAYMENT_SINGLE_CURRENCY_OPEN_AMT = 4;
    public static final int UNALLOCATED_PAYMENT_SINGLE_CURRENCY_APPLIED_AMT = 5;

    public static MPayment[] getOfBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        List<MPayment> list = new Query(ctx, "C_Payment", "C_BPartner_ID=?", trxName).setParameters(C_BPartner_ID).list();
        MPayment[] retValue = new MPayment[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MPayment[] getOfBankTransfer(Properties ctx, int C_BankTransfer_ID, String trxName) {
        List<MPayment> list = new Query(ctx, "C_Payment", "C_BankTransfer_ID=?", trxName).setParameters(C_BankTransfer_ID).setOrderBy("C_Payment_ID").list();
        MPayment[] retValue = new MPayment[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MPayment(Properties ctx, String C_Payment_UU, String trxName) {
        super(ctx, C_Payment_UU, trxName);
        if (Util.isEmpty(C_Payment_UU)) {
            this.setInitialDefaults();
        }
    }

    public MPayment(Properties ctx, int C_Payment_ID, String trxName) {
        super(ctx, C_Payment_ID, trxName);
        if (C_Payment_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setDocAction("CO");
        this.setDocStatus("DR");
        this.setTrxType("S");
        this.setR_AvsAddr("X");
        this.setR_AvsZip("X");
        this.setIsReceipt(true);
        this.setIsApproved(false);
        this.setIsReconciled(false);
        this.setIsAllocated(false);
        this.setIsOnline(false);
        this.setIsSelfService(false);
        this.setIsDelayedCapture(false);
        this.setIsPrepayment(false);
        this.setProcessed(false);
        this.setProcessing(false);
        this.setPosted(false);
        this.setPayAmt(Env.ZERO);
        this.setDiscountAmt(Env.ZERO);
        this.setTaxAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setIsOverUnderPayment(true);
        this.setOverUnderAmt(Env.ZERO);
        this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        this.setDateAcct(this.getDateTrx());
        this.setTenderType("K");
    }

    public MPayment(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void resetNew() {
        this.setC_Payment_ID(0);
        this.set_ValueNoCheck("DocumentNo", null);
        this.setDocAction("PR");
        this.setDocStatus("DR");
        this.setProcessed(false);
        this.setPosted(false);
        this.setIsReconciled(false);
        this.setIsAllocated(false);
        this.setIsOnline(false);
        this.setIsDelayedCapture(false);
        this.setC_Invoice_ID(0);
        this.setC_Order_ID(0);
        this.setC_Charge_ID(0);
        this.setC_Project_ID(0);
        this.setIsPrepayment(false);
    }

    public boolean isCashTrx() {
        return "X".equals(this.getTenderType());
    }

    public boolean isCashbookTrx() {
        return this.isCashTrx() && !MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, this.getAD_Client_ID());
    }

    public boolean setCreditCard(String TrxType, String creditCardType, String creditCardNumber, String creditCardVV, int creditCardExpMM, int creditCardExpYY) {
        this.setTenderType("C");
        this.setTrxType(TrxType);
        this.setCreditCardType(creditCardType);
        this.setCreditCardNumber(creditCardNumber);
        this.setCreditCardVV(creditCardVV);
        this.setCreditCardExpMM(creditCardExpMM);
        this.setCreditCardExpYY(creditCardExpYY);
        int check = MPaymentValidate.validateCreditCardNumber(creditCardNumber, creditCardType).length() + MPaymentValidate.validateCreditCardExp(creditCardExpMM, creditCardExpYY).length();
        if (creditCardVV.length() > 0) {
            check += MPaymentValidate.validateCreditCardVV(creditCardVV, creditCardType).length();
        }
        return check == 0;
    }

    public boolean setCreditCard(String TrxType, String creditCardType, String creditCardNumber, String creditCardVV, String creditCardExp) {
        return this.setCreditCard(TrxType, creditCardType, creditCardNumber, creditCardVV, MPaymentValidate.getCreditCardExpMM(creditCardExp), MPaymentValidate.getCreditCardExpYY(creditCardExp));
    }

    public boolean setBankACH(MPaySelectionCheck preparedPayment) {
        this.setC_BankAccount_ID(preparedPayment.getParent().getC_BankAccount_ID());
        int C_BP_BankAccount_ID = preparedPayment.getC_BP_BankAccount_ID();
        MBPBankAccount ba = new MBPBankAccount(preparedPayment.getCtx(), C_BP_BankAccount_ID, null);
        this.setRoutingNo(ba.getRoutingNo());
        this.setAccountNo(ba.getAccountNo());
        this.setIBAN(ba.getIBAN());
        this.setSwiftCode(ba.getSwiftCode());
        this.setDescription(preparedPayment.getC_PaySelection().getName());
        this.setIsReceipt("D".equals(preparedPayment.getPaymentRule()));
        if ("D".equals(preparedPayment.getPaymentRule())) {
            this.setTenderType("D");
        } else if ("T".equals(preparedPayment.getPaymentRule())) {
            this.setTenderType("A");
        }
        int check = MPaymentValidate.validateRoutingNo(this.getRoutingNo()).length() + MPaymentValidate.validateAccountNo(this.getAccountNo()).length();
        return check == 0;
    }

    public boolean setBankACH(int C_BankAccount_ID, boolean isReceipt, String tenderType, String routingNo, String accountNo) {
        this.setTenderType(tenderType);
        this.setIsReceipt(isReceipt);
        if (C_BankAccount_ID > 0 && (routingNo == null || routingNo.length() == 0 || accountNo == null || accountNo.length() == 0)) {
            this.setBankAccountDetails(C_BankAccount_ID);
        } else {
            this.setC_BankAccount_ID(C_BankAccount_ID);
            this.setRoutingNo(routingNo);
            this.setAccountNo(accountNo);
        }
        this.setCheckNo("");
        int check = MPaymentValidate.validateRoutingNo(routingNo).length() + MPaymentValidate.validateAccountNo(accountNo).length();
        return check == 0;
    }

    public boolean setBankCash(int C_BankAccount_ID, boolean isReceipt, String tenderType) {
        this.setTenderType(tenderType);
        this.setIsReceipt(isReceipt);
        if (C_BankAccount_ID > 0) {
            this.setBankAccountDetails(C_BankAccount_ID);
        } else {
            this.setC_BankAccount_ID(C_BankAccount_ID);
        }
        return true;
    }

    public boolean setBankCheck(int C_BankAccount_ID, boolean isReceipt, String checkNo) {
        return this.setBankCheck(C_BankAccount_ID, isReceipt, null, null, checkNo);
    }

    public boolean setBankCheck(int C_BankAccount_ID, boolean isReceipt, String routingNo, String accountNo, String checkNo) {
        this.setTenderType("K");
        this.setIsReceipt(isReceipt);
        if (C_BankAccount_ID > 0 && (routingNo == null || routingNo.length() == 0 || accountNo == null || accountNo.length() == 0)) {
            this.setBankAccountDetails(C_BankAccount_ID);
        } else {
            this.setC_BankAccount_ID(C_BankAccount_ID);
            this.setRoutingNo(routingNo);
            this.setAccountNo(accountNo);
        }
        this.setCheckNo(checkNo);
        int check = MPaymentValidate.validateRoutingNo(routingNo).length() + MPaymentValidate.validateAccountNo(accountNo).length() + MPaymentValidate.validateCheckNo(checkNo).length();
        return check == 0;
    }

    public void setBankAccountDetails(int C_BankAccount_ID) {
        block7: {
            if (C_BankAccount_ID == 0) {
                return;
            }
            this.setC_BankAccount_ID(C_BankAccount_ID);
            String sql = "SELECT b.RoutingNo, ba.AccountNo, ba.IBAN, b.SwiftCode FROM C_BankAccount ba INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) WHERE C_BankAccount_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, C_BankAccount_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.setRoutingNo(rs.getString(1));
                        this.setAccountNo(rs.getString(2));
                        this.setIBAN(rs.getString(3));
                        this.setSwiftCode(rs.getString(4));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public void setAccountAddress(String name, String street, String city, String state, String zip, String country) {
        this.setA_Name(name);
        this.setA_Street(street);
        this.setA_City(city);
        this.setA_State(state);
        this.setA_Zip(zip);
        this.setA_Country(country);
    }

    public boolean processOnline() {
        boolean approved;
        block38: {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Amt=" + String.valueOf(this.getPayAmt()));
            }
            this.setIsOnline(true);
            this.setErrorMessage(null);
            if (this.getTrxType().equals("V") || this.getTrxType().equals("C")) {
                if (this.isVoided()) {
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Already voided - " + this.getR_Result() + " - " + this.getR_RespMsg());
                    }
                    this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentAlreadyVoided"));
                    return true;
                }
            } else if (this.getTrxType().equals("D")) {
                if (this.isDelayedCapture()) {
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Already delayed capture - " + this.getR_Result() + " - " + this.getR_RespMsg());
                    }
                    this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentAlreadyDelayedCapture"));
                    return true;
                }
            } else if (this.isApproved()) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Already processed - " + this.getR_Result() + " - " + this.getR_RespMsg());
                }
                this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentAlreadyProcessed"));
                return true;
            }
            if (this.m_mBankAccountProcessor == null) {
                this.setPaymentProcessor();
            }
            if (this.m_mBankAccountProcessor == null) {
                if (this.getC_PaymentProcessor_ID() > 0) {
                    MPaymentProcessor pp = new MPaymentProcessor(this.getCtx(), this.getC_PaymentProcessor_ID(), this.get_TrxName());
                    this.log.log(Level.WARNING, "No Payment Processor Model " + pp.toString());
                    this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentNoProcessorModel") + ": " + pp.toString());
                } else {
                    this.log.log(Level.WARNING, "No Payment Processor Model");
                    this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentNoProcessorModel"));
                }
                return false;
            }
            approved = false;
            try {
                PaymentProcessor pp = PaymentProcessor.create(this.m_mBankAccountProcessor, this);
                if (pp == null) {
                    this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentNoProcessor"));
                } else {
                    approved = pp.processCC();
                    if (approved) {
                        this.setErrorMessage(null);
                    } else if (this.getTrxType().equals("V") || this.getTrxType().equals("C")) {
                        this.setErrorMessage("From " + this.getCreditCardName() + ": " + this.getR_VoidMsg());
                    } else {
                        this.setErrorMessage("From " + this.getCreditCardName() + ": " + this.getR_RespMsg());
                    }
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "processOnline", e);
                this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentNotProcessed") + ": " + e.getMessage());
            }
            if (approved) {
                this.setCreditCardNumber(PaymentUtil.encrpytCreditCard(this.getCreditCardNumber()));
                this.setCreditCardVV(PaymentUtil.encrpytCvv(this.getCreditCardVV()));
                this.setDateTrx(new Timestamp(System.currentTimeMillis()));
                this.setDateAcct(new Timestamp(System.currentTimeMillis()));
                this.setProcessed(true);
            }
            this.setIsApproved(approved);
            Trx trx = Trx.get(Trx.createTrxName("ppt-"), true);
            trx.setDisplayName(this.getClass().getName() + "_processOnline");
            try {
                try {
                    trx.start();
                    MPaymentTransaction m_mPaymentTransaction = this.createPaymentTransaction(trx.getTrxName());
                    m_mPaymentTransaction.setIsApproved(approved);
                    if (this.getTrxType().equals("V") || this.getTrxType().equals("C")) {
                        m_mPaymentTransaction.setIsVoided(approved);
                    }
                    m_mPaymentTransaction.setProcessed(approved);
                    m_mPaymentTransaction.setC_Payment_ID(this.getC_Payment_ID());
                    m_mPaymentTransaction.saveEx();
                    MOnlineTrxHistory history = new MOnlineTrxHistory(this.getCtx(), 0, trx.getTrxName());
                    history.setAD_Table_ID(200031);
                    history.setRecord_ID(m_mPaymentTransaction.getC_PaymentTransaction_ID());
                    history.setIsError(!approved);
                    history.setProcessed(approved);
                    StringBuilder msg = new StringBuilder();
                    if (approved) {
                        if (this.getTrxType().equals("V") || this.getTrxType().equals("C")) {
                            msg.append(this.getR_VoidMsg() + "\n");
                        } else {
                            msg.append("Result: " + this.getR_Result() + "\n");
                            msg.append("Response Message: " + this.getR_RespMsg() + "\n");
                            msg.append("Reference: " + this.getR_PnRef() + "\n");
                            msg.append("Authorization Code: " + this.getR_AuthCode() + "\n");
                        }
                    } else {
                        msg.append("ERROR: " + this.getErrorMessage() + "\n");
                    }
                    msg.append("Transaction Type: " + this.getTrxType());
                    history.setTextMsg(msg.toString());
                    history.saveEx();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "processOnline", e);
                    this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentNotProcessed") + ": " + e.getMessage());
                    if (trx != null) {
                        trx.commit();
                        trx.close();
                    }
                    break block38;
                }
            }
            catch (Throwable throwable) {
                if (trx != null) {
                    trx.commit();
                    trx.close();
                }
                throw throwable;
            }
            if (trx != null) {
                trx.commit();
                trx.close();
            }
        }
        if (this.getTrxType().equals("V") || this.getTrxType().equals("C")) {
            this.setIsVoided(approved);
        }
        return approved;
    }

    @Override
    public boolean startProcess(Properties ctx, ProcessInfo pi, Trx trx) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("startProcess - " + pi.getRecord_ID());
        }
        boolean retValue = false;
        if (pi.getRecord_ID() != this.get_ID()) {
            this.log.log(Level.SEVERE, "startProcess - Not same Payment - " + pi.getRecord_ID());
            return false;
        }
        retValue = this.processOnline();
        this.saveEx();
        return retValue;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MBankAccount ba;
        if (this.isProcessed() && !this.is_ValueChanged("Processed") && (this.is_ValueChanged("C_BankAccount_ID") || this.is_ValueChanged("C_BPartner_ID") || this.is_ValueChanged("C_Charge_ID") || this.is_ValueChanged("C_Currency_ID") || this.is_ValueChanged("C_DocType_ID") || this.is_ValueChanged("DateAcct") || this.is_ValueChanged("DateTrx") || this.is_ValueChanged("DiscountAmt") || this.is_ValueChanged("PayAmt") || this.is_ValueChanged("WriteOffAmt"))) {
            this.log.saveError("PaymentAlreadyProcessed", Msg.translate(this.getCtx(), "C_Payment_ID"));
            return false;
        }
        if (this.isCashbookTrx()) {
            if (this.getC_CashBook_ID() <= 0) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Mandatory@: @C_CashBook_ID@"));
                return false;
            }
        } else if (this.getC_BankAccount_ID() <= 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Mandatory@: @C_BankAccount_ID@"));
            return false;
        }
        if (this.getC_Charge_ID() != 0) {
            if (newRecord || this.is_ValueChanged("C_Charge_ID")) {
                this.setC_Order_ID(0);
                this.setC_Invoice_ID(0);
                this.setWriteOffAmt(Env.ZERO);
                this.setDiscountAmt(Env.ZERO);
                this.setIsOverUnderPayment(false);
                this.setOverUnderAmt(Env.ZERO);
                this.setIsPrepayment(false);
            }
        } else if (this.getC_BPartner_ID() == 0 && !this.isCashTrx() && this.getC_Invoice_ID() == 0 && this.getC_Order_ID() == 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@: @C_BPartner_ID@"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("C_Charge_ID") || this.is_ValueChanged("C_Invoice_ID") || this.is_ValueChanged("C_Order_ID") || this.is_ValueChanged("C_Project_ID")) {
            if (this.getReversal_ID() > 0) {
                this.setIsPrepayment(this.getReversal().isPrepayment());
            } else {
                this.setIsPrepayment(this.getC_Charge_ID() == 0 && this.getC_BPartner_ID() != 0 && (this.getC_Order_ID() != 0 || this.getC_Project_ID() != 0 && this.getC_Invoice_ID() == 0));
            }
        }
        if (this.isPrepayment() && (newRecord || this.is_ValueChanged("C_Order_ID") || this.is_ValueChanged("C_Project_ID"))) {
            this.setWriteOffAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setIsOverUnderPayment(false);
            this.setOverUnderAmt(Env.ZERO);
        }
        if (this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID();
        } else {
            MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
            this.setIsReceipt(dt.isSOTrx());
        }
        this.setDocumentNo();
        if (this.getDateAcct() == null) {
            this.setDateAcct(this.getDateTrx());
        }
        if (!this.isOverUnderPayment()) {
            this.setOverUnderAmt(Env.ZERO);
        }
        if ((newRecord || this.is_ValueChanged("C_BankAccount_ID")) && this.getC_Charge_ID() == 0 && (ba = MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID())).getAD_Org_ID() != 0) {
            this.setAD_Org_ID(ba.getAD_Org_ID());
        }
        if (this.getC_BPartner_ID() != 0 && (this.getC_Invoice_ID() != 0 || this.getC_Order_ID() != 0)) {
            MOrder ord;
            MInvoice inv;
            if (this.getC_Invoice_ID() != 0 && (inv = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName())).getC_BPartner_ID() != this.getC_BPartner_ID()) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "BPDifferentFromBPInvoice"));
                return false;
            }
            if (this.getC_Order_ID() != 0 && (ord = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName())).getC_BPartner_ID() != this.getC_BPartner_ID()) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "BPDifferentFromBPOrder"));
                return false;
            }
        }
        if (this.isProcessed()) {
            String encrpytedCvv;
            String encrpytedCCNo;
            if (this.getCreditCardNumber() != null && !(encrpytedCCNo = PaymentUtil.encrpytCreditCard(this.getCreditCardNumber())).equals(this.getCreditCardNumber())) {
                this.setCreditCardNumber(encrpytedCCNo);
            }
            if (this.getCreditCardVV() != null && !(encrpytedCvv = PaymentUtil.encrpytCvv(this.getCreditCardVV())).equals(this.getCreditCardVV())) {
                this.setCreditCardVV(encrpytedCvv);
            }
        }
        if (MSysConfig.getBooleanValue("IBAN_VALIDATION", true, Env.getAD_Client_ID(Env.getCtx())) && !Util.isEmpty(this.getIBAN())) {
            this.setIBAN(IBAN.normalizeIBAN(this.getIBAN()));
            if (!IBAN.isValid(this.getIBAN())) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "InvalidIBAN"));
                return false;
            }
        }
        if (!this.isProcessed()) {
            MClientInfo info = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
            MAcctSchema as = MAcctSchema.get(this.getCtx(), info.getC_AcctSchema1_ID(), this.get_TrxName());
            if (as.getC_Currency_ID() != this.getC_Currency_ID()) {
                if (this.isOverrideCurrencyRate()) {
                    if (this.getCurrencyRate() == null || this.getCurrencyRate().signum() == 0) {
                        this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "CurrencyRate"));
                        return false;
                    }
                    if (this.getConvertedAmt() == null || this.getConvertedAmt().signum() == 0) {
                        this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "ConvertedAmt"));
                        return false;
                    }
                    BigDecimal converted = this.getPayAmt().multiply(this.getCurrencyRate());
                    int stdPrecision = MCurrency.getStdPrecision(this.getCtx(), as.getC_Currency_ID());
                    if (converted.scale() > stdPrecision) {
                        converted = converted.setScale(stdPrecision, RoundingMode.HALF_UP);
                    }
                    this.setConvertedAmt(converted);
                } else {
                    this.setCurrencyRate(null);
                    this.setConvertedAmt(null);
                }
            } else {
                this.setCurrencyRate(null);
                this.setConvertedAmt(null);
            }
        }
        if (!this.isProcessed() && !"C".equals(this.getTenderType())) {
            if (!Util.isEmpty(this.getCreditCardType(), true)) {
                this.setCreditCardType(null);
            }
            if (!Util.isEmpty(this.getCreditCardNumber(), true)) {
                this.setCreditCardNumber(null);
            }
            if (!Util.isEmpty(this.getCreditCardVV(), true)) {
                this.setCreditCardVV(null);
            }
            if (this.getCreditCardExpMM() > 0) {
                this.set_Value("CreditCardExpMM", null);
            }
            if (this.getCreditCardExpYY() > 0) {
                this.set_Value("CreditCardExpYY", null);
            }
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        MPaySelectionCheck.deleteGeneratedDraft(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        return true;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public BigDecimal getAllocatedAmt() {
        BigDecimal retValue;
        block7: {
            retValue = null;
            if (this.getC_Charge_ID() != 0) {
                return this.getPayAmt();
            }
            String sql = "SELECT SUM(currencyConvert(al.Amount,ah.C_Currency_ID, p.C_Currency_ID,ah.DateTrx,p.C_ConversionType_ID, al.AD_Client_ID,al.AD_Org_ID)) FROM C_AllocationLine al INNER JOIN C_AllocationHdr ah ON (al.C_AllocationHdr_ID=ah.C_AllocationHdr_ID)  INNER JOIN C_Payment p ON (al.C_Payment_ID=p.C_Payment_ID) WHERE al.C_Payment_ID=? AND ah.IsActive='Y' AND al.IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_Payment_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "getAllocatedAmt", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public boolean testAllocation() {
        boolean test;
        boolean change;
        BigDecimal alloc = this.getAllocatedAmt();
        if (alloc == null) {
            alloc = Env.ZERO;
        }
        BigDecimal total = this.getPayAmt();
        if (!this.isReceipt()) {
            total = total.negate();
        }
        if (change = (test = total.compareTo(alloc) == 0) ^ this.isAllocated()) {
            this.setIsAllocated(test);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Allocated=" + test + " (" + String.valueOf(alloc) + "=" + String.valueOf(total) + ")");
        }
        return change;
    }

    public static void setIsAllocated(Properties ctx, int C_BPartner_ID, String trxName) {
        int counter;
        block8: {
            counter = 0;
            Object sql = "SELECT * FROM C_Payment WHERE IsAllocated='N' AND DocStatus IN ('CO','CL')";
            sql = C_BPartner_ID > 1 ? (String)sql + " AND C_BPartner_ID=?" : (String)sql + " AND AD_Client_ID=" + Env.getAD_Client_ID(ctx);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, trxName);
                    if (C_BPartner_ID > 1) {
                        pstmt.setInt(1, C_BPartner_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPayment pay = new MPayment(ctx, rs, trxName);
                        if (!pay.testAllocation() || !pay.save()) continue;
                        ++counter;
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, (String)sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("#" + counter);
        }
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    @Override
    public void setC_BankAccount_ID(int C_BankAccount_ID) {
        if (C_BankAccount_ID == 0) {
            this.setPaymentProcessor();
            if (this.getC_BankAccount_ID() == 0) {
                throw new IllegalArgumentException("Can't find Bank Account");
            }
        } else {
            super.setC_BankAccount_ID(C_BankAccount_ID);
        }
    }

    public boolean setPaymentProcessor() {
        return this.setPaymentProcessor(this.getTenderType(), this.getCreditCardType(), this.getC_PaymentProcessor_ID());
    }

    public boolean setPaymentProcessor(String tender, String CCType, int C_PaymentProcessor_ID) {
        this.m_mBankAccountProcessor = null;
        if (this.m_mBankAccountProcessors == null || this.m_mBankAccountProcessors.length == 0) {
            this.m_mBankAccountProcessors = MBankAccountProcessor.find(this.getCtx(), tender, CCType, this.getAD_Client_ID(), this.getC_Currency_ID(), this.getPayAmt(), this.get_TrxName());
        }
        if (this.m_mBankAccountProcessors == null || this.m_mBankAccountProcessors.length == 0) {
            this.m_mBankAccountProcessors = MBankAccountProcessor.find(this.getCtx(), tender, CCType, this.getAD_Client_ID(), this.getC_Currency_ID(), Env.ZERO, this.get_TrxName());
        }
        if (this.m_mBankAccountProcessors == null || this.m_mBankAccountProcessors.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.m_mBankAccountProcessors.length) {
            MBankAccountProcessor bankAccountProcessor = this.m_mBankAccountProcessors[i];
            if (bankAccountProcessor.accepts(tender, CCType) && (C_PaymentProcessor_ID == 0 || bankAccountProcessor.getC_PaymentProcessor_ID() == C_PaymentProcessor_ID)) {
                this.m_mBankAccountProcessor = this.m_mBankAccountProcessors[i];
                break;
            }
            ++i;
        }
        if (this.m_mBankAccountProcessor != null) {
            this.setC_BankAccount_ID(this.m_mBankAccountProcessor.getC_BankAccount_ID());
            this.setC_PaymentProcessor_ID(this.m_mBankAccountProcessor.getC_PaymentProcessor_ID());
        }
        return this.m_mBankAccountProcessor != null;
    }

    public ValueNamePair[] getCreditCards() {
        return this.getCreditCards(this.getPayAmt());
    }

    public ValueNamePair[] getCreditCards(BigDecimal amt) {
        try {
            if (this.m_mBankAccountProcessors == null || this.m_mBankAccountProcessors.length == 0) {
                this.m_mBankAccountProcessors = MBankAccountProcessor.find(this.getCtx(), null, null, this.getAD_Client_ID(), this.getC_Currency_ID(), amt, this.get_TrxName());
            }
            HashMap<String, ValueNamePair> map = new HashMap<String, ValueNamePair>();
            int i = 0;
            while (i < this.m_mBankAccountProcessors.length) {
                MBankAccountProcessor bankAccountProcessor = this.m_mBankAccountProcessors[i];
                MPaymentProcessor paymentProcessor = new MPaymentProcessor(this.getCtx(), bankAccountProcessor.getC_PaymentProcessor_ID(), this.get_TrxName());
                if (bankAccountProcessor.isAcceptAMEX() && paymentProcessor.isAcceptAMEX()) {
                    map.put("A", this.getCreditCardPair("A"));
                }
                if (bankAccountProcessor.isAcceptDiners() && paymentProcessor.isAcceptDiners()) {
                    map.put("D", this.getCreditCardPair("D"));
                }
                if (bankAccountProcessor.isAcceptDiscover() && paymentProcessor.isAcceptDiscover()) {
                    map.put("N", this.getCreditCardPair("N"));
                }
                if (bankAccountProcessor.isAcceptMC() && paymentProcessor.isAcceptMC()) {
                    map.put("M", this.getCreditCardPair("M"));
                }
                if (bankAccountProcessor.isAcceptCorporate() && paymentProcessor.isAcceptCorporate()) {
                    map.put("P", this.getCreditCardPair("P"));
                }
                if (bankAccountProcessor.isAcceptVisa() && paymentProcessor.isAcceptVisa()) {
                    map.put("V", this.getCreditCardPair("V"));
                }
                ++i;
            }
            ValueNamePair[] retValue = new ValueNamePair[map.size()];
            map.values().toArray(retValue);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("getCreditCards - #" + retValue.length + " - Processors=" + this.m_mBankAccountProcessors.length);
            }
            return retValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected ValueNamePair getCreditCardPair(String CreditCardType) {
        return new ValueNamePair(CreditCardType, this.getCreditCardName(CreditCardType));
    }

    @Override
    public void setCreditCardNumber(String CreditCardNumber) {
        super.setCreditCardNumber(MPaymentValidate.checkNumeric(CreditCardNumber));
    }

    @Override
    public void setCreditCardVV(String newCreditCardVV) {
        super.setCreditCardVV(MPaymentValidate.checkNumeric(newCreditCardVV));
    }

    @Override
    public void setCreditCardExpMM(int CreditCardExpMM) {
        if (CreditCardExpMM >= 1 && CreditCardExpMM <= 12) {
            super.setCreditCardExpMM(CreditCardExpMM);
        }
    }

    @Override
    public void setCreditCardExpYY(int newCreditCardExpYY) {
        int CreditCardExpYY = newCreditCardExpYY;
        if (newCreditCardExpYY > 1999) {
            CreditCardExpYY = newCreditCardExpYY - 2000;
        }
        super.setCreditCardExpYY(CreditCardExpYY);
    }

    public boolean setCreditCardExp(String mmyy) {
        if (MPaymentValidate.validateCreditCardExp(mmyy).length() != 0) {
            return false;
        }
        String exp = MPaymentValidate.checkNumeric(mmyy);
        String mmStr = exp.substring(0, 2);
        String yyStr = exp.substring(2, 4);
        this.setCreditCardExpMM(Integer.parseInt(mmStr));
        this.setCreditCardExpYY(Integer.parseInt(yyStr));
        return true;
    }

    public String getCreditCardExp(String delimiter) {
        String mm = String.valueOf(this.getCreditCardExpMM());
        String yy = String.valueOf(this.getCreditCardExpYY());
        StringBuilder retValue = new StringBuilder();
        if (mm.length() == 1) {
            retValue.append("0");
        }
        retValue.append(mm);
        if (delimiter != null) {
            retValue.append(delimiter);
        }
        if (yy.length() == 1) {
            retValue.append("0");
        }
        retValue.append(yy);
        return retValue.toString();
    }

    @Override
    public void setMicr(String MICR) {
        super.setMicr(MPaymentValidate.checkNumeric(MICR));
    }

    @Override
    public void setRoutingNo(String RoutingNo) {
        super.setRoutingNo(RoutingNo);
    }

    @Override
    public void setAccountNo(String AccountNo) {
        super.setAccountNo(MPaymentValidate.checkNumeric(AccountNo));
    }

    @Override
    public void setCheckNo(String CheckNo) {
        super.setCheckNo(MPaymentValidate.checkNumeric(CheckNo));
    }

    protected void setDocumentNo() {
        if ("X".equals(this.getTenderType())) {
            return;
        }
        Object documentNo = this.getDocumentNo();
        if (documentNo != null && ((String)documentNo).indexOf(REVERSE_INDICATOR) >= 0) {
            return;
        }
        if (this.getR_PnRef() != null && this.getR_PnRef().length() > 0) {
            if (!this.getR_PnRef().equals(documentNo)) {
                this.setDocumentNo(this.getR_PnRef());
            }
            return;
        }
        documentNo = "";
        if ("C".equals(this.getTenderType())) {
            if (MSysConfig.getBooleanValue("PAYMENT_OVERWRITE_DOCUMENTNO_WITH_CREDIT_CARD", true, this.getAD_Client_ID())) {
                documentNo = this.getCreditCardType() + " " + Obscure.obscure(this.getCreditCardNumber()) + " " + this.getCreditCardExpMM() + "/" + this.getCreditCardExpYY();
            }
        } else if ("K".equals(this.getTenderType()) && !this.isReceipt() && this.getCheckNo() != null && this.getCheckNo().length() > 0) {
            if (MSysConfig.getBooleanValue("PAYMENT_OVERWRITE_DOCUMENTNO_WITH_CHECK_ON_PAYMENT", true, this.getAD_Client_ID())) {
                documentNo = this.getCheckNo();
            }
        } else if ("K".equals(this.getTenderType()) && this.isReceipt() && MSysConfig.getBooleanValue("PAYMENT_OVERWRITE_DOCUMENTNO_WITH_CHECK_ON_RECEIPT", true, this.getAD_Client_ID())) {
            if (this.getRoutingNo() != null) {
                documentNo = this.getRoutingNo() + ": ";
            }
            if (this.getAccountNo() != null) {
                documentNo = (String)documentNo + this.getAccountNo();
            }
            if (this.getCheckNo() != null) {
                if (((String)documentNo).length() > 0) {
                    documentNo = (String)documentNo + " ";
                }
                documentNo = (String)documentNo + "#" + this.getCheckNo();
            }
        }
        if (((String)(documentNo = ((String)documentNo).trim())).length() > 0) {
            this.setDocumentNo((String)documentNo);
        }
    }

    @Override
    public void setR_PnRef(String R_PnRef) {
        super.setR_PnRef(R_PnRef);
        if (R_PnRef != null) {
            this.setDocumentNo(R_PnRef);
        }
    }

    @Override
    public void setPayAmt(BigDecimal PayAmt) {
        super.setPayAmt(PayAmt == null ? Env.ZERO : PayAmt);
    }

    public void setAmount(int C_Currency_ID, BigDecimal payAmt) {
        if (C_Currency_ID == 0) {
            C_Currency_ID = MClient.get(this.getCtx()).getC_Currency_ID();
        }
        this.setC_Currency_ID(C_Currency_ID);
        this.setPayAmt(payAmt);
    }

    @Override
    public void setDiscountAmt(BigDecimal DiscountAmt) {
        super.setDiscountAmt(DiscountAmt == null ? Env.ZERO : DiscountAmt);
    }

    @Override
    public void setWriteOffAmt(BigDecimal WriteOffAmt) {
        super.setWriteOffAmt(WriteOffAmt == null ? Env.ZERO : WriteOffAmt);
    }

    @Override
    public void setOverUnderAmt(BigDecimal OverUnderAmt) {
        super.setOverUnderAmt(OverUnderAmt == null ? Env.ZERO : OverUnderAmt);
        this.setIsOverUnderPayment(this.getOverUnderAmt().compareTo(Env.ZERO) != 0);
    }

    @Override
    public void setTaxAmt(BigDecimal TaxAmt) {
        super.setTaxAmt(TaxAmt == null ? Env.ZERO : TaxAmt);
    }

    public void setBP_BankAccount(MBPBankAccount ba) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(ba));
        }
        if (ba == null) {
            return;
        }
        this.setC_BPartner_ID(ba.getC_BPartner_ID());
        this.setAccountAddress(ba.getA_Name(), ba.getA_Street(), ba.getA_City(), ba.getA_State(), ba.getA_Zip(), ba.getA_Country());
        this.setA_EMail(ba.getA_EMail());
        this.setA_Ident_DL(ba.getA_Ident_DL());
        this.setA_Ident_SSN(ba.getA_Ident_SSN());
        if (ba.getCreditCardType() != null) {
            this.setCreditCardType(ba.getCreditCardType());
        }
        if (ba.getCreditCardNumber() != null) {
            this.setCreditCardNumber(ba.getCreditCardNumber());
        }
        if (ba.getCreditCardExpMM() != 0) {
            this.setCreditCardExpMM(ba.getCreditCardExpMM());
        }
        if (ba.getCreditCardExpYY() != 0) {
            this.setCreditCardExpYY(ba.getCreditCardExpYY());
        }
        if (ba.getCreditCardVV() != null) {
            this.setCreditCardVV(ba.getCreditCardVV());
        }
        if (ba.getAccountNo() != null) {
            this.setAccountNo(ba.getAccountNo());
        }
        if (ba.getRoutingNo() != null) {
            this.setRoutingNo(ba.getRoutingNo());
        }
        if (ba.getIBAN() != null) {
            this.setIBAN(ba.getIBAN());
        }
        if (ba.getSwiftCode() != null) {
            this.setSwiftCode(ba.getSwiftCode());
        }
    }

    public boolean saveToBP_BankAccount(MBPBankAccount ba) {
        if (ba == null) {
            return false;
        }
        ba.setA_Name(this.getA_Name());
        ba.setA_Street(this.getA_Street());
        ba.setA_City(this.getA_City());
        ba.setA_State(this.getA_State());
        ba.setA_Zip(this.getA_Zip());
        ba.setA_Country(this.getA_Country());
        ba.setA_EMail(this.getA_EMail());
        ba.setA_Ident_DL(this.getA_Ident_DL());
        ba.setA_Ident_SSN(this.getA_Ident_SSN());
        ba.setCreditCardType(this.getCreditCardType());
        ba.setCreditCardNumber(this.getCreditCardNumber());
        ba.setCreditCardExpMM(this.getCreditCardExpMM());
        ba.setCreditCardExpYY(this.getCreditCardExpYY());
        ba.setCreditCardVV(this.getCreditCardVV());
        if (this.getAccountNo() != null) {
            ba.setAccountNo(this.getAccountNo());
        }
        if (this.getRoutingNo() != null) {
            ba.setRoutingNo(this.getRoutingNo());
        }
        if (this.getIBAN() != null) {
            ba.setIBAN(this.getIBAN());
        }
        ba.setR_AvsAddr(this.getR_AvsAddr());
        ba.setR_AvsZip(this.getR_AvsZip());
        boolean ok = ba.save(this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("saveToBP_BankAccount - " + String.valueOf(ba));
        }
        return ok;
    }

    protected void setC_DocType_ID() {
        this.setC_DocType_ID(this.isReceipt());
    }

    public void setC_DocType_ID(boolean isReceipt) {
        block9: {
            this.setIsReceipt(isReceipt);
            String sql = "SELECT C_DocType_ID FROM C_DocType WHERE IsActive='Y' AND AD_Client_ID=? AND DocBaseType=? ORDER BY IsDefault DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Client_ID());
                    if (isReceipt) {
                        pstmt.setString(2, "ARR");
                    } else {
                        pstmt.setString(2, "APP");
                    }
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.setC_DocType_ID(rs.getInt(1));
                    } else {
                        this.log.warning("setDocType - NOT found - isReceipt=" + isReceipt);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    @Override
    public void setC_DocType_ID(int C_DocType_ID) {
        super.setC_DocType_ID(C_DocType_ID);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean verifyDocType(MPaymentAllocate[] pAllocs) {
        block36: {
            block30: {
                if (this.getC_DocType_ID() == 0) {
                    return false;
                }
                documentSO = null;
                if (this.getC_Invoice_ID() > 0) {
                    sql = "SELECT idt.IsSOTrx FROM C_Invoice i INNER JOIN C_DocType idt ON (CASE WHEN i.C_DocType_ID=0 THEN i.C_DocTypeTarget_ID ELSE i.C_DocType_ID END=idt.C_DocType_ID) WHERE i.C_Invoice_ID=?";
                    pstmt = null;
                    rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement(sql, this.get_TrxName());
                            pstmt.setInt(1, this.getC_Invoice_ID());
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                documentSO = "Y".equals(rs.getString(1));
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql, e);
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            break block30;
                        }
                    }
                    catch (Throwable var7_15) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw var7_15;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                } else if (this.getC_Order_ID() > 0) {
                    sql = "SELECT odt.IsSOTrx FROM C_Order o INNER JOIN C_DocType odt ON (o.C_DocType_ID=odt.C_DocType_ID) WHERE o.C_Order_ID=?";
                    pstmt = null;
                    rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement(sql, this.get_TrxName());
                            pstmt.setInt(1, this.getC_Order_ID());
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                documentSO = "Y".equals(rs.getString(1));
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql, e);
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            break block30;
                        }
                    }
                    catch (Throwable var7_16) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw var7_16;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                } else if (this.getC_Charge_ID() <= 0 && pAllocs.length > 0) {
                    e = pAllocs;
                    rs = pAllocs.length;
                    pstmt = 0;
                    while (pstmt < rs) {
                        block34: {
                            block32: {
                                block33: {
                                    pAlloc = e[pstmt];
                                    sql = "SELECT idt.IsSOTrx FROM C_Invoice i INNER JOIN C_DocType idt ON (i.C_DocType_ID=idt.C_DocType_ID) WHERE i.C_Invoice_ID=?";
                                    pstmt = null;
                                    rs = null;
                                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                                    pstmt.setInt(1, pAlloc.getC_Invoice_ID());
                                    rs = pstmt.executeQuery();
                                    if (!rs.next()) break block32;
                                    if (documentSO == null) break block33;
                                    ** if (documentSO.booleanValue() == "Y".equals((Object)rs.getString((int)1))) goto lbl-1000
lbl-1000:
                                    // 1 sources

                                    {
                                        DB.close(rs, pstmt);
                                        rs = null;
                                        pstmt = null;
                                        return false;
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                    }
                                }
                                try {
                                    try {
                                        documentSO = "Y".equals(rs.getString(1));
                                    }
                                    catch (Exception e) {
                                        this.log.log(Level.SEVERE, sql, e);
                                        DB.close(rs, pstmt);
                                        rs = null;
                                        pstmt = null;
                                        break block34;
                                    }
                                }
                                catch (Throwable var11_23) {
                                    DB.close(rs, pstmt);
                                    rs = null;
                                    pstmt = null;
                                    throw var11_23;
                                }
                            }
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                        }
                        ++pstmt;
                    }
                }
            }
            paymentSO = null;
            pstmt = null;
            rs = null;
            sql = "SELECT IsSOTrx FROM C_DocType WHERE C_DocType_ID=?";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_DocType_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        paymentSO = "Y".equals(rs.getString(1));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block36;
                }
            }
            catch (Throwable var8_20) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw var8_20;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (paymentSO == null) {
            return false;
        }
        this.setIsReceipt(paymentSO);
        return documentSO == null || documentSO.booleanValue() == paymentSO.booleanValue();
    }

    protected boolean verifyPaymentAllocateVsHeader(MPaymentAllocate[] pAllocs) {
        return pAllocs.length <= 0 || this.getC_Charge_ID() <= 0 && this.getC_Invoice_ID() <= 0 && this.getC_Order_ID() <= 0;
    }

    protected boolean verifyPaymentAllocateSum(MPaymentAllocate[] pAllocs) {
        BigDecimal sumPaymentAllocates = Env.ZERO;
        if (pAllocs.length > 0) {
            MPaymentAllocate[] mPaymentAllocateArray = pAllocs;
            int n = pAllocs.length;
            int n2 = 0;
            while (n2 < n) {
                MPaymentAllocate pAlloc = mPaymentAllocateArray[n2];
                sumPaymentAllocates = sumPaymentAllocates.add(pAlloc.getAmount());
                ++n2;
            }
            if (this.getPayAmt().compareTo(sumPaymentAllocates) != 0) {
                return this.isReceipt() && this.getPayAmt().compareTo(sumPaymentAllocates) < 0 && MSysConfig.getBooleanValue("ALLOW_OVER_APPLIED_PAYMENT", false, Env.getAD_Client_ID(Env.getCtx()));
            }
        }
        return true;
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code(this.getCtx(), this.getC_Currency_ID());
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    public String getCreditCardName() {
        return this.getCreditCardName(this.getCreditCardType());
    }

    public String getCreditCardName(String CreditCardType) {
        if (CreditCardType == null) {
            return "--";
        }
        if ("M".equals(CreditCardType)) {
            return "MasterCard";
        }
        if ("V".equals(CreditCardType)) {
            return "Visa";
        }
        if ("A".equals(CreditCardType)) {
            return "Amex";
        }
        if ("C".equals(CreditCardType)) {
            return "ATM";
        }
        if ("D".equals(CreditCardType)) {
            return "Diners";
        }
        if ("N".equals(CreditCardType)) {
            return "Discover";
        }
        if ("P".equals(CreditCardType)) {
            return "PurchaseCard";
        }
        return "?" + CreditCardType + "?";
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public BigDecimal getPayAmt(boolean absolute) {
        if (this.isReceipt()) {
            return super.getPayAmt();
        }
        return super.getPayAmt().negate();
    }

    public int getPayAmtInCents() {
        BigDecimal bd = super.getPayAmt().multiply(Env.ONEHUNDRED);
        return bd.intValue();
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        CreditStatus status;
        MPaymentAllocate[] pAllocs;
        MOrder order;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPaySelectionCheck.deleteGeneratedDraft(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName())) {
            this.m_processMsg = "Could not delete draft generated payment selection lines";
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), this.isReceipt() ? "ARR" : "APP", this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (this.isOnline() && !this.isApproved()) {
            this.m_processMsg = this.getR_Result() != null ? "@OnlinePaymentFailed@" : "@PaymentNotProcessed@";
            return "IN";
        }
        if (this.getC_Order_ID() != 0 && this.getC_Invoice_ID() == 0 && "WP".equals((order = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName())).getDocStatus())) {
            MDocType orderDocType;
            order.setC_Payment_ID(this.getC_Payment_ID());
            order.setDocAction("WC");
            order.set_TrxName(this.get_TrxName());
            if (!order.processIt("WC")) {
                throw new AdempiereException(Msg.getMsg(this.getCtx(), "FailedProcessingDocument") + " - " + order.getProcessMsg());
            }
            this.m_processMsg = order.getProcessMsg();
            order.saveEx(this.get_TrxName());
            MInvoice[] invoices = order.getInvoices();
            int length = invoices.length;
            if (length > 0) {
                this.setC_Invoice_ID(invoices[length - 1].getC_Invoice_ID());
            }
            if ((orderDocType = MDocType.get(this.getCtx(), order.getC_DocType_ID())).isAutoGenerateInvoice() && this.getC_Invoice_ID() == 0) {
                this.m_processMsg = "@NotFound@ @C_Invoice_ID@";
                return "IN";
            }
        }
        if (!this.verifyDocType(pAllocs = MPaymentAllocate.get(this))) {
            this.m_processMsg = "@PaymentDocTypeInvoiceInconsistent@";
            return "IN";
        }
        if (!this.verifyPaymentAllocateVsHeader(pAllocs)) {
            this.m_processMsg = "@PaymentAllocateIgnored@";
            return "IN";
        }
        if (!this.verifyPaymentAllocateSum(pAllocs)) {
            this.m_processMsg = "@PaymentAllocateSumInconsistent@";
            return "IN";
        }
        ICreditManager creditManager = Core.getCreditManager(this);
        if (creditManager != null && (status = creditManager.checkCreditStatus("PR")).isError()) {
            this.m_processMsg = status.getErrorMsg();
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String valid;
        MOrder ord;
        MInvoice inv;
        CreditStatus status;
        ICreditManager creditManager;
        if (!this.m_justPrepared) {
            String status2 = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status2)) {
                return status2;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if (this.getC_Charge_ID() != 0) {
            this.setIsAllocated(true);
        }
        if ((creditManager = Core.getCreditManager(this)) != null && (status = creditManager.checkCreditStatus("CO")).isError()) {
            this.m_processMsg = status.getErrorMsg();
            return "IN";
        }
        MPayment counter = this.createCounterDoc();
        if (counter != null) {
            this.m_processMsg = String.valueOf(this.m_processMsg) + " @CounterDoc@: @C_Payment_ID@=" + counter.getDocumentNo();
        }
        if (this.isCashbookTrx()) {
            if (this.getC_CashBook_ID() <= 0) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Mandatory@: @C_CashBook_ID@"));
                this.m_processMsg = "@NoCashBook@";
                return "IN";
            }
            MCash cash = MCash.get(this.getCtx(), this.getAD_Org_ID(), this.getDateAcct(), this.getC_Currency_ID(), this.get_TrxName());
            if (cash == null || cash.get_ID() == 0) {
                this.m_processMsg = "@NoCashBook@";
                return "IN";
            }
            MCashLine cl = new MCashLine(cash);
            cl.setCashType("R");
            cl.setDescription("Generated From Payment #" + this.getDocumentNo());
            cl.setC_Currency_ID(this.getC_Currency_ID());
            cl.setC_Payment_ID(this.getC_Payment_ID());
            StringBuilder info = new StringBuilder();
            info.append("Cash journal ( ").append(cash.getDocumentNo()).append(" )");
            this.m_processMsg = info.toString();
            BigDecimal amt = this.getPayAmt();
            cl.setAmount(amt);
            cl.setDiscountAmt(Env.ZERO);
            cl.setWriteOffAmt(Env.ZERO);
            cl.setIsGenerated(true);
            if (!cl.save(this.get_TrxName())) {
                this.m_processMsg = "Could not save Cash Journal Line";
                return "IN";
            }
        }
        if (this.getC_Invoice_ID() != 0 && (inv = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName())).getC_Payment_ID() != this.getC_Payment_ID()) {
            inv.setC_Payment_ID(this.getC_Payment_ID());
            inv.saveEx();
        }
        if (this.getC_Order_ID() != 0 && (ord = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName())).getC_Payment_ID() != this.getC_Payment_ID()) {
            ord.setC_Payment_ID(this.getC_Payment_ID());
            ord.saveEx();
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    protected void addDocsPostProcess(PO doc) {
        this.docsPostProcess.add(doc);
    }

    @Override
    public List<PO> getDocsPostProcess() {
        return this.docsPostProcess;
    }

    protected void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateTrx(TimeUtil.getDay(0L));
            if (this.getDateAcct().before(this.getDateTrx())) {
                this.setDateAcct(this.getDateTrx());
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
            }
        }
        if (dt.isOverwriteSeqOnComplete() && this.getProcessedOn().signum() == 0 && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    protected MPayment createCounterDoc() {
        if (this.getRef_Payment_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get(this.getCtx(), this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Counter BP=" + counterBP.getName());
        }
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType(this.getCtx(), this.getC_DocType_ID());
        if (counterDT != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(counterDT.toString());
            }
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID(this.getCtx(), this.getC_DocType_ID());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            }
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MPayment counter = new MPayment(this.getCtx(), 0, this.get_TrxName());
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setC_BPartner_ID(counterBP.getC_BPartner_ID());
        counter.setIsReceipt(!this.isReceipt());
        counter.setC_DocType_ID(C_DocTypeTarget_ID);
        counter.setTrxType(this.getTrxType());
        counter.setTenderType(this.getTenderType());
        counter.setPayAmt(this.getPayAmt());
        counter.setDiscountAmt(this.getDiscountAmt());
        counter.setTaxAmt(this.getTaxAmt());
        counter.setWriteOffAmt(this.getWriteOffAmt());
        counter.setIsOverUnderPayment(this.isOverUnderPayment());
        counter.setOverUnderAmt(this.getOverUnderAmt());
        counter.setC_Currency_ID(this.getC_Currency_ID());
        counter.setC_ConversionType_ID(this.getC_ConversionType_ID());
        counter.setDateTrx(this.getDateTrx());
        counter.setDateAcct(this.getDateAcct());
        counter.setRef_Payment_ID(this.getC_Payment_ID());
        String sql = "SELECT C_BankAccount_ID FROM C_BankAccount WHERE C_Currency_ID=? AND AD_Org_ID IN (0,?) AND IsActive='Y' AND AD_Client_ID = ? ORDER BY IsDefault DESC";
        int C_BankAccount_ID = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Currency_ID(), counterAD_Org_ID, this.getAD_Client_ID());
        counter.setC_BankAccount_ID(C_BankAccount_ID);
        counter.setC_Activity_ID(this.getC_Activity_ID());
        counter.setC_Campaign_ID(this.getC_Campaign_ID());
        counter.setC_Project_ID(this.getC_Project_ID());
        counter.setUser1_ID(this.getUser1_ID());
        counter.setUser2_ID(this.getUser2_ID());
        counter.saveEx(this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(counter.toString());
        }
        this.setRef_Payment_ID(counter.getC_Payment_ID());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            if (!counter.processIt(counterDT.getDocAction())) {
                throw new AdempiereException("Failed when rocessing document - " + counter.getProcessMsg());
            }
            counter.saveEx(this.get_TrxName());
        }
        return counter;
    }

    public boolean allocateIt() {
        if (this.getC_Invoice_ID() != 0) {
            return this.allocateInvoice();
        }
        if (this.allocatePaySelection()) {
            return true;
        }
        if (this.getC_Order_ID() != 0) {
            return false;
        }
        MPaymentAllocate[] pAllocs = MPaymentAllocate.get(this);
        if (pAllocs.length == 0) {
            return false;
        }
        MAllocationHdr alloc = new MAllocationHdr(this.getCtx(), false, this.getDateTrx(), this.getC_Currency_ID(), Msg.translate(this.getCtx(), "C_Payment_ID") + ": " + this.getDocumentNo(), this.get_TrxName());
        alloc.setAD_Org_ID(this.getAD_Org_ID());
        alloc.setDateAcct(this.getDateAcct());
        if (!alloc.save()) {
            this.log.severe("P.Allocations not created");
            return false;
        }
        int i = 0;
        while (i < pAllocs.length) {
            MPaymentAllocate pa = pAllocs[i];
            BigDecimal allocationAmt = pa.getAmount();
            if (pa.getOverUnderAmt().signum() < 0 && pa.getAmount().signum() > 0) {
                allocationAmt = allocationAmt.add(pa.getOverUnderAmt());
            }
            MAllocationLine aLine = null;
            aLine = this.isReceipt() ? new MAllocationLine(alloc, allocationAmt, pa.getDiscountAmt(), pa.getWriteOffAmt(), pa.getOverUnderAmt()) : new MAllocationLine(alloc, allocationAmt.negate(), pa.getDiscountAmt().negate(), pa.getWriteOffAmt().negate(), pa.getOverUnderAmt().negate());
            aLine.setDocInfo(pa.getC_BPartner_ID(), 0, pa.getC_Invoice_ID());
            aLine.setPaymentInfo(this.getC_Payment_ID(), 0, this.getC_BankTransfer_ID());
            if (!aLine.save(this.get_TrxName())) {
                this.log.warning("P.Allocations - line not saved");
            } else {
                pa.setC_AllocationLine_ID(aLine.getC_AllocationLine_ID());
                pa.saveEx();
            }
            ++i;
        }
        alloc.set_Attribute("Document.PostImmediateAfterComplete", Boolean.FALSE);
        if (!alloc.processIt("CO")) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "FailedProcessingDocument") + " - " + alloc.getProcessMsg());
        }
        this.addDocsPostProcess(alloc);
        this.m_processMsg = "@C_AllocationHdr_ID@: " + alloc.getDocumentNo();
        return alloc.save(this.get_TrxName());
    }

    protected boolean allocateInvoice() {
        BigDecimal allocationAmt = this.getPayAmt();
        if (this.getOverUnderAmt().signum() < 0 && this.getPayAmt().signum() > 0) {
            allocationAmt = allocationAmt.add(this.getOverUnderAmt());
        }
        MAllocationHdr alloc = new MAllocationHdr(this.getCtx(), false, this.getDateTrx(), this.getC_Currency_ID(), Msg.translate(this.getCtx(), "C_Payment_ID") + ": " + this.getDocumentNo() + " [1]", this.get_TrxName());
        alloc.setAD_Org_ID(this.getAD_Org_ID());
        alloc.setDateAcct(this.getDateAcct());
        MInvoice invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        if (invoice.getDateAcct().after(alloc.getDateAcct())) {
            alloc.setDateAcct(invoice.getDateAcct());
        }
        alloc.saveEx();
        MAllocationLine aLine = null;
        aLine = this.isReceipt() ? new MAllocationLine(alloc, allocationAmt, this.getDiscountAmt(), this.getWriteOffAmt(), this.getOverUnderAmt()) : new MAllocationLine(alloc, allocationAmt.negate(), this.getDiscountAmt().negate(), this.getWriteOffAmt().negate(), this.getOverUnderAmt().negate());
        aLine.setDocInfo(this.getC_BPartner_ID(), 0, this.getC_Invoice_ID());
        aLine.setC_Payment_ID(this.getC_Payment_ID());
        aLine.saveEx(this.get_TrxName());
        alloc.set_Attribute("Document.PostImmediateAfterComplete", Boolean.FALSE);
        if (!alloc.processIt("CO")) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "FailedProcessingDocument") + " - " + alloc.getProcessMsg());
        }
        this.addDocsPostProcess(alloc);
        alloc.saveEx(this.get_TrxName());
        this.m_justCreatedAllocInv = alloc;
        this.m_processMsg = "@C_AllocationHdr_ID@: " + alloc.getDocumentNo();
        int C_Project_ID = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_Project_ID) FROM C_Invoice WHERE C_Invoice_ID=?", this.getC_Invoice_ID());
        if (C_Project_ID > 0 && this.getC_Project_ID() == 0) {
            this.setC_Project_ID(C_Project_ID);
        } else if (C_Project_ID > 0 && this.getC_Project_ID() > 0 && C_Project_ID != this.getC_Project_ID()) {
            this.log.warning("Invoice C_Project_ID=" + C_Project_ID + " <> Payment C_Project_ID=" + this.getC_Project_ID());
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    protected boolean allocatePaySelection() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void deAllocate(boolean accrual) {
        MAllocationHdr[] allocations = MAllocationHdr.getOfPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + allocations.length);
        }
        int i = 0;
        while (i < allocations.length) {
            allocations[i].set_TrxName(this.get_TrxName());
            if (!"RE".equals(allocations[i].getDocStatus()) && !"VO".equals(allocations[i].getDocStatus())) {
                if (accrual) {
                    allocations[i].setDocAction("RA");
                    if (!allocations[i].processIt("RA")) {
                        throw new AdempiereException(allocations[i].getProcessMsg());
                    }
                } else {
                    allocations[i].setDocAction("RC");
                    if (!allocations[i].processIt("RC")) {
                        throw new AdempiereException(allocations[i].getProcessMsg());
                    }
                }
                allocations[i].saveEx();
            }
            ++i;
        }
        if (this.getC_Invoice_ID() != 0) {
            String sql = "UPDATE C_Invoice SET C_Payment_ID = NULL, IsPaid='N' WHERE C_Invoice_ID=" + this.getC_Invoice_ID() + " AND C_Payment_ID=" + this.getC_Payment_ID();
            int no = DB.executeUpdate(sql, this.get_TrxName());
            if (no != 0 && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Unlink Invoice #" + no);
            }
            if ((no = DB.executeUpdate(sql = "UPDATE C_Order o SET C_Payment_ID = NULL WHERE EXISTS (SELECT * FROM C_Invoice i WHERE o.C_Order_ID=i.C_Order_ID AND i.C_Invoice_ID=" + this.getC_Invoice_ID() + ") AND C_Payment_ID=" + this.getC_Payment_ID(), this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Unlink Order #" + no);
            }
        }
        this.setC_Invoice_ID(0);
        this.setIsAllocated(false);
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if (this.getC_DepositBatch_ID() > 0 && this.getC_DepositBatch().isProcessed()) {
            this.m_processMsg = Msg.translate(this.getCtx(), "DepositBatchProcessed") + String.valueOf(this.getC_DepositBatch());
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if (this.getC_BankStatementLine_ID() > 0) {
            return this.reverseCorrectIt();
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
            if (this.m_processMsg != null) {
                return false;
            }
            if (!this.voidOnlinePayment()) {
                return false;
            }
        } else {
            boolean accrual = false;
            try {
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
            }
            catch (PeriodClosedException periodClosedException) {
                accrual = true;
            }
            if (accrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided") + " (" + String.valueOf(this.getPayAmt()) + ")");
        this.setPayAmt(Env.ZERO);
        this.setDiscountAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setOverUnderAmt(Env.ZERO);
        this.setIsAllocated(false);
        this.deAllocate(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if (this.getC_DepositBatch_ID() != 0 && this.getC_DepositBatch().isProcessed()) {
            this.m_processMsg = Msg.translate(this.getCtx(), "DepositBatchProcessed") + String.valueOf(this.getC_DepositBatch());
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        StringBuilder info = this.reverse(false);
        if (info == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = info.toString();
        return true;
    }

    protected StringBuilder reverse(boolean accrual) {
        MDepositBatchLine batchLine;
        boolean allow;
        Timestamp dateAcct;
        if (!this.voidOnlinePayment()) {
            return null;
        }
        Timestamp timestamp = dateAcct = accrual ? Env.getContextAsDate(this.getCtx(), "#Date") : this.getDateAcct();
        if (dateAcct == null) {
            dateAcct = new Timestamp(System.currentTimeMillis());
        }
        MPeriod.testPeriodOpen(this.getCtx(), dateAcct, this.getC_DocType_ID(), this.getAD_Org_ID());
        if (this.getC_BankStatementLine_ID() > 0 && this.isReconciled() && !(allow = MSysConfig.getBooleanValue("ALLOW_REVERSAL_OF_RECONCILED_PAYMENT", true, Env.getAD_Client_ID(this.getCtx())))) {
            this.m_processMsg = Msg.getMsg(this.getCtx(), "NotAllowReversalOfReconciledPayment");
            return null;
        }
        if (this.getC_DepositBatch_ID() != 0 && (batchLine = (MDepositBatchLine)new Query(this.getCtx(), "C_DepositBatchLine", "C_Payment_ID = ? AND C_DepositBatch_ID = ?", this.get_TrxName()).setParameters(this.getC_Payment_ID(), this.getC_DepositBatch_ID()).first()) != null) {
            batchLine.deleteEx(false, this.get_TrxName());
        }
        MPayment reversal = new MPayment(this.getCtx(), 0, this.get_TrxName());
        MPayment.copyValues(this, reversal);
        reversal.setClientOrg(this);
        reversal.setC_Invoice_ID(0);
        reversal.setDateAcct(dateAcct);
        reversal.setDocumentNo(this.getDocumentNo() + REVERSE_INDICATOR);
        reversal.setDocStatus("DR");
        reversal.setDocAction("CO");
        reversal.setPayAmt(this.getPayAmt().negate());
        reversal.setDiscountAmt(this.getDiscountAmt().negate());
        reversal.setWriteOffAmt(this.getWriteOffAmt().negate());
        reversal.setOverUnderAmt(this.getOverUnderAmt().negate());
        reversal.setIsAllocated(true);
        reversal.setIsReconciled(false);
        reversal.setIsOnline(false);
        reversal.setIsApproved(true);
        reversal.setR_PnRef(null);
        reversal.setR_Result(null);
        reversal.setR_RespMsg(null);
        reversal.setR_AuthCode(null);
        reversal.setR_Info(null);
        reversal.setProcessing(false);
        reversal.setOProcessing("N");
        reversal.setProcessed(false);
        reversal.setPosted(false);
        reversal.setDescription(this.getDescription());
        reversal.addDescription("{->" + this.getDocumentNo() + ")");
        reversal.setReversal_ID(this.getC_Payment_ID());
        reversal.saveEx(this.get_TrxName());
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return null;
        }
        reversal.closeIt();
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx(this.get_TrxName());
        this.deAllocate(accrual);
        this.setIsAllocated(true);
        this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        this.setDocStatus("RE");
        this.setDocAction("--");
        this.setProcessed(true);
        this.setReversal_ID(reversal.getC_Payment_ID());
        StringBuilder info = new StringBuilder(reversal.getDocumentNo());
        MAllocationHdr alloc = new MAllocationHdr(this.getCtx(), false, this.getDateTrx(), this.getC_Currency_ID(), Msg.translate(this.getCtx(), "C_Payment_ID") + ": " + reversal.getDocumentNo(), this.get_TrxName());
        alloc.setAD_Org_ID(this.getAD_Org_ID());
        alloc.setDateAcct(dateAcct);
        alloc.saveEx(this.get_TrxName());
        MAllocationLine aLine = new MAllocationLine(alloc, this.getPayAmt(true), Env.ZERO, Env.ZERO, Env.ZERO);
        aLine.setDocInfo(this.getC_BPartner_ID(), 0, 0);
        aLine.setPaymentInfo(this.getC_Payment_ID(), 0);
        if (!aLine.save(this.get_TrxName())) {
            this.log.warning("Automatic allocation - line not saved");
        }
        aLine = new MAllocationLine(alloc, reversal.getPayAmt(true), Env.ZERO, Env.ZERO, Env.ZERO);
        aLine.setDocInfo(reversal.getC_BPartner_ID(), 0, 0);
        aLine.setPaymentInfo(reversal.getC_Payment_ID(), 0, reversal.getC_BankTransfer_ID());
        if (!aLine.save(this.get_TrxName())) {
            this.log.warning("Automatic allocation - reversal line not saved");
        }
        alloc.set_Attribute("Document.PostImmediateAfterComplete", Boolean.FALSE);
        if (!alloc.processIt("CO")) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "FailedProcessingDocument") + " - " + alloc.getProcessMsg());
        }
        this.addDocsPostProcess(alloc);
        alloc.saveEx(this.get_TrxName());
        info.append(" - @C_AllocationHdr_ID@: ").append(alloc.getDocumentNo());
        ICreditManager creditManager = Core.getCreditManager(this);
        if (creditManager != null) {
            creditManager.checkCreditStatus(accrual ? "RA" : "RC");
        }
        return info;
    }

    protected int getC_BankStatementLine_ID() {
        String sql = "SELECT C_BankStatementLine_ID FROM C_BankStatementLine WHERE C_Payment_ID=?";
        int id = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Payment_ID());
        if (id < 0) {
            return 0;
        }
        return id;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if (this.getC_DepositBatch_ID() != 0 && this.getC_DepositBatch().isProcessed()) {
            this.m_processMsg = Msg.translate(this.getCtx(), "DepositBatchProcessed") + String.valueOf(this.getC_DepositBatch());
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        StringBuilder info = this.reverse(true);
        if (info == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = info.toString();
        return true;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
        MAllocationHdr[] allocations = MAllocationHdr.getOfPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        if (allocations.length > 0) {
            this.m_processMsg = Msg.getMsg(this.getCtx(), "PaymentReactivationFailedAllocationLine");
            return false;
        }
        if (DB.getSQLValueEx(this.get_TrxName(), "SELECT 1 FROM C_BankStatementLine WHERE C_Payment_ID = ?", this.getC_Payment_ID()) == 1) {
            this.m_processMsg = Msg.getMsg(this.getCtx(), "PaymentReactivationFailedBankStatementLine");
            return false;
        }
        if (this.getC_BankTransfer_ID() > 0) {
            this.m_processMsg = Msg.getMsg(this.getCtx(), "PaymentReactivationFailedBankTransfer");
            return false;
        }
        if (DB.getSQLValueEx(this.get_TrxName(), "SELECT 1 FROM C_DunningRunLine WHERE C_Payment_ID = ?", this.getC_Payment_ID()) == 1) {
            this.m_processMsg = Msg.getMsg(this.getCtx(), "PaymentReactivationFailedDunningLine");
            return false;
        }
        if (DB.getSQLValueEx(this.get_TrxName(), "SELECT 1 FROM R_Request WHERE C_Payment_ID = ?", this.getC_Payment_ID()) == 1) {
            this.m_processMsg = Msg.getMsg(this.getCtx(), "PaymentReactivationFailedRequest");
            return false;
        }
        MFactAcct.deleteEx(335, this.getC_Payment_ID(), this.get_TrxName());
        this.setPosted(false);
        this.setDocAction("CO");
        this.setProcessed(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MPayment[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",Receipt=").append(this.isReceipt()).append(",PayAmt=").append(this.getPayAmt()).append(",Discount=").append(this.getDiscountAmt()).append(",WriteOff=").append(this.getWriteOffAmt()).append(",OverUnder=").append(this.getOverUnderAmt());
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getNameTrl() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "PayAmt")).append("=").append(this.getPayAmt()).append(",").append(Msg.translate(this.getCtx(), "WriteOffAmt")).append("=").append(this.getWriteOffAmt());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        if (this.isReceipt()) {
            return this.getWriteOffAmt();
        }
        return this.getPayAmt();
    }

    @Override
    public void setProcessUI(IProcessUI processMonitor) {
        this.m_processUI = processMonitor;
    }

    public MPaymentTransaction createPaymentTransaction(String trxName) {
        MPaymentTransaction paymentTransaction = new MPaymentTransaction(this.getCtx(), 0, trxName);
        paymentTransaction.setA_City(this.getA_City());
        paymentTransaction.setA_Country(this.getA_Country());
        paymentTransaction.setA_EMail(this.getA_EMail());
        paymentTransaction.setA_Ident_DL(this.getA_Ident_DL());
        paymentTransaction.setA_Ident_SSN(this.getA_Ident_SSN());
        paymentTransaction.setA_Name(this.getA_Name());
        paymentTransaction.setA_State(this.getA_State());
        paymentTransaction.setA_Street(this.getA_Street());
        paymentTransaction.setA_Zip(this.getA_Zip());
        paymentTransaction.setAccountNo(this.getAccountNo());
        paymentTransaction.setIBAN(this.getIBAN());
        paymentTransaction.setAD_Org_ID(this.getAD_Org_ID());
        paymentTransaction.setC_BankAccount_ID(this.getC_BankAccount_ID());
        paymentTransaction.setC_BP_BankAccount_ID(this.getC_BP_BankAccount_ID());
        paymentTransaction.setC_BPartner_ID(this.getC_BPartner_ID());
        paymentTransaction.setC_ConversionType_ID(this.getC_ConversionType_ID());
        paymentTransaction.setC_Currency_ID(this.getC_Currency_ID());
        paymentTransaction.setC_Invoice_ID(this.getC_Invoice_ID());
        paymentTransaction.setC_Order_ID(this.getC_Order_ID());
        paymentTransaction.setC_PaymentProcessor_ID(this.getC_PaymentProcessor_ID());
        paymentTransaction.setC_POSTenderType_ID(this.getC_POSTenderType_ID());
        paymentTransaction.setCheckNo(this.getCheckNo());
        paymentTransaction.setCreditCardExpMM(this.getCreditCardExpMM());
        paymentTransaction.setCreditCardExpYY(this.getCreditCardExpYY());
        paymentTransaction.setCreditCardNumber(this.getCreditCardNumber());
        paymentTransaction.setCreditCardType(this.getCreditCardType());
        paymentTransaction.setCreditCardVV(this.getCreditCardVV());
        paymentTransaction.setCustomerAddressID(this.getCustomerAddressID());
        paymentTransaction.setCustomerPaymentProfileID(this.getCustomerPaymentProfileID());
        paymentTransaction.setCustomerProfileID(this.getCustomerProfileID());
        paymentTransaction.setDateTrx(this.getDateTrx());
        paymentTransaction.setDescription(this.getDescription());
        paymentTransaction.setIsActive(this.isActive());
        paymentTransaction.setIsApproved(this.isApproved());
        paymentTransaction.setIsDelayedCapture(this.isDelayedCapture());
        paymentTransaction.setIsOnline(this.isOnline());
        paymentTransaction.setIsReceipt(this.isReceipt());
        paymentTransaction.setIsSelfService(this.isSelfService());
        paymentTransaction.setIsVoided(this.isVoided());
        paymentTransaction.setMicr(this.getMicr());
        paymentTransaction.setOrig_TrxID(this.getOrig_TrxID());
        paymentTransaction.setPayAmt(this.getPayAmt());
        paymentTransaction.setPONum(this.getPONum());
        paymentTransaction.setProcessed(this.isProcessed());
        paymentTransaction.setR_AuthCode(this.getR_AuthCode());
        paymentTransaction.setR_AvsAddr(this.getR_AvsAddr());
        paymentTransaction.setR_AvsZip(this.getR_AvsZip());
        paymentTransaction.setR_CVV2Match(this.isR_CVV2Match());
        paymentTransaction.setR_Info(this.getR_Info());
        paymentTransaction.setR_PnRef(this.getR_PnRef());
        paymentTransaction.setR_RespMsg(this.getR_RespMsg());
        paymentTransaction.setR_Result(this.getR_Result());
        paymentTransaction.setR_VoidMsg(this.getR_VoidMsg());
        paymentTransaction.setRoutingNo(this.getRoutingNo());
        paymentTransaction.setSwiftCode(this.getSwiftCode());
        paymentTransaction.setTaxAmt(this.getTaxAmt());
        paymentTransaction.setTenderType(this.getTenderType());
        paymentTransaction.setTrxType(this.getTrxType());
        paymentTransaction.setVoiceAuthCode(this.getVoiceAuthCode());
        return paymentTransaction;
    }

    protected boolean voidOnlinePayment() {
        if (this.getTenderType().equals("C") && this.isOnline()) {
            this.setOrig_TrxID(this.getR_PnRef());
            this.setTrxType("V");
            if (!this.processOnline()) {
                this.setTrxType("C");
                if (!this.processOnline()) {
                    this.log.log(Level.SEVERE, "Failed to cancel payment online");
                    this.m_processMsg = Msg.getMsg(this.getCtx(), "PaymentNotCancelled");
                    return false;
                }
            }
        }
        if (this.getC_Invoice_ID() != 0) {
            MInvoice inv = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            inv.setC_Payment_ID(0);
            inv.saveEx();
        }
        if (this.getC_Order_ID() != 0) {
            MOrder ord = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
            ord.setC_Payment_ID(0);
            ord.saveEx();
        }
        return true;
    }

    @Override
    public PO getPO() {
        return this;
    }

    public static int[] getCompletedPaymentIDs(int C_Order_ID, int C_Invoice_ID, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("TenderType='").append("C").append("' ");
        whereClause.append("AND TrxType IN ('").append("D").append("', ");
        whereClause.append("'").append("S").append("', ");
        whereClause.append("'").append("C").append("') ");
        if (C_Order_ID > 0 && C_Invoice_ID > 0) {
            whereClause.append(" AND (C_Order_ID=").append(C_Order_ID).append(" OR C_Invoice_ID=").append(C_Invoice_ID).append(")");
        } else if (C_Order_ID > 0) {
            whereClause.append(" AND C_Order_ID=").append(C_Order_ID);
        } else if (C_Invoice_ID > 0) {
            whereClause.append(" AND C_Invoice_ID=").append(C_Invoice_ID);
        }
        whereClause.append(" AND IsApproved='Y' AND DocStatus IN ('CO','CL') ");
        whereClause.append("ORDER BY DateTrx DESC");
        return MPaymentTransaction.getAllIDs("C_Payment", whereClause.toString(), trxName);
    }

    public MAllocationHdr getJustCreatedAllocInv() {
        return this.m_justCreatedAllocInv;
    }

    public static Vector<Vector<Object>> getUnAllocatedPaymentData(int C_BPartner_ID, int C_Currency_ID, boolean isMultiCurrency, Timestamp date, int AD_Org_ID, String trxName) {
        Vector<Vector<Object>> data;
        block12: {
            if (C_Currency_ID == 0) {
                C_Currency_ID = Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID");
            }
            data = new Vector<Vector<Object>>();
            StringBuilder sql = new StringBuilder("SELECT p.DateTrx,p.DocumentNo,p.C_Payment_ID,c.ISO_Code,p.PayAmt,currencyConvertPayment(p.C_Payment_ID,?,null,?),currencyConvertPayment(p.C_Payment_ID,?,paymentAvailable(p.C_Payment_ID),?),p.MultiplierAP FROM C_Payment_v p INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID) WHERE p.IsAllocated='N' AND p.Processed='Y' AND p.C_Charge_ID IS NULL AND p.C_BPartner_ID=?");
            if (!isMultiCurrency) {
                sql.append(" AND p.C_Currency_ID=?");
            }
            if (AD_Org_ID != 0) {
                sql.append(" AND p.AD_Org_ID=" + AD_Org_ID);
            }
            sql.append(" ORDER BY p.DateTrx,p.DocumentNo");
            sql = new StringBuilder(MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "p", true, false));
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("PaySQL=" + sql.toString());
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), trxName);
                    pstmt.setInt(1, C_Currency_ID);
                    pstmt.setTimestamp(2, date);
                    pstmt.setInt(3, C_Currency_ID);
                    pstmt.setTimestamp(4, date);
                    pstmt.setInt(5, C_BPartner_ID);
                    if (!isMultiCurrency) {
                        pstmt.setInt(6, C_Currency_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>();
                        line.add(Boolean.FALSE);
                        line.add(rs.getTimestamp(1));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                        line.add(pp);
                        if (isMultiCurrency) {
                            line.add(rs.getString(4));
                            line.add(rs.getBigDecimal(5));
                        }
                        line.add(rs.getBigDecimal(6));
                        BigDecimal available = rs.getBigDecimal(7);
                        if (available == null || available.signum() == 0) continue;
                        line.add(available);
                        line.add(Env.ZERO);
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        return data;
    }
}

