/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderPaySchedule;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Process
public class OrderPayScheduleValidate
extends SvrProcess {
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            if (para[i].getParameter() != null) {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MOrderPaySchedule[] schedule;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_OrderPaySchedule_ID=" + this.getRecord_ID());
        }
        if ((schedule = MOrderPaySchedule.getOrderPaySchedule((Properties)this.getCtx(), (int)0, (int)this.getRecord_ID(), null)).length == 0) {
            throw new IllegalArgumentException("OrderPayScheduleValidate - No Schedule");
        }
        MOrder order = new MOrder(this.getCtx(), schedule[0].getC_Order_ID(), null);
        if (order.get_ID() == 0) {
            throw new IllegalArgumentException("OrderPayScheduleValidate - No Order");
        }
        BigDecimal total = Env.ZERO;
        int i = 0;
        while (i < schedule.length) {
            BigDecimal due = schedule[i].getDueAmt();
            if (due != null) {
                total = total.add(due);
            }
            ++i;
        }
        boolean valid = order.getGrandTotal().compareTo(total) == 0;
        order.setIsPayScheduleValid(valid);
        order.saveEx();
        int i2 = 0;
        while (i2 < schedule.length) {
            if (schedule[i2].isValid() != valid) {
                schedule[i2].setIsValid(valid);
                schedule[i2].saveEx();
            }
            ++i2;
        }
        StringBuilder msg = new StringBuilder("@OK@");
        if (!valid) {
            msg = new StringBuilder("@GrandTotal@ = ").append(order.getGrandTotal()).append(" <> @Total@ = ").append(total).append("  - @Difference@ = ").append(order.getGrandTotal().subtract(total));
        }
        return Msg.parseTranslation((Properties)this.getCtx(), (String)msg.toString());
    }
}

