/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

@Process
public class ApplyMigrationScripts
extends SvrProcess {
    protected String doIt() throws Exception {
        this.log.info("Applying migrations scripts");
        StringBuilder sql = new StringBuilder().append("select ad_migrationscript_id, script, name from ad_migrationscript where isApply = 'Y' and status = 'IP' order by name, created");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                StringBuilder msglog;
                CPreparedStatement pstmtu;
                byte[] scriptArray = rs.getBytes(2);
                int seqID = rs.getInt(1);
                boolean execOk = true;
                try {
                    try {
                        StringBuilder tmpSql = new StringBuilder(new String(scriptArray));
                        if (tmpSql.length() > 0) {
                            if (this.log.isLoggable(Level.INFO)) {
                                this.log.info("Executing script " + rs.getString(3));
                            }
                            execOk = this.executeScript(tmpSql.toString(), rs.getString(3));
                            System.out.println();
                        }
                    }
                    catch (SQLException e) {
                        execOk = false;
                        e.printStackTrace();
                        StringBuilder msglog2 = new StringBuilder("Script: ").append(rs.getString(3)).append(" - ").append(e.getMessage());
                        this.log.saveError("Error", msglog2.toString());
                        this.log.severe(e.getMessage());
                        sql = new StringBuilder("UPDATE ad_migrationscript SET status = ? , isApply = 'N' WHERE ad_migrationscript_id = ? ");
                        pstmtu = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                        if (execOk) {
                            pstmtu.setString(1, "CO");
                            pstmtu.setInt(2, seqID);
                        } else {
                            pstmtu.setString(1, "ER");
                            pstmtu.setInt(2, seqID);
                        }
                        try {
                            try {
                                pstmtu.executeUpdate();
                            }
                            catch (SQLException e2) {
                                e2.printStackTrace();
                                msglog = new StringBuilder("Script: ").append(rs.getString(3)).append(" - ").append(e2.getMessage());
                                this.log.saveError("Error", msglog.toString());
                                this.log.severe(e2.getMessage());
                                DB.close((Statement)pstmtu);
                                pstmtu = null;
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close((Statement)pstmtu);
                            pstmtu = null;
                            throw throwable;
                        }
                        DB.close((Statement)pstmtu);
                        pstmtu = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    block32: {
                        sql = new StringBuilder("UPDATE ad_migrationscript SET status = ? , isApply = 'N' WHERE ad_migrationscript_id = ? ");
                        pstmtu = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                        if (execOk) {
                            pstmtu.setString(1, "CO");
                            pstmtu.setInt(2, seqID);
                        } else {
                            pstmtu.setString(1, "ER");
                            pstmtu.setInt(2, seqID);
                        }
                        try {
                            try {
                                pstmtu.executeUpdate();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                                msglog = new StringBuilder("Script: ").append(rs.getString(3)).append(" - ").append(e.getMessage());
                                this.log.saveError("Error", msglog.toString());
                                this.log.severe(e.getMessage());
                                DB.close((Statement)pstmtu);
                                pstmtu = null;
                                break block32;
                            }
                        }
                        catch (Throwable throwable2) {
                            DB.close((Statement)pstmtu);
                            pstmtu = null;
                            throw throwable2;
                        }
                        DB.close((Statement)pstmtu);
                        pstmtu = null;
                    }
                    throw throwable;
                }
                sql = new StringBuilder("UPDATE ad_migrationscript SET status = ? , isApply = 'N' WHERE ad_migrationscript_id = ? ");
                pstmtu = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                if (execOk) {
                    pstmtu.setString(1, "CO");
                    pstmtu.setInt(2, seqID);
                } else {
                    pstmtu.setString(1, "ER");
                    pstmtu.setInt(2, seqID);
                }
                try {
                    try {
                        pstmtu.executeUpdate();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        msglog = new StringBuilder("Script: ").append(rs.getString(3)).append(" - ").append(e.getMessage());
                        this.log.saveError("Error", msglog.toString());
                        this.log.severe(e.getMessage());
                        DB.close((Statement)pstmtu);
                        pstmtu = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    DB.close((Statement)pstmtu);
                    pstmtu = null;
                    throw throwable;
                }
                DB.close((Statement)pstmtu);
                pstmtu = null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return null;
    }

    protected void prepare() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executeScript(String sql, String fileName) {
        BufferedReader reader = new BufferedReader(new StringReader(sql));
        StringBuilder sqlBuf = new StringBuilder();
        boolean statementReady = false;
        boolean execOk = true;
        boolean longComment = false;
        try {
            while (true) {
                block23: {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        return true;
                    }
                    if ((line = line.trim()).startsWith("--") || line.length() == 0) continue;
                    if (line.endsWith(";") && !longComment) {
                        sqlBuf.append(' ');
                        sqlBuf.append(line.substring(0, line.length() - 1));
                        statementReady = true;
                    } else if (line.startsWith("/*")) {
                        longComment = true;
                    } else if (line.endsWith("*/")) {
                        longComment = false;
                    } else {
                        if (longComment) continue;
                        sqlBuf.append(' ');
                        sqlBuf.append(line);
                        statementReady = false;
                    }
                    if (!statementReady || sqlBuf.length() == 0) continue;
                    Connection conn = DB.getConnection();
                    conn.setAutoCommit(false);
                    Statement stmt = null;
                    try {
                        try {
                            stmt = conn.createStatement();
                            stmt.execute(sqlBuf.toString());
                            System.out.print(".");
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            execOk = false;
                            StringBuilder msglog = new StringBuilder("Script: ").append(fileName).append(" - ").append(e.getMessage()).append(". The line that caused the error is the following ==> ").append((CharSequence)sqlBuf);
                            this.log.saveError("Error", msglog.toString());
                            this.log.severe(e.getMessage());
                            DB.close((Statement)stmt);
                            stmt = null;
                            if (execOk) {
                                conn.commit();
                            } else {
                                conn.rollback();
                            }
                            conn.setAutoCommit(true);
                            conn.close();
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close((Statement)stmt);
                        stmt = null;
                        if (execOk) {
                            conn.commit();
                        } else {
                            conn.rollback();
                        }
                        conn.setAutoCommit(true);
                        conn.close();
                        throw throwable;
                    }
                    DB.close((Statement)stmt);
                    stmt = null;
                    if (execOk) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                    conn.setAutoCommit(true);
                    conn.close();
                }
                if (!execOk) {
                    return false;
                }
                sqlBuf.setLength(0);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

