/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.Extensions;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.IProcessParameterListener;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.EditorBox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Group;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Urlbox;
import org.adempiere.webui.editor.DateRangeEditor;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.DateRangeButton;
import org.adempiere.webui.window.Dialog;
import org.compiere.apps.IProcessParameter;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.WrongValuesException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Div;
import org.zkoss.zul.Label;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Space;
import org.zkoss.zul.impl.InputElement;
import org.zkoss.zul.impl.XulElement;

public class ProcessParameterPanel
extends Panel
implements ValueChangeListener,
IProcessParameter,
EventListener<Event>,
Evaluatee {
    private static final long serialVersionUID = -8476698839617674953L;
    private static final String ON_POST_EDITOR_VALUE_CHANGE_EVENT = "onPostEditorValueChange";
    private int m_WindowNo;
    private int m_TabNo;
    private ProcessInfo m_processInfo;
    private int m_AD_Window_ID = 0;
    private int m_InfoWindowID = 0;
    private static final CLogger log = CLogger.getCLogger(ProcessParameterPanel.class);
    private ArrayList<WEditor> m_wEditors = new ArrayList();
    private ArrayList<WEditor> m_wEditors2 = new ArrayList();
    private ArrayList<GridField> m_mFields = new ArrayList();
    private ArrayList<GridField> m_mFields2 = new ArrayList();
    private ArrayList<Space> m_separators = new ArrayList();
    private ArrayList<Row> m_Rows = new ArrayList();
    private ArrayList<DateRangeEditor> m_dateRangeEditors = new ArrayList();
    private Grid centerPanel = null;
    private Map<String, List<Row>> fieldGroupContents = new HashMap<String, List<Row>>();
    private Map<String, List<org.zkoss.zul.Row>> fieldGroupHeaders = new HashMap<String, List<org.zkoss.zul.Row>>();
    private ArrayList<Row> rowList;
    private List<Group> allCollapsibleGroups = new ArrayList<Group>();
    private Group currentGroup;

    public ProcessParameterPanel(int WindowNo, ProcessInfo pi) {
        this(WindowNo, 0, pi);
    }

    public ProcessParameterPanel(int WindowNo, int tabNo, ProcessInfo pi) {
        this.m_WindowNo = WindowNo;
        this.m_TabNo = tabNo;
        this.m_processInfo = pi;
        this.m_AD_Window_ID = AEnv.getADWindowID(WindowNo);
        this.m_InfoWindowID = pi.getAD_InfoWindow_ID();
        this.initComponent();
        this.addEventListener("onDynamicDisplay", this);
        this.addEventListener(ON_POST_EDITOR_VALUE_CHANGE_EVENT, this);
    }

    private void initComponent() {
        this.centerPanel = GridFactory.newGridLayout();
        this.appendChild((Component)this.centerPanel);
        Columns columns = new Columns();
        this.centerPanel.appendChild((Component)columns);
        Column col = new Column();
        if (!LayoutUtils.isLabelAboveInputForSmallWidth()) {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)col, "30%");
            columns.appendChild((Component)col);
            col = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)col, "70%");
        } else {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)col, "100%");
        }
        columns.appendChild((Component)col);
    }

    public void dispose() {
        this.m_wEditors.clear();
        this.m_wEditors2.clear();
        this.m_mFields.clear();
        this.m_mFields2.clear();
    }

    public boolean init() {
        Rows rows;
        boolean hasFields;
        block22: {
            if (log.isLoggable(Level.CONFIG)) {
                log.config("");
            }
            MClient client = MClient.get((Properties)Env.getCtx());
            Object ASPFilter = "";
            if (client.isUseASP()) {
                ASPFilter = "   AND (   p.AD_Process_Para_ID not IN (               SELECT pp.AD_Process_Para_ID                 FROM ASP_Process_Para pp, ASP_Process p, ASP_Level l, ASP_ClientLevel cl                WHERE p.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID                  AND pp.ASP_Process_ID = p.ASP_Process_ID                  AND pp.IsActive = 'Y'                  AND p.IsActive = 'Y'                  AND l.IsActive = 'Y'                  AND cl.IsActive = 'Y' \t\t\t\t\tAND p.ad_process_ID=" + this.m_processInfo.getAD_Process_ID() + "                 AND pp.ASP_Status = 'H' \t\t\t\t\tAND pp.AD_Process_Para_ID not in ( \t\t\t\t\tSELECT AD_Process_Para_ID \t\t\t\t\tFROM ASP_ClientException ce \t\t\t\t\tWHERE ce.AD_Client_ID =" + client.getAD_Client_ID() + " \t\t\t\t\tAND ce.IsActive = 'Y' \t\t\t\t\tAND ce.AD_Process_Para_ID IS NOT NULL \t\t\t\t\tAND ce.AD_Tab_ID IS NULL \t\t\t\t\tAND ce.AD_Field_ID IS NULL \t\t\t\t\tAND ce.ASP_Status in('S','U') )    UNION ALL           SELECT AD_Process_Para_ID             FROM ASP_ClientException ce            WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y'              AND ce.AD_Process_Para_ID IS NOT NULL              AND ce.AD_Tab_ID IS NULL \t\t\t\tAND ce.AD_Process_Para_ID=" + this.m_processInfo.getAD_Process_ID() + "             AND ce.AD_Field_ID IS NULL              AND ce.ASP_Status = 'H'))";
            }
            String sql = null;
            sql = Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Process_Para") ? "SELECT p.Name, p.Description, p.Help, p.AD_Reference_ID, p.AD_Process_Para_ID, p.FieldLength, p.IsMandatory, p.IsRange, p.dateRangeOption, p.ColumnName, p.DefaultValue, p.DefaultValue2, p.VFormat, p.ValueMin, p.ValueMax, p.SeqNo, p.AD_Reference_Value_ID, vr.Code AS ValidationCode, p.ReadOnlyLogic, p.DisplayLogic, p.IsEncrypted, NULL AS FormatPattern, p.MandatoryLogic, p.Placeholder, p.Placeholder2, p.isAutoComplete, p.EntityType, '' AS ValidationCodeLookup, fg.Name AS FieldGroup, fg.FieldGroupType, fg.IsCollapsedByDefault, p.IsShowNegateButton FROM AD_Process_Para p LEFT OUTER JOIN AD_Val_Rule vr ON (p.AD_Val_Rule_ID=vr.AD_Val_Rule_ID)  LEFT OUTER JOIN AD_FieldGroup fg ON (p.AD_FieldGroup_ID=fg.AD_FieldGroup_ID) WHERE p.AD_Process_ID=? AND p.IsActive='Y' " + (String)ASPFilter + " ORDER BY SeqNo" : "SELECT t.Name, t.Description, t.Help, p.AD_Reference_ID, p.AD_Process_Para_ID, p.FieldLength, p.IsMandatory, p.IsRange, p.dateRangeOption, p.ColumnName, p.DefaultValue, p.DefaultValue2, p.VFormat, p.ValueMin, p.ValueMax, p.SeqNo, p.AD_Reference_Value_ID, vr.Code AS ValidationCode, p.ReadOnlyLogic, p.DisplayLogic, p.IsEncrypted, NULL AS FormatPattern,p.MandatoryLogic, t.Placeholder, t.Placeholder2, p.isAutoComplete, p.EntityType, '' AS ValidationCodeLookup, fgt.Name AS FieldGroup, fg.FieldGroupType, fg.IsCollapsedByDefault, p.IsShowNegateButton FROM AD_Process_Para p INNER JOIN AD_Process_Para_Trl t ON (p.AD_Process_Para_ID=t.AD_Process_Para_ID) LEFT OUTER JOIN AD_Val_Rule vr ON (p.AD_Val_Rule_ID=vr.AD_Val_Rule_ID)  LEFT OUTER JOIN AD_FieldGroup fg ON (p.AD_FieldGroup_ID=fg.AD_FieldGroup_ID)  LEFT OUTER JOIN AD_FieldGroup_Trl fgt ON (p.AD_FieldGroup_ID=fgt.AD_FieldGroup_ID AND fgt.AD_Language='" + Env.getAD_Language((Properties)Env.getCtx()) + "') WHERE p.AD_Process_ID=? AND t.AD_Language='" + Env.getAD_Language((Properties)Env.getCtx()) + "' AND p.IsActive='Y' " + (String)ASPFilter + " ORDER BY SeqNo";
            hasFields = false;
            String currentFieldGroup = null;
            rows = new Rows();
            Row row = new Row();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_processInfo.getAD_Process_ID());
                    rs = pstmt.executeQuery();
                    ArrayList<GridFieldVO> listVO = new ArrayList<GridFieldVO>();
                    ArrayList<Group> toCollapsed = new ArrayList<Group>();
                    while (rs.next()) {
                        hasFields = true;
                        GridFieldVO voF = GridFieldVO.createParameter((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)this.m_TabNo, (int)this.m_processInfo.getAD_Process_ID(), (int)this.m_AD_Window_ID, (int)this.m_InfoWindowID, (ResultSet)rs);
                        listVO.add(voF);
                    }
                    Collections.sort(listVO, new GridFieldVO.SeqNoComparator());
                    int i = 0;
                    while (i < listVO.size()) {
                        GridFieldVO voF = (GridFieldVO)listVO.get(i);
                        GridField field = new GridField(voF);
                        this.m_mFields.add(field);
                        field.setParentEvaluatee((Evaluatee)this);
                        String fieldGroup = field.getFieldGroup();
                        if (!(Util.isEmpty((String)fieldGroup) || fieldGroup.equals(currentFieldGroup) || "D".equals(field.getFieldGroupType()))) {
                            currentFieldGroup = fieldGroup;
                            row.setGroup(this.currentGroup);
                            rows.appendChild((Component)row);
                            if (this.rowList != null) {
                                this.rowList.add(row);
                            }
                            ArrayList<Object> headerRows = new ArrayList<Object>();
                            this.fieldGroupHeaders.put(fieldGroup, headerRows);
                            this.rowList = new ArrayList();
                            this.fieldGroupContents.put(fieldGroup, this.rowList);
                            if ("L".equals(field.getFieldGroupType())) {
                                row = new Row();
                                Label groupLabel = new Label(fieldGroup);
                                row.appendCellChild((Component)groupLabel, 3);
                                rows.appendChild((Component)row);
                                headerRows.add((Object)row);
                                row = new Row();
                                Separator separator = new Separator();
                                separator.setBar(true);
                                row.appendCellChild((Component)separator, 3);
                                rows.appendChild((Component)row);
                                headerRows.add((Object)row);
                                this.currentGroup = null;
                            } else {
                                Group rowg = new Group(fieldGroup);
                                Cell cell = (Cell)rowg.getFirstChild();
                                cell.setSclass("z-group-inner");
                                cell.setColspan(3);
                                this.allCollapsibleGroups.add(rowg);
                                if ("T".equals(field.getFieldGroupType()) || field.getIsCollapsedByDefault()) {
                                    toCollapsed.add(rowg);
                                }
                                this.currentGroup = rowg;
                                rows.appendChild((Component)rowg);
                                headerRows.add((Object)rowg);
                            }
                            row = new Row();
                        }
                        row = new Row();
                        this.createField(voF, field, row);
                        row.setGroup(this.currentGroup);
                        rows.appendChild((Component)row);
                        this.m_Rows.add(row);
                        if (this.rowList != null) {
                            this.rowList.add(row);
                        }
                        if (log.isLoggable(Level.INFO)) {
                            log.info(((GridFieldVO)listVO.get((int)i)).ColumnName + ((GridFieldVO)listVO.get((int)i)).SeqNo);
                        }
                        ++i;
                    }
                    if (toCollapsed.size() > 0) {
                        toCollapsed.stream().forEach(g -> g.setOpen(false));
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block22;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.m_mFields.size() != this.m_mFields2.size() || this.m_mFields.size() != this.m_wEditors.size() || this.m_mFields2.size() != this.m_wEditors2.size()) {
            log.log(Level.SEVERE, "View & Model vector size is different");
        }
        if (hasFields) {
            this.centerPanel.appendChild((Component)rows);
            this.dynamicDisplay();
            if (this.m_processInfo.getAD_Process_ID() > 0) {
                String className = MProcess.get((Properties)Env.getCtx(), (int)this.m_processInfo.getAD_Process_ID()).getClassname();
                List<IProcessParameterListener> listeners = Extensions.getProcessParameterListeners(className, null);
                for (IProcessParameterListener listener : listeners) {
                    listener.onInit(this);
                }
            }
        } else {
            this.dispose();
        }
        return hasFields;
    }

    private void createField(GridFieldVO voF, GridField mField, Row row) {
        WEditor editor = WebEditorFactory.getEditor(mField, false);
        editor.setProcessParameter(true);
        editor.getComponent().addEventListener("onFocus", (EventListener)this);
        editor.addValueChangeListener(this);
        editor.dynamicDisplay();
        mField.addPropertyChangeListener((PropertyChangeListener)editor);
        Object defaultObject = mField.getDefaultForPanel();
        mField.setValue(defaultObject, true);
        editor.fillHorizontal();
        WEditorPopupMenu popupMenu = editor.getPopupMenu();
        if (popupMenu != null) {
            popupMenu.addMenuListener((ContextMenuListener)((Object)editor));
            popupMenu.setId(mField.getColumnName() + "-popup");
            this.appendChild((Component)popupMenu);
            if (!mField.isFieldOnly()) {
                org.adempiere.webui.component.Label label = editor.getLabel();
                if (popupMenu.isZoomEnabled() && editor instanceof IZoomableEditor) {
                    label.addEventListener("onClick", new ZoomListener((IZoomableEditor)((Object)editor)));
                }
                popupMenu.addContextElement((XulElement)label);
                if (editor.getComponent() instanceof XulElement) {
                    popupMenu.addContextElement((XulElement)editor.getComponent());
                }
            }
        }
        this.m_wEditors.add(editor);
        Div div = new Div();
        if (!LayoutUtils.isLabelAboveInputForSmallWidth()) {
            div.setStyle("text-align: right;");
        }
        org.adempiere.webui.component.Label label = editor.getLabel();
        div.appendChild((Component)label);
        if (label.getDecorator() != null) {
            div.appendChild(label.getDecorator());
        }
        if (!LayoutUtils.isLabelAboveInputForSmallWidth()) {
            row.appendChild((Component)div);
        }
        Div box = new Div();
        if (!LayoutUtils.isLabelAboveInputForSmallWidth()) {
            box.setStyle("display: flex; align-items: center;");
        }
        ZKUpdateUtil.setWidth((HtmlBasedComponent)box, "100%");
        if (voF.isRange) {
            box.appendChild(editor.getComponent());
            ZKUpdateUtil.setWidth((HtmlBasedComponent)editor.getComponent(), "49%");
            GridFieldVO voF2 = GridFieldVO.createParameter((GridFieldVO)voF);
            GridField mField2 = new GridField(voF2);
            this.m_mFields2.add(mField2);
            WEditor editor2 = WebEditorFactory.getEditor(mField2, false);
            editor2.setProcessParameter(true);
            editor2.getComponent().setClientAttribute("columnName", mField2.getColumnName() + "_To");
            editor2.getComponent().addEventListener("onFocus", (EventListener)this);
            mField2.addPropertyChangeListener((PropertyChangeListener)editor2);
            editor2.addValueChangeListener(this);
            editor2.dynamicDisplay();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)editor2.getComponent(), "49%");
            this.setEditorPlaceHolder(editor2, mField2.getPlaceholder2());
            popupMenu = editor2.getPopupMenu();
            if (popupMenu != null) {
                popupMenu.addMenuListener((ContextMenuListener)((Object)editor2));
                this.appendChild((Component)popupMenu);
            }
            Object defaultObject2 = mField2.getDefaultForPanel();
            mField2.setValue(defaultObject2, true);
            this.m_wEditors2.add(editor2);
            Space separator = new Space();
            separator.setStyle("margin:0; width: 2%;");
            this.m_separators.add(separator);
            box.appendChild((Component)separator);
            box.appendChild(editor2.getComponent());
            row.appendChild((Component)box);
            if (!(mField.getDisplayType() != 15 && mField.getDisplayType() != 16 || mField2.getDisplayType() != 15 && mField2.getDisplayType() != 16)) {
                if ("T".equalsIgnoreCase(mField.getDateRangeOption())) {
                    editor.setVisible(false, true);
                    editor2.setVisible(false, true);
                    DateRangeEditor dateRangeEditor = new DateRangeEditor(editor, editor2);
                    box.appendChild((Component)dateRangeEditor);
                    dateRangeEditor.setVisible(mField.isDisplayed(true));
                    label.setVisible(dateRangeEditor.isVisible());
                    dateRangeEditor.setReadOnly(!editor.isReadWrite() || !editor2.isReadWrite());
                    this.m_dateRangeEditors.add(dateRangeEditor);
                } else {
                    DateRangeButton dateRangeButton = new DateRangeButton(editor, editor2);
                    box.appendChild((Component)dateRangeButton);
                    this.m_dateRangeEditors.add(null);
                }
            } else {
                this.m_dateRangeEditors.add(null);
            }
        } else {
            box.appendChild(editor.getComponent());
            this.m_mFields2.add(null);
            this.m_wEditors2.add(null);
            this.m_separators.add(null);
            this.m_dateRangeEditors.add(null);
            if (DisplayType.isChosenMultipleSelection((int)mField.getDisplayType()) && voF.IsShowNegateButton) {
                Button bNegate = ButtonFactory.createButton("", null, null);
                bNegate.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"IncludeSelectedValues"));
                bNegate.setIconSclass("z-icon-IncludeSelected");
                bNegate.setSclass("btn-negate btn-negate-include");
                bNegate.setAttribute("isSelected", false);
                bNegate.setVisible(false);
                bNegate.addActionListener(this);
                box.appendChild((Component)bNegate);
                editor.getComponent().setAttribute("isNotClause", (Object)bNegate);
            }
        }
        if (!LayoutUtils.isLabelAboveInputForSmallWidth()) {
            row.appendChild((Component)box);
        } else {
            Div container = new Div();
            container.appendChild((Component)div);
            container.appendChild((Component)box);
            row.appendCellChild((Component)container);
            LayoutUtils.addSclass("form-label-above-input", (HtmlBasedComponent)row.getLastCell());
            LayoutUtils.addSclass("form-label", (HtmlBasedComponent)div);
        }
    }

    private void setEditorPlaceHolder(WEditor editor, String msg) {
        Component c = editor.getComponent();
        if (c instanceof InputElement) {
            ((InputElement)c).setPlaceholder(msg);
        } else {
            for (Component e : c.getChildren()) {
                if (!(e instanceof InputElement)) continue;
                ((InputElement)e).setPlaceholder(msg);
                break;
            }
        }
    }

    public boolean validateParameters() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        HashMap<Component, String> wrongValidateComponents = new HashMap<Component, String>();
        int size = this.m_mFields.size();
        int i = 0;
        while (i < size) {
            Object data;
            String msg2;
            WEditor wEditor2;
            GridField field = this.m_mFields.get(i);
            GridField field2 = this.m_mFields2.get(i);
            WEditor wEditor = this.m_wEditors.get(i);
            if (wEditor.getComponent() instanceof InputElement) {
                ((InputElement)wEditor.getComponent()).clearErrorMessage();
            }
            if ((wEditor2 = this.m_wEditors2.get(i)) != null && wEditor2.getComponent() instanceof InputElement) {
                ((InputElement)wEditor2.getComponent()).clearErrorMessage();
            }
            if ((msg2 = ProcessParameterPanel.validate(data = wEditor.getValue(), field.getValueMin(), field.getValueMax(), field.isMandatory(true), field.getDisplayType())) != null) {
                field.setInserting(true);
                field.setError(true);
                wrongValidateComponents.put(wEditor.getComponent(), msg2);
            }
            if (this.m_wEditors2.get(i) != null && (msg2 = ProcessParameterPanel.validate(data = wEditor2.getValue(), field.getValueMin(), field.getValueMax(), field.isMandatory(true), field.getDisplayType())) != null) {
                field2.setInserting(true);
                field2.setError(true);
                wrongValidateComponents.put(wEditor2.getComponent(), msg2);
            }
            ++i;
        }
        ArrayList wrongValues = new ArrayList();
        wrongValidateComponents.forEach((component, msg) -> {
            WrongValueException wrongValueException = new WrongValueException(component, msg);
            wrongValues.add(wrongValueException);
        });
        if (wrongValues.size() > 0) {
            throw new WrongValuesException(wrongValues.toArray(new WrongValueException[0]));
        }
        if (this.m_processInfo.getAD_Process_ID() > 0) {
            String className = MProcess.get((Properties)Env.getCtx(), (int)this.m_processInfo.getAD_Process_ID()).getClassname();
            List<IProcessParameterListener> listeners = Extensions.getProcessParameterListeners(className, null);
            for (IProcessParameterListener listener : listeners) {
                String error = listener.validate(this);
                if (Util.isEmpty((String)error)) continue;
                Dialog.error(this.m_WindowNo, error);
                return false;
            }
        }
        return true;
    }

    public static String validate(Object value, String valueMin, String valueMax, boolean isMandatory, int fieldType) {
        if (isMandatory && (value == null || value.toString().length() == 0)) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory");
        }
        BigDecimal value_BD = null;
        BigDecimal valueMin_BD = null;
        BigDecimal valueMax_BD = null;
        Timestamp value_TS = null;
        Timestamp valueMin_TS = null;
        Timestamp valueMax_TS = null;
        if (fieldType == 15) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (value != null) {
                try {
                    value_TS = new Timestamp(dateFormat.parse(value.toString()).getTime());
                }
                catch (Exception exception) {}
            }
            if (valueMin != null) {
                try {
                    valueMin_TS = new Timestamp(dateFormat.parse(valueMin).getTime());
                }
                catch (Exception exception) {}
            }
            if (valueMax != null) {
                try {
                    valueMax_TS = new Timestamp(dateFormat.parse(valueMax).getTime());
                }
                catch (Exception exception) {}
            }
            if (value_TS != null && valueMin_TS != null && value_TS.before(valueMin_TS)) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"LessThanMinValue", (Object[])new Object[]{valueMin});
            }
            if (value_TS != null && valueMax_TS != null && value_TS.after(valueMax_TS)) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"MoreThanMaxValue", (Object[])new Object[]{valueMax});
            }
        } else if (DisplayType.isNumeric((int)fieldType)) {
            if (value != null) {
                try {
                    value_BD = new BigDecimal(value.toString());
                }
                catch (Exception exception) {}
            }
            if (valueMin != null) {
                try {
                    valueMin_BD = new BigDecimal(valueMin);
                }
                catch (Exception exception) {}
            }
            if (valueMax != null) {
                try {
                    valueMax_BD = new BigDecimal(valueMax);
                }
                catch (Exception exception) {}
            }
            if (value_BD != null && valueMin_BD != null && valueMin_BD.compareTo(value_BD) > 0) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"LessThanMinValue", (Object[])new Object[]{valueMin});
            }
            if (value_BD != null && valueMax_BD != null && valueMax_BD.compareTo(value_BD) < 0) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"MoreThanMaxValue", (Object[])new Object[]{valueMax});
            }
        } else {
            if (value != null && valueMin != null && valueMin.compareTo(value.toString()) > 0) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"LessThanMinValue", (Object[])new Object[]{valueMin});
            }
            if (value != null && valueMax != null && valueMax.compareTo(value.toString()) < 0) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"MoreThanMaxValue", (Object[])new Object[]{valueMax});
            }
        }
        return null;
    }

    public boolean loadParameters(MPInstance instance) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        MPInstancePara[] params = instance.getParameters();
        int j = 0;
        while (j < this.m_mFields.size()) {
            GridField mField = this.m_mFields.get(j);
            if (mField.isEditablePara(true)) {
                WEditor editor = this.m_wEditors.get(j);
                WEditor editor2 = this.m_wEditors2.get(j);
                editor.setValue(null);
                if (editor2 != null) {
                    editor2.setValue(null);
                }
                int i = 0;
                while (i < params.length) {
                    MPInstancePara para = params[i];
                    if (mField.getColumnName().equals(para.getParameterName())) {
                        ValueChangeEvent changeEvent;
                        Button bNegate = null;
                        if (editor.getComponent() != null) {
                            bNegate = (Button)((Object)editor.getComponent().getAttribute("isNotClause"));
                        }
                        if (para.getP_Date() != null || para.getP_Date_To() != null) {
                            editor.setValue(para.getP_Date());
                            if (editor2 != null) {
                                editor2.setValue(para.getP_Date_To());
                            }
                        } else if (para.getP_String() != null || para.getP_String_To() != null) {
                            editor.setValue(para.getP_String());
                            if (editor2 != null) {
                                editor2.setValue(para.getP_String_To());
                            }
                        } else if (!Env.ZERO.equals(para.getP_Number()) || !Env.ZERO.equals(para.getP_Number_To())) {
                            if (DisplayType.isID((int)para.getDisplayType())) {
                                editor.setValue(para.getP_Number().intValue());
                                if (editor2 != null) {
                                    editor2.setValue(para.getP_Number_To().intValue());
                                }
                            } else {
                                editor.setValue(para.getP_Number());
                                if (editor2 != null) {
                                    editor2.setValue(para.getP_Number_To());
                                }
                            }
                        }
                        if (editor.getValue() != null) {
                            changeEvent = new ValueChangeEvent(editor, editor.getColumnName(), null, editor.getValue());
                            this.valueChange(changeEvent);
                        }
                        if (editor2 != null && editor2.getValue() != null) {
                            changeEvent = new ValueChangeEvent(editor2, editor2.getColumnName(), null, editor2.getValue());
                            this.valueChange(changeEvent);
                        }
                        if (bNegate != null) {
                            if (para.isNotClause()) {
                                bNegate.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"ExcludeSelectedValues"));
                                bNegate.setIconSclass("z-icon-ExcludeSelected");
                                bNegate.setSclass("btn-negate btn-negate-exclude");
                                bNegate.setAttribute("isSelected", true);
                            } else {
                                bNegate.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"IncludeSelectedValues"));
                                bNegate.setIconSclass("z-icon-IncludeSelected");
                                bNegate.setSclass("btn-negate btn-negate-include");
                                bNegate.setAttribute("isSelected", false);
                            }
                            if (editor.getValue() != null) {
                                bNegate.setVisible(true);
                            }
                        }
                        log.fine(para.toString());
                        break;
                    }
                    ++i;
                }
            }
            ++j;
        }
        this.dynamicDisplay();
        return true;
    }

    public boolean loadParametersFromProcessInfo(ProcessInfo pi) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        ProcessInfoParameter[] params = pi.getParameter();
        int j = 0;
        while (j < this.m_mFields.size()) {
            GridField mField = this.m_mFields.get(j);
            if (mField.isEditablePara(true)) {
                WEditor editor = this.m_wEditors.get(j);
                WEditor editor2 = this.m_wEditors2.get(j);
                editor.setValue(null);
                if (editor2 != null) {
                    editor2.setValue(null);
                }
                int i = 0;
                while (i < params.length) {
                    ProcessInfoParameter para = params[i];
                    if (mField.getColumnName().equals(para.getParameterName())) {
                        ValueChangeEvent changeEvent;
                        editor.setValue(para.getParameter());
                        if (editor2 != null) {
                            editor2.setValue(para.getParameter_To());
                        }
                        if (editor.getValue() != null) {
                            changeEvent = new ValueChangeEvent(editor, editor.getColumnName(), null, editor.getValue());
                            this.valueChange(changeEvent);
                        }
                        if (editor2 != null && editor2.getValue() != null) {
                            changeEvent = new ValueChangeEvent(editor2, editor2.getColumnName(), null, editor2.getValue());
                            this.valueChange(changeEvent);
                        }
                        log.fine(para.toString());
                        break;
                    }
                    ++i;
                }
            }
            ++j;
        }
        this.dynamicDisplay();
        return true;
    }

    public boolean saveParameters() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        if (!this.validateParameters()) {
            return false;
        }
        int i = 0;
        while (i < this.m_mFields.size()) {
            WEditor editor = this.m_wEditors.get(i);
            WEditor editor2 = this.m_wEditors2.get(i);
            Object result = editor.getValue();
            Object result2 = null;
            if (editor2 != null) {
                result2 = editor2.getValue();
            }
            if (!(result == null && result2 == null || result instanceof String && Util.isEmpty((String)((String)result)) && (result2 == null || Util.isEmpty((String)((String)result2))))) {
                MPInstancePara para = MPInstancePara.getOrCreate((Properties)Env.getCtx(), (int)this.m_processInfo.getAD_PInstance_ID(), (int)i);
                GridField mField = this.m_mFields.get(i);
                para.setParameterName(mField.getColumnName());
                Button bNegate = null;
                if (editor.getComponent() != null) {
                    bNegate = (Button)((Object)editor.getComponent().getAttribute("isNotClause"));
                }
                if (bNegate != null) {
                    para.setIsNotClause(((Boolean)bNegate.getAttribute("isSelected")).booleanValue());
                }
                if (result instanceof Timestamp || result2 instanceof Timestamp) {
                    if (result instanceof Timestamp) {
                        para.setP_Date((Timestamp)result);
                    }
                    if (editor2 != null && result2 != null && result2 instanceof Timestamp) {
                        para.setP_Date_To((Timestamp)result2);
                    }
                } else if (result instanceof Integer || result2 instanceof Integer) {
                    Integer ii;
                    if (result != null && result instanceof Integer) {
                        ii = (Integer)result;
                        para.setP_Number(ii.intValue());
                    }
                    if (editor2 != null && result2 != null && result2 instanceof Integer) {
                        ii = (Integer)result2;
                        para.setP_Number_To(ii.intValue());
                    }
                } else if (result instanceof BigDecimal || result2 instanceof BigDecimal) {
                    if (result instanceof BigDecimal) {
                        para.setP_Number((BigDecimal)result);
                    }
                    if (editor2 != null && result2 != null && result2 instanceof BigDecimal) {
                        para.setP_Number_To((BigDecimal)result2);
                    }
                } else if (result instanceof Boolean) {
                    Boolean bb = (Boolean)result;
                    String value = bb != false ? "Y" : "N";
                    para.setP_String(value);
                } else {
                    if (result != null) {
                        para.setP_String(result.toString());
                    }
                    if (editor2 != null && result2 != null) {
                        para.setP_String_To(result2.toString());
                    }
                }
                para.setInfo(editor.getDisplay());
                if (editor2 != null) {
                    para.setInfo_To(editor2.getDisplay());
                }
                para.saveEx();
                if (log.isLoggable(Level.FINE)) {
                    log.fine(para.toString());
                }
            }
            ++i;
        }
        return true;
    }

    public MPInstancePara[] getParameters() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        if (!this.validateParameters()) {
            return new MPInstancePara[0];
        }
        ArrayList<MPInstancePara> paras = new ArrayList<MPInstancePara>();
        int i = 0;
        while (i < this.m_mFields.size()) {
            WEditor editor = this.m_wEditors.get(i);
            WEditor editor2 = this.m_wEditors2.get(i);
            Object result = editor.getValue();
            Object result2 = null;
            if (editor2 != null) {
                result2 = editor2.getValue();
            }
            MPInstancePara para = new MPInstancePara(Env.getCtx(), 0, i);
            GridField mField = this.m_mFields.get(i);
            para.setParameterName(mField.getColumnName());
            para.setP_Date(null);
            para.setP_Date_To(null);
            para.setP_Number(null);
            para.setP_Number_To(null);
            para.setP_String(null);
            para.setP_String_To(null);
            if (result instanceof Timestamp || result2 instanceof Timestamp) {
                if (result instanceof Timestamp) {
                    para.setP_Date((Timestamp)result);
                }
                if (editor2 != null && result2 != null && result2 instanceof Timestamp) {
                    para.setP_Date_To((Timestamp)result2);
                }
            } else if (result instanceof Integer || result2 instanceof Integer) {
                Integer ii;
                if (result != null && result instanceof Integer) {
                    ii = (Integer)result;
                    para.setP_Number(ii.intValue());
                }
                if (editor2 != null && result2 != null && result2 instanceof Integer) {
                    ii = (Integer)result2;
                    para.setP_Number_To(ii.intValue());
                }
            } else if (result instanceof BigDecimal || result2 instanceof BigDecimal) {
                if (result instanceof BigDecimal) {
                    para.setP_Number((BigDecimal)result);
                }
                if (editor2 != null && result2 != null && result2 instanceof BigDecimal) {
                    para.setP_Number_To((BigDecimal)result2);
                }
            } else if (result instanceof Boolean) {
                Boolean bb = (Boolean)result;
                String value = bb != false ? "Y" : "N";
                para.setP_String(value);
            } else {
                if (result != null) {
                    para.setP_String(result.toString());
                }
                if (editor2 != null && result2 != null) {
                    para.setP_String_To(result2.toString());
                }
            }
            para.setInfo(editor.getDisplay());
            if (editor2 != null) {
                para.setInfo_To(editor2.getDisplay());
            }
            paras.add(para);
            ++i;
        }
        return paras.toArray(new MPInstancePara[0]);
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        Object propName = evt.getPropertyName();
        if (evt.getSource() instanceof WEditor) {
            GridField changedField;
            WEditor editor = (WEditor)evt.getSource();
            if (this.m_wEditors2.contains(editor)) {
                propName = (String)propName + "_2";
            }
            if ((changedField = editor.getGridField()) != null) {
                this.processDependencies(changedField);
            }
            Events.postEvent((String)ON_POST_EDITOR_VALUE_CHANGE_EVENT, (Component)this, (Object)evt.getSource());
        }
        this.processNewValue(evt.getNewValue(), (String)propName);
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals("onFocus")) {
            for (WEditor editor : this.m_wEditors) {
                if (!editor.isComponentOfEditor(event.getTarget())) continue;
                SessionManager.getAppDesktop().updateHelpTooltip(editor.getGridField());
                return;
            }
            for (WEditor editor : this.m_wEditors2) {
                if (editor == null || editor.getComponent() == null || !editor.isComponentOfEditor(event.getTarget())) continue;
                SessionManager.getAppDesktop().updateHelpTooltip(editor.getGridField());
                return;
            }
        } else if (event.getName().equals("onDynamicDisplay")) {
            this.dynamicDisplay();
        } else if (event.getName().equals(ON_POST_EDITOR_VALUE_CHANGE_EVENT)) {
            Button bNegate;
            WEditor editor = (WEditor)event.getData();
            this.onPostEditorValueChange(editor);
            if (editor.getComponent() != null && (bNegate = (Button)((Object)editor.getComponent().getAttribute("isNotClause"))) != null) {
                if (editor.getValue() != null) {
                    bNegate.setVisible(true);
                } else {
                    bNegate.setVisible(false);
                    bNegate.setAttribute("isSelected", false);
                    bNegate.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"IncludeSelectedValues"));
                    bNegate.setIconSclass("z-icon-IncludeSelected");
                    bNegate.setSclass("btn-negate btn-negate-include");
                }
            }
        } else if (event.getName().equals("onClick") && event.getTarget() instanceof Button) {
            boolean isSelected;
            Button bNegate = (Button)event.getTarget();
            boolean bl = isSelected = (Boolean)bNegate.getAttribute("isSelected") == false;
            if (isSelected) {
                bNegate.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"ExcludeSelectedValues"));
                bNegate.setIconSclass("z-icon-ExcludeSelected");
                bNegate.setSclass("btn-negate btn-negate-exclude");
            } else {
                bNegate.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"IncludeSelectedValues"));
                bNegate.setIconSclass("z-icon-IncludeSelected");
                bNegate.setSclass("btn-negate btn-negate-include");
            }
            bNegate.setAttribute("isSelected", isSelected);
        }
    }

    private void onPostEditorValueChange(WEditor editor) {
        if (this.m_processInfo.getAD_Process_ID() > 0) {
            String className = MProcess.get((Properties)Env.getCtx(), (int)this.m_processInfo.getAD_Process_ID()).getClassname();
            Object colName = editor.getColumnName();
            if (this.m_wEditors2.contains(editor)) {
                colName = (String)colName + "_2";
            }
            List<IProcessParameterListener> listeners = Extensions.getProcessParameterListeners(className, (String)colName);
            for (IProcessParameterListener listener : listeners) {
                listener.onChange(this, (String)colName, editor);
            }
        }
    }

    private void processDependencies(GridField changedField) {
        String columnName = changedField.getColumnName();
        for (GridField field : this.m_mFields) {
            if (field == null || field == changedField) continue;
            this.verifyChangedField(field, columnName);
        }
        for (GridField field : this.m_mFields2) {
            if (field == null || field == changedField) continue;
            this.verifyChangedField(field, columnName);
        }
    }

    private void verifyChangedField(GridField field, String columnName) {
        ArrayList list = field.getDependentOn();
        if (list.contains(columnName)) {
            GridField.updateDependentField((GridField)field, (String)columnName, (int)-1, null);
        }
    }

    private void processNewValue(Object value, String name) {
        if (value == null) {
            value = new String("");
        }
        if (value instanceof String) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)name, (String)((String)value));
        } else if (value instanceof Integer) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)name, (int)((Integer)value));
        } else if (value instanceof Boolean) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)name, (boolean)((Boolean)value));
        } else if (value instanceof Timestamp) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)name, (Timestamp)((Timestamp)value));
        } else {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)name, (String)value.toString());
        }
        Events.postEvent((String)"onDynamicDisplay", (Component)this, null);
    }

    private void dynamicDisplay() {
        int i = 0;
        while (i < this.m_wEditors.size()) {
            DateRangeEditor dateRangeEditor;
            WEditor editor = this.m_wEditors.get(i);
            GridField mField = editor.getGridField();
            GridField mField2 = null;
            if (mField.getVO().isRange) {
                mField2 = this.m_wEditors2.get(i).getGridField();
            }
            if (mField.isDisplayed(true)) {
                if (!editor.isVisible()) {
                    editor.setVisible(true);
                    this.m_Rows.get(i).setVisible(true);
                    this.m_Rows.get(i).setAttribute("groupRowVisible", "true");
                    if (mField.getVO().isRange) {
                        this.m_separators.get(i).setVisible(true);
                        this.m_wEditors2.get(i).setVisible(true);
                    }
                    Button bNegate = null;
                    if (editor.getComponent() != null) {
                        bNegate = (Button)((Object)editor.getComponent().getAttribute("isNotClause"));
                    }
                    if (bNegate != null) {
                        bNegate.setVisible(true);
                    }
                }
                boolean rw = mField.isEditablePara(true);
                editor.setReadWrite(rw);
                editor.dynamicDisplay();
                if (mField.getVO().isRange) {
                    this.m_wEditors2.get(i).setReadWrite(rw);
                    this.m_wEditors2.get(i).dynamicDisplay();
                }
            } else if (editor.isVisible()) {
                editor.setVisible(false);
                this.m_Rows.get(i).setVisible(false);
                this.m_Rows.get(i).setAttribute("groupRowVisible", "false");
                if (mField.getVO().isRange) {
                    this.m_separators.get(i).setVisible(false);
                    this.m_wEditors2.get(i).setVisible(false);
                }
                Button bNegate = null;
                if (editor.getComponent() != null) {
                    bNegate = (Button)((Object)editor.getComponent().getAttribute("isNotClause"));
                }
                if (bNegate != null) {
                    bNegate.setVisible(false);
                }
            }
            editor.setMandatory(mField.isMandatory(true));
            editor.updateStyle();
            if (mField.getVO().isRange) {
                this.m_wEditors2.get(i).setMandatory(mField.isMandatory(true));
                this.m_wEditors2.get(i).updateStyle();
                if (editor.isMandatory() && editor.getLabel() != null && this.m_wEditors2.get(i).isNullOrEmpty()) {
                    LayoutUtils.addSclass("idempiere-mandatory-label", (HtmlBasedComponent)editor.getLabel());
                }
            }
            if (!(mField.getDisplayType() != 15 && mField.getDisplayType() != 16 || mField2 == null || mField2.getDisplayType() != 15 && mField2.getDisplayType() != 16 || !"T".equalsIgnoreCase(mField.getDateRangeOption()) || (dateRangeEditor = this.m_dateRangeEditors.get(i)) == null)) {
                dateRangeEditor.setVisible(editor.isVisible());
                this.m_Rows.get(i).setVisible(editor.isVisible());
                this.m_Rows.get(i).setAttribute("groupRowVisible", editor.isVisible());
                editor.setVisible(false, true);
                if (mField.getVO().isRange) {
                    this.m_separators.get(i).setVisible(false);
                    this.m_wEditors2.get(i).setVisible(false, true);
                }
                dateRangeEditor.setFieldMandatoryStyle();
                dateRangeEditor.setReadOnly(!editor.isReadWrite() || !this.m_wEditors2.get(i).isReadWrite());
            }
            ++i;
        }
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    protected void restoreContext() {
        for (GridField f : this.m_mFields) {
            if (f == null) continue;
            f.restoreValue();
        }
        for (GridField f : this.m_mFields2) {
            if (f == null) continue;
            f.restoreValue();
        }
    }

    public void setProcessInfo(ProcessInfo processInfo) {
        this.m_processInfo = processInfo;
    }

    public ProcessInfo getProcessInfo() {
        return this.m_processInfo;
    }

    public boolean focusToFirstEditor() {
        if (this.m_wEditors.isEmpty()) {
            return false;
        }
        for (WEditor editor : this.m_wEditors) {
            if (!editor.isVisible()) continue;
            this.focusToEditor(editor);
            return true;
        }
        return false;
    }

    private void focusToEditor(WEditor toFocus) {
        Object c = toFocus.getComponent();
        if (c instanceof EditorBox) {
            c = ((EditorBox)((Object)c)).getTextbox();
        } else if (c instanceof NumberBox) {
            c = ((NumberBox)((Object)c)).getDecimalbox();
        } else if (c instanceof Urlbox) {
            c = ((Urlbox)((Object)c)).getTextbox();
        }
        ((HtmlBasedComponent)c).focus();
    }

    public WEditor getEditor(String columnName) {
        int i = 0;
        while (i < this.m_mFields.size()) {
            if (this.m_mFields.get(i).getColumnName().equals(columnName)) {
                return this.m_wEditors.get(i);
            }
            ++i;
        }
        return null;
    }

    public WEditor getEditorTo(String columnName) {
        int i = 0;
        while (i < this.m_mFields.size()) {
            if (this.m_mFields.get(i).getColumnName().equals(columnName)) {
                return this.m_wEditors2.get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isWaitingForDialog() {
        int i = 0;
        while (i < this.m_mFields.size()) {
            WEditor editor = this.m_wEditors.get(i);
            WEditor editor2 = this.m_wEditors2.get(i);
            if (editor != null && editor instanceof WSearchEditor ? ((WSearchEditor)editor).isShowingDialog() : editor2 != null && editor2 instanceof WSearchEditor && ((WSearchEditor)editor2).isShowingDialog()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getWindowNo() {
        return this.m_WindowNo;
    }

    public String get_ValueAsString(String variableName) {
        DefaultEvaluatee evaluatee = new DefaultEvaluatee((DefaultEvaluatee.DataProvider)new FieldEditorDataProvider(), this.m_WindowNo, this.m_TabNo);
        return evaluatee.get_ValueAsString(variableName);
    }

    private class FieldEditorDataProvider
    implements DefaultEvaluatee.DataProvider {
        private FieldEditorDataProvider() {
        }

        public Object getValue(String columnName) {
            for (WEditor editor : ProcessParameterPanel.this.m_wEditors) {
                if (!editor.getGridField().getColumnName().equals(columnName)) continue;
                int displayType = editor.getGridField().getVO().displayType;
                if (displayType == 14 || displayType == 34 || displayType == 36 || displayType == 200267 || displayType == 23 || displayType == 26 || editor.getGridField().isEncrypted()) {
                    return "";
                }
                Object value = editor.getValue();
                if (value == null) {
                    return "";
                }
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? "Y" : "N";
                }
                if (value instanceof Timestamp) {
                    String stringValue = null;
                    if (value != null && !value.toString().equals("")) {
                        Calendar c1 = Calendar.getInstance();
                        c1.setTime((Date)value);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        stringValue = sdf.format(c1.getTime());
                    }
                    return stringValue;
                }
                return value.toString();
            }
            return null;
        }

        public Object getProperty(String propertyName) {
            return null;
        }

        public MColumn getColumn(String columnName) {
            return null;
        }

        public String getTrxName() {
            return null;
        }
    }

    static class ZoomListener
    implements EventListener<Event> {
        private IZoomableEditor searchEditor;

        ZoomListener(IZoomableEditor editor) {
            this.searchEditor = editor;
        }

        public void onEvent(Event event) throws Exception {
            if ("onClick".equals(event.getName())) {
                this.searchEditor.actionZoom();
            }
        }
    }
}

