/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.broadcast;

import java.util.ArrayList;
import java.util.List;
import org.idempiere.broadcast.BroadCastMsg;
import org.idempiere.distributed.IMessageService;
import org.idempiere.distributed.ITopic;
import org.idempiere.distributed.ITopicSubscriber;

public class BroadCastUtil {
    public static final String TOPIC_BROADCAST_MESSAGE = "BROADCAST_MESSAGE";
    public static final int EVENT_BROADCAST_MESSAGE = 1;
    public static final int EVENT_TEST_BROADCAST_MESSAGE = 2;
    public static final int EVENT_SESSION_TIMEOUT = 3;
    public static final int EVENT_SESSION_ONNODE_TIMEOUT = 4;
    private static final List<ITopicSubscriber<BroadCastMsg>> subscribers = new ArrayList<ITopicSubscriber<BroadCastMsg>>();
    private static IMessageService service = null;

    public static synchronized void subscribe(ITopicSubscriber<BroadCastMsg> subscriber) {
        subscribers.add(subscriber);
        if (service != null) {
            ITopic<BroadCastMsg> topic = service.getTopic(TOPIC_BROADCAST_MESSAGE);
            topic.subscribe(subscriber);
        }
    }

    public static synchronized void unSubscribe(ITopicSubscriber<BroadCastMsg> subscriber) {
        subscribers.remove(subscriber);
        if (service != null) {
            ITopic<BroadCastMsg> topic = service.getTopic(TOPIC_BROADCAST_MESSAGE);
            topic.unsubscribe(subscriber);
        }
    }

    public static synchronized boolean publish(BroadCastMsg msg) {
        if (service != null) {
            ITopic<BroadCastMsg> topic = service.getTopic(TOPIC_BROADCAST_MESSAGE);
            topic.publish(msg);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindMessageService(IMessageService messageService) {
        Class<BroadCastUtil> clazz = BroadCastUtil.class;
        synchronized (BroadCastUtil.class) {
            service = messageService;
            for (ITopicSubscriber<BroadCastMsg> subscriber : subscribers) {
                ITopic<BroadCastMsg> topic = service.getTopic(TOPIC_BROADCAST_MESSAGE);
                topic.subscribe(subscriber);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindMessageService(IMessageService messageService) {
        Class<BroadCastUtil> clazz = BroadCastUtil.class;
        synchronized (BroadCastUtil.class) {
            service = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

